/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.engine.source;

import com.funambol.framework.engine.SyncItem;
import com.funambol.framework.engine.SyncItemKey;
import com.funambol.framework.engine.source.SyncSource;
import com.funambol.framework.engine.source.SyncSourceException;
import com.funambol.framework.engine.source.SyncSourceInfo;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;

public abstract class AbstractSyncSource
implements SyncSource,
Serializable {
    public static final String LOG_NAME = "source";
    protected String name = null;
    protected String type = null;
    protected String sourceURI = null;
    protected SyncSourceInfo info = null;

    protected AbstractSyncSource() {
    }

    public AbstractSyncSource(String name, String type, String sourceURI) {
        if (name == null) {
            throw new NullPointerException("name is null!");
        }
        this.name = name;
        this.type = type == null ? "unknown" : type;
        this.sourceURI = sourceURI;
    }

    public AbstractSyncSource(String name) {
        this(name, null, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getSourceURI() {
        return this.sourceURI;
    }

    public void setSourceURI(String sourceURI) {
        this.sourceURI = sourceURI;
    }

    @Override
    public SyncSourceInfo getInfo() {
        return this.info;
    }

    public void setInfo(SyncSourceInfo info) {
        this.info = info;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" - {name: ").append(this.getName());
        sb.append(" type: ").append(this.getType());
        sb.append(" uri: ").append(this.getSourceURI());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void beginSync(Principal principal, int syncMode) throws SyncSourceException {
    }

    @Override
    public void endSync(Principal principal) throws SyncSourceException {
    }

    @Override
    public abstract SyncItem[] getAllSyncItems(Principal var1) throws SyncSourceException;

    @Override
    public abstract SyncItemKey[] getDeletedSyncItemKeys(Principal var1, Timestamp var2) throws SyncSourceException;

    @Override
    public abstract SyncItem[] getDeletedSyncItems(Principal var1, Timestamp var2) throws SyncSourceException;

    @Override
    public abstract SyncItemKey[] getNewSyncItemKeys(Principal var1, Timestamp var2) throws SyncSourceException;

    @Override
    public abstract SyncItem[] getNewSyncItems(Principal var1, Timestamp var2) throws SyncSourceException;

    @Override
    public abstract SyncItem getSyncItemFromId(Principal var1, SyncItemKey var2) throws SyncSourceException;

    @Override
    public abstract SyncItem[] getSyncItemsFromIds(Principal var1, SyncItemKey[] var2) throws SyncSourceException;

    @Override
    public abstract SyncItem[] getUpdatedSyncItems(Principal var1, Timestamp var2) throws SyncSourceException;

    @Override
    public abstract void removeSyncItem(Principal var1, SyncItem var2) throws SyncSourceException;

    @Override
    public abstract void removeSyncItems(Principal var1, SyncItem[] var2) throws SyncSourceException;

    @Override
    public abstract SyncItem setSyncItem(Principal var1, SyncItem var2) throws SyncSourceException;

    @Override
    public abstract SyncItem[] setSyncItems(Principal var1, SyncItem[] var2) throws SyncSourceException;

    @Override
    public abstract SyncItem getSyncItemFromTwin(Principal var1, SyncItem var2) throws SyncSourceException;

    @Override
    public abstract SyncItem[] getSyncItemsFromTwins(Principal var1, SyncItem[] var2) throws SyncSourceException;
}

