/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.security;

import com.funambol.framework.config.Configuration;
import com.funambol.framework.core.Authentication;
import com.funambol.framework.core.Cred;
import com.funambol.framework.core.HMACAuthentication;
import com.funambol.framework.security.Officer;
import com.funambol.framework.server.Sync4jDevice;
import com.funambol.framework.server.SyncUser;
import com.funambol.framework.server.store.Clause;
import com.funambol.framework.server.store.NotFoundException;
import com.funambol.framework.server.store.PersistentStore;
import com.funambol.framework.server.store.PersistentStoreException;
import com.funambol.framework.server.store.WhereClause;
import com.funambol.framework.tools.Base64;
import com.funambol.framework.tools.MD5;
import com.funambol.server.admin.UserManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Principal;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DBOfficer
implements Officer,
Serializable {
    protected static final transient Logger log = Logger.getLogger((String)DBOfficer.class.getName());
    protected PersistentStore ps = null;
    private boolean loginFailed = false;
    private boolean loginExpired = false;
    private boolean guestEnabled = true;
    private String authType = "syncml:auth-md5";
    private String supportedAuthType = null;

    public boolean isLoginFailed() {
        return this.loginFailed;
    }

    @Override
    public boolean isGuestEnabled() {
        return this.guestEnabled;
    }

    public void setGuestEnabled(boolean guestEnabled) {
        this.guestEnabled = guestEnabled;
    }

    @Override
    public String getAuthType() {
        return this.authType;
    }

    @Override
    public void setAuthType(String authType) {
        this.authType = authType;
        this.supportedAuthType = this.supportedAuthType + this.authType;
    }

    @Override
    public String getSupportedAuthType() {
        return this.supportedAuthType;
    }

    @Override
    public void setSupportedAuthType(String supportedAuthType) {
        this.supportedAuthType = this.authType + supportedAuthType;
    }

    @Override
    public boolean authenticate(Cred credential) {
        String type = credential.getType();
        if ("syncml:auth-basic".equals(type)) {
            return this.authenticateBasicCredential(credential);
        }
        if ("syncml:auth-md5".equals(type)) {
            return this.authenticateMD5Credential(credential);
        }
        if ("syncml:auth-MAC".equals(type)) {
            return this.authenticateHMACCredential(credential);
        }
        return false;
    }

    @Override
    public boolean authorize(Principal principal, String resource) {
        return true;
    }

    @Override
    public void unAuthenticate(Cred credential) {
    }

    @Override
    public boolean isAccountExpired() {
        return this.loginExpired;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private boolean authenticateBasicCredential(Cred credential) {
        SyncUser user = null;
        Authentication auth = credential.getAuthentication();
        String username = null;
        String password = null;
        String s = new String(Base64.decode(credential.getData()));
        int p = s.indexOf(58);
        if (p == -1) {
            username = s;
            password = "";
        } else {
            username = p > 0 ? s.substring(0, p) : "";
            String string = password = p == s.length() - 1 ? "" : s.substring(p + 1);
        }
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Username: " + username + "; password: " + password));
        }
        try {
            user = this.readUser(username);
        }
        catch (NotFoundException e) {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)("User " + username + " not found!"));
            }
        }
        catch (PersistentStoreException e) {
            log.fatal((Object)("Error reading the user " + username + ": " + e.getMessage()));
            log.debug((Object)"authenticateBasicCredential", (Throwable)e);
            return false;
        }
        return password.equals(user.getPassword());
    }

    private boolean authenticateMD5Credential(Cred credential) {
        Sync4jDevice device = null;
        Authentication auth = credential.getAuthentication();
        try {
            device = this.readDevice(auth.getDeviceId());
        }
        catch (PersistentStoreException e) {
            log.fatal((Object)("Error configuring the persistent store: " + e.getMessage()), (Throwable)e);
            log.debug((Object)"authenticateMD5Credential", (Throwable)e);
            return false;
        }
        String userDigest = device.getDigest();
        byte[] clientNonce = auth.getNextNonce().getValue();
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("userDigest: " + userDigest));
        }
        byte[] userDigestBytes = userDigest.getBytes();
        byte[] buf = new byte[userDigestBytes.length + 1 + clientNonce.length];
        System.arraycopy(userDigestBytes, 0, buf, 0, userDigestBytes.length);
        buf[userDigestBytes.length] = 58;
        System.arraycopy(clientNonce, 0, buf, userDigestBytes.length + 1, clientNonce.length);
        byte[] digest = MD5.digest(buf);
        String serverDigestNonceB64 = new String(Base64.encode(digest));
        String msgDigestNonceB64 = auth.getData();
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("serverDigestNonceB64: " + serverDigestNonceB64));
            log.trace((Object)("msgDigestNonceB64: " + msgDigestNonceB64));
        }
        if (!msgDigestNonceB64.equals(serverDigestNonceB64)) {
            return false;
        }
        auth.setUsername(userDigest);
        return true;
    }

    private boolean authenticateHMACCredential(Cred credential) {
        Sync4jDevice device = null;
        Authentication auth = credential.getAuthentication();
        if (!(auth instanceof HMACAuthentication)) {
            throw new IllegalStateException("Authentication not valid!");
        }
        try {
            device = this.readDevice(auth.getDeviceId());
        }
        catch (PersistentStoreException e) {
            log.fatal((Object)("Error configuring the persistent store: " + e.getMessage()), (Throwable)e);
            log.debug((Object)"authenticateMD5Credential", (Throwable)e);
            return false;
        }
        String userMac = ((HMACAuthentication)auth).getUserMac();
        String calculatedMac = ((HMACAuthentication)auth).getCalculatedMac();
        if (userMac != null && userMac.equals(calculatedMac)) {
            auth.setUsername(device.getDigest());
            return true;
        }
        return false;
    }

    private Sync4jDevice readDevice(String deviceId) throws PersistentStoreException {
        Configuration config = Configuration.getConfiguration();
        PersistentStore ps = (PersistentStore)config.getBeanInstance("engine.store");
        Sync4jDevice device = new Sync4jDevice(deviceId, null, null);
        ps.read(device);
        return device;
    }

    private SyncUser readUser(String username) throws NotFoundException, PersistentStoreException {
        Configuration config = Configuration.getConfiguration();
        UserManager um = (UserManager)config.getBeanInstance("user.manager");
        SyncUser[] results = um.getUsers((Clause)new WhereClause("username", new String[]{username}, "EQ", false));
        if (results == null || results.length == 0) {
            throw new NotFoundException(username);
        }
        return results[0];
    }
}

