/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.vmguys.vmtools.utils.AttributeNameComparator;
import org.vmguys.vmtools.utils.XPath;

public class DiffElement
extends Element {
    private int nodeNumber = -1;
    private int childNumber = -1;
    private DiffElement root;
    private int treesize = -1;
    private int contentsize = -1;
    private int leftmostLeafNum = -1;
    private List children;
    private Object[] content;
    private Attribute[] attributes;
    private boolean treeInfoOk;
    private String xpath;

    public DiffElement(String name) {
        super(name);
    }

    public DiffElement(String name, Namespace namespace) {
        super(name, namespace);
    }

    public DiffElement(String name, String uri) {
        super(name, uri);
    }

    public DiffElement(String name, String prefix, String uri) {
        super(name, prefix, uri);
    }

    public int getTreesize() {
        if (!this.treeInfoOk) {
            this.buildTreeInfo();
        }
        return this.treesize;
    }

    public int getContentsize() {
        if (!this.treeInfoOk) {
            this.buildTreeInfo();
        }
        return this.contentsize;
    }

    public int getChildNumber() {
        if (!this.treeInfoOk) {
            this.buildTreeInfo();
        }
        return this.childNumber;
    }

    public int getNodeNumber() {
        if (!this.treeInfoOk) {
            this.buildTreeInfo();
        }
        return this.nodeNumber;
    }

    public boolean hasLeftSibling() {
        return this.getChildNumber() > 1;
    }

    public int getLeftmostLeafNum() {
        if (this.leftmostLeafNum < 0) {
            List children;
            DiffElement leftmostLeaf = this;
            while ((children = leftmostLeaf.getChildren()).size() > 0) {
                leftmostLeaf = (DiffElement)((Object)children.get(0));
            }
            this.leftmostLeafNum = leftmostLeaf.getNodeNumber();
        }
        return this.leftmostLeafNum;
    }

    public DiffElement getDiffParent() {
        return (DiffElement)this.getParent();
    }

    public List getChildren() {
        if (this.children == null) {
            this.children = super.getChildren();
        }
        return this.children;
    }

    public Object[] getContentAsArray() {
        if (this.content == null) {
            List fullContent = this.getContent();
            ArrayList xContent = new ArrayList(fullContent.size());
            Iterator it = fullContent.iterator();
            while (it.hasNext()) {
                Object c = it.next();
                if (c instanceof DiffElement) continue;
                xContent.add(c);
            }
            this.content = xContent.toArray();
        }
        return this.content;
    }

    public Attribute[] getAttributesAsArray() {
        if (this.attributes == null) {
            List attribList = this.getAttributes();
            this.attributes = new Attribute[attribList.size()];
            attribList.toArray(this.attributes);
            Arrays.sort(this.attributes, new AttributeNameComparator());
        }
        return this.attributes;
    }

    public String getXpath() throws JDOMException {
        if (this.xpath == null) {
            DiffElement parent = this.getDiffParent();
            this.xpath = parent != null ? parent.getXpath() + XPath.getChildXPath(parent, (Object)this) : XPath.getXPath(this.getRoot(), (Object)this);
        }
        return this.xpath;
    }

    public String toString() {
        try {
            return this.getXpath();
        }
        catch (JDOMException e) {
            return this.getNodeNumber() + ":" + this.getName();
        }
    }

    private void buildTreeInfo() {
        if (!this.treeInfoOk) {
            DiffElement root = this.getRoot();
            root.buildTreeInfo(1, new NodeNumberSingleton());
        }
    }

    private void buildTreeInfo(int childNumber, NodeNumberSingleton nodeNumber) {
        this.treesize = 0;
        this.contentsize = 0;
        int childNum = 1;
        List children = this.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            DiffElement child = (DiffElement)((Object)it.next());
            child.buildTreeInfo(childNum++, nodeNumber);
            this.treesize += child.getTreesize();
            this.contentsize += child.getContentsize();
        }
        this.childNumber = childNumber;
        this.nodeNumber = nodeNumber.getNodeNumber();
        ++this.treesize;
        this.contentsize += 1 + this.getContentAsArray().length + this.getAttributesAsArray().length;
        this.treeInfoOk = true;
    }

    public DiffElement getRoot() {
        if (this.root == null) {
            this.root = this;
            DiffElement next = (DiffElement)this.root.getParent();
            while (next != null) {
                this.root = next;
                next = (DiffElement)this.root.getParent();
            }
        }
        return this.root;
    }

    private class NodeNumberSingleton {
        private int nextNodeNumber = 1;

        public int getNodeNumber() {
            return this.nextNodeNumber++;
        }
    }
}

