/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.vmguys.vmtools.utils.AbstractOperation;
import org.vmguys.vmtools.utils.DiffElement;

public class SubtreeInsertOperation
extends AbstractOperation {
    public SubtreeInsertOperation(DiffElement node) {
        this(node, null);
    }

    public SubtreeInsertOperation(DiffElement node, String comment) {
        this.node = node;
        this.comment = comment;
    }

    public Element asElement(Namespace namespace) {
        Element el = new Element("Subtree", namespace);
        el.setAttribute("Operation", "insert");
        el.setAttribute("Child", Integer.toString(this.node.getChildNumber()));
        el.addContent(this.wrapMetaData((Element)this.node.clone()));
        if (this.comment != null) {
            Comment c = new Comment(this.comment);
            el.addContent(c);
        }
        return el;
    }

    public int cost() {
        return this.node.getContentsize();
    }

    public String toString() {
        return "insert subtree " + this.node.toString();
    }

    public String getOperationXpath() throws JDOMException {
        return this.node.getDiffParent().getXpath();
    }

    public int getOperationNodeNumber() {
        return this.node.getDiffParent().getNodeNumber();
    }
}

