/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.vmguys.vmtools.utils.XPath;

public class TestXPath
extends TestCase {
    private Element tree1;
    private Element tree2;
    private Element surname;
    private Element fantasy1;
    private String surnameString;
    private String xpathToSurname;
    private String xpathToSurnameString;
    private String xpathToFantasy1;

    public TestXPath(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.tree1 = this.createTree1();
        this.tree2 = this.createTree2();
        this.surname = this.tree1.getChild("Customer").getChild("PersonName").getChild("SurName");
        if (this.surname == null) {
            throw new Exception("can't find SurName element");
        }
        this.xpathToSurname = "/Profile/Customer/PersonName/SurName";
        this.surnameString = (String)this.surname.getContent().get(0);
        this.xpathToSurnameString = this.xpathToSurname + "/self::node()[1]";
        this.fantasy1 = this.tree2.getChild("Customer").getChild("Fantasy");
        if (this.fantasy1 == null) {
            throw new Exception("can't find Fantasy[1] element");
        }
        this.xpathToFantasy1 = "/Profile/Customer/Fantasy[1]";
    }

    protected void tearDown() throws Exception {
        this.tree1 = null;
        this.tree2 = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestXPath("testNothing"));
        suite.addTest((Test)new TestXPath("testRelative"));
        suite.addTest((Test)new TestXPath("testSimplePath"));
        suite.addTest((Test)new TestXPath("testSimplePath2"));
        suite.addTest((Test)new TestXPath("testBadPath"));
        suite.addTest((Test)new TestXPath("testGetPath"));
        suite.addTest((Test)new TestXPath("testGetPath2"));
        suite.addTest((Test)new TestXPath("testBadElement"));
        suite.addTest((Test)new TestXPath("testIndex1"));
        suite.addTest((Test)new TestXPath("testIndex2"));
        return suite;
    }

    public void testNothing() {
    }

    public void testRelative() {
        try {
            XPath.getElement(this.tree1, "badpath");
            Assert.fail((String)"getElement didn't throw exception on relative path");
        }
        catch (JDOMException jde) {
            String goodMsg = "not absolute";
            String errMsg = jde.getMessage();
            if (errMsg != null) {
                if (errMsg.indexOf(goodMsg) < 0) {
                    Assert.fail((String)("expected exception containing \"" + goodMsg + "\"; got \"" + errMsg + "\""));
                }
            }
            Assert.fail((String)"getElement threw exception with null message");
        }
    }

    public void testSimplePath() {
        Object e1 = null;
        try {
            e1 = XPath.getElement(this.tree1, this.xpathToSurname);
            Assert.assertTrue((String)"getElement returned null", (e1 != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"getElement returned incorrect element", (e1 == this.surname ? 1 : 0) != 0);
        }
        catch (JDOMException jde) {
            Assert.fail((String)("caught JDOMException getting element: " + jde.getMessage()));
        }
    }

    public void testSimplePath2() {
        Object e1 = null;
        try {
            e1 = XPath.getElement(this.tree1, this.xpathToSurnameString);
            Assert.assertTrue((String)"getElement returned null", (e1 != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"getElement returned incorrect element", (e1 == this.surnameString ? 1 : 0) != 0);
        }
        catch (JDOMException jde) {
            Assert.fail((String)("caught JDOMException getting element: " + jde.getMessage()));
        }
    }

    public void testBadPath() {
        try {
            Object e1 = XPath.getElement(this.tree1, "/Profile/Customer/Foofoo");
            Assert.assertTrue((String)"got unexpected element using bad xpath", (e1 == null ? 1 : 0) != 0);
        }
        catch (JDOMException jde) {
            Assert.fail((String)("caught JDOMException getting element: " + jde.getMessage()));
        }
    }

    public void testGetPath() {
        try {
            String xpath = XPath.getXPath(this.tree1, this.surname);
            Assert.assertTrue((String)"got incorrect xpath", (boolean)xpath.equals(this.xpathToSurname));
        }
        catch (JDOMException jde) {
            Assert.fail((String)("caught JDOMException getting path: " + jde.getMessage()));
        }
    }

    public void testGetPath2() {
        try {
            String xpath = XPath.getXPath(this.tree1, this.surnameString);
            Assert.assertTrue((String)"got incorrect xpath", (boolean)xpath.equals(this.xpathToSurnameString));
        }
        catch (JDOMException jde) {
            Assert.fail((String)("caught JDOMException getting path: " + jde.getMessage()));
        }
    }

    public void testBadElement() {
        try {
            Element nonChild = new Element("fake");
            String xpath = XPath.getXPath(this.tree1, nonChild);
            Assert.fail((String)"getXPath didn't throw exception for bad element");
        }
        catch (JDOMException jDOMException) {
            // empty catch block
        }
    }

    public void testIndex1() {
        try {
            Element customer = this.tree2.getChild("Customer");
            List twins = customer.getChildren("Fantasy");
            Assert.assertTrue((String)"can't find the two Fantasy twins", (twins.size() == 2 ? 1 : 0) != 0);
            Element fantasy1 = (Element)twins.get(0);
            Element fantasy2 = (Element)twins.get(1);
            Object xfantasy1 = XPath.getElement(this.tree2, "/Profile/Customer/Fantasy[1]");
            Assert.assertTrue((String)"can't get /Profile/Customer/Fantasy[1]", (xfantasy1 != null ? 1 : 0) != 0);
            Object xfantasy2 = XPath.getElement(this.tree2, "/Profile/Customer/Fantasy[2]");
            Assert.assertTrue((String)"can't get /Profile/Customer/Fantasy[2]", (xfantasy1 != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"/Profile/Customer/Fantasy[1] didn't retrieve the correct element", (xfantasy1 == fantasy1 ? 1 : 0) != 0);
            Assert.assertTrue((String)"/Profile/Customer/Fantasy[2] didn't retrieve the correct element", (xfantasy2 == fantasy2 ? 1 : 0) != 0);
        }
        catch (JDOMException jde) {
            Assert.fail((String)("caught JDOMException getting child: " + jde.getMessage()));
        }
    }

    public void testIndex2() {
        try {
            String xpath = XPath.getXPath(this.tree2, this.fantasy1);
            Assert.assertTrue((String)"got unexpected xpath to fantasy1", (boolean)xpath.equals(this.xpathToFantasy1));
        }
        catch (JDOMException jde) {
            Assert.fail((String)("caught JDOMException getting xpath: " + jde.getMessage()));
        }
    }

    private Element createTree1() {
        Element nameTitle = new Element("NameTitle");
        nameTitle.addContent("Mr.");
        Element givenName = new Element("GivenName");
        givenName.addContent("George");
        Element surName = new Element("SurName");
        surName.addContent("Smith");
        Element personName = new Element("PersonName");
        personName.setAttribute("NameType", "Default");
        personName.addContent(nameTitle);
        personName.addContent(givenName);
        personName.addContent(surName);
        Element customer = new Element("Customer");
        customer.addContent(personName);
        Element profile = new Element("Profile");
        profile.addContent(customer);
        return profile;
    }

    private Element createTree2() throws Exception {
        Element newSurName = new Element("SurName");
        newSurName.addContent("Jones");
        Element profile = this.createTree1();
        Element customer = profile.getChild("Customer");
        Element personName = customer.getChild("PersonName");
        if (personName == null) {
            throw new Exception("can't find PersonName element");
        }
        personName.removeChild("SurName");
        personName.addContent(newSurName);
        Element fantasy1 = new Element("Fantasy");
        fantasy1.addContent("Lamborghini");
        Element fantasy2 = new Element("Fantasy");
        fantasy2.addContent("Money");
        customer.addContent(fantasy1);
        customer.addContent(fantasy2);
        return profile;
    }
}

