/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.dmdemo;

import com.funambol.dmdemo.DMDemoBean;
import com.funambol.framework.engine.dm.AddManagementOperation;
import com.funambol.framework.engine.dm.CopyManagementOperation;
import com.funambol.framework.engine.dm.DeleteManagementOperation;
import com.funambol.framework.engine.dm.ExecManagementOperation;
import com.funambol.framework.engine.dm.GetManagementOperation;
import com.funambol.framework.engine.dm.ManagementException;
import com.funambol.framework.engine.dm.ManagementOperation;
import com.funambol.framework.engine.dm.ManagementOperationResult;
import com.funambol.framework.engine.dm.ReplaceManagementOperation;
import com.funambol.framework.engine.dm.TreeManagementOperation;
import com.funambol.framework.engine.dm.TreeNode;
import com.funambol.framework.engine.dm.UserAlertManagementOperation;
import com.funambol.framework.tools.Base64;
import com.funambol.framework.tools.DBTools;
import com.funambol.framework.tools.IOTools;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class GenericProcessorTools {
    public static final String PRECONFIGURED_GET_DEVICE_DETAILS = "GetDeviceDetails";
    private static final String COMMAND_WITHOUT_VALUE_IN_RESPONSE = "Add, Replace";
    private static final String SQL_SELECT_DM_STATE = "SELECT id, device, state, start_ts, end_ts FROM fnbl_dm_state WHERE mssid=?";
    private static final Logger log = Logger.getLogger((String)GenericProcessorTools.class.getName());
    private DataSource datasource = null;
    private List<ManagementOperation> operationsList = null;
    private List<ManagementOperationResult> operationsResults = null;
    private String sessionId = null;
    private String sessionsDirectory = System.getProperty("com.funambol.dmdemo.resultsDirectory");

    private GenericProcessorTools() {
        if (this.sessionsDirectory == null) {
            this.sessionsDirectory = ".";
        }
    }

    public GenericProcessorTools(DataSource ds) {
        this();
        this.datasource = ds;
    }

    public void startNewManagementSession(String deviceId, String sessionId, String processor) throws ManagementException {
        if (PRECONFIGURED_GET_DEVICE_DETAILS.equals(processor)) {
            int numOperations;
            this.operationsList = this.getPreconfiguredOperationsForGetDeviceDetail();
            if (this.operationsList == null) {
                this.operationsList = new ArrayList<ManagementOperation>();
            }
            if ((numOperations = this.operationsList.size()) > 0) {
                if (!DMDemoBean.isDummyOperation(this.operationsList.get(numOperations - 1))) {
                    this.operationsList.add((ManagementOperation)DMDemoBean.DUMMY_ALERT_OPERATION);
                }
            } else {
                this.operationsList.add((ManagementOperation)DMDemoBean.DUMMY_ALERT_OPERATION);
            }
        } else {
            this.operationsList = new ArrayList<ManagementOperation>();
        }
        this.operationsResults = null;
        this.sessionId = sessionId;
    }

    public void saveSession() throws ManagementException {
        if (this.sessionId == null) {
            return;
        }
        this.saveOperations(this.operationsList, this.sessionId);
    }

    public void deleteSession() throws ManagementException {
        if (this.sessionId == null) {
            return;
        }
        try {
            this.deleteSessions(this.sessionId);
        }
        catch (Exception e) {
            throw new ManagementException("Error deleting the session", (Throwable)e);
        }
    }

    public void addManagementOperation(String operationName, String nodeUri, String value, String format, String option1, String option2, String option3, boolean newNode) throws ManagementException {
        AddManagementOperation operationToAdd = null;
        if (this.operationsList == null) {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)"Try to add a new operation with operationsList null");
            }
            return;
        }
        String currentState = this.loadSessionState();
        if (currentState == null || currentState.equals("P")) {
            int numOperations = this.operationsList.size();
            if (numOperations > 0 && DMDemoBean.isDummyOperation(this.operationsList.get(numOperations - 1))) {
                this.operationsList.remove(numOperations - 1);
            }
            if (operationName != null) {
                if (operationName.equalsIgnoreCase("Add")) {
                    operationToAdd = new AddManagementOperation();
                    HashMap<String, TreeNode> nodes = new HashMap<String, TreeNode>();
                    if (newNode) {
                        TreeNode newNodeToAdd = new TreeNode(nodeUri);
                        newNodeToAdd.setFormat("node");
                        nodes.put(nodeUri, newNodeToAdd);
                    } else {
                        TreeNode newNodeToAdd = new TreeNode(nodeUri);
                        newNodeToAdd.setFormat(format);
                        newNodeToAdd.setValue(this.fixType(value, format));
                        nodes.put(nodeUri, newNodeToAdd);
                    }
                    operationToAdd.setNodes(nodes);
                } else if (operationName.equalsIgnoreCase("Get")) {
                    operationToAdd = new GetManagementOperation();
                    HashMap<String, String> nodes = new HashMap<String, String>();
                    nodes.put(nodeUri, "");
                    ((GetManagementOperation)operationToAdd).setNodes(nodes);
                } else if (operationName.equalsIgnoreCase("Delete")) {
                    operationToAdd = new DeleteManagementOperation();
                    HashMap<String, String> nodes = new HashMap<String, String>();
                    nodes.put(nodeUri, "");
                    ((DeleteManagementOperation)operationToAdd).setNodes(nodes);
                } else if (operationName.equalsIgnoreCase("Replace")) {
                    operationToAdd = new ReplaceManagementOperation();
                    HashMap<String, TreeNode> nodes = new HashMap<String, TreeNode>();
                    if (newNode) {
                        TreeNode newNodeToAdd = new TreeNode(nodeUri);
                        newNodeToAdd.setFormat("node");
                        nodes.put(nodeUri, newNodeToAdd);
                    } else {
                        TreeNode newNodeToAdd = new TreeNode(nodeUri);
                        newNodeToAdd.setFormat(format);
                        newNodeToAdd.setValue(this.fixType(value, format));
                        nodes.put(nodeUri, newNodeToAdd);
                    }
                    ((ReplaceManagementOperation)operationToAdd).setNodes(nodes);
                } else if (operationName.equalsIgnoreCase("Copy")) {
                    operationToAdd = new CopyManagementOperation();
                    HashMap<String, String> nodes = new HashMap<String, String>();
                    nodes.put(nodeUri, value);
                    ((CopyManagementOperation)operationToAdd).setNodes(nodes);
                } else if (operationName.equalsIgnoreCase("Exec")) {
                    operationToAdd = new ExecManagementOperation();
                    HashMap<String, String> nodes = new HashMap<String, String>();
                    ((ExecManagementOperation)operationToAdd).setCorrelator(option1);
                    nodes.put(nodeUri, value);
                    ((ExecManagementOperation)operationToAdd).setNodes(nodes);
                } else if (operationName.equalsIgnoreCase("ShowAlertMessage")) {
                    operationToAdd = UserAlertManagementOperation.getDisplay((String)value, (int)10, (int)15);
                } else if (operationName.equalsIgnoreCase("ShowConfirmMessage")) {
                    operationToAdd = UserAlertManagementOperation.getConfirm((String)value, (int)10, (int)15, (String)"No");
                } else if (operationName.equalsIgnoreCase("ShowInputMessage")) {
                    operationToAdd = UserAlertManagementOperation.getInput((String)value, (int)10, (int)15, (String)"", (int)32, (char)'A', (char)'T');
                } else if (operationName.equalsIgnoreCase("ShowChoiceMessage")) {
                    String[] Options = new String[]{option1, option2, option3};
                    operationToAdd = UserAlertManagementOperation.getChoice((String)value, (String[])Options, (int)10, (int)15, (String)option1);
                }
            }
            if (operationToAdd != null) {
                this.operationsList.add((ManagementOperation)operationToAdd);
            }
            if ((numOperations = this.operationsList.size()) > 0) {
                if (!DMDemoBean.isDummyOperation(this.operationsList.get(numOperations - 1))) {
                    this.operationsList.add((ManagementOperation)DMDemoBean.DUMMY_ALERT_OPERATION);
                }
            } else {
                this.operationsList.add((ManagementOperation)DMDemoBean.DUMMY_ALERT_OPERATION);
            }
        }
    }

    public List<ManagementOperationResult> getOperationsResultsWithValue() throws ManagementException {
        if (this.operationsResults == null) {
            return null;
        }
        int numResults = this.operationsResults.size();
        ManagementOperationResult operationResult = null;
        ManagementOperation operation = null;
        String commandName = null;
        for (int i = 0; i < numResults; ++i) {
            operationResult = this.operationsResults.get(i);
            operation = this.operationsList.get(i);
            if (!(operation instanceof TreeManagementOperation)) continue;
            commandName = operationResult.getCommand();
            if (COMMAND_WITHOUT_VALUE_IN_RESPONSE.indexOf(commandName) != -1) {
                operationResult.setNodes(((TreeManagementOperation)operation).getNodes());
            }
            if (!commandName.equalsIgnoreCase("Alert")) continue;
            if (!(operation instanceof UserAlertManagementOperation)) {
                throw new ManagementException("Error matching the results with the operation");
            }
            int alertCode = ((UserAlertManagementOperation)operation).getAlertCode();
            if (alertCode == 1100) {
                operationResult.setCommand("Display");
                continue;
            }
            if (alertCode == 1101) {
                operationResult.setCommand("Confirmation");
                continue;
            }
            if (alertCode == 1102) {
                operationResult.setCommand("Input");
                continue;
            }
            if (alertCode == 1103) {
                operationResult.setCommand("Choice");
                continue;
            }
            operationResult.setCommand("Alert");
        }
        return this.operationsResults;
    }

    public void moveOperationUp(int index) {
        ManagementOperation opToMove = null;
        if (index > 0) {
            opToMove = this.operationsList.remove(index);
            this.operationsList.add(index - 1, opToMove);
        }
    }

    public void moveOperationDown(int index) {
        ManagementOperation opToMove = null;
        if (index < this.operationsList.size() - 2) {
            opToMove = this.operationsList.remove(index);
            this.operationsList.add(index + 1, opToMove);
        }
    }

    public void removeOperation(int index) {
        if (this.operationsList == null) {
            return;
        }
        if (index != -1) {
            this.operationsList.remove(index);
        }
    }

    public void loadGenericSession(String sessionId) throws ManagementException {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("loadGenericSession with sessionId: " + sessionId));
        }
        Object xmlOperationsResults = null;
        try {
            this.operationsList = this.readOperations(sessionId);
            this.operationsResults = this.readResults(sessionId);
        }
        catch (IOException e) {
            throw new ManagementException("Error loading the session", (Throwable)e);
        }
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("number of operations: " + this.operationsList.size()));
        }
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("number of results: " + this.operationsResults.size()));
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public List<ManagementOperation> getOperationsList() {
        if (this.operationsList == null) {
            return new ArrayList<ManagementOperation>();
        }
        return this.operationsList;
    }

    public List<ManagementOperationResult> getOperationsResults() {
        if (this.operationsResults == null) {
            return new ArrayList<ManagementOperationResult>();
        }
        return this.operationsResults;
    }

    public void setPreconfiguredOperations(String preconfiguredOperations) throws ManagementException {
        List<ManagementOperation> list = null;
        if (!PRECONFIGURED_GET_DEVICE_DETAILS.equals(preconfiguredOperations)) {
            throw new ManagementException("Unknow preconfigured operations (" + preconfiguredOperations + ")");
        }
        list = this.getPreconfiguredOperationsForGetDeviceDetail();
        this.operationsList = list;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this);
        sb.append("sessionId", (Object)this.sessionId);
        sb.append("num.operations", (Object)(this.operationsList == null ? "null" : String.valueOf(this.operationsList.size())));
        sb.append("num.results", (Object)(this.operationsResults == null ? "null" : String.valueOf(this.operationsResults.size())));
        return sb.toString();
    }

    private void setValuesInManagementOperationResult(ManagementOperationResult operationResult) {
        String commandName = operationResult.getCommand();
        Map resultNodes = operationResult.getNodes();
        Iterator<ManagementOperation> itOperationsList = this.operationsList.iterator();
        String operationCommandName = null;
        Map operationNodes = null;
        ManagementOperation operation = null;
        while (itOperationsList.hasNext()) {
            operation = itOperationsList.next();
            operationCommandName = operation.getDescription();
            if (!(operation instanceof TreeManagementOperation) || !operationCommandName.equals(commandName) || operation instanceof UserAlertManagementOperation || (operationNodes = ((TreeManagementOperation)operation).getNodes()).size() != resultNodes.size() || !this.compareKeys(resultNodes, operationNodes)) continue;
            operationResult.setNodes(operationNodes);
        }
    }

    private boolean compareKeys(Map map1, Map<String, Object> map2) {
        Iterator itMap1 = map1.keySet().iterator();
        String key1 = null;
        while (itMap1.hasNext()) {
            key1 = (String)itMap1.next();
            if (map2.containsKey(key1)) continue;
            return false;
        }
        return true;
    }

    private String loadSessionState() throws ManagementException {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("loadSessionState with sessionId: " + this.sessionId));
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String state = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_DM_STATE);
            pStmt.setObject(1, this.sessionId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                state = rs.getString("state");
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error reading the session operations", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("State of the session '" + this.sessionId + "':  " + state));
        }
        return state;
    }

    private List<ManagementOperation> getPreconfiguredOperationsForGetDeviceDetail() {
        ArrayList<ManagementOperation> operations = new ArrayList<ManagementOperation>();
        ArrayList<String> nodesList = new ArrayList<String>();
        nodesList.add("./DevInfo/Man");
        nodesList.add("./DevInfo/Mod");
        nodesList.add("./DevDetail/DevTyp");
        nodesList.add("./DevDetail/OEM");
        nodesList.add("./DevInfo/Lang");
        nodesList.add("./DevDetail/FwV");
        nodesList.add("./DevDetail/SwV");
        nodesList.add("./DevDetail/HwV");
        nodesList.add("./DevInfo/DmV");
        int numNodes = nodesList.size();
        GetManagementOperation getOp = null;
        HashMap nodes = null;
        for (int i = 0; i < numNodes; ++i) {
            getOp = new GetManagementOperation();
            nodes = new HashMap();
            nodes.put(nodesList.get(i), "");
            getOp.setNodes(nodes);
            operations.add((ManagementOperation)getOp);
        }
        return operations;
    }

    private List<ManagementOperationResult> readResults(String dmStateId) throws IOException {
        File resultsFile = new File(this.sessionsDirectory + File.separator + dmStateId + File.separator + "results.xml");
        if (!resultsFile.exists()) {
            return new ArrayList<ManagementOperationResult>();
        }
        String xmlResults = IOTools.readFileString((File)resultsFile);
        if (xmlResults == null) {
            return new ArrayList<ManagementOperationResult>();
        }
        XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(xmlResults.getBytes()));
        return (ArrayList)decoder.readObject();
    }

    private void deleteSessions(String dmStateId) throws IOException {
        File directory = new File(this.sessionsDirectory + File.separator + dmStateId);
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].delete()) continue;
                throw new IOException("Error deleting file '" + files[i].getAbsolutePath() + "'");
            }
        }
        directory.delete();
    }

    private void saveOperations(List<ManagementOperation> operationsList, String id) {
        block2: {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            XMLEncoder encoder = new XMLEncoder(bout);
            encoder.writeObject(operationsList);
            encoder.flush();
            encoder.close();
            String directory = this.sessionsDirectory + File.separator + id;
            File resultsFileDir = new File(directory);
            resultsFileDir.mkdirs();
            File operationsFile = new File(directory + File.separator + "operations.xml");
            try {
                IOTools.writeFile((byte[])bout.toByteArray(), (File)operationsFile);
            }
            catch (Exception e) {
                log.debug((Object)"saveOperations", (Throwable)e);
                if (!log.isEnabledFor((Priority)Level.FATAL)) break block2;
                log.fatal((Object)("Error saving device tree: " + e.getMessage()));
            }
        }
    }

    private List<ManagementOperation> readOperations(String dmStateId) throws IOException {
        File operationsFile = new File(this.sessionsDirectory + File.separator + dmStateId + File.separator + "operations.xml");
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("get operations for id: " + dmStateId));
        }
        if (!operationsFile.exists()) {
            return null;
        }
        String xmlOperations = IOTools.readFileString((File)operationsFile);
        if (xmlOperations == null) {
            return new ArrayList<ManagementOperation>();
        }
        XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(xmlOperations.getBytes()));
        ArrayList operationsList = (ArrayList)decoder.readObject();
        return operationsList;
    }

    private Object fixType(String value, String type) {
        Object objValue = null;
        if ("int".equalsIgnoreCase(type)) {
            try {
                objValue = new Integer(value);
            }
            catch (NumberFormatException ex) {
                return value;
            }
            return objValue;
        }
        if ("bool".equalsIgnoreCase(type)) {
            objValue = new Boolean(value);
            return objValue;
        }
        if ("b64".equalsIgnoreCase(type)) {
            objValue = Base64.decode((String)value);
            return objValue;
        }
        return value;
    }
}

