/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.dmdemo;

import com.funambol.framework.engine.dm.AddManagementOperation;
import com.funambol.framework.engine.dm.DeleteManagementOperation;
import com.funambol.framework.engine.dm.GetManagementOperation;
import com.funambol.framework.engine.dm.ManagementException;
import com.funambol.framework.engine.dm.ManagementOperation;
import com.funambol.framework.engine.dm.ManagementOperationResult;
import com.funambol.framework.engine.dm.ReplaceManagementOperation;
import com.funambol.framework.engine.dm.TreeManagementOperation;
import com.funambol.framework.engine.dm.TreeNode;
import com.funambol.framework.tools.Base64;
import com.funambol.framework.tools.DBTools;
import com.funambol.framework.tools.MD5;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ManagementSessionTools {
    private static final String JNDI_NAME = "java:comp/env/jdbc/fnbldm";
    private static final String DEFAULT_USER_NAME = "funambol";
    private static final String DEFAULT_USER_PASSWORD = "funambol";
    private static final String DEFAULT_DEVICE_DESCRIPTION = "phone for DM demo";
    private static final String DEFAULT_DEVICE_SERVER_PASSWORD = "srvpwd";
    private static final String DEFAULT_DEVICE_TYPE = "phone";
    private static final String COMMAND_WITHOUT_VALUE_IN_RESPONSE = "Add, Replace";
    private static final String SQL_INSERT_DM_STATE = "INSERT INTO fnbl_dm_state (id,device,mssid,state,operation) values (?,?,?,'P',?)";
    private static final String SQL_INSERT_DM_DEMO_OPERATIONS = "INSERT INTO fnbl_dmdemo_operations (id,operations) values (?,?)";
    private static final String SQL_SELECT_DM_DEMO_OPERATIONS = "SELECT id,operations,results FROM fnbl_dmdemo_operations WHERE id=?";
    private static final String SQL_SELECT_DM_SESSIONS_LIST = "SELECT id, device, state, operation, start_ts, end_ts FROM fnbl_dm_state ";
    private static final String SQL_SELECT_DM_STATE = "SELECT id, device, state, start_ts, end_ts FROM fnbl_dm_state WHERE mssid=?";
    private static final String SQL_UPDATE_DM_DEMO_OPERATIONS = "UPDATE fnbl_dmdemo_operations SET operations=? WHERE id=?";
    private static final String SQL_INSERT_TREE_DISCOVERY_SESSION = "INSERT INTO fnbl_device_tree (id,root_node) values (?,?)";
    private static final String SQL_UPDATE_TREE_DISCOVERY_SESSION = "UPDATE fnbl_device_tree set root_node=? WHERE id=?";
    private static final String SQL_SELECT_TREE_DISCOVERY_SESSION = "SELECT id, root_node, results FROM fnbl_device_tree WHERE id=? ";
    private static final String SQL_INSERT_NEW_USER_DM_DEMO = "INSERT INTO fnbl_user_dm_demo  (name, company, job, address, city, zip, state, country, email, phone, device_id, password)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_SELECT_USER_DM_DEMO = "SELECT password FROM fnbl_user_dm_demo WHERE device_id=?";
    private static final String SQL_INSERT_USER = "INSERT INTO fnbl_user (username) values (?)";
    private static final String SQL_UPDATE_USER = "UPDATE fnbl_user SET password=?, email=?, last_name=? WHERE username = ?";
    private static final String SQL_INSERT_DEVICE = "INSERT INTO fnbl_device (id, description, type, digest, server_password)  values (?,?,?,?,?)";
    private static final String SQL_UPDATE_DEVICE = "UPDATE fnbl_device SET description=?, type=?, digest=?, client_nonce=?, server_nonce=?, server_password=?  WHERE id= ?";
    private static final String SQL_SELECT_USER = "SELECT * FROM fnbl_user WHERE username=?";
    private static final String SQL_SELECT_DEVICE = "SELECT * FROM fnbl_device WHERE id=?";
    private static final String SQL_SELECT_ID_PRINCIPAL = "SELECT counter FROM fnbl_id WHERE idspace=?";
    private static final String SQL_UPDATE_ID_PRINCIPAL = "UPDATE fnbl_id SET counter=? WHERE idspace=?";
    private static final String SQL_SELECT_PRINCIPAL = "SELECT * FROM fnbl_principal WHERE username=? AND device=?";
    private static final String SQL_INSERT_PRINCIPAL = "INSERT INTO fnbl_principal (id, username, device) values (?,?,?)";
    private static final Logger log = Logger.getLogger((String)ManagementSessionTools.class.getName());
    private DataSource datasource = null;
    private String sessionId = null;
    private String state = null;
    private String deviceId = null;
    private List<ManagementOperation> operationsList = null;
    private List<ManagementOperationResult> operationsResults = null;
    private String rootNode = null;
    private Map treeDiscoveryResults = null;

    public ManagementSessionTools() {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)"New ManagementSessionTools");
        }
        this.datasource = this.lookupDataSource();
    }

    public DataSource getDataSource() {
        if (this.datasource == null) {
            this.datasource = this.lookupDataSource();
        }
        return this.datasource;
    }

    public List<Map> getSessionsList(String deviceId) throws ManagementException {
        String whereDeviceId = "";
        if (deviceId != null && !deviceId.equals("")) {
            whereDeviceId = " WHERE device=?";
        } else {
            deviceId = "";
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String query = "SELECT id, device, state, operation, start_ts, end_ts FROM fnbl_dm_state  " + whereDeviceId + " order by id, end_ts";
        ArrayList<Map> sessionsList = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(query);
            if (deviceId != null && !deviceId.equals("")) {
                pStmt.setObject(1, deviceId);
            }
            rs = pStmt.executeQuery();
            sessionsList = new ArrayList<Map>();
            HashMap<String, Object> row = null;
            while (rs.next()) {
                row = new HashMap<String, Object>();
                row.put("id", rs.getString("id"));
                row.put("device", rs.getString("device"));
                row.put("operation", rs.getString("operation"));
                row.put("state", rs.getString("state"));
                row.put("start_ts", rs.getTimestamp("start_ts"));
                row.put("end_ts", rs.getTimestamp("end_ts"));
                sessionsList.add(row);
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error reading the sessions list", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        return sessionsList;
    }

    public int updateOperationsList() throws ManagementException {
        if (this.sessionId == null) {
            return 0;
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int numUpdated = 0;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_UPDATE_DM_DEMO_OPERATIONS);
            pStmt.setObject(1, this.getXmlOperationsList());
            pStmt.setObject(2, this.sessionId);
            numUpdated = pStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error updating the operations list for session: " + this.sessionId, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, rs);
        return numUpdated;
    }

    public List<ManagementOperation> getOperationsList() {
        if (this.operationsList == null) {
            return new ArrayList<ManagementOperation>();
        }
        return this.operationsList;
    }

    public Map getTreeDiscoveryResults() {
        if (this.treeDiscoveryResults == null) {
            return new HashMap();
        }
        return this.treeDiscoveryResults;
    }

    public List<ManagementOperationResult> getOperationsResults() {
        if (this.operationsResults == null) {
            return new ArrayList<ManagementOperationResult>();
        }
        return this.operationsResults;
    }

    public void startNewManagementSession(String deviceId) throws ManagementException {
        String sessionId = String.valueOf(System.currentTimeMillis());
        this.operationsList = new ArrayList<ManagementOperation>();
        this.operationsResults = null;
        this.sessionId = sessionId;
        this.deviceId = deviceId;
        this.state = "P";
        this.rootNode = null;
        this.treeDiscoveryResults = null;
    }

    public void saveOperationsList() throws ManagementException {
        if (this.sessionId == null) {
            return;
        }
        int numUpdated = this.updateOperationsList();
        if (numUpdated == 0) {
            this.insertOperationsList();
        }
    }

    public boolean loginUser(String deviceId, String password) throws ManagementException {
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String dbPassword = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_USER_DM_DEMO);
            pStmt.setObject(1, deviceId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                dbPassword = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error reading the user", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        if (dbPassword != null && dbPassword.equalsIgnoreCase(password)) {
            this.deviceId = deviceId;
            return true;
        }
        return false;
    }

    public void insertOperationsList() throws ManagementException {
        if (this.sessionId == null) {
            return;
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_INSERT_DM_STATE);
            pStmt.setObject(1, this.sessionId);
            pStmt.setObject(2, this.deviceId);
            pStmt.setObject(3, this.sessionId);
            pStmt.setObject(4, "DMDemoProcessor");
            int temp = pStmt.executeUpdate();
            pStmt = con.prepareStatement(SQL_INSERT_DM_DEMO_OPERATIONS);
            pStmt.setObject(1, this.sessionId);
            pStmt.setObject(2, this.getXmlOperationsList());
            pStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the session", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, rs);
    }

    public void addManagementOperation(String operationName, String nodeUri, String value, boolean newNode) throws ManagementException {
        AddManagementOperation operationToAdd = null;
        if (this.operationsList == null) {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)"Try to add a new operation with operationsList null");
            }
            return;
        }
        String currentState = this.loadSessionState();
        this.state = currentState == null ? "P" : currentState;
        if (this.state != null && this.state.equals("P")) {
            if (operationName != null) {
                if (operationName.equalsIgnoreCase("Add")) {
                    operationToAdd = new AddManagementOperation();
                    HashMap<String, Object> nodes = new HashMap<String, Object>();
                    if (newNode) {
                        TreeNode newNodeToAdd = new TreeNode(nodeUri);
                        newNodeToAdd.setFormat("node");
                        nodes.put(nodeUri, newNodeToAdd);
                    } else {
                        nodes.put(nodeUri, value);
                    }
                    operationToAdd.setNodes(nodes);
                } else if (operationName.equalsIgnoreCase("Get")) {
                    operationToAdd = new GetManagementOperation();
                    HashMap<String, String> nodes = new HashMap<String, String>();
                    nodes.put(nodeUri, "");
                    ((GetManagementOperation)operationToAdd).setNodes(nodes);
                } else if (operationName.equalsIgnoreCase("Delete")) {
                    operationToAdd = new DeleteManagementOperation();
                    HashMap<String, String> nodes = new HashMap<String, String>();
                    nodes.put(nodeUri, "");
                    ((DeleteManagementOperation)operationToAdd).setNodes(nodes);
                } else if (operationName.equalsIgnoreCase("Replace")) {
                    operationToAdd = new ReplaceManagementOperation();
                    HashMap<String, String> nodes = new HashMap<String, String>();
                    nodes.put(nodeUri, value);
                    ((ReplaceManagementOperation)operationToAdd).setNodes(nodes);
                }
            }
            if (operationToAdd != null) {
                this.operationsList.add((ManagementOperation)operationToAdd);
            }
        }
    }

    public List<ManagementOperationResult> getOperationsResultsWithValue() {
        if (this.operationsResults == null) {
            return null;
        }
        Iterator<ManagementOperationResult> itResults = this.operationsResults.iterator();
        ManagementOperationResult operationResult = null;
        String commandName = null;
        while (itResults.hasNext()) {
            operationResult = itResults.next();
            commandName = operationResult.getCommand();
            if (COMMAND_WITHOUT_VALUE_IN_RESPONSE.indexOf(commandName) == -1) continue;
            this.setValuesInManagementOperationResult(operationResult);
        }
        return this.operationsResults;
    }

    public String getRootNode() {
        return this.rootNode;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void moveOperationUp(int index) {
        ManagementOperation opToMove = null;
        if (index > 0) {
            opToMove = this.operationsList.remove(index);
            this.operationsList.add(index - 1, opToMove);
        }
    }

    public void moveOperationDown(int index) {
        ManagementOperation opToMove = null;
        if (index < this.operationsList.size() - 1) {
            opToMove = this.operationsList.remove(index);
            this.operationsList.add(index + 1, opToMove);
        }
    }

    public void removeOperation(int index) {
        if (this.operationsList == null) {
            return;
        }
        if (index != -1) {
            this.operationsList.remove(index);
        }
    }

    public String getSessionState() {
        return this.state;
    }

    public String getStateDescription() {
        if (this.state == null || this.state.equals("")) {
            return "Unknow";
        }
        if (this.state.equalsIgnoreCase("P")) {
            return "To process";
        }
        if (this.state.equalsIgnoreCase("C")) {
            return "Completed";
        }
        return "Unknow";
    }

    public void loadDMSession(String sessionId) throws ManagementException {
        XMLDecoder decoder;
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("loadDMSession with sessionId: " + sessionId));
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String xmlOperations = null;
        String xmlOperationsResults = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_DM_STATE);
            pStmt.setObject(1, sessionId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                this.deviceId = rs.getString("device");
                this.state = rs.getString("state");
                this.sessionId = sessionId;
            }
            pStmt = con.prepareStatement(SQL_SELECT_DM_DEMO_OPERATIONS);
            pStmt.setObject(1, sessionId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                xmlOperations = rs.getString("operations");
                xmlOperationsResults = rs.getString("results");
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error reading the session operations", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        if (xmlOperations == null) {
            this.operationsList = new ArrayList<ManagementOperation>();
        } else {
            decoder = new XMLDecoder(new ByteArrayInputStream(xmlOperations.getBytes()));
            this.operationsList = (ArrayList)decoder.readObject();
        }
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("number of operations: " + this.operationsList.size()));
        }
        if (xmlOperationsResults == null) {
            this.operationsResults = new ArrayList<ManagementOperationResult>();
        } else {
            decoder = new XMLDecoder(new ByteArrayInputStream(xmlOperationsResults.getBytes()));
            this.operationsResults = (ArrayList)decoder.readObject();
        }
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("number of results: " + this.operationsResults.size()));
        }
    }

    public void cloneSession() {
        this.state = "P";
        this.sessionId = String.valueOf(System.currentTimeMillis());
        this.operationsResults = null;
    }

    private void setValuesInManagementOperationResult(ManagementOperationResult operationResult) {
        String commandName = operationResult.getCommand();
        Map resultNodes = operationResult.getNodes();
        Iterator<ManagementOperation> itOperationsList = this.operationsList.iterator();
        String operationCommandName = null;
        Map operationNodes = null;
        ManagementOperation operation = null;
        while (itOperationsList.hasNext()) {
            operation = itOperationsList.next();
            operationCommandName = operation.getDescription();
            if (!(operation instanceof TreeManagementOperation) || !operationCommandName.equals(commandName) || (operationNodes = ((TreeManagementOperation)operation).getNodes()).size() != resultNodes.size() || !this.compareKeys(resultNodes, operationNodes)) continue;
            operationResult.setNodes(operationNodes);
        }
    }

    private boolean compareKeys(Map map1, Map<String, Object> map2) {
        Iterator itMap1 = map1.keySet().iterator();
        String key1 = null;
        while (itMap1.hasNext()) {
            key1 = (String)itMap1.next();
            if (map2.containsKey(key1)) continue;
            return false;
        }
        return true;
    }

    private DataSource lookupDataSource() {
        DataSource ds;
        block4: {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)"getDataSource: java:comp/env/jdbc/fnbldm");
            }
            ds = null;
            try {
                DataSource obj;
                InitialContext namingContext = new InitialContext();
                ds = obj = (DataSource)namingContext.lookup(JNDI_NAME);
                if (log.isEnabledFor((Priority)Level.TRACE)) {
                    log.trace((Object)("datasource: " + ds));
                }
            }
            catch (Exception e) {
                log.debug((Object)"lookupDataSource", (Throwable)e);
                if (!log.isEnabledFor((Priority)Level.FATAL)) break block4;
                log.fatal((Object)("Error getting the datasource: " + e.getMessage()));
            }
        }
        return ds;
    }

    private String getXmlOperationsList() {
        if (this.operationsList == null) {
            return null;
        }
        String xml = null;
        byte[] bytes = null;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(bout);
        encoder.writeObject(this.operationsList);
        encoder.flush();
        encoder.close();
        bytes = bout.toByteArray();
        xml = new String(bytes);
        return xml;
    }

    private String getXmlForEmptyListOfOperations() {
        byte[] bytes = null;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(bout);
        encoder.writeObject(new ArrayList());
        encoder.flush();
        encoder.close();
        bytes = bout.toByteArray();
        String xml = new String(bytes);
        return xml;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this);
        sb.append("sessionId", (Object)this.sessionId);
        sb.append("deviceId", (Object)this.deviceId);
        sb.append("state", (Object)this.state);
        sb.append("num.operations", (Object)(this.operationsList == null ? "null" : String.valueOf(this.operationsList.size())));
        sb.append("num.results", (Object)(this.operationsResults == null ? "null" : String.valueOf(this.operationsResults.size())));
        sb.append("rootNode", (Object)this.rootNode);
        sb.append("num.results treeDiscovery", (Object)(this.treeDiscoveryResults == null ? "null" : String.valueOf(this.treeDiscoveryResults.size())));
        return sb.toString();
    }

    private String loadSessionState() throws ManagementException {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("loadSessionState with sessionId: " + this.sessionId));
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String state = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_DM_STATE);
            pStmt.setObject(1, this.sessionId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                state = rs.getString("state");
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error reading the session operations", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("State of the session '" + this.sessionId + "':  " + state));
        }
        return state;
    }

    public void insertTreeDiscoverySession(String rootNode) throws ManagementException {
        if (this.sessionId == null) {
            return;
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_INSERT_DM_STATE);
            pStmt.setObject(1, this.sessionId);
            pStmt.setObject(2, this.deviceId);
            pStmt.setObject(3, this.sessionId);
            pStmt.setObject(4, "TreeDiscovery");
            int temp = pStmt.executeUpdate();
            pStmt = con.prepareStatement(SQL_INSERT_TREE_DISCOVERY_SESSION);
            pStmt.setObject(1, this.sessionId);
            pStmt.setObject(2, rootNode);
            pStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the session", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, rs);
    }

    public int updateTreeDiscoverySession(String rootNode) throws ManagementException {
        if (this.sessionId == null) {
            return 0;
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int numUpdated = 0;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_UPDATE_TREE_DISCOVERY_SESSION);
            pStmt.setObject(1, rootNode);
            pStmt.setObject(2, this.sessionId);
            numUpdated = pStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error updating the treeDiscoverySession with session: " + this.sessionId, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, rs);
        return numUpdated;
    }

    public void saveTreeDiscoverySession(String rootNode) throws ManagementException {
        if (this.sessionId == null) {
            throw new ManagementException("The sessionId must be != null");
        }
        if (rootNode == null) {
            throw new ManagementException("The root node must be != null");
        }
        int numUpdated = this.updateTreeDiscoverySession(rootNode);
        if (numUpdated == 0) {
            this.insertTreeDiscoverySession(rootNode);
        }
    }

    public void loadTreeSession(String sessionId) throws ManagementException {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("loadTreeSession with sessionId: " + sessionId));
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String xmlOperationsResults = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_DM_STATE);
            pStmt.setObject(1, sessionId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                this.deviceId = rs.getString("device");
                this.state = rs.getString("state");
                this.sessionId = sessionId;
            }
            pStmt = con.prepareStatement(SQL_SELECT_TREE_DISCOVERY_SESSION);
            pStmt.setObject(1, sessionId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                this.rootNode = rs.getString("root_node");
                xmlOperationsResults = rs.getString("results");
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error reading the session operations", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        if (xmlOperationsResults == null) {
            this.treeDiscoveryResults = new TreeMap();
        } else {
            XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(xmlOperationsResults.getBytes()));
            this.treeDiscoveryResults = (Map)decoder.readObject();
        }
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("number of results: " + this.treeDiscoveryResults.size()));
        }
    }

    public void registerNewUser(String name, String company, String job, String address, String city, String zip, String state, String country, String email, String phone, String deviceId, String password) throws ManagementException {
        this.insertNewUser(name, company, job, address, city, zip, state, country, email, phone, deviceId, password);
        String digest = this.setSync4jUser();
        this.setSync4jDevice(deviceId, digest);
        this.setSync4jPrincipal(digest, deviceId);
    }

    public void insertNewUser(String name, String company, String job, String address, String city, String zip, String state, String country, String email, String phone, String deviceId, String password) throws ManagementException {
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        if (name == null || name.equals("") || deviceId == null || deviceId.equals("") || password == null || password.equals("") || email == null || email.equals("")) {
            throw new ManagementException("Name, Email, Device Id and Password are required");
        }
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_INSERT_NEW_USER_DM_DEMO);
            pStmt.setObject(1, name);
            pStmt.setObject(2, company);
            pStmt.setObject(3, job);
            pStmt.setObject(4, address);
            pStmt.setObject(5, city);
            pStmt.setObject(6, zip);
            pStmt.setObject(7, state);
            pStmt.setObject(8, country);
            pStmt.setObject(9, email);
            pStmt.setObject(10, phone);
            pStmt.setObject(11, deviceId);
            pStmt.setObject(12, password);
            int temp = pStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the new user", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, rs);
    }

    private String setSync4jUser() throws ManagementException {
        String name = "funambol";
        String password = "funambol";
        String digest = new String(Base64.encode((byte[])MD5.digest((byte[])(name + ":" + password).getBytes())));
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        boolean userFound = false;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_USER);
            pStmt.setObject(1, digest);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                userFound = true;
            }
            if (!userFound) {
                pStmt = con.prepareStatement(SQL_INSERT_USER);
                pStmt.setObject(1, digest);
                pStmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the user", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        return digest;
    }

    private void setSync4jDevice(String deviceId, String digest) throws ManagementException {
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        boolean deviceFound = false;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_DEVICE);
            pStmt.setObject(1, deviceId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                deviceFound = true;
            }
            if (!deviceFound) {
                pStmt = con.prepareStatement(SQL_INSERT_DEVICE);
                pStmt.setObject(1, deviceId);
                pStmt.setObject(2, DEFAULT_DEVICE_DESCRIPTION);
                pStmt.setObject(3, DEFAULT_DEVICE_TYPE);
                pStmt.setObject(4, digest);
                pStmt.setObject(5, DEFAULT_DEVICE_SERVER_PASSWORD);
                pStmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the device", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
    }

    private void setSync4jPrincipal(String digest, String deviceId) throws ManagementException {
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        boolean principalFound = false;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_PRINCIPAL);
            pStmt.setObject(1, digest);
            pStmt.setObject(2, deviceId);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                principalFound = true;
            }
            if (!principalFound) {
                pStmt = con.prepareStatement(SQL_INSERT_PRINCIPAL);
                pStmt.setObject(1, this.getSync4jPrincipalId());
                pStmt.setObject(2, digest);
                pStmt.setObject(3, deviceId);
                pStmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the principal", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
    }

    private String getSync4jPrincipalId() throws ManagementException {
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String sId = null;
        int id = -1;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_ID_PRINCIPAL);
            pStmt.setObject(1, "principal");
            rs = pStmt.executeQuery();
            while (rs.next()) {
                sId = rs.getString(1);
            }
            id = Integer.parseInt(sId);
            pStmt = con.prepareStatement(SQL_UPDATE_ID_PRINCIPAL);
            pStmt.setObject(1, String.valueOf(id + 1));
            pStmt.setObject(2, "principal");
            pStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error reading id for the principal", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        return sId;
    }
}

