/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.dmdemo.processor;

import com.funambol.framework.core.Alert;
import com.funambol.framework.core.Util;
import com.funambol.framework.core.dm.ddf.DevInfo;
import com.funambol.framework.engine.dm.DeviceDMState;
import com.funambol.framework.engine.dm.GetManagementOperation;
import com.funambol.framework.engine.dm.LegacyManagementProcessorAdapter;
import com.funambol.framework.engine.dm.ManagementException;
import com.funambol.framework.engine.dm.ManagementOperation;
import com.funambol.framework.engine.dm.ManagementOperationResult;
import com.funambol.framework.engine.dm.TreeNode;
import com.funambol.framework.engine.dm.UserAlertManagementOperation;
import com.funambol.framework.tools.DBTools;
import com.funambol.framework.tools.IOTools;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TreeDiscoveryProcessor
extends LegacyManagementProcessorAdapter
implements Serializable {
    private static final String SQL_UPDATE_DEVICE_TREE = "UPDATE fnbl_treediscovery_processor SET results=? WHERE id=?";
    private static final String SQL_SELECT_ROOT_NODE = "SELECT root_node FROM fnbl_treediscovery_processor WHERE id=?";
    private DataSource datasource = null;
    private String sessionId = null;
    private DeviceDMState dmState = null;
    private final Logger log = Logger.getLogger((String)TreeDiscoveryProcessor.class.getName());
    private ArrayList<String> nodesList = null;
    private Map<String, Object> nodesResults = null;
    private String rootNode = null;
    private boolean dummyAlertAlreadySent = false;
    private String resultsDirectory = System.getProperty("com.funambol.dmdemo.resultsDirectory");
    private String name;
    private String jndiDataSourceName = null;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getJndiDataSourceName() {
        return this.jndiDataSourceName;
    }

    public void setJndiDataSourceName(String jndiDataSourceName) throws ManagementException {
        this.jndiDataSourceName = jndiDataSourceName;
        if (jndiDataSourceName == null) {
            this.datasource = null;
        }
        try {
            InitialContext ctx = new InitialContext();
            this.datasource = (DataSource)ctx.lookup(jndiDataSourceName);
        }
        catch (NamingException e) {
            throw new ManagementException("Data source " + jndiDataSourceName + " not found", (Throwable)e);
        }
    }

    public TreeDiscoveryProcessor() {
        if (this.resultsDirectory == null) {
            this.resultsDirectory = ".";
        }
    }

    public void beginSession(String sessionId, Principal p, int type, DevInfo devInfo, DeviceDMState dmState) throws ManagementException {
        if (this.log.isEnabledFor((Priority)Level.DEBUG)) {
            this.log.debug((Object)"Starting a new DM management session");
            this.log.debug((Object)("sessionId: " + sessionId));
            this.log.debug((Object)("principal: " + p));
            this.log.debug((Object)("type: " + type));
            this.log.debug((Object)("deviceId: " + devInfo));
        }
        this.nodesList = new ArrayList();
        this.nodesResults = new TreeMap<String, Object>();
        this.sessionId = sessionId;
        this.dmState = dmState;
        this.rootNode = this.getRootNode(dmState.id);
        if (this.rootNode != null && !this.rootNode.equals("")) {
            this.nodesList.add(this.rootNode);
        }
    }

    void setGenericAlerts(Alert[] genericAlerts) {
        int numAlerts = genericAlerts.length;
        this.log.info((Object)("SetGenericAlerts (num. alerts: " + numAlerts + ")"));
        for (int i = 0; i < numAlerts; ++i) {
            this.log.info((Object)("Alert[" + i + "]: " + Util.toXML((Object)genericAlerts[i])));
        }
    }

    public void endSession(int completionCode) throws ManagementException {
        this.saveResults();
        if (this.log.isEnabledFor((Priority)Level.DEBUG)) {
            this.log.debug((Object)("End a DM management session with sessionId: " + this.sessionId));
        }
    }

    public ManagementOperation[] getNextOperations() throws ManagementException {
        ArrayList<GetManagementOperation> operationsList = new ArrayList<GetManagementOperation>();
        ManagementOperation[] operations = null;
        HashMap<String, String> nodes = new HashMap<String, String>();
        int numNodes = this.nodesList.size();
        if (numNodes == 0) {
            if (!this.dummyAlertAlreadySent) {
                GetManagementOperation dummyGet = new GetManagementOperation();
                HashMap<String, String> dummyNode = new HashMap<String, String>();
                dummyNode.put("./DevInfo/Man", "");
                dummyGet.setNodes(dummyNode);
                operations = new ManagementOperation[]{dummyGet, UserAlertManagementOperation.getDisplay((String)"Funambol DM Demo", (int)5, (int)15)};
                this.dummyAlertAlreadySent = true;
            } else {
                operations = new ManagementOperation[]{};
            }
            return operations;
        }
        GetManagementOperation o = null;
        for (int i = 0; i < numNodes; ++i) {
            if (i % 10 == 0) {
                if (i != 0) {
                    ((GetManagementOperation)o).setNodes(nodes);
                }
                o = new GetManagementOperation();
                operationsList.add(o);
                nodes = new HashMap();
            }
            nodes.put(this.nodesList.get(i), "");
        }
        ((GetManagementOperation)o).setNodes(nodes);
        operations = operationsList.toArray(new ManagementOperation[0]);
        return operations;
    }

    public void setOperationResults(ManagementOperationResult[] results) throws ManagementException {
        String id = this.dmState.id;
        if (this.log.isEnabledFor((Priority)Level.TRACE)) {
            this.log.trace((Object)("setOperationResults for id: " + id));
        }
        int numResults = results.length;
        this.nodesList = new ArrayList();
        if (!this.dummyAlertAlreadySent) {
            for (int i = 0; i < numResults; ++i) {
                this.nodesList.addAll(this.getNodesList(results[i].getNodes()));
            }
        }
        if (this.nodesList.isEmpty()) {
            if (this.log.isEnabledFor((Priority)Level.TRACE)) {
                this.log.trace((Object)"No other nodes to get");
            }
            this.dmState.state = (byte)67;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRootNode(String id) {
        if (this.log.isEnabledFor((Priority)Level.TRACE)) {
            this.log.trace((Object)("get root node for id: " + id));
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String rootNode = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_SELECT_ROOT_NODE);
            pStmt.setString(1, id);
            rs = pStmt.executeQuery();
            while (rs.next()) {
                rootNode = rs.getString(1);
            }
        }
        catch (SQLException ex) {
            block7: {
                try {
                    if (!this.log.isEnabledFor((Priority)Level.FATAL)) break block7;
                    this.log.fatal((Object)("Error reading root node: " + ex.getMessage()));
                }
                catch (Throwable throwable) {
                    DBTools.close((Connection)con, pStmt, rs);
                    throw throwable;
                }
            }
            DBTools.close((Connection)con, (Statement)pStmt, rs);
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        if (this.log.isEnabledFor((Priority)Level.TRACE)) {
            this.log.trace((Object)("rootNode: " + rootNode));
        }
        return rootNode;
    }

    private void saveResults() {
        block3: {
            String id = this.dmState.id;
            if (this.log.isEnabledFor((Priority)Level.TRACE)) {
                this.log.trace((Object)("save results for id: " + id));
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            XMLEncoder encoder = new XMLEncoder(bout);
            encoder.writeObject(this.nodesResults);
            encoder.flush();
            encoder.close();
            String directory = this.resultsDirectory + File.separator + id;
            File resultsFileDir = new File(directory);
            resultsFileDir.mkdirs();
            File resultsFile = new File(directory + File.separator + "results.xml");
            try {
                IOTools.writeFile((byte[])bout.toByteArray(), (File)resultsFile);
            }
            catch (Exception e) {
                this.log.debug((Object)"saveResults", (Throwable)e);
                if (!this.log.isEnabledFor((Priority)Level.FATAL)) break block3;
                this.log.fatal((Object)("Error saving device tree: " + e.getMessage()));
            }
        }
        this.dmState.state = (byte)67;
    }

    private ArrayList<String> getNodesList(Map nodes) {
        ArrayList<String> nodesList = new ArrayList<String>();
        Iterator it = nodes.keySet().iterator();
        String key = null;
        Object value = null;
        StringTokenizer st = null;
        String format = null;
        String temp = null;
        while (it.hasNext()) {
            key = (String)it.next();
            value = nodes.get(key);
            if (value instanceof TreeNode) {
                format = ((TreeNode)value).getFormat();
                if (format.equalsIgnoreCase("node")) {
                    value = ((TreeNode)value).getValue();
                    st = new StringTokenizer((String)value, "/");
                    while (st.hasMoreTokens()) {
                        temp = key + "/" + st.nextToken();
                        nodesList.add(temp);
                        this.nodesResults.put(temp, "");
                    }
                    continue;
                }
                this.nodesResults.put(key, value);
                continue;
            }
            this.nodesResults.put(key, value);
        }
        return nodesList;
    }
}

