/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.bootstrap;

import com.funambol.framework.core.dm.bootstrap.BasicAccountInfo;
import com.funambol.framework.core.dm.bootstrap.Characteristic;
import com.funambol.framework.core.dm.bootstrap.Parm;
import com.funambol.framework.core.dm.bootstrap.WapProvisioningDoc;
import com.funambol.framework.notification.NotificationException;
import com.funambol.framework.tools.Base64;
import com.funambol.server.notification.WBXMLTools;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jibx.runtime.JiBXException;

public class WapBootstrapMessageBuilder {
    private static final String VERSION_WAP_PROVISIONIG_DOC = "1.0";
    private static final String APPLICATION_ID = "w7";
    private static final String AAUTH_LEVEL_SERVER = "APPSRV";
    private static final String AAUTH_LEVEL_CLIENT = "CLIENT";
    private static final String PROPERTY_NAME_ADDR = "ADDR";
    private static final String PROPERTY_NAME_APPLICATION_ID = "APPID";
    private static final String PROPERTY_NAME_NAME = "NAME";
    private static final String PROPERTY_NAME_PROVIDER_ID = "PROVIDER-ID";
    private static final String PROPERTY_NAME_AAUTHSECRET = "AAUTHSECRET";
    private static final String PROPERTY_NAME_AAUTHDATA = "AAUTHDATA";
    private static final String PROPERTY_NAME_AAUTHNAME = "AAUTHNAME";
    private static final String PROPERTY_NAME_AAUTHLEVEL = "AAUTHLEVEL";
    private static final String PROPERTY_NAME_PORTNBR = "PORTNBR";
    private static final Logger log = Logger.getLogger((String)WapBootstrapMessageBuilder.class.getName());

    public byte[] buildMessage(BasicAccountInfo basicAccountInfo, WapProvisioningDoc wapDoc) throws NotificationException {
        Characteristic w7;
        if (wapDoc == null) {
            wapDoc = new WapProvisioningDoc(VERSION_WAP_PROVISIONIG_DOC);
        }
        if ((w7 = this.getApplicationW7(wapDoc)) == null) {
            w7 = new Characteristic("APPLICATION");
            Parm appId = new Parm(PROPERTY_NAME_APPLICATION_ID, APPLICATION_ID);
            w7.add(appId);
            wapDoc.addCharacteristic(w7);
        }
        this.setDMAccount(basicAccountInfo, w7);
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            try {
                log.trace((Object)("WapProvisioninDoc to send: " + wapDoc.toXml()));
            }
            catch (JiBXException ex) {
                // empty catch block
            }
        }
        byte[] message = null;
        try {
            message = WBXMLTools.toWBXML(wapDoc);
        }
        catch (Exception e) {
            throw new NotificationException("Error during the conversion of the WAP bootstrap message in WBXML", (Throwable)e);
        }
        return message;
    }

    private Characteristic getApplicationW7(WapProvisioningDoc wapDoc) {
        ArrayList characteristics = wapDoc.getCharacteristics();
        if (characteristics == null || characteristics.isEmpty()) {
            return null;
        }
        Iterator itCharacteristics = characteristics.iterator();
        Characteristic c = null;
        Parm parm = null;
        while (itCharacteristics.hasNext()) {
            c = (Characteristic)itCharacteristics.next();
            if (!"APPLICATION".equalsIgnoreCase(c.getType()) || (parm = c.getParm(PROPERTY_NAME_APPLICATION_ID)) == null || !APPLICATION_ID.equals(parm.getValue())) continue;
            return c;
        }
        return null;
    }

    private void setDMAccount(BasicAccountInfo basicAccountInfo, Characteristic applicationCharacteristic) {
        applicationCharacteristic.removeParm(PROPERTY_NAME_NAME);
        applicationCharacteristic.removeParm(PROPERTY_NAME_PROVIDER_ID);
        applicationCharacteristic.removeCharacteristic("APPAUTH");
        applicationCharacteristic.removeCharacteristic("APPADDR");
        int position = 1;
        String accountName = basicAccountInfo.getAccountName();
        if (accountName != null) {
            position = applicationCharacteristic.setParm(PROPERTY_NAME_NAME, accountName, position++);
        }
        applicationCharacteristic.setParm(PROPERTY_NAME_PROVIDER_ID, basicAccountInfo.getServerId(), position++);
        Characteristic appAddr = new Characteristic("APPADDR");
        Parm addr = new Parm(PROPERTY_NAME_ADDR, basicAccountInfo.getServerAddress());
        appAddr.add(addr);
        Characteristic port = new Characteristic("PORT");
        Parm portNbr = new Parm(PROPERTY_NAME_PORTNBR, String.valueOf(basicAccountInfo.getServerPort()));
        port.add(portNbr);
        appAddr.add(port);
        Characteristic appAuthServer = new Characteristic("APPAUTH");
        Parm levelServer = new Parm(PROPERTY_NAME_AAUTHLEVEL, AAUTH_LEVEL_SERVER);
        Parm serverName = new Parm(PROPERTY_NAME_AAUTHNAME, basicAccountInfo.getServerId());
        Parm serverPw = new Parm(PROPERTY_NAME_AAUTHSECRET, basicAccountInfo.getServerPassword());
        String serverNonceB64 = new String(Base64.encode((byte[])basicAccountInfo.getServerNonce()));
        Parm serverNonce = new Parm(PROPERTY_NAME_AAUTHDATA, serverNonceB64);
        appAuthServer.add(levelServer);
        appAuthServer.add(serverName);
        appAuthServer.add(serverPw);
        appAuthServer.add(serverNonce);
        Characteristic appAuthClient = new Characteristic("APPAUTH");
        Parm levelClient = new Parm(PROPERTY_NAME_AAUTHLEVEL, AAUTH_LEVEL_CLIENT);
        Parm clientName = new Parm(PROPERTY_NAME_AAUTHNAME, basicAccountInfo.getClientUsername());
        Parm clientPwd = new Parm(PROPERTY_NAME_AAUTHSECRET, basicAccountInfo.getClientPassword());
        String clientNonceB64 = new String(Base64.encode((byte[])basicAccountInfo.getClientNonce()));
        Parm clientNonce = new Parm(PROPERTY_NAME_AAUTHDATA, clientNonceB64);
        appAuthClient.add(levelClient);
        appAuthClient.add(clientName);
        appAuthClient.add(clientPwd);
        appAuthClient.add(clientNonce);
        applicationCharacteristic.add(appAddr);
        applicationCharacteristic.add(appAuthServer);
        applicationCharacteristic.add(appAuthClient);
    }
}

