/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.engine;

import com.funambol.framework.config.Configuration;
import com.funambol.framework.config.ConfigurationConstants;
import com.funambol.framework.core.Authentication;
import com.funambol.framework.core.Constants;
import com.funambol.framework.core.Cred;
import com.funambol.framework.core.HMACAuthentication;
import com.funambol.framework.core.Sync4jException;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.core.Util;
import com.funambol.framework.engine.pipeline.MessageProcessingContext;
import com.funambol.framework.engine.pipeline.PipelineManager;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.server.Sync4jDevice;
import com.funambol.framework.server.SyncResponse;
import com.funambol.framework.server.error.BadRequestException;
import com.funambol.framework.server.error.InvalidCredentialsException;
import com.funambol.framework.server.error.NotImplementedException;
import com.funambol.framework.server.error.ServerException;
import com.funambol.framework.server.session.SessionHandler;
import com.funambol.framework.server.store.PersistentStore;
import com.funambol.framework.server.store.PersistentStoreException;
import com.funambol.framework.tools.SecurityTools;
import com.funambol.framework.tools.WBXMLTools;
import com.funambol.framework.tools.beans.BeanFactory;
import com.funambol.server.SyncMLCanonizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class SyncAdapter
implements Constants,
ConfigurationConstants,
Serializable {
    protected static final String CONFIG_SYNCML_CANONIZER = "com/funambol/server/SyncMLCanonizer.xml";
    protected static final String HMAC_ALGORITHM = "MD5";
    protected static final transient Logger log = Logger.getLogger((String)SyncAdapter.class.getName());
    protected SessionHandler sessionHandler = null;
    protected Configuration config = null;
    protected String sessionId = null;
    protected PipelineManager pipelineManager = null;
    protected MessageProcessingContext mpc = null;
    protected SyncML inputMessage = null;
    protected SyncMLCanonizer syncMLCanonizer = null;
    protected String mimeType = null;

    public SyncAdapter(Configuration config) {
        this.config = config;
        this.sessionHandler = (SessionHandler)config.getBeanInstance("engine.handler");
        this.pipelineManager = (PipelineManager)config.getBeanInstance("engine.pipeline");
        try {
            this.syncMLCanonizer = (SyncMLCanonizer)BeanFactory.getBeanInstance((ClassLoader)config.getClassLoader(), (String)CONFIG_SYNCML_CANONIZER);
        }
        catch (Exception e) {
            log.debug((Object)"constructor", (Throwable)e);
            new Sync4jException("Error " + e.getClass().getName() + " creating the syncMLCanonizer: " + e.getMessage()).printStackTrace();
        }
        this.mpc = new MessageProcessingContext();
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void endSync() {
        int currentState = this.sessionHandler.getCurrentState();
        switch (currentState) {
            case 1: {
                this.sessionHandler.commit();
                break;
            }
            case 65535: {
                this.sessionHandler.abort(506);
                break;
            }
            case 2: {
                this.sessionHandler.abort(20000);
                break;
            }
            default: {
                this.sessionHandler.abort(10000);
            }
        }
    }

    public SyncResponse processMessage(byte[] msg, String mimeType, String hmacHeader) throws ServerException {
        SyncML outMessage;
        String inMessage;
        SyncResponse response;
        block35: {
            response = null;
            inMessage = null;
            outMessage = null;
            if (msg == null) {
                String err = "msg is null!";
                if (log.isEnabledFor((Priority)Level.FATAL)) {
                    log.fatal((Object)err);
                }
                throw new ServerException(err);
            }
            if (mimeType == null) {
                String err = "mimeType is null!";
                if (log.isEnabledFor((Priority)Level.FATAL)) {
                    log.fatal((Object)err);
                }
                throw new ServerException(err);
            }
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)("mimeType: " + mimeType));
            }
            this.mimeType = mimeType;
            try {
                if ("application/vnd.syncml+wbxml".equals(mimeType) || "application/vnd.syncml.dm+wbxml".equals(mimeType)) {
                    if (log.isEnabledFor((Priority)Level.TRACE)) {
                        log.trace((Object)"Convert message from wbxml to xml");
                    }
                    inMessage = WBXMLTools.wbxmlToXml((byte[])msg);
                    break block35;
                }
                if ("application/vnd.syncml+xml".equals(mimeType) || "application/vnd.syncml.dm+xml".equals(mimeType)) {
                    inMessage = new String(msg);
                    break block35;
                }
                String err = "Unknown mime type:  " + mimeType;
                if (log.isEnabledFor((Priority)Level.FATAL)) {
                    log.fatal((Object)err);
                }
                throw new NotImplementedException(err);
            }
            catch (Sync4jException e) {
                String err = "Error processing message: " + e.getMessage();
                if (log.isEnabledFor((Priority)Level.FATAL)) {
                    log.fatal((Object)err);
                }
                throw new ServerException(err, (Throwable)e);
            }
        }
        inMessage = this.syncMLCanonizer.canonizeInputMessage(inMessage);
        try {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)("Message to translate into the SyncML object:\n" + inMessage));
            }
            IBindingFactory f = BindingDirectory.getFactory(SyncML.class);
            IUnmarshallingContext c = f.createUnmarshallingContext();
            Object syncML = c.unmarshalDocument((InputStream)new ByteArrayInputStream(inMessage.getBytes()), "UTF-8");
            this.inputMessage = (SyncML)syncML;
        }
        catch (JiBXException e) {
            e.printStackTrace();
            if (log.isEnabledFor((Priority)Level.FATAL)) {
                log.fatal((Object)("Error unmarshalling message: " + e.getMessage()));
            }
            throw new ServerException((Throwable)e);
        }
        this.mpc.setProperty("funambol.sessionid", (Object)this.sessionId);
        try {
            if (this.pipelineManager != null) {
                if (log.isEnabledFor((Priority)Level.TRACE)) {
                    log.trace((Object)"Calling input pipeline");
                }
                this.pipelineManager.preProcessMessage(this.mpc, this.inputMessage);
            } else if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)"Pipeline manager is null...preprocess message not performed");
            }
            outMessage = this.processInputMessage(hmacHeader, msg);
            String resultMimeType = mimeType;
            if (this.pipelineManager != null) {
                if (log.isEnabledFor((Priority)Level.TRACE)) {
                    log.trace((Object)"Calling output pipeline");
                }
                this.pipelineManager.postProcessMessage(this.mpc, outMessage);
            } else if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)"Pipeline manager is null...postprocess message not performed");
            }
            Cred credOut = outMessage.getSyncHdr().getCred();
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                if (credOut != null) {
                    log.trace((Object)("credOut.getFormat: " + credOut.getFormat()));
                    log.trace((Object)("credOut.getType: " + credOut.getType()));
                    log.trace((Object)("credOut.getData: " + credOut.getData()));
                } else {
                    log.trace((Object)"credOut is null");
                }
            }
            boolean hmacRequired = false;
            String serverId = null;
            String serverPassword = null;
            byte[] serverNonce = null;
            if (credOut != null && credOut.getType().equalsIgnoreCase("syncml:auth-MAC")) {
                hmacRequired = true;
                outMessage.getSyncHdr().setCred(null);
            }
            if (credOut != null) {
                Sync4jDevice device = this.sessionHandler.getDevice();
                serverId = this.config.getStringValue("server.id");
                if (device != null) {
                    serverPassword = device.getServerPassword();
                    serverNonce = device.getServerNonce();
                }
            }
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)("Outgoing message: " + Util.toXML((SyncML)outMessage)));
            }
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)("The process is " + (outMessage.isLastMessage() ? "" : "not ") + "complete"));
            }
            response = this.getSyncResponse(outMessage, resultMimeType, hmacRequired, serverId, serverPassword, serverNonce);
        }
        catch (Sync4jException e) {
            String err = "Error processing return message: " + e.getMessage();
            if (log.isEnabledFor((Priority)Level.FATAL)) {
                log.fatal((Object)err);
            }
            throw new ServerException(err);
        }
        return response;
    }

    public SyncResponse processStatusCode(int statusCode, String info) {
        if (statusCode != 200) {
            this.sessionHandler.abort(statusCode);
        }
        return null;
    }

    private SyncML processInputMessage(String hmacHeader, byte[] data) throws ServerException {
        try {
            try {
                this.sessionHandler.setMimeType(this.mimeType);
                this.checkHmacHeader(hmacHeader, data);
                return this.sessionHandler.processMessage(this.inputMessage);
            }
            catch (InvalidCredentialsException e) {
                return this.sessionHandler.processError(this.inputMessage, (Throwable)e);
            }
            catch (ServerException e) {
                return this.sessionHandler.processError(this.inputMessage, (Throwable)e);
            }
            catch (ProtocolException e) {
                return this.sessionHandler.processError(this.inputMessage, (Throwable)new BadRequestException(e.getMessage()));
            }
        }
        catch (Sync4jException e1) {
            throw new ServerException((Throwable)e1);
        }
    }

    private void checkHmacHeader(String hmacHeader, byte[] data) throws ServerException {
        if (hmacHeader == null) {
            return;
        }
        HMACAuthentication auth = new HMACAuthentication(hmacHeader);
        String algorithm = auth.getAlgorithm();
        if (!HMAC_ALGORITHM.equals(algorithm)) {
            throw new IllegalArgumentException("Algorithm '" + algorithm + "' isn't supported using hmac");
        }
        String deviceId = this.inputMessage.getSyncHdr().getSource().getLocURI();
        String calculatedMac = this.calculateMac(algorithm, deviceId, data);
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("calculatedMac: " + calculatedMac));
        }
        auth.setCalculatedMac(calculatedMac);
        auth.setDeviceId(deviceId);
        Cred cred = new Cred((Authentication)auth);
        this.inputMessage.getSyncHdr().setCred(cred);
    }

    private String calculateMac(String algorithm, String deviceId, byte[] data) {
        PersistentStore ps = (PersistentStore)this.config.getBeanInstance("engine.store");
        Sync4jDevice device = new Sync4jDevice(deviceId);
        try {
            boolean tmp = ps.read((Object)device);
        }
        catch (PersistentStoreException e) {
            if (log.isEnabledFor((Priority)Level.FATAL)) {
                log.fatal((Object)("Error reading device with id: '" + deviceId + "': " + (Object)((Object)e)));
            }
            log.debug((Object)"calculateMac", (Throwable)e);
            return null;
        }
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Compute hmac credential for device: " + device));
        }
        String hmacValue = null;
        try {
            hmacValue = SecurityTools.getHMACValue((String)algorithm, (byte[])data, (String)device.getDigest(), (byte[])device.getClientNonce(), (Logger)log);
        }
        catch (NoSuchAlgorithmException e) {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.fatal((Object)e.getMessage());
            }
            log.debug((Object)"calculateMac", (Throwable)e);
        }
        return hmacValue;
    }

    private SyncResponse getSyncResponse(SyncML outMessage, String mimeType, boolean hmacRequired, String serverId, String serverPassword, byte[] serverNonce) throws ServerException {
        byte[] msg = null;
        if ("application/vnd.syncml+xml".equals(mimeType) || "application/vnd.syncml.dm+xml".equals(mimeType)) {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)"Sending back XML");
            }
            try {
                if (log.isEnabledFor((Priority)Level.TRACE)) {
                    log.trace((Object)"Marshalling response message SyncML");
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                IBindingFactory f = BindingDirectory.getFactory(SyncML.class);
                IMarshallingContext c = f.createMarshallingContext();
                c.setIndent(0);
                c.marshalDocument((Object)outMessage, "UTF-8", null, (OutputStream)bout);
                msg = bout.toByteArray();
                msg = this.syncMLCanonizer.canonizeOutputMessage(new String(msg)).getBytes();
            }
            catch (Exception e) {
                throw new ServerException("Error marshalling the syncml response", (Throwable)e);
            }
        }
        if ("application/vnd.syncml+wbxml".equals(mimeType) || "application/vnd.syncml.dm+wbxml".equals(mimeType)) {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)"Sending back WBXML");
            }
            String verDTD = outMessage.getSyncHdr().getVerDTD().getValue();
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                IBindingFactory f = BindingDirectory.getFactory(SyncML.class);
                IMarshallingContext c = f.createMarshallingContext();
                c.setIndent(0);
                c.marshalDocument((Object)outMessage, "UTF-8", null, (OutputStream)bout);
                msg = bout.toByteArray();
                String sResponse = this.syncMLCanonizer.canonizeOutputMessage(new String(msg));
                msg = WBXMLTools.toWBXML((String)sResponse, (String)verDTD);
            }
            catch (Exception e) {
                throw new ServerException("Error converting the syncml response in wbxml", (Throwable)e);
            }
        }
        StringBuffer hmacHeaderResponse = null;
        if (hmacRequired) {
            try {
                String mac = SecurityTools.getHMACValue((String)HMAC_ALGORITHM, msg, (String)serverId, (String)serverPassword, (byte[])serverNonce, (Logger)log);
                if (mac == null) {
                    mac = "";
                }
                hmacHeaderResponse = new StringBuffer("algorithm=");
                hmacHeaderResponse.append(HMAC_ALGORITHM).append(", username=\"");
                hmacHeaderResponse.append(serverId).append("\", mac=").append(mac);
            }
            catch (NoSuchAlgorithmException e) {
                if (log.isEnabledFor((Priority)Level.FATAL)) {
                    log.fatal((Object)("Error calculating hmac: " + e));
                }
                log.debug((Object)"getSyncResponse", (Throwable)e);
            }
        }
        Sync4jResponse syncResponse = new Sync4jResponse(msg, mimeType, hmacHeaderResponse == null ? null : hmacHeaderResponse.toString(), outMessage.isLastMessage());
        return syncResponse;
    }

    private static class Sync4jResponse
    implements SyncResponse {
        private byte[] msg;
        private String resultMimeType;
        private String hmacHeader;
        private boolean lastMessage;

        private Sync4jResponse(byte[] msg, String resultMimeType, String hmacHeader, boolean lastMessage) {
            this.msg = msg;
            this.resultMimeType = resultMimeType;
            this.hmacHeader = hmacHeader;
            this.lastMessage = lastMessage;
        }

        public byte[] getMessage() {
            return this.msg;
        }

        public String getMimeType() {
            return this.resultMimeType;
        }

        public String getHMACHeader() {
            return this.hmacHeader;
        }

        public boolean isCompleted() {
            return this.lastMessage;
        }
    }
}

