/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.engine.dm;

import com.funambol.framework.config.Configuration;
import com.funambol.framework.config.ConfigurationConstants;
import com.funambol.framework.core.dm.ddf.DevInfo;
import com.funambol.framework.engine.dm.DeviceDMState;
import com.funambol.framework.engine.dm.ManagementProcessor;
import com.funambol.framework.server.dm.ProcessorSelector;
import com.funambol.framework.tools.beans.BeanInitializationException;
import com.funambol.framework.tools.beans.LazyInitBean;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class OperationProcessorSelector
implements ProcessorSelector,
LazyInitBean,
ConfigurationConstants {
    private static final transient Logger log = Logger.getLogger((String)OperationProcessorSelector.class.getName());
    private String defaultProcessor;
    private String errorProcessor;
    private String namePrefix;
    private String namePostfix;

    public void setDefaultProcessor(String defaultProcessor) {
        this.defaultProcessor = defaultProcessor;
    }

    public String getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public void setErrorProcessor(String errorProcessor) {
        this.errorProcessor = errorProcessor;
    }

    public String getErrorProcessor() {
        return this.errorProcessor;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePostfix(String namePostfix) {
        this.namePostfix = namePostfix;
    }

    public String getNamePostfix() {
        return this.namePostfix;
    }

    public ManagementProcessor getProcessor(DeviceDMState dms, DevInfo devInfo) {
        String processorName = null;
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("dms: " + dms));
        }
        processorName = dms.state == 69 ? this.errorProcessor : (StringUtils.isEmpty((String)dms.operation) ? this.defaultProcessor : this.namePrefix + dms.operation + this.namePostfix);
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Selected processor: " + processorName));
        }
        try {
            Object o = Configuration.getConfiguration().getBeanInstanceByName(processorName);
            return (ManagementProcessor)o;
        }
        catch (Exception e) {
            if (log.isEnabledFor((Priority)Level.FATAL)) {
                log.fatal((Object)("Error creating the management processor: " + e.getMessage()));
            }
            log.debug((Object)"getProcessor", (Throwable)e);
            return null;
        }
    }

    public void init() throws BeanInitializationException {
        if (StringUtils.isEmpty((String)this.defaultProcessor)) {
            throw new BeanInitializationException("Missing mandatory parameter defaultProcessor");
        }
        if (StringUtils.isEmpty((String)this.namePrefix)) {
            this.namePrefix = "";
        }
        if (StringUtils.isEmpty((String)this.namePostfix)) {
            this.namePostfix = "";
        }
    }
}

