/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.engine.dm;

import bsh.BshClassManager;
import bsh.Interpreter;
import com.funambol.framework.config.ConfigClassLoader;
import com.funambol.framework.config.Configuration;
import com.funambol.framework.core.Alert;
import com.funambol.framework.core.dm.ddf.DevInfo;
import com.funambol.framework.engine.dm.DeviceDMState;
import com.funambol.framework.engine.dm.ManagementException;
import com.funambol.framework.engine.dm.ManagementOperation;
import com.funambol.framework.engine.dm.ManagementOperationResult;
import com.funambol.framework.engine.dm.ManagementProcessor;
import com.funambol.framework.engine.dm.SessionContext;
import com.funambol.framework.security.Sync4jPrincipal;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ScriptManagementProcessor
implements ManagementProcessor,
Serializable {
    public static final String VAR_PROCESSOR = "processor";
    public static final String VAR_SESSIONID = "sessionId";
    public static final String VAR_PRINCIPAL = "principal";
    public static final String VAR_MANAGEMENT_TYPE = "managementType";
    public static final String VAR_DEVINFO = "devInfo";
    public static final String VAR_CONFIG = "config";
    public static final String VAR_OPERATIONS = "operations";
    public static final String VAR_RESULTS = "results";
    public static final String VAR_LOG = "log";
    public static final String VAR_DM_STATE = "dmstate";
    public static final String VAR_GENERIC_ALERTS = "genericAlerts";
    public static final String VAR_SESSION_CONTEXT = "context";
    public static final String SCRIPT_INIT = "init()";
    public static final String SCRIPT_NEXTOPERATIONS = "getNextOperations()";
    public static final String SCRIPT_SETRESULTS = "setOperationResults()";
    public static final String SCRIPT_SETGENERICALERTS = "setGenericAlerts()";
    public static final String SCRIPT_ENDSESSION = "endSession";
    private Interpreter interpreter;
    private static final Logger log = Logger.getLogger((String)ScriptManagementProcessor.class.getName());
    private String name;
    private String scriptFile;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setScriptFile(String scriptFile) {
        this.scriptFile = scriptFile;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public void beginSession(SessionContext context) throws ManagementException {
        String sessionId = context.getSessionId();
        Sync4jPrincipal p = context.getPrincipal();
        int type = context.getType();
        DevInfo devInfo = context.getDevInfo();
        DeviceDMState dmstate = context.getDmstate();
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)"Starting a new management session");
            log.trace((Object)("sessionContext: " + context));
        }
        Configuration c = Configuration.getConfiguration();
        ConfigClassLoader cl = (ConfigClassLoader)c.getClassLoader();
        URL[] urls = cl.getURLs();
        this.interpreter = new Interpreter();
        if (urls != null) {
            BshClassManager cm = this.interpreter.getClassManager();
            for (int i = 0; i < urls.length; ++i) {
                try {
                    cm.addClassPath(urls[i]);
                    continue;
                }
                catch (Exception e) {
                    if (!log.isEnabledFor((Priority)Level.INFO)) continue;
                    log.info((Object)("Wrong path " + urls[i] + " will not be added to the interpreter classpath"));
                }
            }
        }
        try {
            this.interpreter.set(VAR_PROCESSOR, (Object)this);
            this.interpreter.set(VAR_SESSIONID, (Object)sessionId);
            this.interpreter.set(VAR_PRINCIPAL, (Object)p);
            this.interpreter.set(VAR_MANAGEMENT_TYPE, type);
            this.interpreter.set(VAR_DEVINFO, (Object)devInfo);
            this.interpreter.set(VAR_CONFIG, (Object)c);
            this.interpreter.set(VAR_LOG, (Object)log);
            this.interpreter.set(VAR_DM_STATE, (Object)dmstate);
            this.interpreter.set(VAR_OPERATIONS, null);
            this.interpreter.set(VAR_RESULTS, null);
            this.interpreter.set(VAR_GENERIC_ALERTS, null);
            this.interpreter.set(VAR_SESSION_CONTEXT, (Object)context);
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
        if (this.scriptFile != null && this.scriptFile.trim().length() > 0) {
            InputStream is = cl.getResourceAsStream(this.scriptFile);
            if (is == null) {
                if (log.isEnabledFor((Priority)Level.INFO)) {
                    log.info((Object)("Initialization script file " + this.scriptFile + " not found in config path"));
                }
            } else {
                try {
                    this.interpreter.eval((Reader)new InputStreamReader(is));
                    this.interpreter.eval(SCRIPT_INIT);
                }
                catch (Exception e) {
                    throw new ManagementException(e.getMessage(), (Throwable)e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public void endSession(int completionCode) throws ManagementException {
        String script = "endSession(" + completionCode + ")";
        try {
            this.interpreter.eval(script);
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
        this.interpreter = null;
    }

    public ManagementOperation[] getNextOperations() throws ManagementException {
        try {
            this.interpreter.eval(SCRIPT_NEXTOPERATIONS);
            return (ManagementOperation[])this.interpreter.get(VAR_OPERATIONS);
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public void setOperationResults(ManagementOperationResult[] results) throws ManagementException {
        try {
            this.interpreter.set(VAR_RESULTS, (Object)results);
            this.interpreter.eval(SCRIPT_SETRESULTS);
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public void setGenericAlert(Alert[] genericAlerts) throws ManagementException {
        try {
            this.interpreter.set(VAR_GENERIC_ALERTS, (Object)genericAlerts);
            this.interpreter.eval(SCRIPT_SETGENERICALERTS);
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }
}

