/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.test.tools;

import com.funambol.framework.core.RepresentationException;
import com.funambol.framework.core.Sync4jException;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.tools.CommandIdGenerator;
import com.funambol.framework.tools.IOTools;
import com.funambol.test.TestFailedException;
import com.funambol.test.tools.HttpClientConnection;
import com.funambol.test.tools.SQLTools;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.vmguys.vmtools.ota.OtaUpdate;
import org.vmguys.vmtools.ota.UniqueId;
import org.vmguys.vmtools.utils.DomFactory;

public class PostSyncML {
    public static String LOG_NAME = "funambol.test.tools.PostSyncML";
    public static String FILE_ERROR = "error";
    public static String FILE_RESPONSE = "response";
    public static String FILE_REFERENCE = "reference";
    private CommandIdGenerator idGenerator = new CommandIdGenerator();
    private String nextURL = null;
    private String[] msgs = null;
    private String[] msgFiles = null;
    private String[] ignoreXPaths = null;
    private File baseDir = null;
    private File responseDir = null;
    private File referenceDir = null;
    private File errorDir = null;
    private Connection conn = null;
    private static final Logger log = Logger.getLogger((String)PostSyncML.class.getName());

    public PostSyncML(String initialURL, File baseDir, String[] msgFiles, String[] ignoreXPaths, Connection conn) throws IOException {
        if (msgFiles == null || msgFiles.length == 0) {
            this.msgs = new String[0];
        }
        this.msgs = new String[msgFiles.length];
        this.baseDir = baseDir;
        this.responseDir = new File(baseDir, FILE_RESPONSE);
        this.referenceDir = new File(baseDir, FILE_REFERENCE);
        this.errorDir = new File(baseDir, FILE_ERROR);
        this.msgFiles = msgFiles;
        for (int i = 0; i < msgFiles.length; ++i) {
            this.msgs[i] = IOTools.readFileString((File)new File(baseDir, msgFiles[i]));
        }
        this.ignoreXPaths = ignoreXPaths;
        this.nextURL = initialURL;
        this.conn = conn;
    }

    public void syncAndTest() throws IOException, TestFailedException {
        this.clean();
        SyncML response = null;
        String respURI = null;
        String referenceXML = null;
        File responseFile = null;
        String sqlScriptFileName = null;
        for (int i = 0; i < this.msgs.length; ++i) {
            if (this.conn != null) {
                sqlScriptFileName = this.checkForSQLScriptFile(this.msgFiles[i]);
                log.info((Object)("Executing file: " + sqlScriptFileName));
                if (sqlScriptFileName != null) {
                    try {
                        SQLTools.executeScript(this.conn, new File(this.baseDir, sqlScriptFileName));
                    }
                    catch (Exception ex) {
                        throw new TestFailedException("Error executing sql script file '" + sqlScriptFileName + "'", ex);
                    }
                }
            }
            log.info((Object)("Sending " + this.msgFiles[i]));
            try {
                response = this.postRequest(this.msgs[i]);
            }
            catch (RepresentationException e) {
                IOTools.writeFile((String)e.getMessage(), (File)new File(this.errorDir, this.msgFiles[i]));
                throw new TestFailedException("XML syntax error: " + e.getMessage(), e);
            }
            catch (Sync4jException e) {
                IOTools.writeFile((String)e.getMessage(), (File)new File(this.errorDir, this.msgFiles[i]));
                throw new TestFailedException("XML syntax error: " + e.getMessage(), e);
            }
            responseFile = new File(this.responseDir, this.msgFiles[i]);
            log.info((Object)("Writing the response into " + responseFile));
            try {
                String xmlMsg = this.marshallSyncML(response);
                IOTools.writeFile((String)xmlMsg, (File)responseFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TestFailedException("XML syntax error: " + e.getMessage(), e);
            }
            referenceXML = IOTools.readFileString((File)new File(this.referenceDir, this.msgFiles[i]));
            this.compare(this.msgFiles[i]);
            respURI = response.getSyncHdr().getRespURI();
            if (respURI == null) continue;
            this.nextURL = respURI;
        }
    }

    private SyncML postRequest(String request) throws IOException, Sync4jException, RepresentationException {
        HttpClientConnection syncMLConnection = new HttpClientConnection(this.nextURL);
        return syncMLConnection.sendMessage(request);
    }

    private void compare(String msgFile) throws IOException, TestFailedException {
        File responseFile = new File(this.responseDir, msgFile);
        File referenceFile = new File(this.referenceDir, msgFile);
        SAXBuilder sb = new SAXBuilder();
        sb.setFactory((JDOMFactory)new DomFactory());
        try {
            Document response = sb.build(responseFile);
            Document reference = sb.build(referenceFile);
            OtaUpdate update = new OtaUpdate(false);
            UniqueId id = new UniqueId("SyncMLTest", msgFile);
            Element diffs = update.generateDiffs(response.getRootElement(), reference.getRootElement(), id);
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                this.saveDiffs(diffs, new File(this.errorDir, msgFile + ".dbg"));
            }
            if (this.checkDiffs(diffs)) {
                this.saveDiffs(diffs, new File(this.errorDir, msgFile));
                throw new TestFailedException("Test failed on " + msgFile + ". Diff file saved in " + new File(this.errorDir, msgFile));
            }
        }
        catch (JDOMException e) {
            IOTools.writeFile((String)e.getMessage(), (File)new File(this.errorDir, msgFile));
            throw new TestFailedException("Test failed on " + msgFile + ": " + e.getMessage() + ". Error message saved in " + new File(this.errorDir, msgFile));
        }
    }

    private boolean checkDiffs(Element diffs) {
        List positions = diffs.getChildren("Position", diffs.getNamespace());
        Element position2 = null;
        for (Element position2 : positions) {
            if (this.ignore(position2.getAttributeValue("XPath"))) continue;
            return true;
        }
        return false;
    }

    private void clean() {
        int i;
        FilenameFilter filter = IOTools.getFileTypeFilter((String)"xml");
        String[] files = this.responseDir.list(filter);
        for (i = 0; files != null && i < files.length; ++i) {
            new File(files[i]).delete();
        }
        files = this.errorDir.list(filter);
        for (i = 0; files != null && i < files.length; ++i) {
            new File(files[i]).delete();
        }
    }

    private boolean ignore(String xPath) {
        for (int i = 0; xPath != null && this.ignoreXPaths != null && i < this.ignoreXPaths.length; ++i) {
            if (!xPath.equals(this.ignoreXPaths[i])) continue;
            return true;
        }
        return false;
    }

    private void saveDiffs(Element diffs, File file) throws IOException {
        XMLOutputter xmlo = new XMLOutputter("  ", true);
        xmlo.setTextNormalize(true);
        FileOutputStream fos = new FileOutputStream(file);
        xmlo.output(diffs, (OutputStream)fos);
        fos.close();
    }

    private static void syntax() {
        System.out.println("Syntax: " + PostSyncML.class + "<initial URL> <msg1> ... <msgN>");
    }

    private String marshallSyncML(SyncML syncML) throws Sync4jException {
        String msg = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IBindingFactory f = BindingDirectory.getFactory(SyncML.class);
            IMarshallingContext c = f.createMarshallingContext();
            c.setIndent(0);
            c.marshalDocument((Object)syncML, "UTF-8", null, (OutputStream)bout);
            msg = new String(bout.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Sync4jException(e);
        }
        return msg;
    }

    private String checkForSQLScriptFile(String msg) {
        String sqlScriptFileName = null;
        int index = msg.lastIndexOf(46);
        sqlScriptFileName = index == -1 ? msg + ".sql" : msg.substring(0, index) + ".sql";
        File sqlFile = new File(this.baseDir, sqlScriptFileName);
        if (sqlFile.isFile()) {
            return sqlScriptFileName;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            PostSyncML.syntax();
        }
        String[] msgFiles = new String[args.length - 1];
        System.arraycopy(args, 1, msgFiles, 0, msgFiles.length);
        PostSyncML postsyncml = new PostSyncML(args[0], new File("."), msgFiles, new String[0], null);
        postsyncml.syncAndTest();
    }
}

