/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.test.tools;

import com.funambol.framework.core.Sync4jException;
import com.funambol.framework.tools.IOTools;
import com.funambol.framework.tools.WBXMLTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WBXMLConverter {
    private static boolean xmlToWbxml = false;
    private static boolean wbxmlToXml = false;

    public static void main(String[] args) throws Exception {
        try {
            WBXMLConverter.checkArguments(args);
        }
        catch (IllegalArgumentException e) {
            System.out.println("usage:");
            System.out.println(WBXMLConverter.class.getName() + " [-xml|-wbxml] <xml dir>");
            return;
        }
        WBXMLConverter.convert(args.length == 1 ? args[0] : args[1]);
    }

    private static void checkArguments(String[] args) throws IllegalArgumentException {
        switch (args.length) {
            case 0: {
                throw new IllegalArgumentException();
            }
            case 1: {
                wbxmlToXml = false;
                xmlToWbxml = true;
                break;
            }
            case 2: {
                wbxmlToXml = "-wbxml".equalsIgnoreCase(args[0]);
                xmlToWbxml = "-xml".equalsIgnoreCase(args[0]);
                if (wbxmlToXml || xmlToWbxml) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static void convert(String xmlPath) throws IOException, Sync4jException {
        System.out.println("converting xmlPath:" + xmlPath);
        File xmlDir = new File(xmlPath);
        List<File> filesToConvert = WBXMLConverter.getFilesInDir(xmlDir);
        Iterator<File> it = filesToConvert.iterator();
        while (it.hasNext()) {
            try {
                File file = it.next();
                System.out.println("file:" + file.getAbsolutePath());
                if (xmlToWbxml) {
                    WBXMLConverter.xmlToWbxml(file);
                }
                if (!wbxmlToXml) continue;
                WBXMLConverter.wbxmlToXml(file);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void xmlToWbxml(File file) throws IOException, Sync4jException {
        String xml = IOTools.readFileString((File)file);
        byte[] wbxml = WBXMLTools.toWBXML((String)xml);
        String xmlFileName = file.getAbsolutePath();
        String wbxmlFileName = xmlFileName.substring(0, xmlFileName.lastIndexOf("."));
        wbxmlFileName = wbxmlFileName + ".wbxml";
        System.out.println("Writing to: " + wbxmlFileName);
        IOTools.writeFile((byte[])wbxml, (String)wbxmlFileName);
    }

    private static void wbxmlToXml(File file) throws IOException, Sync4jException {
        byte[] wbxml = IOTools.readFileBytes((File)file);
        String xml = WBXMLTools.wbxmlToXml((byte[])wbxml);
        String wbxmlFileName = file.getAbsolutePath();
        String xmlFileName = wbxmlFileName.substring(0, wbxmlFileName.lastIndexOf("."));
        xmlFileName = xmlFileName + ".xml";
        System.out.println("Writing to: " + xmlFileName);
        IOTools.writeFile((String)xml, (String)xmlFileName);
    }

    private static List<File> getFilesInDir(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        File[] dirFiles = dir.listFiles();
        for (int i = 0; dirFiles != null && i < dirFiles.length; ++i) {
            File file = dirFiles[i];
            if (file.isFile()) {
                if (xmlToWbxml) {
                    if (!file.getName().toUpperCase().endsWith(".XML")) continue;
                    files.add(file);
                    continue;
                }
                if (!file.getName().toUpperCase().endsWith(".WBXML")) continue;
                files.add(file);
                continue;
            }
            files.addAll(WBXMLConverter.getFilesInDir(file));
        }
        return files;
    }

    public static String readWbxmlAsXml(File wbxmlFile) throws IOException, Sync4jException {
        FileInputStream fis = new FileInputStream(wbxmlFile);
        byte[] byteArray = new byte[(int)wbxmlFile.length()];
        int count = fis.read(byteArray);
        fis.close();
        return WBXMLTools.wbxmlToXml((byte[])byteArray);
    }
}

