/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.test.tools.ant;

import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Property;

public class IterateTask
extends Task {
    private String items;
    private String targetName;
    private boolean inheritAll = true;
    private Ant task;
    private String property;
    private String delimiter = ",";

    public void setItems(String items) {
        this.items = items;
    }

    public void setTarget(String targetName) {
        this.targetName = targetName;
    }

    public void setInheritAll(boolean inheritAll) {
        this.inheritAll = inheritAll;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void execute() throws BuildException {
        Project p = this.getProject();
        this.validateAttributes();
        this.task.setDir(p.getBaseDir());
        this.task.setAntfile(p.getProperty("ant.file"));
        this.task.setTarget(this.targetName);
        this.task.setInheritAll(this.inheritAll);
        StringTokenizer st = new StringTokenizer(this.items, this.delimiter);
        while (st.hasMoreTokens()) {
            p.setProperty(this.property, st.nextToken().trim());
            this.task.execute();
        }
    }

    public void init() throws BuildException {
        super.init();
        this.task = (Ant)this.getProject().createTask("ant");
        this.task.setOwningTarget(this.getOwningTarget());
        this.task.setTaskName(this.targetName);
        this.task.setLocation(this.getLocation());
        this.task.init();
    }

    public Property createParam() {
        return this.task.createProperty();
    }

    private void validateAttributes() throws BuildException {
        if (this.isEmpty(this.targetName)) {
            throw new BuildException("Attribute target is required.", this.getLocation());
        }
        if (this.isEmpty(this.property)) {
            throw new BuildException("Attribute property is required.", this.getLocation());
        }
        if (this.items == null) {
            throw new BuildException("Attribute items is required.", this.getLocation());
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

