/*
 * Decompiled with CFR 0.152.
 */
package com.danga.MemCached;

import java.util.Date;

public class NativeHandler {
    public static final int MARKER_BYTE = 1;
    public static final int MARKER_BOOLEAN = 2;
    public static final int MARKER_INTEGER = 3;
    public static final int MARKER_LONG = 4;
    public static final int MARKER_CHARACTER = 5;
    public static final int MARKER_STRING = 6;
    public static final int MARKER_STRINGBUFFER = 7;
    public static final int MARKER_FLOAT = 8;
    public static final int MARKER_SHORT = 9;
    public static final int MARKER_DOUBLE = 10;
    public static final int MARKER_DATE = 11;

    public static boolean isHandled(Object value) {
        return value instanceof Boolean || value instanceof Byte || value instanceof String || value instanceof Character || value instanceof StringBuffer || value instanceof Short || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof Date || value instanceof Integer;
    }

    public static byte[] encode(Object value) throws Exception {
        if (value instanceof Boolean) {
            return NativeHandler.encode((Boolean)value);
        }
        if (value instanceof Integer) {
            Integer o = (Integer)value;
            return NativeHandler.encode(o);
        }
        if (value instanceof String) {
            return NativeHandler.encode((String)value);
        }
        if (value instanceof Character) {
            return NativeHandler.encode((Character)value);
        }
        if (value instanceof Byte) {
            return NativeHandler.encode((Byte)value);
        }
        if (value instanceof StringBuffer) {
            return NativeHandler.encode((StringBuffer)value);
        }
        if (value instanceof Short) {
            return NativeHandler.encode((Short)value);
        }
        if (value instanceof Long) {
            Long o = (Long)value;
            return NativeHandler.encode(o);
        }
        if (value instanceof Double) {
            Double o = (Double)value;
            return NativeHandler.encode(o);
        }
        if (value instanceof Float) {
            Float o = (Float)value;
            return NativeHandler.encode(o.floatValue());
        }
        if (value instanceof Date) {
            Date o = (Date)value;
            return NativeHandler.encode(o);
        }
        return null;
    }

    public static byte[] encode(Date value) {
        byte[] b = NativeHandler.getBytes(value.getTime());
        b[0] = 11;
        return b;
    }

    public static byte[] encode(Boolean value) {
        byte[] b = new byte[]{2, value != false ? (byte)1 : 0};
        return b;
    }

    public static byte[] encode(int value) {
        byte[] b = NativeHandler.getBytes(value);
        b[0] = 3;
        return b;
    }

    public static byte[] encode(Character value) {
        byte[] result = NativeHandler.encode((int)value.charValue());
        result[0] = 5;
        return result;
    }

    public static byte[] encode(String value) throws Exception {
        byte[] svalue = value.getBytes("UTF-8");
        byte[] result = new byte[svalue.length + 1];
        result[0] = 6;
        System.arraycopy(svalue, 0, result, 1, svalue.length);
        return result;
    }

    public static byte[] encode(Byte value) {
        byte[] b = new byte[]{1, value};
        return b;
    }

    public static byte[] encode(StringBuffer value) throws Exception {
        byte[] b = NativeHandler.encode(value.toString());
        b[0] = 7;
        return b;
    }

    public static byte[] encode(Short value) throws Exception {
        byte[] b = NativeHandler.encode((int)value.shortValue());
        b[0] = 9;
        return b;
    }

    public static byte[] encode(long value) throws Exception {
        byte[] b = NativeHandler.getBytes(value);
        b[0] = 4;
        return b;
    }

    public static byte[] encode(double value) throws Exception {
        byte[] b = NativeHandler.encode(Double.doubleToLongBits(value));
        b[0] = 10;
        return b;
    }

    public static byte[] encode(float value) throws Exception {
        byte[] b = NativeHandler.encode(Float.floatToIntBits(value));
        b[0] = 8;
        return b;
    }

    public static byte[] getBytes(long value) {
        byte b0 = (byte)(value >> 56 & 0xFFL);
        byte b1 = (byte)(value >> 48 & 0xFFL);
        byte b2 = (byte)(value >> 40 & 0xFFL);
        byte b3 = (byte)(value >> 32 & 0xFFL);
        byte b4 = (byte)(value >> 24 & 0xFFL);
        byte b5 = (byte)(value >> 16 & 0xFFL);
        byte b6 = (byte)(value >> 8 & 0xFFL);
        byte b7 = (byte)(value >> 0 & 0xFFL);
        byte[] b = new byte[9];
        b[1] = b0;
        b[2] = b1;
        b[3] = b2;
        b[4] = b3;
        b[5] = b4;
        b[6] = b5;
        b[7] = b6;
        b[8] = b7;
        return b;
    }

    public static byte[] getBytes(int value) {
        byte b0 = (byte)(value >> 24 & 0xFF);
        byte b1 = (byte)(value >> 16 & 0xFF);
        byte b2 = (byte)(value >> 8 & 0xFF);
        byte b3 = (byte)(value >> 0 & 0xFF);
        byte[] b = new byte[5];
        b[1] = b0;
        b[2] = b1;
        b[3] = b2;
        b[4] = b3;
        return b;
    }

    public static Object decode(byte[] b) throws Exception {
        if (b.length < 1) {
            return null;
        }
        if (b[0] == 2) {
            return NativeHandler.decodeBoolean(b);
        }
        if (b[0] == 3) {
            return NativeHandler.decodeInteger(b);
        }
        if (b[0] == 6) {
            return NativeHandler.decodeString(b);
        }
        if (b[0] == 5) {
            return NativeHandler.decodeCharacter(b);
        }
        if (b[0] == 1) {
            return NativeHandler.decodeByte(b);
        }
        if (b[0] == 7) {
            return NativeHandler.decodeStringBuffer(b);
        }
        if (b[0] == 9) {
            return NativeHandler.decodeShort(b);
        }
        if (b[0] == 4) {
            return NativeHandler.decodeLong(b);
        }
        if (b[0] == 10) {
            return NativeHandler.decodeDouble(b);
        }
        if (b[0] == 8) {
            return NativeHandler.decodeFloat(b);
        }
        if (b[0] == 11) {
            return NativeHandler.decodeDate(b);
        }
        return null;
    }

    public static Date decodeDate(byte[] b) {
        return new Date(NativeHandler.toLong(b));
    }

    public static Boolean decodeBoolean(byte[] b) {
        boolean value;
        boolean bl = value = b[1] == 1;
        if (value) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Integer decodeInteger(byte[] b) {
        return new Integer(NativeHandler.toInt(b));
    }

    public static String decodeString(byte[] b) throws Exception {
        return new String(b, 1, b.length - 1, "UTF-8");
    }

    public static Character decodeCharacter(byte[] b) {
        return new Character((char)NativeHandler.decodeInteger(b).intValue());
    }

    public static Byte decodeByte(byte[] b) {
        byte value = b[1];
        return new Byte(value);
    }

    public static StringBuffer decodeStringBuffer(byte[] b) throws Exception {
        return new StringBuffer(NativeHandler.decodeString(b));
    }

    public static Short decodeShort(byte[] b) throws Exception {
        return new Short((short)NativeHandler.decodeInteger(b).intValue());
    }

    public static Long decodeLong(byte[] b) throws Exception {
        return new Long(NativeHandler.toLong(b));
    }

    public static Double decodeDouble(byte[] b) throws Exception {
        Long l = NativeHandler.decodeLong(b);
        return new Double(Double.longBitsToDouble(l));
    }

    public static Float decodeFloat(byte[] b) throws Exception {
        Integer l = NativeHandler.decodeInteger(b);
        return new Float(Float.intBitsToFloat(l));
    }

    public static int toInt(byte[] b) {
        return ((b[4] & 0xFF) << 32) + ((b[3] & 0xFF) << 40) + ((b[2] & 0xFF) << 48) + ((b[1] & 0xFF) << 56);
    }

    public static long toLong(byte[] b) {
        return ((long)b[8] & 0xFFL) + (((long)b[7] & 0xFFL) << 8) + (((long)b[6] & 0xFFL) << 16) + (((long)b[5] & 0xFFL) << 24) + (((long)b[4] & 0xFFL) << 32) + (((long)b[3] & 0xFFL) << 40) + (((long)b[2] & 0xFFL) << 48) + (((long)b[1] & 0xFFL) << 56);
    }
}

