/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.helper;

import java.io.BufferedReader;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ArrayBlockingQueue;
import okuyama.base.job.AbstractHelper;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.util.JavaSystemApi;

public class KeyManagerAcceptHelper
extends AbstractHelper {
    private long connetionTimeout = 1800000L;
    private String queuePrefix = null;
    private ArrayBlockingQueue connectCheckQueue = new ArrayBlockingQueue(5000);
    private CheckConnection[] checkConnections = null;
    private static ILogger logger = LoggerFactory.createLogger(KeyManagerAcceptHelper.class);

    @Override
    public void initHelper(String initValue) {
        if (initValue != null && !initValue.trim().equals("")) {
            long workCloseTimeLong;
            int workCloseTimeInt = Integer.parseInt(initValue);
            this.connetionTimeout = workCloseTimeLong = (long)(workCloseTimeInt * 1000);
        }
        this.checkConnections = new CheckConnection[1];
        this.checkConnections[0] = new CheckConnection();
    }

    @Override
    public String executeHelper(String optionParam) throws BatchException {
        logger.debug("KeyManagerAcceptHelper - executeHelper - start");
        String ret = SUCCESS;
        Object serverStopMarkerFileName = null;
        Object serverStopMarkerFile = null;
        String pollQueueName = null;
        String[] addExecQueueNames = null;
        String addCheckQueueName = null;
        boolean serverRunning = true;
        try {
            Object[] parameters = super.getParameters();
            pollQueueName = (String)parameters[0];
            addExecQueueNames = (String[])parameters[1];
            addCheckQueueName = (String)parameters[0];
            this.checkConnections[0].setAddQueueName(addCheckQueueName);
            this.checkConnections[0].start();
            while (serverRunning) {
                Object[] param = super.pollSpecificationParameterQueue(pollQueueName);
                if (param == null || param.length < 1) continue;
                Object[] clientMap = (Object[])param[0];
                BufferedReader br = (BufferedReader)clientMap[2];
                Socket socket = (Socket)clientMap[0];
                if (br.ready()) {
                    clientMap[4] = new Long(JavaSystemApi.currentTimeMillis);
                    Object[] queueParam = new Object[]{clientMap};
                    super.addSmallSizeParameterQueue(addExecQueueNames, queueParam);
                    continue;
                }
                this.connectCheckQueue.add(param);
                if (this.checkConnections[0].isAlive()) continue;
                this.checkConnections[0] = new CheckConnection();
                this.checkConnections[0].setAddQueueName(addCheckQueueName);
                this.checkConnections[0].start();
            }
        }
        catch (Exception e) {
            logger.error("KeyManagerAcceptHelper - executeHelper - Error", e);
            throw new BatchException(e);
        }
        logger.debug("KeyManagerAcceptHelper - executeHelper - end");
        return ret;
    }

    @Override
    public void endHelper() {
    }

    public boolean addCheckEndParamQueue(String addQueueName, Object[] clientMap) {
        Object[] queueParam = new Object[1];
        boolean ret = false;
        queueParam[0] = clientMap;
        try {
            super.addSpecificationParameterQueue(addQueueName, queueParam);
            ret = true;
        }
        catch (Throwable te) {
            te.printStackTrace();
            ret = false;
        }
        return ret;
    }

    private class CheckConnection
    extends Thread {
        private String addQueueName = null;

        private CheckConnection() {
        }

        public void setAddQueueName(String addQueueName) {
            this.addQueueName = addQueueName;
        }

        @Override
        public void run() {
            while (true) {
                Object[] param = null;
                Object[] clientMap = null;
                Socket socket = null;
                BufferedReader br = null;
                try {
                    param = (Object[])KeyManagerAcceptHelper.this.connectCheckQueue.take();
                    clientMap = (Object[])param[0];
                    socket = (Socket)clientMap[0];
                    if ((Integer)clientMap[5] > 10) {
                        clientMap[5] = new Integer(0);
                        br = (BufferedReader)clientMap[2];
                        int test = 0;
                        br.mark(1);
                        long last = (Long)clientMap[4];
                        if (KeyManagerAcceptHelper.this.connetionTimeout == -1L || JavaSystemApi.currentTimeMillis - last < KeyManagerAcceptHelper.this.connetionTimeout) {
                            socket.setSoTimeout(1);
                            test = br.read();
                            br.reset();
                        } else {
                            test = -1;
                        }
                        if (test == -1) {
                            br.close();
                            socket.close();
                            br = null;
                            socket = null;
                        }
                    } else {
                        int checkCount = (Integer)clientMap[5];
                        clientMap[5] = new Integer(++checkCount);
                    }
                }
                catch (SocketTimeoutException se) {
                }
                catch (Throwable te) {
                    try {
                        br.close();
                        socket.close();
                        br = null;
                        socket = null;
                    }
                    catch (Throwable tee) {
                        br = null;
                        socket = null;
                    }
                }
                if (socket == null) continue;
                KeyManagerAcceptHelper.this.addCheckEndParamQueue(this.addQueueName, clientMap);
            }
        }
    }
}

