/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.helper.AbstractMasterManagerHelper;
import okuyama.imdst.util.DataDispatcher;
import okuyama.imdst.util.StatusUtil;

public class KeyNodeWatchHelper
extends AbstractMasterManagerHelper {
    private int checkCycle = 1000;
    private ArrayList mainNodeList = null;
    private ArrayList subNodeList = null;
    private ArrayList thirdNodeList = null;
    private String nodeStatusStr = null;
    private static ILogger logger = LoggerFactory.createLogger(KeyNodeWatchHelper.class);

    @Override
    public void initHelper(String initValue) {
    }

    @Override
    public String executeHelper(String optionParam) throws BatchException {
        logger.debug("KeyNodeWatchHelper - executeHelper - start");
        String ret = SUCCESS;
        Object serverStopMarkerFile = null;
        boolean serverRunning = true;
        Object shareKeys = null;
        Object serverSocket = null;
        String[] pingRet = null;
        HashMap<String, Integer> rebootNodeMap = new HashMap<String, Integer>(128);
        while (serverRunning) {
            try {
                HashMap allNodeInfo = DataDispatcher.getAllDataNodeInfo();
                this.mainNodeList = (ArrayList)allNodeInfo.get("main");
                this.subNodeList = (ArrayList)allNodeInfo.get("sub");
                this.thirdNodeList = (ArrayList)allNodeInfo.get("third");
                if (this.thirdNodeList != null && this.thirdNodeList.size() > 0) {
                    int i;
                    ArrayList newMainNodeList = new ArrayList();
                    ArrayList newSubNodeList = new ArrayList();
                    for (i = 0; i < this.mainNodeList.size(); ++i) {
                        newMainNodeList.add(this.mainNodeList.get(i));
                        newSubNodeList.add(this.subNodeList.get(i));
                    }
                    for (i = 0; i < this.mainNodeList.size(); ++i) {
                        newMainNodeList.add(this.mainNodeList.get(i));
                        newSubNodeList.add(this.thirdNodeList.get(i));
                        newMainNodeList.add(this.subNodeList.get(i));
                        newSubNodeList.add(this.thirdNodeList.get(i));
                    }
                    this.mainNodeList = newMainNodeList;
                    this.subNodeList = newSubNodeList;
                }
                for (int i = 0; i < this.mainNodeList.size(); ++i) {
                    Thread.sleep(this.checkCycle);
                    if (!StatusUtil.isMainMasterNode()) continue;
                    String nodeInfo = (String)this.mainNodeList.get(i);
                    String[] nodeDt = nodeInfo.split(":");
                    logger.info("************************************************************");
                    logger.info(nodeDt[0] + ":" + nodeDt[1] + " Node Check Start");
                    pingRet = this.execNodePing(nodeDt[0], new Integer(nodeDt[1]), logger);
                    if (pingRet[1] != null) {
                        this.nodeStatusStr = pingRet[1];
                    }
                    if (pingRet[0].equals("false")) {
                        logger.info(nodeDt[0] + ":" + nodeDt[1] + " Node Check Dead");
                        super.setDeadNode(nodeInfo, 1, null);
                        StatusUtil.setNodeStatusDt(nodeDt[0] + ":" + nodeDt[1], "Node Check Dead");
                    } else if (!super.isNodeArrival(nodeInfo)) {
                        logger.info("Node Name [" + nodeInfo + "] Reboot");
                        if (rebootNodeMap.containsKey(nodeInfo)) {
                            Integer recoverCount = (Integer)rebootNodeMap.get(nodeInfo);
                            int recoverCountInt = recoverCount;
                            rebootNodeMap.put(nodeInfo, new Integer(++recoverCountInt));
                        } else {
                            rebootNodeMap.put(nodeInfo, new Integer(1));
                        }
                        if (this.subNodeList != null && this.subNodeList.get(i) != null) {
                            logger.info("Node Name [" + nodeInfo + "] Use Wait 1-1 Start");
                            super.setDeadNode(nodeInfo, 1, null);
                            super.setRecoverNode(true, (String)this.subNodeList.get(i));
                            logger.info(nodeInfo + " - Recover Start");
                            StatusUtil.setNodeStatusDt(nodeInfo, "Recover Start");
                            if (this.nodeDataRecover(nodeInfo, (String)this.subNodeList.get(i), logger)) {
                                logger.info(nodeInfo + " - Recover Success");
                                rebootNodeMap.remove(nodeInfo);
                                StatusUtil.setNodeStatusDt(nodeInfo, "Recover Success");
                            } else {
                                logger.info(nodeInfo + " - Recover Miss");
                                super.setRecoverNode(false, "");
                                StatusUtil.setNodeStatusDt(nodeInfo, "Recover Miss");
                            }
                            logger.info(nodeInfo + " - Recover End");
                        } else {
                            rebootNodeMap.remove(nodeInfo);
                            super.setArriveNode(nodeInfo);
                        }
                    } else {
                        logger.info(nodeDt[0] + ":" + nodeDt[1] + " Node Check Arrival");
                        logger.info(nodeDt[0] + ":" + nodeDt[1] + " Server Status [" + this.nodeStatusStr + "]");
                        StatusUtil.setNodeStatusDt(nodeDt[0] + ":" + nodeDt[1], "[" + this.nodeStatusStr + "]");
                    }
                    logger.info(nodeDt[0] + ":" + nodeDt[1] + " Node Check End");
                    logger.info("------------------------------------------------------------");
                    if (this.subNodeList == null || i >= this.subNodeList.size()) continue;
                    String subNodeInfo = (String)this.subNodeList.get(i);
                    String[] subNodeDt = subNodeInfo.split(":");
                    logger.info(subNodeDt[0] + ":" + subNodeDt[1] + " Sub Node Check Start");
                    pingRet = super.execNodePing(subNodeDt[0], new Integer(subNodeDt[1]), logger);
                    if (pingRet[1] != null) {
                        this.nodeStatusStr = pingRet[1];
                    }
                    if (pingRet[0].equals("false")) {
                        logger.info(subNodeDt[0] + ":" + subNodeDt[1] + " SubNode Check Dead");
                        super.setDeadNode(subNodeInfo, 2, null);
                        StatusUtil.setNodeStatusDt(subNodeDt[0] + ":" + subNodeDt[1], "SubNode Check Dead");
                    } else if (!super.isNodeArrival(subNodeInfo)) {
                        logger.info("Node Name [" + subNodeInfo + "] Reboot");
                        if (rebootNodeMap.containsKey(subNodeInfo)) {
                            Integer recoverCount = (Integer)rebootNodeMap.get(subNodeInfo);
                            int recoverCountInt = recoverCount;
                            rebootNodeMap.put(subNodeInfo, new Integer(++recoverCountInt));
                        } else {
                            rebootNodeMap.put(subNodeInfo, new Integer(1));
                        }
                        super.setDeadNode(subNodeInfo, 1, null);
                        super.setRecoverNode(true, nodeInfo);
                        logger.info(subNodeInfo + " - Recover Start");
                        StatusUtil.setNodeStatusDt(subNodeInfo, "Recover Start");
                        if (this.nodeDataRecover(subNodeInfo, nodeInfo, logger)) {
                            logger.info(subNodeInfo + " - Recover Success");
                            rebootNodeMap.remove(subNodeInfo);
                            StatusUtil.setNodeStatusDt(subNodeInfo, "Recover Success");
                        } else {
                            logger.info(subNodeInfo + " - Recover Miss");
                            super.setRecoverNode(false, "");
                            StatusUtil.setNodeStatusDt(subNodeInfo, "Recover Miss");
                        }
                        logger.info(subNodeInfo + " - Recover End");
                    } else {
                        logger.info(subNodeDt[0] + ":" + subNodeDt[1] + " Sub Node Check Arrival");
                        logger.info(subNodeDt[0] + ":" + subNodeDt[1] + " Server Status [" + this.nodeStatusStr + "]");
                        StatusUtil.setNodeStatusDt(subNodeDt[0] + ":" + subNodeDt[1], "[" + this.nodeStatusStr + "]");
                    }
                    logger.info(subNodeDt[0] + ":" + subNodeDt[1] + " Sub Node Check End");
                    logger.info("************************************************************");
                }
                Set rebootNodeMapSet = rebootNodeMap.entrySet();
                Iterator rebootNodeMapIte = rebootNodeMapSet.iterator();
                while (rebootNodeMapIte.hasNext()) {
                    Map.Entry obj = rebootNodeMapIte.next();
                    String nodeInfo = (String)obj.getKey();
                    Integer recoverTryCount = (Integer)obj.getValue();
                    if (nodeInfo == null || recoverTryCount <= 3) continue;
                    super.setArriveNode(nodeInfo);
                    rebootNodeMapIte.remove();
                    logger.info("Node Name [" + nodeInfo + "] Reboot Register");
                }
            }
            catch (Exception e) {
                logger.error("KeyNodeWatchHelper - executeHelper - Error", e);
            }
        }
        logger.debug("KeyNodeWatchHelper - executeHelper - end");
        return ret;
    }

    @Override
    public void endHelper() {
    }

    protected boolean nodeDataRecover(String nodeInfo, String masterNodeInfo, ILogger logger) throws BatchException {
        return this.nodeDataRecover(nodeInfo, masterNodeInfo, false, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean nodeDataRecover(String nodeInfo, String masterNodeInfo, boolean noDataCheck, ILogger logger) throws BatchException {
        boolean ret = true;
        String retParam = null;
        Object retParams = null;
        String lineCount = null;
        String[] nodeDt = nodeInfo.split(":");
        String[] masterNodeDt = masterNodeInfo.split(":");
        String nodeName = nodeDt[0];
        int nodePort = new Integer(nodeDt[1]);
        String masterNodeName = masterNodeDt[0];
        int masterNodePort = new Integer(masterNodeDt[1]);
        String sendRet = null;
        String diffDataInputRet = null;
        String diffModeOffRet = null;
        PrintWriter pw = null;
        BufferedReader br = null;
        Socket socket = null;
        ObjectOutputStream oos = null;
        PrintWriter mpw = null;
        BufferedReader mbr = null;
        Socket msocket = null;
        ObjectInputStream mois = null;
        try {
            logger.info("Data Recover Schedule [" + masterNodeInfo + " => " + nodeInfo + "]");
            socket = new Socket(nodeName, nodePort);
            socket.setSoTimeout(3600000);
            OutputStreamWriter osw = new OutputStreamWriter(socket.getOutputStream(), "UTF-8");
            pw = new PrintWriter(new BufferedWriter(osw));
            InputStreamReader isr = new InputStreamReader(socket.getInputStream(), "UTF-8");
            br = new BufferedReader(isr);
            msocket = new Socket(masterNodeName, masterNodePort);
            msocket.setSoTimeout(3600000);
            OutputStreamWriter mosw = new OutputStreamWriter(msocket.getOutputStream(), "UTF-8");
            mpw = new PrintWriter(new BufferedWriter(mosw));
            InputStreamReader misr = new InputStreamReader(msocket.getInputStream(), "UTF-8");
            mbr = new BufferedReader(misr);
            StringBuilder buf = new StringBuilder();
            logger.info("Recover Step - 1");
            buf = new StringBuilder();
            buf.append("22").append(",").append("true");
            mpw.println(buf.toString());
            mpw.flush();
            String diffModeOn = mbr.readLine();
            logger.info("Recover Step - 2");
            buf = new StringBuilder();
            buf.append("20");
            buf.append(",");
            buf.append("true");
            mpw.println(buf.toString());
            mpw.flush();
            logger.info("Recover Step - 3");
            lineCount = mbr.readLine();
            logger.info("Recover Step - 4");
            buf = new StringBuilder();
            buf.append("21");
            buf.append(",");
            buf.append(lineCount);
            pw.println(buf.toString());
            pw.flush();
            logger.info("Recover Step - 5 Recover Data Schedule Line Count =[" + lineCount + "]");
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                logger.info("Recover Step - 6 [" + i + "]");
                retParam = mbr.readLine();
                if (retParam == null || retParam.trim().equals("") || retParam.length() < 3 && retParam.trim().equals("-1")) {
                    pw.println("-1");
                    pw.flush();
                    break;
                }
                pw.println(retParam);
                logger.info("Recover Step - 7 [" + i + "]");
            }
            if ((sendRet = br.readLine()) != null) {
                logger.info("Recover Step - 8");
                if (!sendRet.equals("1")) {
                    throw new Exception("send Data Error Ret=[" + sendRet + "]");
                }
            } else {
                logger.info("Recover Step - 9");
                throw new Exception("send Data Error Ret=[" + sendRet + "]");
            }
            logger.info("Recover Step - 10");
            buf = new StringBuilder();
            buf.append("24");
            buf.append(",");
            buf.append("true");
            mpw.println(buf.toString());
            mpw.flush();
            logger.info("Recover Step - 11");
            buf = new StringBuilder();
            buf.append("25");
            buf.append(",");
            pw.println(buf.toString());
            pw.flush();
            String diffDataStr = null;
            while ((diffDataStr = mbr.readLine()) != null && !diffDataStr.equals("-1")) {
                pw.println(diffDataStr);
                pw.flush();
            }
            pw.println("-1");
            pw.flush();
            logger.info("Recover Step - 12");
            diffDataInputRet = br.readLine();
            if (diffDataInputRet != null) {
                logger.info("Recover Step - 13");
                if (!diffDataInputRet.equals("1")) {
                    throw new Exception("Diff Data Input Error Ret=[" + diffDataInputRet + "]");
                }
            } else {
                logger.info("Recover Step - 14");
                throw new Exception("Diff Data Input Error Ret=[" + diffDataInputRet + "]");
            }
            logger.info("Recover Step - 15");
            super.setRecoverNode(false, "");
            super.setArriveNode(nodeInfo);
            mpw.println("1");
            mpw.flush();
            diffModeOffRet = mbr.readLine();
            if (diffModeOffRet != null) {
                logger.info("Recover Step - 16");
                if (!diffModeOffRet.equals("1")) {
                    throw new Exception("Diff Mode Off Error Ret=[" + diffModeOffRet + "]");
                }
            } else {
                logger.info("Recover Step - 17");
                throw new Exception("Diff Mode Off Error Ret=[" + diffModeOffRet + "]");
            }
            logger.info("Recover Step - 18");
        }
        catch (Exception e) {
            logger.error(e);
            ret = false;
        }
        finally {
            try {
                if (pw != null) {
                    pw.println("23,true");
                    pw.flush();
                    pw.println("(&imdst9999&)");
                    pw.flush();
                    pw.close();
                }
                if (oos != null) {
                    oos.close();
                }
                if (socket != null) {
                    socket.close();
                }
                if (mpw != null) {
                    mpw.println("23,true");
                    mpw.flush();
                    mpw.println("(&imdst9999&)");
                    mpw.flush();
                    mpw.close();
                }
                if (mois != null) {
                    mois.close();
                }
                if (msocket != null) {
                    msocket.close();
                }
            }
            catch (Exception e2) {
                logger.error(e2);
            }
        }
        return ret;
    }
}

