/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.helper;

import java.util.HashMap;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.client.ImdstKeyValueClient;
import okuyama.imdst.client.OkuyamaClient;
import okuyama.imdst.helper.AbstractMasterManagerHelper;
import okuyama.imdst.util.DataDispatcher;
import okuyama.imdst.util.StatusUtil;

public class MasterConfigurationManagerHelper
extends AbstractMasterManagerHelper {
    private String keyMapNodesStr = null;
    private String subKeyMapNodesStr = null;
    private String thirdKeyMapNodesStr = null;
    private String ruleStrProp = null;
    private String loadBalanceStr = null;
    private String transactionModeStr = null;
    private String transactionManagerStr = null;
    private String mainMasterNodeModeStr = null;
    private String slaveMasterNodeInfoStr = null;
    private String myNodeInfoStr = null;
    private String mainMasterNodeInfoStr = null;
    private String allMasterNodeInfoStr = null;
    private String[] addNodeInfos = null;
    private String dispatchMode = "mod";
    private int checkCycle = 5000;
    private static ILogger logger = LoggerFactory.createLogger(MasterConfigurationManagerHelper.class);

    @Override
    public void initHelper(String initValue) {
        logger.debug("MasterConfigurationManagerHelper - initHelper - start");
        logger.debug("MasterConfigurationManagerHelper - initHelper - end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeHelper(String optionParam) throws BatchException {
        logger.debug("MasterConfigurationManagerHelper - executeHelper - start");
        String ret = SUCCESS;
        Object serverStopMarkerFile = null;
        boolean serverRunning = true;
        String[] reloadKeys = new String[]{"KeyMapNodesInfo", "SubKeyMapNodesInfo", "KeyMapNodesRule", "MainMasterNodeMode", "SlaveMasterNodes", "LoadBalanceMode", "SystemConfigMode", "MyNodeInfo", "TransactionMode", "TransactionManagerInfo", "MainMasterNodeInfo", "AllMasterNodeInfo", "DistributionAlgorithm", "ThirdKeyMapNodesInfo"};
        if (super.getPropertiesValue("DistributionAlgorithm") != null && super.getPropertiesValue("DistributionAlgorithm").equals("consistenthash")) {
            this.dispatchMode = "consistenthash";
        }
        StatusUtil.setDistributionAlgorithm(this.dispatchMode);
        DataDispatcher.setDispatchMode(this.dispatchMode);
        try {
            this.parseAllNodesInfo();
            while (serverRunning) {
                block36: {
                    try {
                        String port;
                        String node;
                        String[] myInfos;
                        if (super.getPropertiesValue("SystemConfigMode") != null && super.getPropertiesValue("SystemConfigMode").equals("file")) {
                            if (super.isJobFileChange()) {
                                logger.info("MasterNode Config File Change");
                                super.reloadJobFileParameter(reloadKeys);
                                this.parseAllNodesInfo();
                            } else {
                                logger.info("MasterNode Config File No Change");
                            }
                        } else {
                            this.parseAllNodesInfo4Node();
                        }
                        boolean arrivalFlg = false;
                        String[] checkMasterNodes = null;
                        String[] checkMasterNodeInfo = null;
                        ImdstKeyValueClient imdstKeyValueClient = null;
                        String checkMasterNodeStr = StatusUtil.getCheckTargetMasterNodes();
                        if (checkMasterNodeStr != null && checkMasterNodeStr.equals("false")) {
                            StatusUtil.setMainMasterNode(false, -1);
                            break block36;
                        }
                        if (checkMasterNodeStr != null && !checkMasterNodeStr.trim().equals("")) {
                            checkMasterNodes = checkMasterNodeStr.split(",");
                            arrivalFlg = false;
                            for (int idx = 0; idx < checkMasterNodes.length; ++idx) {
                                try {
                                    checkMasterNodeInfo = checkMasterNodes[idx].split(":");
                                    String node2 = checkMasterNodeInfo[0];
                                    String port2 = checkMasterNodeInfo[1];
                                    imdstKeyValueClient = new ImdstKeyValueClient();
                                    imdstKeyValueClient.connect(node2, Integer.parseInt(port2));
                                    if (!imdstKeyValueClient.arrivalMasterNode()) continue;
                                    arrivalFlg = true;
                                    continue;
                                }
                                catch (Exception e) {
                                    logger.info("Master Node = [" + checkMasterNodes[idx] + "] Check Error");
                                    continue;
                                }
                                finally {
                                    if (imdstKeyValueClient != null) {
                                        imdstKeyValueClient.close();
                                        imdstKeyValueClient = null;
                                    }
                                }
                            }
                            if (!arrivalFlg) {
                                if (super.getPropertiesValue("SystemConfigMode") != null && super.getPropertiesValue("SystemConfigMode").equals("file")) {
                                    StatusUtil.setMainMasterNode(true, 1);
                                    break block36;
                                }
                                String myInfo = StatusUtil.getMyNodeInfo();
                                myInfos = myInfo.split(":");
                                node = myInfos[0];
                                port = myInfos[1];
                                try {
                                    imdstKeyValueClient = new ImdstKeyValueClient();
                                    imdstKeyValueClient.connect(node, Integer.parseInt(port));
                                    imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ MainMasterNodeInfo", StatusUtil.getMyNodeInfo());
                                    break block36;
                                }
                                catch (Exception e) {
                                    logger.error(node + ":" + port + " MasterNode Regist Error" + e.toString());
                                    StatusUtil.setMainMasterNode(true, 2);
                                    this.mainMasterNodeModeStr = StatusUtil.getMyNodeInfo();
                                    break block36;
                                }
                                finally {
                                    if (imdstKeyValueClient != null) {
                                        imdstKeyValueClient.close();
                                        imdstKeyValueClient = null;
                                    }
                                }
                            }
                            if (super.getPropertiesValue("SystemConfigMode") != null && super.getPropertiesValue("SystemConfigMode").equals("file")) {
                                StatusUtil.setMainMasterNode(false, 3);
                            } else {
                                StatusUtil.setMainMasterNode(false, 4);
                            }
                            break block36;
                        }
                        if (super.getPropertiesValue("SystemConfigMode") != null && super.getPropertiesValue("SystemConfigMode").equals("file")) {
                            StatusUtil.setMainMasterNode(true, 5);
                            break block36;
                        }
                        String myInfo = StatusUtil.getMyNodeInfo();
                        myInfos = myInfo.split(":");
                        node = myInfos[0];
                        port = myInfos[1];
                        try {
                            imdstKeyValueClient = new ImdstKeyValueClient();
                            imdstKeyValueClient.connect(node, Integer.parseInt(port));
                            imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ MainMasterNodeInfo", StatusUtil.getMyNodeInfo());
                        }
                        catch (Exception e) {
                            logger.error(node + ":" + port + " MasterNode Regist Error" + e.toString());
                            StatusUtil.setMainMasterNode(true, 6);
                            this.mainMasterNodeModeStr = StatusUtil.getMyNodeInfo();
                        }
                        finally {
                            if (imdstKeyValueClient != null) {
                                imdstKeyValueClient.close();
                                imdstKeyValueClient = null;
                            }
                        }
                    }
                    catch (Exception innerE) {
                        logger.error("MasterConfigurationManagerHelper - executeHelper - Inner Error", innerE);
                    }
                }
                Thread.sleep(this.checkCycle);
            }
        }
        catch (Exception e) {
            logger.error("MasterConfigurationManagerHelper - executeHelper - Error", e);
            throw new BatchException(e);
        }
        logger.debug("MasterConfigurationManagerHelper - executeHelper - end");
        return ret;
    }

    @Override
    public void endHelper() {
    }

    private void parseAllNodesInfo() {
        this.keyMapNodesStr = super.getPropertiesValue("KeyMapNodesInfo");
        this.subKeyMapNodesStr = super.getPropertiesValue("SubKeyMapNodesInfo");
        this.thirdKeyMapNodesStr = super.getPropertiesValue("ThirdKeyMapNodesInfo");
        this.ruleStrProp = super.getPropertiesValue("KeyMapNodesRule");
        this.loadBalanceStr = super.getPropertiesValue("LoadBalanceMode");
        this.transactionModeStr = super.getPropertiesValue("TransactionMode");
        this.transactionManagerStr = super.getPropertiesValue("TransactionManagerInfo");
        this.mainMasterNodeModeStr = super.getPropertiesValue("MainMasterNodeMode");
        this.slaveMasterNodeInfoStr = super.getPropertiesValue("SlaveMasterNodes");
        this.myNodeInfoStr = super.getPropertiesValue("MyNodeInfo");
        StatusUtil.setMyNodeInfo(this.myNodeInfoStr);
        this.mainMasterNodeInfoStr = super.getPropertiesValue("MainMasterNodeInfo");
        this.allMasterNodeInfoStr = super.getPropertiesValue("AllMasterNodeInfo");
        if (this.dispatchMode.equals("consistenthash")) {
            this.infomationSetterConsistentHash();
        } else {
            this.infomationSetter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAllNodesInfo4Node() {
        OkuyamaClient imdstKeyValueClient = null;
        String[] nodeRet = null;
        boolean setterFlg = false;
        try {
            String[] addNodeRequest;
            if (this.mainMasterNodeInfoStr != null) {
                try {
                    String[] connectMainMasterNodeInfo = this.mainMasterNodeInfoStr.split(":");
                    imdstKeyValueClient = new ImdstKeyValueClient();
                    imdstKeyValueClient.setConnectionInfos(this.allMasterNodeInfoStr.split(","));
                    imdstKeyValueClient.connect(connectMainMasterNodeInfo[0], Integer.parseInt(connectMainMasterNodeInfo[1]));
                }
                catch (Throwable e) {
                    imdstKeyValueClient = null;
                }
            }
            if (imdstKeyValueClient == null) {
                imdstKeyValueClient = new ImdstKeyValueClient();
                imdstKeyValueClient.setConnectionInfos(this.allMasterNodeInfoStr.split(","));
                imdstKeyValueClient.autoConnect();
            }
            logger.info("[MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ KeyMapNodesInfo] Get Method Call [" + System.nanoTime() + "]");
            nodeRet = imdstKeyValueClient.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ KeyMapNodesInfo");
            if (nodeRet[0].equals("true") && nodeRet[1] != null) {
                if (!nodeRet[1].equals(this.keyMapNodesStr)) {
                    this.keyMapNodesStr = nodeRet[1];
                    setterFlg = true;
                }
            } else if (nodeRet[0].equals("false") && StatusUtil.isMainMasterNode()) {
                imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ KeyMapNodesInfo", this.keyMapNodesStr);
            } else if (nodeRet[0].equals("error")) {
                // empty if block
            }
            logger.info("[MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ SubKeyMapNodesInfo] Get Method Call [" + System.nanoTime() + "]");
            nodeRet = imdstKeyValueClient.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ SubKeyMapNodesInfo");
            if (nodeRet[0].equals("true") && nodeRet[1] != null) {
                if (!nodeRet[1].equals(this.subKeyMapNodesStr)) {
                    this.subKeyMapNodesStr = nodeRet[1];
                    setterFlg = true;
                }
            } else if (nodeRet[0].equals("false") && StatusUtil.isMainMasterNode()) {
                if (this.subKeyMapNodesStr != null && !this.subKeyMapNodesStr.trim().equals("")) {
                    imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ SubKeyMapNodesInfo", this.subKeyMapNodesStr);
                }
            } else if (nodeRet[0].equals("error")) {
                // empty if block
            }
            if ((nodeRet = imdstKeyValueClient.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ ThirdKeyMapNodesInfo"))[0].equals("true") && nodeRet[1] != null) {
                if (!nodeRet[1].equals(this.thirdKeyMapNodesStr)) {
                    this.thirdKeyMapNodesStr = nodeRet[1];
                    setterFlg = true;
                }
            } else if (nodeRet[0].equals("false") && StatusUtil.isMainMasterNode()) {
                if (this.thirdKeyMapNodesStr != null && !this.thirdKeyMapNodesStr.trim().equals("")) {
                    imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ ThirdKeyMapNodesInfo", this.thirdKeyMapNodesStr);
                }
            } else if (nodeRet[0].equals("error")) {
                // empty if block
            }
            if ((nodeRet = imdstKeyValueClient.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ KeyMapNodesRule"))[0].equals("true") && nodeRet[1] != null) {
                if (!nodeRet[1].equals(this.ruleStrProp)) {
                    this.ruleStrProp = nodeRet[1];
                    setterFlg = true;
                }
            } else if (nodeRet[0].equals("false") && StatusUtil.isMainMasterNode()) {
                if (this.ruleStrProp != null && !this.ruleStrProp.trim().equals("")) {
                    imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ KeyMapNodesRule", this.ruleStrProp);
                }
            } else if (nodeRet[0].equals("error")) {
                // empty if block
            }
            if ((nodeRet = imdstKeyValueClient.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ LoadBalanceMode"))[0].equals("true") && nodeRet[1] != null) {
                if (!nodeRet[1].equals(this.loadBalanceStr)) {
                    this.loadBalanceStr = nodeRet[1];
                    setterFlg = true;
                }
            } else if (nodeRet[0].equals("false") && StatusUtil.isMainMasterNode()) {
                if (this.loadBalanceStr != null && !this.loadBalanceStr.trim().equals("")) {
                    imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ LoadBalanceMode", this.loadBalanceStr);
                }
            } else if (nodeRet[0].equals("error")) {
                // empty if block
            }
            if ((nodeRet = imdstKeyValueClient.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ TransactionMode"))[0].equals("true") && nodeRet[1] != null) {
                if (!nodeRet[1].equals(this.transactionModeStr)) {
                    this.transactionModeStr = nodeRet[1];
                    setterFlg = true;
                }
            } else if (nodeRet[0].equals("false") && StatusUtil.isMainMasterNode()) {
                if (this.transactionModeStr != null && !this.transactionModeStr.trim().equals("")) {
                    imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ TransactionMode", this.transactionModeStr);
                }
            } else if (nodeRet[0].equals("error")) {
                // empty if block
            }
            if ((nodeRet = imdstKeyValueClient.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ TransactionManagerInfo"))[0].equals("true") && nodeRet[1] != null) {
                if (!nodeRet[1].equals(this.transactionManagerStr)) {
                    this.transactionManagerStr = nodeRet[1];
                    setterFlg = true;
                }
            } else if (nodeRet[0].equals("false") && StatusUtil.isMainMasterNode()) {
                if (this.transactionManagerStr != null && !this.transactionManagerStr.trim().equals("")) {
                    imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ TransactionManagerInfo", this.transactionManagerStr);
                }
            } else if (nodeRet[0].equals("error")) {
                // empty if block
            }
            if ((nodeRet = imdstKeyValueClient.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ MainMasterNodeMode"))[0].equals("true") && nodeRet[1] != null) {
                if (this.mainMasterNodeModeStr != null && !nodeRet[1].equals(this.mainMasterNodeModeStr)) {
                    this.mainMasterNodeModeStr = nodeRet[1];
                    setterFlg = true;
                }
            } else if (nodeRet[0].equals("false") && StatusUtil.isMainMasterNode()) {
                if (this.mainMasterNodeModeStr != null && !this.mainMasterNodeModeStr.trim().equals("")) {
                    imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ MainMasterNodeMode", this.mainMasterNodeModeStr);
                }
            } else if (nodeRet[0].equals("error")) {
                // empty if block
            }
            if ((nodeRet = imdstKeyValueClient.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ SlaveMasterNodes"))[0].equals("true") && nodeRet[1] != null) {
                if (this.slaveMasterNodeInfoStr != null && !nodeRet[1].equals(this.slaveMasterNodeInfoStr)) {
                    this.slaveMasterNodeInfoStr = nodeRet[1];
                    setterFlg = true;
                }
            } else if (nodeRet[0].equals("false") && StatusUtil.isMainMasterNode()) {
                if (this.slaveMasterNodeInfoStr != null && !this.slaveMasterNodeInfoStr.trim().equals("")) {
                    imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ SlaveMasterNodes", this.slaveMasterNodeInfoStr);
                }
            } else if (nodeRet[0].equals("error")) {
                // empty if block
            }
            if ((nodeRet = imdstKeyValueClient.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ MainMasterNodeInfo"))[0].equals("true") && nodeRet[1] != null) {
                if (!nodeRet[1].equals(this.mainMasterNodeInfoStr)) {
                    this.mainMasterNodeInfoStr = nodeRet[1];
                    setterFlg = true;
                }
            } else if (nodeRet[0].equals("false") && StatusUtil.isMainMasterNode()) {
                if (this.mainMasterNodeInfoStr != null && !this.mainMasterNodeInfoStr.trim().equals("")) {
                    imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ MainMasterNodeInfo", this.mainMasterNodeInfoStr);
                }
            } else if (nodeRet[0].equals("error")) {
                // empty if block
            }
            if ((nodeRet = imdstKeyValueClient.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ AllMasterNodeInfo"))[0].equals("true") && nodeRet[1] != null) {
                if (!nodeRet[1].equals(this.allMasterNodeInfoStr)) {
                    this.allMasterNodeInfoStr = nodeRet[1];
                    setterFlg = true;
                }
            } else if (nodeRet[0].equals("false") && StatusUtil.isMainMasterNode()) {
                if (this.allMasterNodeInfoStr != null && !this.allMasterNodeInfoStr.trim().equals("")) {
                    imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ AllMasterNodeInfo", this.allMasterNodeInfoStr);
                }
            } else if (nodeRet[0].equals("error")) {
                // empty if block
            }
            imdstKeyValueClient.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ DistributionAlgorithm", this.dispatchMode);
            if (this.dispatchMode.equals("consistenthash") && (addNodeRequest = imdstKeyValueClient.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ addNode4ConsistentHashMode"))[0].equals("true")) {
                String[] removeRet;
                if (this.addNodeInfos == null) {
                    setterFlg = true;
                    this.addNodeInfos = addNodeRequest[1].split(",");
                } else if (super.getConsistentHashMoveData() == null && (removeRet = imdstKeyValueClient.removeValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ addNode4ConsistentHashMode"))[0].equals("true")) {
                    setterFlg = true;
                    this.addNodeInfos = null;
                }
            }
            if (setterFlg) {
                if (this.dispatchMode.equals("consistenthash")) {
                    this.infomationSetterConsistentHash();
                } else {
                    this.infomationSetter();
                }
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        finally {
            try {
                if (imdstKeyValueClient != null) {
                    imdstKeyValueClient.close();
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
    }

    private void infomationSetter() {
        int i;
        String[] mainKeyNodes = null;
        String[] subKeyNodes = new String[]{};
        String[] thirdKeyNodes = new String[]{};
        String[] allNodeInfos = null;
        int allNodeCounter = 0;
        if (this.mainMasterNodeModeStr != null && this.mainMasterNodeModeStr.equals("true")) {
            StatusUtil.setMainMasterNode(true, 7);
        } else {
            StatusUtil.setMainMasterNode(false, 8);
        }
        StatusUtil.setSlaveMasterNodes(this.slaveMasterNodeInfoStr);
        if (this.myNodeInfoStr != null && this.mainMasterNodeInfoStr != null) {
            if (this.mainMasterNodeInfoStr.trim().equals(this.myNodeInfoStr.trim())) {
                StatusUtil.setMainMasterNode(true, 9);
                if (this.allMasterNodeInfoStr != null) {
                    String[] allMasterNodeInfos = this.allMasterNodeInfoStr.trim().split(",");
                    StringBuilder slaveMasterNodeInfoBuf = new StringBuilder();
                    String sep = "";
                    for (int idx = 0; idx < allMasterNodeInfos.length; ++idx) {
                        if (allMasterNodeInfos[idx].trim().equals(this.myNodeInfoStr.trim())) continue;
                        slaveMasterNodeInfoBuf.append(sep);
                        slaveMasterNodeInfoBuf.append(allMasterNodeInfos[idx]);
                        sep = ",";
                    }
                    if (slaveMasterNodeInfoBuf.toString().equals("")) {
                        StatusUtil.setSlaveMasterNodes(null);
                    } else {
                        StatusUtil.setSlaveMasterNodes(slaveMasterNodeInfoBuf.toString());
                    }
                } else {
                    StatusUtil.setSlaveMasterNodes(null);
                }
            } else {
                StatusUtil.setMainMasterNode(false, 10);
                StatusUtil.setSlaveMasterNodes(null);
            }
            StatusUtil.setCheckTargetMasterNodes("");
            if (this.allMasterNodeInfoStr != null) {
                Object checkTargetMasterNodes = null;
                if (this.allMasterNodeInfoStr.indexOf(this.myNodeInfoStr) > 0) {
                    String[] workStrs = this.allMasterNodeInfoStr.split(this.myNodeInfoStr);
                    if (workStrs.length > 0 && !workStrs[0].trim().equals("")) {
                        StatusUtil.setCheckTargetMasterNodes(workStrs[0]);
                    }
                } else if (this.allMasterNodeInfoStr.indexOf(this.myNodeInfoStr) == -1) {
                    StatusUtil.setCheckTargetMasterNodes("false");
                }
            }
        }
        String[] ruleStrs = this.ruleStrProp.split(",");
        int[] oldRules = null;
        if (ruleStrs.length > 1) {
            oldRules = new int[ruleStrs.length - 1];
            for (int i2 = 1; i2 < ruleStrs.length; ++i2) {
                oldRules[i2 - 1] = new Integer(ruleStrs[i2].trim());
            }
        }
        mainKeyNodes = this.keyMapNodesStr.split(",");
        allNodeCounter = mainKeyNodes.length;
        if (this.subKeyMapNodesStr != null && !this.subKeyMapNodesStr.equals("")) {
            subKeyNodes = this.subKeyMapNodesStr.split(",");
            allNodeCounter += subKeyNodes.length;
        }
        if (this.thirdKeyMapNodesStr != null && !this.thirdKeyMapNodesStr.equals("")) {
            thirdKeyNodes = this.thirdKeyMapNodesStr.split(",");
            allNodeCounter += thirdKeyNodes.length;
        }
        allNodeInfos = new String[allNodeCounter];
        for (i = 0; i < mainKeyNodes.length; ++i) {
            allNodeInfos[i] = mainKeyNodes[i];
        }
        for (i = 0; i < subKeyNodes.length; ++i) {
            allNodeInfos[i + mainKeyNodes.length] = subKeyNodes[i];
        }
        for (i = 0; i < thirdKeyNodes.length; ++i) {
            allNodeInfos[i + mainKeyNodes.length + subKeyNodes.length] = thirdKeyNodes[i];
        }
        StatusUtil.initNodeExecMap(allNodeInfos);
        if (this.transactionModeStr != null) {
            StatusUtil.setTransactionMode(new Boolean(this.transactionModeStr));
            if (StatusUtil.isTransactionMode()) {
                StatusUtil.setTransactionNode(this.transactionManagerStr.trim().split(":"));
            }
        } else {
            StatusUtil.setTransactionMode(false);
        }
        DataDispatcher.init(ruleStrs[0], oldRules, this.keyMapNodesStr, this.subKeyMapNodesStr, this.thirdKeyMapNodesStr, this.transactionManagerStr);
        super.executeKeyNodeOptimization(true);
    }

    private void infomationSetterConsistentHash() {
        int i;
        String[] mainKeyNodes = null;
        String[] subKeyNodes = new String[]{};
        String[] thirdKeyNodes = new String[]{};
        String[] allNodeInfos = null;
        int allNodeCounter = 0;
        if (this.mainMasterNodeModeStr != null && this.mainMasterNodeModeStr.equals("true")) {
            StatusUtil.setMainMasterNode(true, 11);
        } else {
            StatusUtil.setMainMasterNode(false, 12);
        }
        StatusUtil.setSlaveMasterNodes(this.slaveMasterNodeInfoStr);
        if (this.myNodeInfoStr != null && this.mainMasterNodeInfoStr != null) {
            if (this.mainMasterNodeInfoStr.trim().equals(this.myNodeInfoStr.trim())) {
                StatusUtil.setMainMasterNode(true, 13);
                if (this.allMasterNodeInfoStr != null) {
                    String[] allMasterNodeInfos = this.allMasterNodeInfoStr.trim().split(",");
                    StringBuilder slaveMasterNodeInfoBuf = new StringBuilder();
                    String sep = "";
                    for (int idx = 0; idx < allMasterNodeInfos.length; ++idx) {
                        if (allMasterNodeInfos[idx].trim().equals(this.myNodeInfoStr.trim())) continue;
                        slaveMasterNodeInfoBuf.append(sep);
                        slaveMasterNodeInfoBuf.append(allMasterNodeInfos[idx]);
                        sep = ",";
                    }
                    if (slaveMasterNodeInfoBuf.toString().equals("")) {
                        StatusUtil.setSlaveMasterNodes(null);
                    } else {
                        StatusUtil.setSlaveMasterNodes(slaveMasterNodeInfoBuf.toString());
                    }
                } else {
                    StatusUtil.setSlaveMasterNodes(null);
                }
            } else {
                StatusUtil.setMainMasterNode(false, 14);
                StatusUtil.setSlaveMasterNodes(null);
            }
            StatusUtil.setCheckTargetMasterNodes("");
            if (this.allMasterNodeInfoStr != null) {
                Object checkTargetMasterNodes = null;
                if (this.allMasterNodeInfoStr.indexOf(this.myNodeInfoStr) > 0) {
                    String[] workStrs = this.allMasterNodeInfoStr.split(this.myNodeInfoStr);
                    if (workStrs.length > 0 && !workStrs[0].trim().equals("")) {
                        StatusUtil.setCheckTargetMasterNodes(workStrs[0]);
                    }
                } else if (this.allMasterNodeInfoStr.indexOf(this.myNodeInfoStr) == -1) {
                    StatusUtil.setCheckTargetMasterNodes("false");
                }
            }
        }
        mainKeyNodes = this.keyMapNodesStr.split(",");
        allNodeCounter = mainKeyNodes.length;
        if (this.subKeyMapNodesStr != null && !this.subKeyMapNodesStr.equals("")) {
            subKeyNodes = this.subKeyMapNodesStr.split(",");
            allNodeCounter += subKeyNodes.length;
        }
        if (this.thirdKeyMapNodesStr != null && !this.thirdKeyMapNodesStr.equals("")) {
            thirdKeyNodes = this.thirdKeyMapNodesStr.split(",");
            allNodeCounter += thirdKeyNodes.length;
        }
        allNodeInfos = new String[allNodeCounter];
        for (i = 0; i < mainKeyNodes.length; ++i) {
            allNodeInfos[i] = mainKeyNodes[i];
        }
        for (i = 0; i < subKeyNodes.length; ++i) {
            allNodeInfos[i + mainKeyNodes.length] = subKeyNodes[i];
        }
        for (i = 0; i < thirdKeyNodes.length; ++i) {
            allNodeInfos[i + mainKeyNodes.length + subKeyNodes.length] = thirdKeyNodes[i];
        }
        StatusUtil.initNodeExecMap(allNodeInfos);
        if (this.transactionModeStr != null) {
            StatusUtil.setTransactionMode(new Boolean(this.transactionModeStr));
            if (StatusUtil.isTransactionMode()) {
                StatusUtil.setTransactionNode(this.transactionManagerStr.trim().split(":"));
            }
        } else {
            StatusUtil.setTransactionMode(false);
        }
        if (!DataDispatcher.getInitFlg()) {
            DataDispatcher.initConsistentHashMode(this.keyMapNodesStr, this.subKeyMapNodesStr, this.thirdKeyMapNodesStr, this.transactionManagerStr);
        }
        if (this.addNodeInfos == null) {
            DataDispatcher.clearConsistentHashOldCircle();
        } else {
            HashMap moveDataMap = null;
            if (this.addNodeInfos.length == 1) {
                moveDataMap = DataDispatcher.addNode4ConsistentHash(this.addNodeInfos[0], null, null);
            } else if (this.addNodeInfos.length == 2) {
                moveDataMap = DataDispatcher.addNode4ConsistentHash(this.addNodeInfos[0], this.addNodeInfos[1], null);
            } else if (this.addNodeInfos.length == 3) {
                moveDataMap = DataDispatcher.addNode4ConsistentHash(this.addNodeInfos[0], this.addNodeInfos[1], this.addNodeInfos[2]);
            }
            if (StatusUtil.isMainMasterNode() && moveDataMap != null) {
                super.setConsistentHashMoveData(moveDataMap);
            }
        }
    }
}

