/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.helper;

import com.sun.mail.util.BASE64DecoderStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.helper.AbstractMasterManagerHelper;
import okuyama.imdst.util.DataDispatcher;
import okuyama.imdst.util.JavaSystemApi;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.io.CustomReader;
import okuyama.imdst.util.io.KeyNodeConnector;
import okuyama.imdst.util.protocol.IProtocolTaker;
import okuyama.imdst.util.protocol.ProtocolTakerFactory;

public class MasterManagerHelper
extends AbstractMasterManagerHelper {
    private String protocolMode = null;
    private IProtocolTaker porotocolTaker = null;
    private boolean isProtocolOkuyama = true;
    private String myPollQueue = "";
    private boolean reverseAccess = false;
    private short dataConsistencyMode = 0;
    private boolean transactionMode = false;
    private String[] transactionManagerInfo = null;
    private AtomicInteger numberOfQueueBindWaitCounter = null;
    private static final int returnProccessingCount = 2;
    private short setTime = 0;
    private StringBuilder getSendData = new StringBuilder(128);
    private StringBuilder setSendData = new StringBuilder(512);
    private boolean isolationMode = false;
    private short isolationPrefixLength = 0;
    private StringBuilder isolationBuffer = null;
    private String[] initReturnParam = new String[]{"0", "true", new Integer(0x100000).toString()};
    private static ILogger logger = LoggerFactory.createLogger(MasterManagerHelper.class);

    @Override
    public void initHelper(String initValue) {
        String consistencyModeStr = super.getPropertiesValue("DataConsistencyMode");
        if (consistencyModeStr != null && !consistencyModeStr.trim().equals("")) {
            this.dataConsistencyMode = Short.parseShort(consistencyModeStr);
        }
        if (StatusUtil.getIsolationMode()) {
            this.isolationMode = true;
            String isolationPrefixStr = StatusUtil.getIsolationPrefix();
            this.isolationPrefixLength = new Integer(isolationPrefixStr.length()).shortValue();
            this.isolationBuffer = new StringBuilder(128);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeHelper(String optionParam) throws BatchException {
        String ret = null;
        Object[] parameters = null;
        boolean closeFlg = false;
        boolean serverRunning = true;
        String pollQueueName = null;
        String[] addQueueNames = null;
        String bindQueueWaitHelperCountKey = "";
        boolean reloopSameClient = false;
        String[] retParams = null;
        String retParamStr = null;
        String clientParametersStr = null;
        String[] clientParameterList = null;
        String[] clientTargetNodes = null;
        IProtocolTaker okuyamaPorotocolTaker = null;
        PrintWriter pw = null;
        CustomReader br = null;
        Object bis = null;
        Socket socket = null;
        try {
            parameters = super.getParameters();
            this.protocolMode = (String)parameters[2];
            this.porotocolTaker = ProtocolTakerFactory.getProtocolTaker(this.protocolMode);
            if (!this.protocolMode.equals("okuyama")) {
                this.isProtocolOkuyama = false;
                okuyamaPorotocolTaker = ProtocolTakerFactory.getProtocolTaker("okuyama");
            }
            this.transactionMode = (Boolean)parameters[4];
            if (this.transactionMode) {
                this.transactionManagerInfo = (String[])parameters[5];
            }
            this.initConsistencyMode();
            pollQueueName = (String)parameters[6];
            this.myPollQueue = (String)parameters[6];
            addQueueNames = (String[])parameters[7];
            bindQueueWaitHelperCountKey = (String)parameters[8];
            this.numberOfQueueBindWaitCounter = (AtomicInteger)super.getHelperShareParam(bindQueueWaitHelperCountKey);
            Object[] queueParam = null;
            Object[] queueMap = null;
            while (serverRunning) {
                try {
                    retParams = null;
                    retParamStr = "";
                    if (closeFlg) {
                        this.closeClientConnect(pw, br, socket);
                    }
                    this.porotocolTaker.init();
                    if (closeFlg || !reloopSameClient) {
                        queueParam = super.pollSpecificationParameterQueue(pollQueueName);
                        queueMap = (Object[])queueParam[0];
                        this.reverseAccess = (Boolean)queueMap[5];
                        if (this.dataConsistencyMode == 1) {
                            this.reverseAccess = true;
                        }
                        pw = (PrintWriter)queueMap[1];
                        br = (CustomReader)queueMap[2];
                        socket = (Socket)queueMap[0];
                        socket.setSoTimeout(0);
                        closeFlg = false;
                    }
                    if (!reloopSameClient) {
                        this.numberOfQueueBindWaitCounter.getAndDecrement();
                    }
                    reloopSameClient = false;
                    if (this.isProtocolOkuyama) {
                        clientParametersStr = this.porotocolTaker.takeRequestLine(br, pw);
                        clientParameterList = clientParametersStr.split(",");
                    } else {
                        clientParameterList = this.porotocolTaker.takeRequestLine4List(br, pw);
                    }
                    if (this.porotocolTaker.nextExecution() != 1) {
                        if (this.porotocolTaker.nextExecution() == 2) {
                            queueMap[4] = new Long(JavaSystemApi.currentTimeMillis);
                            queueParam[0] = queueMap;
                            super.addSmallSizeParameterQueue(addQueueNames, queueParam);
                            continue;
                        }
                        if (this.porotocolTaker.nextExecution() == 3) {
                            closeFlg = true;
                            continue;
                        }
                    }
                    switch (StatusUtil.isExecuteMethod(Integer.parseInt(clientParameterList[0]))) {
                        case 0: {
                            retParams = this.initClient();
                            break;
                        }
                        case 1: {
                            retParams = this.setKeyValue(clientParameterList[1], clientParameterList[2], clientParameterList[3], clientParameterList[4]);
                            break;
                        }
                        case 2: {
                            retParams = this.getKeyValue(clientParameterList[1]);
                            break;
                        }
                        case 3: {
                            boolean noExistsData = true;
                            if (clientParameterList.length > 2) {
                                noExistsData = new Boolean(clientParameterList[2]);
                            }
                            retParams = this.getTagKeys(clientParameterList[1], noExistsData);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            retParams = this.removeKeyValue(clientParameterList[1], clientParameterList[2]);
                            break;
                        }
                        case 6: {
                            if (clientParameterList.length > 5) {
                                clientParameterList[4] = clientParameterList[4] + "," + clientParameterList[5];
                            }
                            retParams = this.setKeyValueOnlyOnce(clientParameterList[1], clientParameterList[2], clientParameterList[3], clientParameterList[4]);
                            break;
                        }
                        case 8: {
                            retParams = this.getKeyValueScript(clientParameterList[1], clientParameterList[2]);
                            break;
                        }
                        case 9: {
                            retParams = this.getKeyValueScriptForUpdate(clientParameterList[1], clientParameterList[2]);
                            break;
                        }
                        case 10: {
                            String[] nodeDt = new String[]{"10", "true", StatusUtil.getNodeStatusDt(clientParameterList[1])};
                            retParams = nodeDt;
                            break;
                        }
                        case 12: {
                            retParams = new String[]{"12", "true", ""};
                            break;
                        }
                        case 13: {
                            retParams = this.incrValue(clientParameterList[1], clientParameterList[2], clientParameterList[3]);
                            break;
                        }
                        case 14: {
                            retParams = this.decrValue(clientParameterList[1], clientParameterList[2], clientParameterList[3]);
                            break;
                        }
                        case 15: {
                            retParams = this.getKeyValueAndVersion(clientParameterList[1]);
                            break;
                        }
                        case 16: {
                            retParams = this.setKeyValueVersionCheck(clientParameterList[1], clientParameterList[2], clientParameterList[3], clientParameterList[4], clientParameterList[5]);
                            break;
                        }
                        case 30: {
                            retParams = this.lockingData(clientParameterList[1], clientParameterList[2], clientParameterList[3], clientParameterList[4]);
                            break;
                        }
                        case 31: {
                            retParams = this.releaseLockingData(clientParameterList[1], clientParameterList[2]);
                            break;
                        }
                        case 37: {
                            retParams = this.startTransaction();
                            break;
                        }
                        case 38: {
                            break;
                        }
                        case 39: {
                            break;
                        }
                        case 90: {
                            retParams = this.pauseKeyNodeUse(clientParameterList[1]);
                            break;
                        }
                        case 91: {
                            retParams = this.restartKeyNodeUse(clientParameterList[1]);
                            break;
                        }
                        case 92: {
                            retParams = this.arriveKeyNode(clientParameterList[1]);
                            break;
                        }
                        case 93: {
                            int i;
                            clientTargetNodes = clientParameterList[1].split("_");
                            for (i = 0; i < clientTargetNodes.length; ++i) {
                                retParams = this.pauseKeyNodeUse(clientTargetNodes[i]);
                            }
                            break;
                        }
                        case 94: {
                            int i;
                            clientTargetNodes = clientParameterList[1].split("_");
                            for (i = 0; i < clientTargetNodes.length; ++i) {
                                retParams = this.restartKeyNodeUse(clientTargetNodes[i]);
                            }
                            break;
                        }
                        case 95: {
                            retParams = this.deadKeyNode(clientParameterList[1]);
                            break;
                        }
                        case 96: {
                            KeyNodeConnector.setRecoverMode(true, clientParameterList[1]);
                            retParams = new String[]{"96", "true", ""};
                            break;
                        }
                        case 97: {
                            KeyNodeConnector.setRecoverMode(false, "");
                            retParams = new String[]{"97", "true", ""};
                            break;
                        }
                        case 999: {
                            retParams = new String[]{"999", "VERSION okuyama-0.8.5", ""};
                            break;
                        }
                        case -1: {
                            logger.info("MasterManagerHelper Execution has not been permitted  MethodNo=[" + clientParameterList[0] + "]");
                            retParams = new String[]{clientParameterList[0], "error", "Execution has not been permitted"};
                            break;
                        }
                        default: {
                            logger.info("MasterManagerHelper No Method =[" + clientParameterList[0] + "]");
                        }
                    }
                    retParamStr = this.porotocolTaker.isMatchMethod() ? this.porotocolTaker.takeResponseLine(retParams) : okuyamaPorotocolTaker.takeResponseLine(retParams);
                    if (this.isProtocolOkuyama) {
                        pw.println(retParamStr);
                    } else {
                        pw.print(retParamStr);
                        pw.print("\r\n");
                    }
                    pw.flush();
                    if (this.numberOfQueueBindWaitCounter.get() >= 2) {
                        try {
                            if (!br.ready()) {
                                br.mark(1);
                                socket.setSoTimeout(300);
                                int readCheck = br.read();
                                br.reset();
                                reloopSameClient = true;
                                socket.setSoTimeout(0);
                                closeFlg = false;
                                continue;
                            }
                            reloopSameClient = true;
                            socket.setSoTimeout(0);
                            closeFlg = false;
                        }
                        catch (SocketTimeoutException ste) {
                            queueMap[4] = new Long(JavaSystemApi.currentTimeMillis);
                            queueParam[0] = queueMap;
                            super.addSmallSizeParameterQueue(addQueueNames, queueParam);
                            reloopSameClient = false;
                        }
                        catch (Throwable te) {
                            this.closeClientConnect(pw, br, socket);
                            reloopSameClient = false;
                        }
                        continue;
                    }
                    queueMap[4] = new Long(JavaSystemApi.currentTimeMillis);
                    queueParam[0] = queueMap;
                    super.addSmallSizeParameterQueue(addQueueNames, queueParam);
                    reloopSameClient = false;
                }
                catch (NumberFormatException e) {
                    pw.println("-1,false,ERROR");
                    pw.flush();
                    closeFlg = true;
                    reloopSameClient = false;
                }
                catch (SocketException se) {
                    closeFlg = true;
                    reloopSameClient = false;
                }
                catch (IOException ie) {
                    closeFlg = true;
                    reloopSameClient = false;
                }
                finally {
                    if (reloopSameClient) continue;
                    this.numberOfQueueBindWaitCounter.getAndIncrement();
                }
            }
            ret = AbstractMasterManagerHelper.SUCCESS;
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - executeHelper - Error", e);
            ret = AbstractMasterManagerHelper.ERROR;
        }
        return ret;
    }

    @Override
    public void endHelper() {
    }

    private String[] initClient() throws BatchException {
        return this.initReturnParam;
    }

    private String[] setKeyValue(String keyStr, String tagStr, String transactionCode, String dataStr) throws BatchException {
        String[] retStrs;
        block21: {
            retStrs = new String[3];
            String[] tagKeyPair = null;
            String[] keyNodeSaveRet = null;
            String[] keyDataNodePair = null;
            if (tagStr.equals("(B)")) {
                tagStr = null;
            }
            try {
                keyStr = this.encodeIsolationConvert(keyStr);
                tagStr = this.encodeIsolationConvert(tagStr);
                if (!this.checkKeyLength(keyStr)) {
                    retStrs[0] = "1";
                    retStrs[1] = "false";
                    retStrs[2] = "Key Length Error";
                    return retStrs;
                }
                if (!this.checkValueLength(dataStr)) {
                    retStrs[0] = "1";
                    retStrs[1] = "false";
                    retStrs[2] = "Value Length Error";
                    return retStrs;
                }
                if (tagStr != null && !tagStr.equals("")) {
                    String[] tags = tagStr.split(":");
                    for (int i = 0; i < tags.length; ++i) {
                        if (!this.checkKeyLength(tags[i])) {
                            retStrs[0] = "1";
                            retStrs[1] = "false";
                            throw new BatchException("Tag Data Length Error");
                        }
                        String[] tagKeyNodeInfo = DataDispatcher.dispatchKeyNode(tags[i], this.reverseAccess);
                        tagKeyPair = new String[]{tags[i], keyStr};
                        if (tagKeyNodeInfo.length == 3) {
                            keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], null, null, null, "3", tagKeyPair, transactionCode);
                        } else if (tagKeyNodeInfo.length == 6) {
                            keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], "3", tagKeyPair, transactionCode);
                        } else if (tagKeyNodeInfo.length == 9) {
                            keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], tagKeyNodeInfo[6], tagKeyNodeInfo[7], tagKeyNodeInfo[8], "3", tagKeyPair, transactionCode);
                        }
                        if (!keyNodeSaveRet[1].equals("false")) continue;
                        retStrs[0] = "1";
                        retStrs[1] = "false";
                        retStrs[2] = keyNodeSaveRet[2];
                        throw new BatchException("Tag Data Save Error");
                    }
                }
                String[] keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess);
                keyDataNodePair = new String[]{keyStr, dataStr};
                if (keyNodeInfo.length == 3) {
                    keyNodeSaveRet = this.setKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "1", keyDataNodePair, transactionCode);
                } else if (keyNodeInfo.length == 6) {
                    keyNodeSaveRet = this.setKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "1", keyDataNodePair, transactionCode);
                } else if (keyNodeInfo.length == 9) {
                    keyNodeSaveRet = this.setKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "1", keyDataNodePair, transactionCode);
                }
                if (keyNodeSaveRet[1].equals("true")) {
                    retStrs[0] = "1";
                    retStrs[1] = "true";
                    retStrs[2] = "OK";
                    break block21;
                }
                if (keyNodeSaveRet[1].equals("false")) {
                    retStrs[0] = "1";
                    retStrs[1] = "false";
                    retStrs[2] = keyNodeSaveRet[2];
                    break block21;
                }
                throw new BatchException("Key Data Save Error");
            }
            catch (BatchException be) {
                logger.info("MasterManagerHelper - setKeyValue - Error", be);
                retStrs[0] = "1";
                retStrs[1] = "error";
                retStrs[2] = "NG:MasterManagerHelper - setKeyValue - Exception - " + be.toString();
            }
            catch (Exception e) {
                logger.info("MasterManagerHelper - setKeyValue - Error", e);
                retStrs[0] = "1";
                retStrs[1] = "false";
                retStrs[2] = "NG:MasterManagerHelper - setKeyValue - Exception - " + e.toString();
            }
        }
        return retStrs;
    }

    private String[] setKeyValueOnlyOnce(String keyStr, String tagStr, String transactionCode, String dataStr) throws BatchException {
        String[] retStrs = new String[3];
        String[] tagKeyPair = null;
        String[] keyNodeSaveRet = null;
        String[] keyDataNodePair = null;
        if (tagStr.equals("(B)")) {
            tagStr = null;
        }
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            tagStr = this.encodeIsolationConvert(tagStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "6";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            if (!this.checkValueLength(dataStr)) {
                retStrs[0] = "6";
                retStrs[1] = "false";
                retStrs[2] = "Value Length Error";
                return retStrs;
            }
            String[] keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess);
            keyDataNodePair = new String[]{keyStr, dataStr};
            if (keyNodeInfo.length == 3) {
                keyNodeSaveRet = this.setKeyNodeValueOnlyOnce(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "1", keyDataNodePair, transactionCode);
            } else if (keyNodeInfo.length == 6) {
                keyNodeSaveRet = this.setKeyNodeValueOnlyOnce(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "1", keyDataNodePair, transactionCode);
            } else if (keyNodeInfo.length == 9) {
                keyNodeSaveRet = this.setKeyNodeValueOnlyOnce(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "1", keyDataNodePair, transactionCode);
            }
            if (keyNodeSaveRet[1].equals("false")) {
                retStrs[0] = "6";
                retStrs[1] = "false";
                retStrs[2] = keyNodeSaveRet[2];
                return retStrs;
            }
            if (tagStr != null && !tagStr.equals("")) {
                String[] tags = tagStr.split(":");
                for (int i = 0; i < tags.length; ++i) {
                    if (!this.checkKeyLength(tags[i])) {
                        retStrs[0] = "6";
                        retStrs[1] = "false";
                        throw new BatchException("Tag Length Error");
                    }
                    String[] tagKeyNodeInfo = DataDispatcher.dispatchKeyNode(tags[i], this.reverseAccess);
                    tagKeyPair = new String[]{tags[i], keyStr};
                    if (tagKeyNodeInfo.length == 3) {
                        keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], null, null, null, "3", tagKeyPair, transactionCode);
                    } else if (tagKeyNodeInfo.length == 6) {
                        keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], "3", tagKeyPair, transactionCode);
                    } else if (tagKeyNodeInfo.length == 9) {
                        keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], tagKeyNodeInfo[6], tagKeyNodeInfo[7], tagKeyNodeInfo[8], "3", tagKeyPair, transactionCode);
                    }
                    if (!keyNodeSaveRet[1].equals("false")) continue;
                    retStrs[0] = "6";
                    retStrs[1] = "false";
                    retStrs[2] = keyNodeSaveRet[2];
                    throw new BatchException("Tag Data Save Error");
                }
            }
            retStrs[0] = "6";
            retStrs[1] = "true";
            retStrs[2] = "OK";
        }
        catch (BatchException be) {
            logger.info("MasterManagerHelper - setKeyValueOnlyOnce - Error", be);
            retStrs[0] = "6";
            retStrs[1] = "error";
            retStrs[2] = "NG:MasterManagerHelper - setKeyValueOnlyOnce - Exception - " + be.toString();
        }
        catch (Exception e) {
            logger.info("MasterManagerHelper - setKeyValueOnlyOnce - Error", e);
            retStrs[0] = "6";
            retStrs[1] = "false";
            retStrs[2] = "NG:MasterManagerHelper - setKeyValueOnlyOnce - Exception - " + e.toString();
        }
        return retStrs;
    }

    private String[] setKeyValueVersionCheck(String keyStr, String tagStr, String transactionCode, String dataStr, String checkVersionNo) throws BatchException {
        String[] retStrs = new String[3];
        String[] tagKeyPair = null;
        String[] keyNodeSaveRet = null;
        String[] keyDataNodePair = null;
        if (tagStr.equals("(B)")) {
            tagStr = null;
        }
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            tagStr = this.encodeIsolationConvert(tagStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "16";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            if (!this.checkValueLength(dataStr)) {
                retStrs[0] = "16";
                retStrs[1] = "false";
                retStrs[2] = "Value Length Error";
                return retStrs;
            }
            String[] keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess);
            keyDataNodePair = new String[]{keyStr, dataStr};
            if (keyNodeInfo.length == 3) {
                keyNodeSaveRet = this.setKeyNodeValueVersionCheck(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "1", keyDataNodePair, transactionCode, checkVersionNo, true);
            } else if (keyNodeInfo.length == 6) {
                keyNodeSaveRet = this.setKeyNodeValueVersionCheck(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "1", keyDataNodePair, transactionCode, checkVersionNo, true);
            } else if (keyNodeInfo.length == 9) {
                keyNodeSaveRet = this.setKeyNodeValueVersionCheck(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "1", keyDataNodePair, transactionCode, checkVersionNo);
            }
            if (keyNodeSaveRet[1].equals("false")) {
                retStrs[0] = "16";
                retStrs[1] = "false";
                retStrs[2] = keyNodeSaveRet[2];
                return retStrs;
            }
            if (tagStr != null && !tagStr.equals("")) {
                String[] tags = tagStr.split(":");
                for (int i = 0; i < tags.length; ++i) {
                    if (!this.checkKeyLength(tags[i])) {
                        retStrs[0] = "16";
                        retStrs[1] = "false";
                        throw new BatchException("Tag Length Error");
                    }
                    String[] tagKeyNodeInfo = DataDispatcher.dispatchKeyNode(tags[i], this.reverseAccess);
                    tagKeyPair = new String[]{tags[i], keyStr};
                    if (tagKeyNodeInfo.length == 3) {
                        keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], null, null, null, "3", tagKeyPair, transactionCode);
                    } else if (tagKeyNodeInfo.length == 6) {
                        keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], "3", tagKeyPair, transactionCode);
                    } else if (tagKeyNodeInfo.length == 9) {
                        keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], tagKeyNodeInfo[6], tagKeyNodeInfo[7], tagKeyNodeInfo[8], "3", tagKeyPair, transactionCode);
                    }
                    if (!keyNodeSaveRet[1].equals("false")) continue;
                    retStrs[0] = "16";
                    retStrs[1] = "false";
                    retStrs[2] = keyNodeSaveRet[2];
                    throw new BatchException("Tag Data Save Error");
                }
            }
            retStrs[0] = "16";
            retStrs[1] = "true";
            retStrs[2] = "OK";
        }
        catch (BatchException be) {
            logger.info("MasterManagerHelper - setKeyValueVersionCheck - Error", be);
            retStrs[0] = "16";
            retStrs[1] = "error";
            retStrs[2] = "NG:MasterManagerHelper - setKeyValueVersionCheck - Exception - " + be.toString();
        }
        catch (Exception e) {
            logger.info("MasterManagerHelper - setKeyValueVersionCheck - Error", e);
            retStrs[0] = "16";
            retStrs[1] = "false";
            retStrs[2] = "NG:MasterManagerHelper - setKeyValueVersionCheck - Exception - " + e.toString();
        }
        return retStrs;
    }

    private String[] getKeyValue(String keyStr) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeSaveRet = null;
        String[] keyNodeInfo = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "2";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess);
            if (keyNodeInfo.length == 3) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "2", keyStr);
            } else if (keyNodeInfo.length == 6) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "2", keyStr);
            } else if (keyNodeInfo.length == 9) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "2", keyStr);
            }
            if (keyNodeSaveRet[1].equals("false")) {
                int i = 0;
                while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess, i)) != null) {
                    if (keyNodeInfo.length == 3) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "2", keyStr);
                    } else if (keyNodeInfo.length == 6) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "2", keyStr);
                    } else if (keyNodeInfo.length == 9) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "2", keyStr);
                    }
                    if (keyNodeSaveRet[1].equals("true")) break;
                    ++i;
                }
            }
            if (keyNodeSaveRet[1].equals("false")) {
                retStrs[0] = keyNodeSaveRet[0];
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = keyNodeSaveRet[0];
                retStrs[1] = "true";
                retStrs[2] = keyNodeSaveRet[2];
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - getKeyValue - Error", be);
            retStrs[0] = "2";
            retStrs[1] = "error";
            retStrs[2] = "NG:MasterManagerHelper - getKeyValue - Exception - " + be.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            retStrs[0] = "2";
            retStrs[1] = "error";
            retStrs[2] = "NG:MasterManagerHelper - getKeyValue - Exception - " + e.toString();
        }
        return retStrs;
    }

    private String[] getKeyValueAndVersion(String keyStr) throws BatchException {
        String[] retStrs = new String[4];
        String[] keyNodeSaveRet = null;
        String[] keyNodeInfo = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "15";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                retStrs[3] = "";
                return retStrs;
            }
            keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess);
            if (keyNodeInfo.length == 3) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "2", keyStr, true);
            } else if (keyNodeInfo.length == 6) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "2", keyStr, true);
            } else if (keyNodeInfo.length == 9) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "2", keyStr, true);
            }
            if (keyNodeSaveRet[1].equals("false")) {
                int i = 0;
                while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess, i)) != null) {
                    if (keyNodeInfo.length == 3) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "2", keyStr, true);
                    } else if (keyNodeInfo.length == 6) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "2", keyStr, true);
                    } else if (keyNodeInfo.length == 9) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "2", keyStr, true);
                    }
                    if (keyNodeSaveRet[1].equals("true")) break;
                    ++i;
                }
            }
            if (keyNodeSaveRet[1].equals("false")) {
                retStrs[0] = "15";
                retStrs[1] = "false";
                retStrs[2] = "";
                retStrs[3] = "";
            } else {
                retStrs[0] = "15";
                retStrs[1] = "true";
                retStrs[2] = keyNodeSaveRet[2];
                retStrs[3] = keyNodeSaveRet[3];
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - getKeyValueAndVersion - Error", be);
            retStrs[0] = "15";
            retStrs[1] = "error";
            retStrs[2] = "NG:MasterManagerHelper - getKeyValueAndVersion - Exception - " + be.toString();
            retStrs[3] = "";
        }
        catch (Exception e) {
            e.printStackTrace();
            retStrs[0] = "15";
            retStrs[1] = "error";
            retStrs[2] = "NG:MasterManagerHelper - getKeyValueAndVersion - Exception - " + e.toString();
            retStrs[3] = "";
        }
        return retStrs;
    }

    private String[] getKeyValueScript(String keyStr, String scriptStr) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeSaveRet = null;
        String[] keyNodeInfo = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "8";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess);
            if (keyNodeInfo.length == 3) {
                keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "8", keyStr, scriptStr);
            } else if (keyNodeInfo.length == 6) {
                keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "8", keyStr, scriptStr);
            } else if (keyNodeInfo.length == 9) {
                keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "8", keyStr, scriptStr);
            }
            if (keyNodeSaveRet[1].equals("false")) {
                int i = 0;
                while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess, i)) != null) {
                    if (keyNodeInfo.length == 3) {
                        keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "8", keyStr, scriptStr);
                    } else if (keyNodeInfo.length == 6) {
                        keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "8", keyStr, scriptStr);
                    } else if (keyNodeInfo.length == 9) {
                        keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "8", keyStr, scriptStr);
                    }
                    if (keyNodeSaveRet[1].equals("true")) break;
                    ++i;
                }
            }
            if (keyNodeSaveRet[1].equals("false")) {
                retStrs[0] = keyNodeSaveRet[0];
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = keyNodeSaveRet[0];
                retStrs[1] = keyNodeSaveRet[1];
                retStrs[2] = keyNodeSaveRet[2];
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - getKeyValueScript - Error", be);
        }
        catch (Exception e) {
            e.printStackTrace();
            retStrs[0] = "8";
            retStrs[1] = "error";
            retStrs[2] = "NG:MasterManagerHelper - getKeyValueScript - Exception - " + e.toString();
        }
        return retStrs;
    }

    private String[] getKeyValueScriptForUpdate(String keyStr, String scriptStr) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeSaveRet = null;
        String[] keyNodeInfo = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "9";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, false);
            try {
                if (keyNodeInfo.length > 2) {
                    keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "8", keyStr, scriptStr);
                }
            }
            catch (Exception e1) {
                retStrs[0] = "9";
                retStrs[1] = "error";
                retStrs[2] = "NG:MasterManagerHelper - getKeyValueScriptForUpdate - Exception - " + e1.toString();
            }
            try {
                if (keyNodeInfo.length > 5) {
                    keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], null, null, null, "8", keyStr, scriptStr);
                }
            }
            catch (Exception e2) {
                retStrs[0] = "9";
                retStrs[1] = "error";
                retStrs[2] = "NG:MasterManagerHelper - getKeyValueScriptForUpdate - Exception - " + e2.toString();
            }
            try {
                if (keyNodeInfo.length > 8) {
                    keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], null, null, null, "8", keyStr, scriptStr);
                }
            }
            catch (Exception e3) {
                retStrs[0] = "9";
                retStrs[1] = "error";
                retStrs[2] = "NG:MasterManagerHelper - getKeyValueScriptForUpdate - Exception - " + e3.toString();
            }
            if (keyNodeSaveRet == null && retStrs != null) {
                return retStrs;
            }
            if (keyNodeSaveRet[1].equals("false")) {
                int i = 0;
                while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, false, i)) != null) {
                    try {
                        if (keyNodeInfo.length > 2) {
                            keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "8", keyStr, scriptStr);
                        }
                    }
                    catch (Exception e1) {
                        retStrs[0] = "9";
                        retStrs[1] = "error";
                        retStrs[2] = "NG:MasterManagerHelper - getKeyValueScriptForUpdate - Exception - " + e1.toString();
                    }
                    try {
                        if (keyNodeInfo.length > 5) {
                            keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], null, null, null, "8", keyStr, scriptStr);
                        }
                    }
                    catch (Exception e2) {
                        retStrs[0] = "9";
                        retStrs[1] = "error";
                        retStrs[2] = "NG:MasterManagerHelper - getKeyValueScriptForUpdate - Exception - " + e2.toString();
                    }
                    try {
                        if (keyNodeInfo.length > 8) {
                            keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], null, null, null, "8", keyStr, scriptStr);
                        }
                    }
                    catch (Exception e3) {
                        retStrs[0] = "9";
                        retStrs[1] = "error";
                        retStrs[2] = "NG:MasterManagerHelper - getKeyValueScriptForUpdate - Exception - " + e3.toString();
                    }
                    if (keyNodeSaveRet != null && keyNodeSaveRet[1].equals("true")) break;
                    ++i;
                }
            }
            if (keyNodeSaveRet == null && retStrs != null) {
                return retStrs;
            }
            if (keyNodeSaveRet[1].equals("false")) {
                retStrs[0] = "9";
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = "9";
                retStrs[1] = keyNodeSaveRet[1];
                retStrs[2] = keyNodeSaveRet[2];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            retStrs[0] = "9";
            retStrs[1] = "error";
            retStrs[2] = "NG:MasterManagerHelper - getKeyValueScriptForUpdate - Exception - " + e.toString();
        }
        return retStrs;
    }

    private String[] removeKeyValue(String keyStr, String transactionCode) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeRemoveRet = null;
        String[] keyNodeInfo = null;
        String[] oldKeyNodeRemoveRet = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "5";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, false);
            if (keyNodeInfo.length == 3) {
                keyNodeRemoveRet = this.removeKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, keyStr, transactionCode);
            } else if (keyNodeInfo.length == 6) {
                keyNodeRemoveRet = this.removeKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyStr, transactionCode);
            } else if (keyNodeInfo.length == 9) {
                keyNodeRemoveRet = this.removeKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], keyStr, transactionCode);
            }
            int i = 0;
            while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, false, i)) != null) {
                if (keyNodeInfo.length == 3) {
                    oldKeyNodeRemoveRet = this.removeKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, keyStr, transactionCode);
                } else if (keyNodeInfo.length == 6) {
                    oldKeyNodeRemoveRet = this.removeKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyStr, transactionCode);
                } else if (keyNodeInfo.length == 9) {
                    oldKeyNodeRemoveRet = this.removeKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], keyStr, transactionCode);
                }
                if ((keyNodeRemoveRet == null || keyNodeRemoveRet[1].equals("false")) && oldKeyNodeRemoveRet != null && oldKeyNodeRemoveRet[1].equals("true")) {
                    keyNodeRemoveRet = oldKeyNodeRemoveRet;
                }
                ++i;
            }
            if (keyNodeRemoveRet[1].equals("false")) {
                retStrs[0] = keyNodeRemoveRet[0];
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = keyNodeRemoveRet[0];
                retStrs[1] = "true";
                retStrs[2] = keyNodeRemoveRet[2];
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - removeKeyValue - Error", be);
        }
        catch (Exception e) {
            e.printStackTrace();
            retStrs[0] = "5";
            retStrs[1] = "error";
            retStrs[2] = "NG:MasterManagerHelper - removeKeyValue - Exception - " + e.toString();
        }
        return retStrs;
    }

    private String[] decrValue(String keyStr, String decrValue, String transactionCode) throws BatchException {
        String[] retStrs = new String[3];
        try {
            retStrs = this.incrValue(keyStr, "-" + decrValue, transactionCode);
        }
        catch (BatchException be) {
            logger.info("MasterManagerHelper - decrValue - Error", be);
        }
        catch (Exception e) {
            logger.info("MasterManagerHelper - decrValue - Error", e);
            retStrs[0] = "14";
            retStrs[1] = "false";
            retStrs[2] = "NG:MasterManagerHelper - decrValue - Exception - " + e.toString();
        }
        return retStrs;
    }

    private String[] incrValue(String keyStr, String incrValue, String transactionCode) throws BatchException {
        String[] retStrs = new String[3];
        int idx = 0;
        String[] calcRet = null;
        String[] calcFixValue = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "13";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            String[] keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, false);
            for (idx = 0; idx < keyNodeInfo.length; idx += 3) {
                calcRet = null;
                calcRet = this.calcKeyValue(keyNodeInfo[idx], keyNodeInfo[idx + 1], keyNodeInfo[idx + 2], keyStr, incrValue, transactionCode);
                if (calcRet == null || !calcRet[1].equals("true")) continue;
                calcFixValue = new String[]{keyStr, calcRet[2]};
                break;
            }
            try {
                if (calcFixValue != null) {
                    String[] keyNodeSaveRet = null;
                    if (keyNodeInfo.length == 6 && idx < 3) {
                        keyNodeSaveRet = this.setKeyNodeValue(keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], null, null, null, "1", calcFixValue, transactionCode);
                    }
                    if (keyNodeInfo.length == 9 && idx < 3) {
                        keyNodeSaveRet = this.setKeyNodeValue(keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "1", calcFixValue, transactionCode);
                    } else if (keyNodeInfo.length == 9 && idx < 6) {
                        keyNodeSaveRet = this.setKeyNodeValue(keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], null, null, null, "1", calcFixValue, transactionCode);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (calcFixValue != null) {
                retStrs[0] = "13";
                retStrs[1] = "true";
                retStrs[2] = calcRet[2];
            } else {
                retStrs[0] = "13";
                retStrs[1] = "false";
                retStrs[2] = "NG";
            }
        }
        catch (BatchException be) {
            logger.info("MasterManagerHelper - incrValue - Error", be);
        }
        catch (Exception e) {
            logger.info("MasterManagerHelper - incrValue - Error", e);
            retStrs[0] = "13";
            retStrs[1] = "false";
            retStrs[2] = "NG:MasterManagerHelper - incrValue - Exception - " + e.toString();
        }
        return retStrs;
    }

    private String[] lockingData(String keyStr, String transactionCode, String lockingTime, String lockingWaitTime) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeLockRet = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.transactionMode) {
                retStrs = new String[]{"30", "false"};
                return retStrs;
            }
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "30";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            keyNodeLockRet = this.lockKeyNodeValue(this.transactionManagerInfo[0], this.transactionManagerInfo[1], keyStr, transactionCode, lockingTime, lockingWaitTime);
            if (keyNodeLockRet[1].equals("false")) {
                retStrs[0] = keyNodeLockRet[0];
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = keyNodeLockRet[0];
                retStrs[1] = "true";
                retStrs[2] = keyNodeLockRet[2];
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - lockingData - Error", be);
        }
        catch (Exception e) {
            retStrs[0] = "30";
            retStrs[1] = "error";
            retStrs[2] = "NG:MasterManagerHelper - lockingData - Exception - " + e.toString();
        }
        return retStrs;
    }

    private String[] releaseLockingData(String keyStr, String transactionCode) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeReleaseRet = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.transactionMode) {
                retStrs = new String[]{"31", "false"};
                return retStrs;
            }
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "31";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            keyNodeReleaseRet = this.releaseLockKeyNodeValue(this.transactionManagerInfo[0], this.transactionManagerInfo[1], keyStr, transactionCode);
            if (keyNodeReleaseRet[1].equals("false")) {
                retStrs[0] = "31";
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = "31";
                retStrs[1] = "true";
                retStrs[2] = keyNodeReleaseRet[2];
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - releaseLockingData - Error", be);
        }
        catch (Exception e) {
            retStrs[0] = "31";
            retStrs[1] = "error";
            retStrs[2] = "NG:MasterManagerHelper - releaseLockingData - Exception - " + e.toString();
        }
        return retStrs;
    }

    private String[] startTransaction() throws BatchException {
        String[] retStrs = new String[3];
        if (!this.transactionMode) {
            retStrs[0] = "37";
            retStrs[1] = "false";
            retStrs[2] = "No Transaction Mode";
            return retStrs;
        }
        retStrs[0] = "37";
        retStrs[1] = "true";
        retStrs[2] = Long.valueOf(System.nanoTime()).toString() + new Integer(this.hashCode()).toString();
        return retStrs;
    }

    private String[] getTagKeys(String tagStr, boolean noExistsData) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeSaveRet = null;
        try {
            tagStr = this.encodeIsolationConvert(tagStr);
            if (!this.checkKeyLength(tagStr)) {
                retStrs[0] = "4";
                retStrs[1] = "false";
                retStrs[2] = "Tag Length Error";
                return retStrs;
            }
            String[] keyNodeInfo = DataDispatcher.dispatchKeyNode(tagStr, false);
            if (keyNodeInfo.length == 3) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "4", tagStr);
            } else if (keyNodeInfo.length == 6) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "4", tagStr);
            } else if (keyNodeInfo.length == 9) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "4", tagStr);
            }
            if (keyNodeSaveRet[1].equals("false")) {
                int i = 0;
                while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(tagStr, this.reverseAccess, i)) != null) {
                    if (keyNodeInfo.length == 3) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "4", tagStr);
                    } else if (keyNodeInfo.length == 6) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "4", tagStr);
                    } else if (keyNodeInfo.length == 9) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "4", tagStr);
                    }
                    if (keyNodeSaveRet[1].equals("true")) break;
                    ++i;
                }
            }
            if (keyNodeSaveRet[1].equals("false")) {
                retStrs[0] = keyNodeSaveRet[0];
                retStrs[1] = "false";
                retStrs[2] = "";
            } else if (noExistsData) {
                retStrs[0] = keyNodeSaveRet[0];
                retStrs[1] = "true";
                if (!this.isolationMode) {
                    retStrs[2] = keyNodeSaveRet[2];
                } else {
                    String[] splitList = keyNodeSaveRet[2].split(":");
                    if (splitList.length > 0) {
                        StringBuilder retBuf = new StringBuilder(1024);
                        String retSep = "";
                        for (int idx = 0; idx < splitList.length; ++idx) {
                            retBuf.append(retSep);
                            retBuf.append(this.decodeIsolationConvert(splitList[idx]));
                            retSep = ":";
                        }
                        retStrs[2] = retBuf.toString();
                    }
                }
            } else {
                retStrs[0] = keyNodeSaveRet[0];
                retStrs[1] = "true";
                String[] splitList = keyNodeSaveRet[2].split(":");
                keyNodeSaveRet[2] = null;
                if (splitList.length > 0) {
                    StringBuilder retBuf = new StringBuilder(1024);
                    String retSep = "";
                    for (int idx = 0; idx < splitList.length; ++idx) {
                        String decodeIsokationCnvKey = this.decodeIsolationConvert(splitList[idx]);
                        String[] retKey = this.getKeyValue(decodeIsokationCnvKey);
                        if (!retKey[1].equals("true")) continue;
                        retBuf.append(retSep);
                        retBuf.append(decodeIsokationCnvKey);
                        retSep = ":";
                    }
                    retStrs[2] = retBuf.toString();
                    if (retStrs[2].length() == 0) {
                        retStrs[1] = "false";
                    }
                } else {
                    retStrs[1] = "false";
                    retStrs[2] = "";
                }
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - getTagKeys - Error", be);
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - getTagKeys - Exception", e);
            retStrs[0] = "4";
            retStrs[1] = "error";
            retStrs[2] = "NG:MasterManagerHelper - getTagKeys - Exception - " + e.toString();
        }
        return retStrs;
    }

    private String[] getKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String key) throws BatchException {
        return this.getKeyNodeValue(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, key, false);
    }

    private String[] getKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String key) throws BatchException {
        return this.getKeyNodeValue(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, type, key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String key, boolean returnVersion) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.getKeyNodeValue(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, key, returnVersion);
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block19: {
                try {
                    if (exceptionFlg) {
                        thirdRet = this.getKeyNodeValue(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, key, returnVersion);
                        ret = thirdRet;
                    } else if (thirdKeyNodeFullName != null) {
                        super.execNodeUseEnd(thirdKeyNodeFullName);
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block19;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] getKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String key, boolean returnVersion) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String[] retParams = null;
        String[] cnvConsistencyRet = null;
        boolean slaveUse = false;
        boolean mainRetry = false;
        int nowUse = 0;
        String[] mainNodeRetParam = null;
        String[] subNodeRetParam = null;
        Object nowUseNodeInfo = null;
        SocketException se = null;
        IOException ie = null;
        try {
            keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, false);
            nowUse = 1;
            while (true) {
                block35: {
                    if (keyNodeConnector == null) {
                        if (subKeyNodeName != null) {
                            keyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false);
                        }
                        if (keyNodeConnector == null) {
                            if (mainNodeRetParam != null) break;
                            throw new BatchException("Key Node IO Error: detail info for log file");
                        }
                        slaveUse = true;
                        nowUse = 2;
                    }
                    try {
                        String[] workRet;
                        String retParam;
                        this.getSendData.delete(0, Integer.MAX_VALUE);
                        String sendStr = null;
                        if (type.equals("2")) {
                            this.getSendData.append(type);
                            this.getSendData.append(",");
                            this.getSendData.append(this.stringCnv(key));
                            sendStr = this.getSendData.toString();
                            keyNodeConnector.println(sendStr);
                            keyNodeConnector.flush();
                            retParam = keyNodeConnector.readLine(sendStr);
                            retParams = retParam.split(",", 3);
                        } else if (type.equals("4")) {
                            this.getSendData.append(type);
                            this.getSendData.append(",");
                            this.getSendData.append(this.stringCnv(key));
                            sendStr = this.getSendData.toString();
                            keyNodeConnector.println(this.getSendData.toString());
                            keyNodeConnector.flush();
                            retParam = keyNodeConnector.readLine(sendStr);
                            retParams = retParam.split(",", 3);
                        }
                        super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                        if (type.equals("4")) {
                            if (retParams == null || retParams.length <= 1 || !retParams[1].equals("true")) break;
                            cnvConsistencyRet = this.dataConvert4Consistency(retParams[2]);
                            retParams[2] = cnvConsistencyRet[0];
                            if (returnVersion) {
                                workRet = new String[retParams.length + 1];
                                for (int idx = 0; idx < retParams.length; ++idx) {
                                    workRet[idx] = retParams[idx];
                                }
                                workRet[retParams.length] = cnvConsistencyRet[1];
                                break;
                            }
                            retParams[2] = cnvConsistencyRet[0];
                            break;
                        }
                        if (this.dataConsistencyMode < 2) {
                            if (retParams == null || retParams.length <= 1 || !retParams[1].equals("true")) break;
                            cnvConsistencyRet = this.dataConvert4Consistency(retParams[2]);
                            retParams[2] = cnvConsistencyRet[0];
                            if (returnVersion) {
                                workRet = new String[retParams.length + 1];
                                for (int idx = 0; idx < retParams.length; ++idx) {
                                    workRet[idx] = retParams[idx];
                                }
                                workRet[retParams.length] = cnvConsistencyRet[1];
                                retParams = workRet;
                                break;
                            }
                            retParams[2] = cnvConsistencyRet[0];
                            break;
                        }
                        if (nowUse == 1) {
                            mainNodeRetParam = retParams;
                        }
                        if (nowUse == 2) {
                            subNodeRetParam = retParams;
                        }
                        if (subKeyNodeName == null || mainNodeRetParam != null && subNodeRetParam != null) {
                            break;
                        }
                    }
                    catch (SocketException tSe) {
                        se = tSe;
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                    }
                    catch (IOException tIe) {
                        ie = tIe;
                        if (keyNodeConnector == null) break block35;
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                }
                if (slaveUse) {
                    if (mainRetry) {
                        if (mainNodeRetParam != null || subNodeRetParam != null) break;
                        if (se != null) {
                            throw se;
                        }
                        if (ie != null) {
                            throw ie;
                        }
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, true);
                    if (keyNodeConnector == null) {
                        if (mainNodeRetParam != null || subNodeRetParam != null) break;
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    mainRetry = true;
                    nowUse = 1;
                    continue;
                }
                if (subKeyNodeName == null) {
                    if (mainNodeRetParam != null) break;
                    if (se != null) {
                        throw se;
                    }
                    if (ie == null) continue;
                    throw ie;
                }
                keyNodeConnector = null;
            }
            if (type.equals("2") && this.dataConsistencyMode == 2) {
                retParams = this.strongConsistencyDataConvert(retParams, mainNodeRetParam, subNodeRetParam, type, returnVersion);
            }
        }
        catch (Exception e) {
            logger.error("PollQueue =[" + this.myPollQueue + "] RequestTime=[" + new Date() + "] ErrorKey=[" + new String(BASE64DecoderStream.decode((byte[])this.decodeIsolationConvert(key).getBytes())) + "]");
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            this.getSendData.delete(0, Integer.MAX_VALUE);
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getKeyNodeValueScript(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String key, String scriptStr) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.getKeyNodeValueScript(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, key, scriptStr);
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block19: {
                try {
                    if (exceptionFlg) {
                        thirdRet = this.getKeyNodeValueScript(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, key, scriptStr);
                        ret = thirdRet;
                    } else if (thirdKeyNodeFullName != null) {
                        super.execNodeUseEnd(thirdKeyNodeFullName);
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block19;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] getKeyNodeValueScript(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String key, String scriptStr) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String[] retParams = null;
        String[] cnvConsistencyRet = null;
        boolean slaveUse = false;
        boolean mainRetry = false;
        Object nowUseNodeInfo = null;
        SocketException se = null;
        IOException ie = null;
        try {
            keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, false);
            while (true) {
                block28: {
                    if (keyNodeConnector == null) {
                        if (subKeyNodeName != null) {
                            keyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false);
                        }
                        if (keyNodeConnector == null) {
                            throw new BatchException("Key Node IO Error: detail info for log file");
                        }
                        slaveUse = true;
                    }
                    try {
                        if (type.equals("8")) {
                            StringBuilder buf = new StringBuilder(512);
                            String sendStr = null;
                            buf.append("8");
                            buf.append(",");
                            buf.append(this.stringCnv(key));
                            buf.append(",");
                            buf.append(scriptStr);
                            sendStr = buf.toString();
                            keyNodeConnector.println(buf.toString());
                            keyNodeConnector.flush();
                            String retParam = keyNodeConnector.readLine(sendStr);
                            retParams = retParam.split(",", 3);
                        }
                        super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                        if (this.dataConsistencyMode == 0) {
                            if (retParams != null && retParams.length > 1 && retParams[1].equals("true")) {
                                cnvConsistencyRet = this.dataConvert4Consistency((String)retParams[2]);
                                retParams[2] = cnvConsistencyRet[0];
                            }
                        } else if (retParams != null && retParams.length > 1 && retParams[1].equals("true")) {
                            cnvConsistencyRet = this.dataConvert4Consistency((String)retParams[2]);
                            retParams[2] = cnvConsistencyRet[0];
                        }
                        break;
                    }
                    catch (SocketException tSe) {
                        se = tSe;
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                    }
                    catch (IOException tIe) {
                        ie = tIe;
                        if (keyNodeConnector == null) break block28;
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                }
                if (slaveUse) {
                    if (mainRetry) {
                        if (se != null) {
                            throw se;
                        }
                        if (ie != null) {
                            throw ie;
                        }
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, true);
                    if (keyNodeConnector == null) {
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    mainRetry = true;
                    continue;
                }
                if (subKeyNodeName == null) {
                    if (se != null) {
                        throw se;
                    }
                    if (ie == null) continue;
                    throw ie;
                }
                keyNodeConnector = null;
            }
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] setKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String[] values, String transactionCode) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.setKeyNodeValue(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, values, transactionCode);
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block17: {
                try {
                    thirdRet = this.setKeyNodeValue(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, values, transactionCode);
                    if (exceptionFlg) {
                        ret = thirdRet;
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block17;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] setKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String[] values, String transactionCode) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        KeyNodeConnector slaveKeyNodeConnector = null;
        String nodeName = keyNodeName;
        String nodePort = keyNodePort;
        String nodeFullName = keyNodeFullName;
        String[] retParams = null;
        boolean counter = false;
        Object tmpSaveHost = null;
        Object tmpSaveData = null;
        String retParam = null;
        boolean mainNodeSave = false;
        boolean subNodeSave = false;
        this.setSendData.delete(0, Integer.MAX_VALUE);
        String sendStr = null;
        boolean subNodeConnect = false;
        try {
            if (this.transactionMode) {
                String[] keyNodeLockRet;
                while ((keyNodeLockRet = this.hasLockKeyNode(this.transactionManagerInfo[0], this.transactionManagerInfo[1], values[0]))[1].equals("true") && !keyNodeLockRet[2].equals(transactionCode)) {
                }
            }
            this.setSendData.append(type);
            this.setSendData.append(",");
            this.setSendData.append(this.stringCnv(values[0]));
            this.setSendData.append(",");
            this.setSendData.append(transactionCode);
            this.setSendData.append(",");
            this.setSendData.append(values[1]);
            this.setSendData.append("!");
            this.setSendData.append(this.setTime);
            sendStr = this.setSendData.toString();
            keyNodeConnector = this.createKeyNodeConnection(nodeName, nodePort, nodeFullName, false);
            if (keyNodeConnector != null) {
                try {
                    keyNodeConnector.println(sendStr);
                    keyNodeConnector.flush();
                    retParam = keyNodeConnector.readLine(sendStr);
                    if (type.equals("1")) {
                        if (retParam != null && retParam.indexOf("1,true") == 0) {
                            mainNodeSave = true;
                        } else {
                            super.setDeadNode(nodeName + ":" + nodePort, 3, null);
                            logger.error("setKeyNodeValue Logical Error Node =[" + nodeName + ":" + nodePort + "] retParam=[" + retParam + "]" + " Connectoer=[" + keyNodeConnector.connectorDump() + "]");
                        }
                    } else if (type.equals("3")) {
                        if (retParam != null && retParam.indexOf("3,true") == 0) {
                            mainNodeSave = true;
                        } else {
                            super.setDeadNode(nodeName + ":" + nodePort, 4, null);
                            logger.error("setKeyNodeValue Logical Error Node =[" + nodeName + ":" + nodePort + "] retParam=[" + retParam + "]" + " Connectoer=[" + keyNodeConnector.connectorDump() + "]");
                        }
                    }
                    super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                }
                catch (SocketException se) {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    super.setDeadNode(nodeName + ":" + nodePort, 5, se);
                    logger.error(se);
                }
                catch (IOException ie) {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    super.setDeadNode(nodeName + ":" + nodePort, 6, ie);
                    logger.error(ie);
                }
                catch (Exception ee) {
                    super.setDeadNode(nodeName + ":" + nodePort, 7, ee);
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    logger.error(ee);
                }
            }
            if (subKeyNodeName != null && (slaveKeyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false)) != null) {
                try {
                    slaveKeyNodeConnector.println(sendStr);
                    slaveKeyNodeConnector.flush();
                    retParam = slaveKeyNodeConnector.readLine(sendStr);
                    if (type.equals("1")) {
                        if (retParam != null && retParam.indexOf("1,true") == 0) {
                            subNodeSave = true;
                        } else {
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 3, null);
                            logger.error("setKeyNodeValue Logical Error Node =[" + nodeName + ":" + nodePort + "] retParam=[" + retParam + "]" + " Connectoer=[" + slaveKeyNodeConnector.connectorDump() + "]");
                        }
                    } else if (type.equals("3")) {
                        if (retParam != null && retParam.indexOf("3,true") == 0) {
                            subNodeSave = true;
                        } else {
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 4, null);
                            logger.error("setKeyNodeValue Logical Error Node =[" + nodeName + ":" + nodePort + "] retParam=[" + retParam + "]" + " Connectoer=[" + slaveKeyNodeConnector.connectorDump() + "]");
                        }
                    }
                    super.addKeyNodeCacheConnectionPool(slaveKeyNodeConnector);
                }
                catch (SocketException se) {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 5, se);
                    logger.debug(se);
                }
                catch (IOException ie) {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 6, ie);
                    logger.debug(ie);
                }
                catch (Exception ee) {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 7, ee);
                    logger.debug(ee);
                }
            }
            if (!mainNodeSave && !subNodeSave && retParam == null) {
                throw new BatchException("Key Node IO Error: detail info for log file");
            }
        }
        catch (BatchException be) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw be;
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
            if (retParam != null) {
                retParams = retParam.split(",");
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] setKeyNodeValueOnlyOnce(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String[] values, String transactionCode) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.setKeyNodeValueOnlyOnce(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, values, transactionCode);
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block21: {
                try {
                    if (exceptionFlg) {
                        thirdRet = this.setKeyNodeValueOnlyOnce(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, values, transactionCode);
                        ret = thirdRet;
                    } else if (ret[1].equals("true")) {
                        thirdRet = this.setKeyNodeValue(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, "1", values, transactionCode);
                    } else if (thirdKeyNodeFullName != null) {
                        super.execNodeUseEnd(thirdKeyNodeFullName);
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block21;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] setKeyNodeValueOnlyOnce(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String[] values, String transactionCode) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String nodeName = keyNodeName;
        String nodePort = keyNodePort;
        String nodeFullName = keyNodeFullName;
        String[] retParams = null;
        String[] mainRetParams = null;
        String[] subRetParams = null;
        boolean counter = false;
        Object tmpSaveHost = null;
        Object tmpSaveData = null;
        String retParam = null;
        boolean mainNodeSave = false;
        boolean mainNodeNetworkError = false;
        boolean subNodeSave = false;
        boolean subNodeNetworkError = false;
        try {
            block43: {
                block42: {
                    String decodeIsokationCnvKey;
                    String[] checkRet;
                    if (this.transactionMode) {
                        String[] keyNodeLockRet;
                        while ((keyNodeLockRet = this.hasLockKeyNode(this.transactionManagerInfo[0], this.transactionManagerInfo[1], values[0]))[1].equals("true") && !keyNodeLockRet[2].equals(transactionCode)) {
                        }
                    }
                    if (DataDispatcher.hasOldRule() && (checkRet = this.getKeyValue(decodeIsokationCnvKey = this.decodeIsolationConvert(values[0])))[0].equals("true")) {
                        retParams = new String[]{"6", "false", "NG:Data has already been registered"};
                        String[] stringArray = retParams;
                        return stringArray;
                    }
                    keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, false);
                    if (keyNodeConnector != null) {
                        try {
                            StringBuilder buf = new StringBuilder(512);
                            String sendStr = null;
                            buf.append("6");
                            buf.append(",");
                            buf.append(this.stringCnv(values[0]));
                            buf.append(",");
                            buf.append(transactionCode);
                            buf.append(",");
                            buf.append(values[1]);
                            buf.append("!");
                            buf.append(this.setTime);
                            sendStr = buf.toString();
                            keyNodeConnector.println(sendStr);
                            keyNodeConnector.flush();
                            retParam = keyNodeConnector.readLine(sendStr);
                            super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                            if (retParam.indexOf("6,true") == 0) {
                                mainNodeSave = true;
                                mainRetParams = retParam.split(",");
                                break block42;
                            }
                            mainNodeSave = false;
                            mainRetParams = retParam.split(",");
                        }
                        catch (SocketException se) {
                            mainNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(keyNodeName + ":" + keyNodePort, 8, se);
                            logger.debug(se);
                        }
                        catch (IOException ie) {
                            mainNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(keyNodeName + ":" + keyNodePort, 9, ie);
                            logger.debug(ie);
                        }
                        catch (Exception ee) {
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(keyNodeName + ":" + keyNodePort, 10, ee);
                            logger.debug(ee);
                        }
                    } else {
                        mainNodeNetworkError = true;
                    }
                }
                if (subKeyNodeName != null && (mainNodeSave || !mainNodeSave && mainNodeNetworkError)) {
                    String subNodeExecType = "";
                    subNodeExecType = !mainNodeSave ? "6" : "1";
                    keyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false);
                    if (keyNodeConnector != null) {
                        try {
                            StringBuilder buf = new StringBuilder(512);
                            String sendStr = null;
                            buf.append(subNodeExecType);
                            buf.append(",");
                            buf.append(this.stringCnv(values[0]));
                            buf.append(",");
                            buf.append(transactionCode);
                            buf.append(",");
                            buf.append(values[1]);
                            buf.append("!");
                            buf.append(this.setTime);
                            sendStr = buf.toString();
                            keyNodeConnector.println(sendStr);
                            keyNodeConnector.flush();
                            retParam = keyNodeConnector.readLine(sendStr);
                            super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                            if (retParam.indexOf("6,true") == 0) {
                                subNodeSave = true;
                                subRetParams = retParam.split(",");
                                break block43;
                            }
                            subNodeSave = false;
                            subRetParams = retParam.split(",");
                        }
                        catch (SocketException se) {
                            subNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 11, se);
                            logger.debug(se);
                        }
                        catch (IOException ie) {
                            subNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 12, ie);
                            logger.debug(ie);
                        }
                        catch (Exception ee) {
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 13, ee);
                            logger.debug(ee);
                        }
                    } else {
                        subNodeNetworkError = true;
                    }
                }
            }
            if (mainNodeNetworkError && subNodeNetworkError) {
                throw new BatchException("Key Node IO Error: detail info for log file");
            }
            if (!mainNodeSave) {
                if (!mainNodeNetworkError) {
                    retParams = mainRetParams;
                }
            } else {
                retParams = mainRetParams;
            }
            if (subKeyNodeName != null && retParams == null) {
                if (!subNodeSave) {
                    if (!subNodeNetworkError) {
                        retParams = subRetParams;
                    }
                } else {
                    retParams = subRetParams;
                }
            }
        }
        catch (BatchException be) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw be;
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] setKeyNodeValueVersionCheck(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String[] values, String transactionCode, String checkVersionNo) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.setKeyNodeValueVersionCheck(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, values, transactionCode, checkVersionNo, true);
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block21: {
                try {
                    if (exceptionFlg) {
                        thirdRet = this.setKeyNodeValueVersionCheck(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, values, transactionCode, checkVersionNo, true);
                        ret = thirdRet;
                    } else if (ret[1].equals("true")) {
                        thirdRet = this.setKeyNodeValueVersionCheck(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, "1", values, transactionCode, checkVersionNo, false);
                    } else if (thirdKeyNodeFullName != null) {
                        super.execNodeUseEnd(thirdKeyNodeFullName);
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block21;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] setKeyNodeValueVersionCheck(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String[] values, String transactionCode, String checkVersionNo, boolean execCheck) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String nodeName = keyNodeName;
        String nodePort = keyNodePort;
        String nodeFullName = keyNodeFullName;
        String[] retParams = null;
        String[] mainRetParams = null;
        String[] subRetParams = null;
        boolean counter = false;
        Object tmpSaveHost = null;
        Object tmpSaveData = null;
        String retParam = null;
        boolean mainNodeSave = false;
        boolean mainNodeNetworkError = false;
        boolean subNodeSave = false;
        boolean subNodeNetworkError = false;
        try {
            block41: {
                String sendStr;
                StringBuilder buf;
                block40: {
                    if (this.transactionMode) {
                        String[] keyNodeLockRet;
                        while ((keyNodeLockRet = this.hasLockKeyNode(this.transactionManagerInfo[0], this.transactionManagerInfo[1], values[0]))[1].equals("true") && !keyNodeLockRet[2].equals(transactionCode)) {
                        }
                    }
                    if ((keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, false)) != null) {
                        try {
                            buf = new StringBuilder(512);
                            sendStr = null;
                            buf.append("16");
                            buf.append(",");
                            buf.append(this.stringCnv(values[0]));
                            buf.append(",");
                            buf.append(transactionCode);
                            buf.append(",");
                            buf.append(checkVersionNo);
                            buf.append(",");
                            buf.append(execCheck);
                            buf.append(",");
                            buf.append(values[1]);
                            sendStr = buf.toString();
                            keyNodeConnector.println(sendStr);
                            keyNodeConnector.flush();
                            retParam = keyNodeConnector.readLine(sendStr);
                            super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                            if (retParam.indexOf("16,true") == 0) {
                                mainNodeSave = true;
                                mainRetParams = retParam.split(",");
                                break block40;
                            }
                            mainNodeSave = false;
                            mainRetParams = retParam.split(",");
                        }
                        catch (SocketException se) {
                            mainNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(keyNodeName + ":" + keyNodePort, 115, se);
                            logger.debug(se);
                        }
                        catch (IOException ie) {
                            mainNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(keyNodeName + ":" + keyNodePort, 116, ie);
                            logger.debug(ie);
                        }
                        catch (Exception ee) {
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(keyNodeName + ":" + keyNodePort, 117, ee);
                            logger.debug(ee);
                        }
                    } else {
                        mainNodeNetworkError = true;
                    }
                }
                if (subKeyNodeName != null && (mainNodeSave || !mainNodeSave && mainNodeNetworkError)) {
                    execCheck = !mainNodeSave;
                    keyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false);
                    if (keyNodeConnector != null) {
                        try {
                            buf = new StringBuilder(512);
                            sendStr = null;
                            buf.append("16");
                            buf.append(",");
                            buf.append(this.stringCnv(values[0]));
                            buf.append(",");
                            buf.append(transactionCode);
                            buf.append(",");
                            buf.append(checkVersionNo);
                            buf.append(",");
                            buf.append(execCheck);
                            buf.append(",");
                            buf.append(values[1]);
                            sendStr = buf.toString();
                            keyNodeConnector.println(sendStr);
                            keyNodeConnector.flush();
                            retParam = keyNodeConnector.readLine(sendStr);
                            super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                            if (retParam.indexOf("16,true") == 0) {
                                subNodeSave = true;
                                subRetParams = retParam.split(",");
                                break block41;
                            }
                            subNodeSave = false;
                            subRetParams = retParam.split(",");
                        }
                        catch (SocketException se) {
                            subNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 125, se);
                            logger.debug(se);
                        }
                        catch (IOException ie) {
                            subNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 126, ie);
                            logger.debug(ie);
                        }
                        catch (Exception ee) {
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 127, ee);
                            logger.debug(ee);
                        }
                    } else {
                        subNodeNetworkError = true;
                    }
                }
            }
            if (mainNodeNetworkError && subNodeNetworkError) {
                throw new BatchException("Key Node IO Error: detail info for log file");
            }
            if (!mainNodeSave) {
                if (!mainNodeNetworkError) {
                    retParams = mainRetParams;
                }
            } else {
                retParams = mainRetParams;
            }
            if (subKeyNodeName != null && retParams == null) {
                if (!subNodeSave) {
                    if (!subNodeNetworkError) {
                        retParams = subRetParams;
                    }
                } else {
                    retParams = subRetParams;
                }
            }
        }
        catch (BatchException be) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw be;
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] removeKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String key, String transactionCode) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.removeKeyNodeValue(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, key, transactionCode);
            if (ret == null) {
                throw new BatchException("removeKeyNodeValue - RetParam = null");
            }
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block18: {
                try {
                    thirdRet = this.removeKeyNodeValue(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, key, transactionCode);
                    if (exceptionFlg) {
                        ret = thirdRet;
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block18;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] removeKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String key, String transactionCode) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String nodeName = keyNodeName;
        String nodePort = keyNodePort;
        String nodeFullName = keyNodeFullName;
        String[] retParams = null;
        String[] cnvConsistencyRet = null;
        int counter = 0;
        Object tmpSaveHost = null;
        Object tmpSaveData = null;
        String retParam = null;
        boolean mainNodeSave = false;
        boolean subNodeSave = false;
        try {
            if (this.transactionMode) {
                String[] keyNodeLockRet;
                while ((keyNodeLockRet = this.hasLockKeyNode(this.transactionManagerInfo[0], this.transactionManagerInfo[1], key))[1].equals("true") && !keyNodeLockRet[2].equals(transactionCode)) {
                }
            }
            do {
                if ((keyNodeConnector = this.createKeyNodeConnection(nodeName, nodePort, nodeFullName, false)) != null) {
                    try {
                        StringBuilder buf = new StringBuilder(128);
                        String sendStr = null;
                        buf.append("5");
                        buf.append(",");
                        buf.append(this.stringCnv(key));
                        buf.append(",");
                        buf.append(transactionCode);
                        sendStr = buf.toString();
                        keyNodeConnector.println(sendStr);
                        keyNodeConnector.flush();
                        retParam = keyNodeConnector.readLine(sendStr);
                        super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                        if (retParam != null && retParam.indexOf("5,true") == 0) {
                            if (counter == 0) {
                                mainNodeSave = true;
                            }
                            if (counter == 1) {
                                subNodeSave = true;
                            }
                        } else if (retParam == null || retParam.indexOf("5,false") != 0) {
                            super.setDeadNode(nodeName + ":" + nodePort, 14, null);
                            logger.error("removeKeyNodeValue Logical Error Node =[" + nodeName + ":" + nodePort + "] retParam=[" + retParam + "]" + " Connectoer=[" + keyNodeConnector.connectorDump() + "]");
                        }
                    }
                    catch (SocketException se) {
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                        super.setDeadNode(nodeName + ":" + nodePort, 15, se);
                        logger.debug(se);
                    }
                    catch (IOException ie) {
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                        super.setDeadNode(nodeName + ":" + nodePort, 16, ie);
                        logger.debug(ie);
                    }
                    catch (Exception ee) {
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                        super.setDeadNode(nodeName + ":" + nodePort, 17, ee);
                        logger.debug(ee);
                    }
                }
                nodeName = subKeyNodeName;
                nodePort = subKeyNodePort;
                nodeFullName = subKeyNodeFullName;
            } while (nodeName != null && ++counter < 2);
        }
        catch (BatchException be) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw be;
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
            if (retParam != null && (retParams = retParam.split(","))[1].equals("true")) {
                cnvConsistencyRet = this.dataConvert4Consistency(retParams[2]);
                retParams[2] = cnvConsistencyRet[0];
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] calcKeyValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String key, String calcValue, String transactionCode) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        Object slaveKeyNodeConnector = null;
        String nodeName = keyNodeName;
        String nodePort = keyNodePort;
        String nodeFullName = keyNodeFullName;
        String[] retParams = null;
        boolean counter = false;
        Object tmpSaveHost = null;
        Object tmpSaveData = null;
        String retParam = null;
        boolean mainNodeSave = false;
        StringBuilder buf = new StringBuilder(128);
        String sendStr = null;
        try {
            if (this.transactionMode) {
                String[] keyNodeLockRet;
                while ((keyNodeLockRet = this.hasLockKeyNode(this.transactionManagerInfo[0], this.transactionManagerInfo[1], key))[1].equals("true") && !keyNodeLockRet[2].equals(transactionCode)) {
                }
            }
            buf.append("13");
            buf.append(",");
            buf.append(this.stringCnv(key));
            buf.append(",");
            buf.append(transactionCode);
            buf.append(",");
            buf.append(calcValue);
            buf.append("!");
            buf.append(this.setTime);
            sendStr = buf.toString();
            keyNodeConnector = this.createKeyNodeConnection(nodeName, nodePort, nodeFullName, false);
            if (keyNodeConnector != null) {
                try {
                    keyNodeConnector.println(sendStr);
                    keyNodeConnector.flush();
                    retParam = keyNodeConnector.readLine(sendStr);
                    if (retParam != null && retParam.indexOf("13,true") == 0) {
                        mainNodeSave = true;
                    } else {
                        super.setDeadNode(nodeName + ":" + nodePort, 3, null);
                        logger.error("calcValue Logical Error Node =[" + nodeName + ":" + nodePort + "] retParam=[" + retParam + "]" + " Connectoer=[" + keyNodeConnector.connectorDump() + "]");
                    }
                    super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                }
                catch (SocketException se) {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    super.setDeadNode(nodeName + ":" + nodePort, 5, se);
                    logger.debug(se);
                }
                catch (IOException ie) {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    super.setDeadNode(nodeName + ":" + nodePort, 6, ie);
                    logger.debug(ie);
                }
                catch (Exception ee) {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    super.setDeadNode(nodeName + ":" + nodePort, 7, ee);
                    logger.debug(ee);
                }
            }
            if (!mainNodeSave) {
                retParam = null;
            }
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            retParam = null;
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (retParam != null) {
                retParams = retParam.split(",");
            }
        }
        return retParams;
    }

    private String[] lockKeyNodeValue(String transactionManagerName, String transactionManagerPort, String key, String transactionCode, String lockingTime, String lockingWaitTime) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String retParam = null;
        String[] retParams = null;
        try {
            if (!this.transactionMode) {
                retParams = new String[]{"30", "false"};
            }
            if ((keyNodeConnector = this.createTransactionManagerConnection(transactionManagerName, transactionManagerPort, transactionManagerName + ":" + transactionManagerPort)) != null) {
                try {
                    StringBuilder buf = new StringBuilder(128);
                    buf.append("30");
                    buf.append(",");
                    buf.append(this.stringCnv(key));
                    buf.append(",");
                    buf.append(transactionCode);
                    buf.append(",");
                    buf.append(lockingTime);
                    buf.append(",");
                    buf.append(lockingWaitTime);
                    keyNodeConnector.println(buf.toString());
                    keyNodeConnector.flush();
                    retParam = keyNodeConnector.readLine();
                }
                catch (SocketException se) {
                    logger.error("TransactionManager - Error " + se);
                }
                catch (IOException ie) {
                    logger.error("TransactionManager - Error " + ie);
                }
            }
            retParams = retParam != null ? (retParam.indexOf("30,true") == 0 ? new String[]{"30", "true", transactionCode} : new String[]{"30", "false"}) : new String[]{"30", "false"};
        }
        catch (BatchException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return retParams;
    }

    private String[] releaseLockKeyNodeValue(String transactionManagerName, String transactionManagerPort, String key, String transactionCode) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String retParam = null;
        String[] retParams = null;
        try {
            if (!this.transactionMode) {
                retParams = new String[]{"31", "false"};
            }
            if ((keyNodeConnector = this.createTransactionManagerConnection(transactionManagerName, transactionManagerPort, transactionManagerName + ":" + transactionManagerPort)) != null) {
                try {
                    StringBuilder buf = new StringBuilder(128);
                    buf.append("31");
                    buf.append(",");
                    buf.append(this.stringCnv(key));
                    buf.append(",");
                    buf.append(transactionCode);
                    keyNodeConnector.println(buf.toString());
                    keyNodeConnector.flush();
                    retParam = keyNodeConnector.readLine();
                }
                catch (SocketException se) {
                    logger.error("TransactionManager - Error " + se);
                }
                catch (IOException ie) {
                    logger.error("TransactionManager - Error " + ie);
                }
            }
            retParams = retParam != null ? (retParam.indexOf("31,true") == 0 ? new String[]{"31", "true", transactionCode} : new String[]{"31", "false"}) : new String[]{"31", "false"};
        }
        catch (BatchException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return retParams;
    }

    private String[] hasLockKeyNode(String transactionManagerName, String transactionManagerPort, String key) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String retParam = null;
        String[] retParams = null;
        try {
            if (!this.transactionMode) {
                retParams = new String[]{"32", "false"};
            }
            if ((keyNodeConnector = this.createTransactionManagerConnection(transactionManagerName, transactionManagerPort, transactionManagerName + ":" + transactionManagerPort)) != null) {
                try {
                    StringBuilder buf = new StringBuilder(128);
                    buf.append("32");
                    buf.append(",");
                    buf.append(this.stringCnv(key));
                    keyNodeConnector.println(buf.toString());
                    keyNodeConnector.flush();
                    retParam = keyNodeConnector.readLine();
                }
                catch (SocketException se) {
                    logger.error("TransactionManager - Error " + se);
                }
                catch (IOException ie) {
                    logger.error("TransactionManager - Error " + ie);
                }
            }
            retParams = retParam != null ? (retParam.indexOf("32,true") == 0 ? retParam.split(",") : new String[]{"32", "false"}) : new String[]{"32", "false"};
        }
        catch (BatchException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return retParams;
    }

    private String[] pauseKeyNodeUse(String keyNodeFullName) throws BatchException {
        String[] retParams = new String[3];
        try {
            super.setNodeWaitStatus(keyNodeFullName);
            while (super.getNodeUseStatus(keyNodeFullName) != 0) {
                Thread.sleep(50L);
            }
            retParams[0] = "90";
            retParams[1] = "true";
            retParams[2] = "";
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return retParams;
    }

    private String[] restartKeyNodeUse(String keyNodeFullName) throws BatchException {
        String[] retParams = new String[3];
        try {
            super.removeNodeWaitStatus(keyNodeFullName);
            retParams[0] = "91";
            retParams[1] = "true";
            retParams[2] = "";
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] deadKeyNode(String keyNodeFullName) throws BatchException {
        String[] retParams = null;
        try {
            StatusUtil.setDeadNode(keyNodeFullName);
            super.setDeadNode(keyNodeFullName, 9, null);
        }
        catch (Exception e) {
            logger.error(e);
        }
        finally {
            retParams = new String[]{"95", "true", ""};
        }
        return retParams;
    }

    private String[] arriveKeyNode(String keyNodeFullName) throws BatchException {
        String[] retParams = new String[3];
        try {
            super.setArriveNode(keyNodeFullName);
            retParams[0] = "92";
            retParams[1] = "true";
            retParams[2] = "";
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return retParams;
    }

    private KeyNodeConnector createKeyNodeConnection(String keyNodeName, String keyNodePort, String keyNodeFullName, boolean retryFlg) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String connectionFullName = keyNodeFullName;
        Long connectTime = new Long(0L);
        String connTimeKey = "time";
        boolean sockCheck = false;
        try {
            if (!super.isNodeArrival(connectionFullName)) {
                return null;
            }
            if (!retryFlg && AbstractMasterManagerHelper.keyNodeConnectPool.containsKey(connectionFullName) && (keyNodeConnector = (KeyNodeConnector)((ArrayBlockingQueue)AbstractMasterManagerHelper.keyNodeConnectPool.get(connectionFullName)).poll()) != null && !super.checkConnectionEffective(connectionFullName, keyNodeConnector.getConnetTime())) {
                keyNodeConnector = null;
            }
            if (keyNodeConnector == null) {
                keyNodeConnector = new KeyNodeConnector(keyNodeName, Integer.parseInt(keyNodePort), keyNodeFullName);
                keyNodeConnector.connect();
            }
            if (keyNodeConnector != null) {
                keyNodeConnector.initRetryFlg();
            }
        }
        catch (Exception e) {
            logger.error(connectionFullName + " " + e);
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            super.setDeadNode(connectionFullName, 20, e);
        }
        return keyNodeConnector;
    }

    private KeyNodeConnector createTransactionManagerConnection(String keyNodeName, String keyNodePort, String keyNodeFullName) throws BatchException {
        return this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, false);
    }

    private void closeClientConnect(PrintWriter pw, CustomReader br, Socket socket) {
        try {
            if (pw != null) {
                pw.close();
                pw = null;
            }
            if (br != null) {
                br.close();
                br = null;
            }
            if (socket != null) {
                socket.close();
                socket = null;
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    private void initConsistencyMode() {
        if (this.dataConsistencyMode == 1) {
            this.reverseAccess = true;
        } else if (this.dataConsistencyMode == 2) {
            this.reverseAccess = false;
        }
    }

    private String[] dataConvert4Consistency(String targetStr) {
        String[] ret = new String[]{null, "-1"};
        if (targetStr != null) {
            String[] setTimeSplitRet = targetStr.split("!");
            if (setTimeSplitRet.length > 1) {
                ret[0] = setTimeSplitRet[0];
                if (setTimeSplitRet[1].trim().length() > 0) {
                    ret[1] = setTimeSplitRet[1];
                }
            } else {
                ret[0] = setTimeSplitRet[0];
            }
        }
        return ret;
    }

    private String[] strongConsistencyDataConvert(String[] execRetParams, String[] mainNodeRetParam, String[] subNodeRetParam, String type, boolean returnVersion) {
        String[] checkConsistencyRetMain = null;
        String[] checkConsistencyRetSub = null;
        String[] retParams = execRetParams;
        if (mainNodeRetParam != null && mainNodeRetParam.length > 1 && mainNodeRetParam[1].equals("true")) {
            checkConsistencyRetMain = this.dataConvert4Consistency(mainNodeRetParam[2]);
        } else if (mainNodeRetParam != null && mainNodeRetParam.length > 1 && mainNodeRetParam[1].equals("false")) {
            checkConsistencyRetMain = new String[]{null, "-1"};
        }
        if (subNodeRetParam != null && subNodeRetParam.length > 1 && subNodeRetParam[1].equals("true")) {
            checkConsistencyRetSub = this.dataConvert4Consistency(subNodeRetParam[2]);
        } else if (subNodeRetParam != null && subNodeRetParam.length > 1 && subNodeRetParam[1].equals("false")) {
            checkConsistencyRetSub = new String[]{null, "-1"};
        }
        if (checkConsistencyRetMain != null && checkConsistencyRetSub != null) {
            if (checkConsistencyRetMain[0] == null && checkConsistencyRetSub[0] == null) {
                retParams = new String[]{type, "false"};
            } else if (Long.parseLong(checkConsistencyRetMain[1]) >= Long.parseLong(checkConsistencyRetSub[1])) {
                retParams = !returnVersion ? new String[3] : new String[4];
                retParams[0] = type;
                retParams[1] = "true";
                retParams[2] = checkConsistencyRetMain[0];
                if (returnVersion) {
                    retParams[3] = checkConsistencyRetMain[1];
                }
            } else {
                retParams = !returnVersion ? new String[3] : new String[4];
                retParams[0] = type;
                retParams[1] = "true";
                retParams[2] = checkConsistencyRetSub[0];
                if (returnVersion) {
                    retParams[3] = checkConsistencyRetSub[1];
                }
            }
        } else if (checkConsistencyRetMain != null) {
            if (checkConsistencyRetMain[0] == null) {
                retParams[1] = "false";
            } else {
                if (returnVersion) {
                    String[] workRet = new String[]{retParams[0], retParams[1], retParams[2], checkConsistencyRetMain[1]};
                    retParams = workRet;
                }
                retParams[2] = checkConsistencyRetMain[0];
            }
        } else if (checkConsistencyRetSub[0] == null) {
            retParams[1] = "false";
        } else {
            if (returnVersion) {
                String[] workRet = new String[]{retParams[0], retParams[1], retParams[2], checkConsistencyRetSub[1]};
                retParams = workRet;
            }
            retParams[2] = checkConsistencyRetSub[0];
        }
        return retParams;
    }

    private String encodeIsolationConvert(String str) {
        if (this.isolationMode) {
            this.isolationBuffer.delete(0, Integer.MAX_VALUE);
            if (str != null && StatusUtil.isIsolationEncodeTarget(str)) {
                this.isolationBuffer.append(StatusUtil.getIsolationPrefix());
                this.isolationBuffer.append(str);
                return this.isolationBuffer.toString();
            }
            return str;
        }
        return str;
    }

    private String decodeIsolationConvert(String str) {
        if (this.isolationMode) {
            if (str != null) {
                return str.substring(this.isolationPrefixLength);
            }
            return str;
        }
        return str;
    }

    private String stringCnv(String str) {
        return str;
    }

    private boolean checkKeyLength(String key) {
        if (key == null) {
            return false;
        }
        return key.length() < 486;
    }

    private boolean checkValueLength(String value) {
        if (value == null) {
            return false;
        }
        return value.length() < new Double(1447034.88).intValue();
    }
}

