/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.helper;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import okuyama.base.JavaMain;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.helper.AbstractMasterManagerHelper;

public class ServerControllerHelper
extends AbstractMasterManagerHelper {
    private String statusCommandBindIp = "127.0.0.1";
    private int statusCommandPortNo = 8881;
    private static ILogger logger = LoggerFactory.createLogger(ServerControllerHelper.class);

    @Override
    public void initHelper(String initValue) {
        if (initValue != null && !initValue.trim().equals("")) {
            if (initValue.indexOf(":") == -1) {
                this.statusCommandPortNo = Integer.parseInt(initValue);
            } else {
                String[] bindDt = initValue.split(":");
                this.statusCommandBindIp = bindDt[0];
                this.statusCommandPortNo = Integer.parseInt(bindDt[1]);
            }
        }
    }

    @Override
    public String executeHelper(String optionParam) throws BatchException {
        logger.debug("ServerControllerHelper - executeHelper - start");
        String ret = SUCCESS;
        try {
            InetSocketAddress bindAddress = new InetSocketAddress(this.statusCommandBindIp, this.statusCommandPortNo);
            ServerSocket svSoc = new ServerSocket();
            svSoc.bind(bindAddress);
            Socket soc = svSoc.accept();
            soc.close();
            JavaMain.shutdownMainProccess();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("ServerControllerHelper - executeHelper - Error", e);
            throw new BatchException(e);
        }
        logger.debug("ServerControllerHelper - executeHelper - end");
        return ret;
    }

    @Override
    public void endHelper() {
    }
}

