/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;

public class JavaSystemApi {
    private static int cacheUseMemoryPercent = 2;
    private static ILogger logger = LoggerFactory.createLogger(JavaSystemApi.class);
    private static int availableProcessorsCache = 0;
    private static final int useMemSizeLimit = 97;
    public static transient long currentTimeMillis = System.currentTimeMillis();

    public static void autoGc() {
        if (JavaSystemApi.getUseMemoryPercent() >= 97) {
            JavaSystemApi.gc();
        }
    }

    public static void manualGc() {
        JavaSystemApi.gc();
    }

    private static void gc() {
        logger.info("JavaSystemApi - GC Execute Request");
        System.gc();
    }

    public static long getRuntimeMaxMem() {
        return JavaSystemApi.getRuntimeMaxMem("");
    }

    public static long getRuntimeMaxMem(String format) {
        long formatSize = JavaSystemApi.getFormatLong(format);
        Runtime runtime = Runtime.getRuntime();
        return runtime.maxMemory() / formatSize;
    }

    public static long getRuntimeTotalMem() {
        return JavaSystemApi.getRuntimeTotalMem("");
    }

    public static long getRuntimeTotalMem(String format) {
        long formatSize = JavaSystemApi.getFormatLong(format);
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() / formatSize;
    }

    public static long getRuntimeFreeMem() {
        return JavaSystemApi.getRuntimeFreeMem("");
    }

    public static long getRuntimeFreeMem(String format) {
        long formatSize = JavaSystemApi.getFormatLong(format);
        Runtime runtime = Runtime.getRuntime();
        return runtime.freeMemory() / formatSize;
    }

    public static int getUseMemoryPercent() {
        double useMem = JavaSystemApi.getRuntimeTotalMem() - JavaSystemApi.getRuntimeFreeMem();
        double usePercent = useMem / (double)JavaSystemApi.getRuntimeMaxMem();
        double percentSize = 100.0;
        Double useMemSize = new Double(usePercent *= percentSize);
        cacheUseMemoryPercent = useMemSize.intValue();
        return cacheUseMemoryPercent;
    }

    public static int getUseMemoryPercentCache() {
        return cacheUseMemoryPercent;
    }

    public static int getAvailableProcessors() {
        if (availableProcessorsCache == 0) {
            Runtime runtime = Runtime.getRuntime();
            availableProcessorsCache = runtime.availableProcessors();
        }
        return availableProcessorsCache;
    }

    private static long getFormatLong(String format) {
        long formatSize = 1L;
        if (format != null && !format.equals("")) {
            if (format.equals("K")) {
                formatSize = 1000L;
            }
            if (format.equals("M")) {
                formatSize = 1000000L;
            }
            if (format.equals("G")) {
                formatSize = 1000000000L;
            }
        }
        return formatSize;
    }
}

