/*
 * Decompiled with CFR 0.152.
 */
package okuyama.base;

import okuyama.base.IJobController;
import okuyama.base.lang.BatchDefine;
import okuyama.base.lang.BatchException;
import okuyama.base.parameter.config.BatchConfig;
import okuyama.base.parameter.config.ConfigFolder;
import okuyama.base.parameter.config.JobConfig;
import okuyama.base.util.ClassUtility;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;

public class JavaMain {
    private static ILogger logger = LoggerFactory.createLogger(JavaMain.class);

    public static void main(String[] args) {
        logger.info("JavaMain - start");
        try {
            if (args == null || args.length < 2) {
                if (args == null) {
                    System.err.println("Error : JavaMain The argument is illega [Main.properties, Node.properties]");
                    throw new BatchException("JavaMain Configure File Not Found");
                }
                System.err.println("Error : JavaMain The argument is illega [Node.properties]");
                throw new BatchException("JavaMain Configure File Not Found");
            }
            JavaMain me = new JavaMain();
            if (args.length > 2) {
                for (int i = 2; i < args.length; ++i) {
                    BatchDefine.USER_OPTION_STR = BatchDefine.USER_OPTION_STR + " " + args[i];
                }
                BatchDefine.USER_OPTION_STR = BatchDefine.USER_OPTION_STR.trim();
            } else {
                BatchDefine.USER_OPTION_STR = null;
            }
            me.exec(args[0], args[1]);
        }
        catch (BatchException be) {
            logger.error("JavaMain - error", be);
            System.exit(1);
        }
        logger.info("JavaMain - end");
    }

    public void exec(String batchConfPath, String jobConfPath) throws BatchException {
        logger.debug("JavaMain - exec - start");
        Object controllerClassName = null;
        try {
            BatchConfig batchConfig = new BatchConfig(batchConfPath);
            JobConfig jobConfig = new JobConfig(jobConfPath);
            ConfigFolder.setConfig(batchConfig, jobConfig);
            IJobController jobController = (IJobController)ClassUtility.createInstance(batchConfig.getBatchParam("controller"));
            jobController.execute();
        }
        catch (BatchException be) {
            logger.info("JavaMain - exec - error1");
            throw be;
        }
        catch (Exception e) {
            logger.info("JavaMain - exec - error2");
            throw new BatchException(e);
        }
        logger.debug("JavaMain - exec - end");
    }

    public static void shutdownMainProccess() {
        System.exit(0);
    }
}

