/*
 * Decompiled with CFR 0.152.
 */
package okuyama.base.job;

import java.util.concurrent.ConcurrentHashMap;
import okuyama.base.lang.BatchException;
import okuyama.base.parameter.config.ConfigFolder;
import okuyama.base.parameter.config.HelperConfigMap;
import okuyama.base.util.HelperPool;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;

public abstract class AbstractHelper
implements Runnable {
    private ILogger logger = LoggerFactory.createLogger(AbstractHelper.class);
    public static String WAIT = "job_wait";
    public static String RUN = "job_run";
    public static String ERR = "job_err";
    public static String END;
    protected static String SUCCESS;
    protected static String ERROR;
    protected String status = WAIT;
    protected HelperConfigMap helperConfigMap = null;
    private int useCount = 0;
    private boolean reboot = false;
    private String name = null;
    private boolean threadEnd = false;
    private static ConcurrentHashMap helperParamShareMap;
    private Object[] parameters = null;
    private Object returnParameter = null;

    public int getParameterQueueSize(String helperName) throws Exception {
        int ret = -1;
        ret = HelperPool.getParameterQueueSize(helperName);
        return ret;
    }

    public void addSmallSizeParameterQueue(String[] helperNames, Object[] params) throws Exception {
        String targetQueue = null;
        boolean fix = false;
        int targetSize = Integer.MAX_VALUE;
        for (int i = 0; i < helperNames.length; ++i) {
            int size = this.getParameterQueueSize(helperNames[i]);
            if (size == 0) {
                HelperPool.addSpecificationParameterQueue(helperNames[i], params, false);
                fix = true;
                break;
            }
            if (targetSize <= size) continue;
            targetSize = size;
            targetQueue = helperNames[i];
        }
        if (!fix) {
            this.addSpecificationParameterQueue(targetQueue, params, false);
        }
    }

    public void addSpecificationParameterQueue(String helperName, Object[] params) throws Exception {
        this.addSpecificationParameterQueue(helperName, params, false);
    }

    public void addSpecificationParameterQueue(String helperName, Object[] params, boolean debug) throws Exception {
        HelperPool.addSpecificationParameterQueue(helperName, params, debug);
    }

    public void addParameterQueue(Object[] params) throws Exception {
        HelperPool.addParameterQueue(params);
    }

    public Object[] pollSpecificationParameterQueue(String helperName) {
        return HelperPool.pollSpecificationParameterQueue(helperName);
    }

    public Object[] pollParameterQueue() {
        return HelperPool.pollParameterQueue();
    }

    public void initialize() {
        this.status = WAIT;
        this.parameters = null;
        this.returnParameter = null;
        ++this.useCount;
    }

    public void setConfig(HelperConfigMap helperConfigMap) {
        this.helperConfigMap = helperConfigMap;
    }

    public HelperConfigMap getConfig() {
        return this.helperConfigMap;
    }

    public abstract void initHelper(String var1);

    public abstract String executeHelper(String var1) throws BatchException;

    public abstract void endHelper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: {
            this.logger.debug("Helper - [" + this.helperConfigMap.getHelperName() + "] - run - start");
            String retStatus = null;
            this.status = RUN;
            try {
                this.initHelper(this.helperConfigMap.getHelperInit());
                retStatus = this.executeHelper(this.helperConfigMap.getHelperOption());
                if (retStatus != null) {
                    if (retStatus.equals(SUCCESS)) {
                        this.status = retStatus;
                        break block10;
                    }
                    if (retStatus.equals(ERROR)) {
                        this.status = retStatus;
                        break block10;
                    }
                    throw new BatchException("Helper End Erro Return Value");
                }
                throw new BatchException("Helper End Erro Return Value");
            }
            catch (BatchException be) {
                this.logger.error("AbstractHelperJob - run - BatchException ", be);
                this.status = ERR;
            }
            catch (Exception e) {
                this.logger.error("AbstractHelperJob - run - Exception", e);
                this.status = ERR;
            }
            finally {
                this.threadEnd = true;
            }
        }
        this.logger.debug("Helper - run - end");
    }

    public String getStatus() {
        return this.status;
    }

    protected String getPropertiesValue(String key) {
        return ConfigFolder.getJobUserParam(key);
    }

    protected boolean isJobFileChange() throws BatchException {
        return ConfigFolder.isJobFileChange();
    }

    protected void reloadJobFileParameter(String[] keys) throws BatchException {
        ConfigFolder.reloadJobFileParameter(keys);
    }

    public void setHelperShareParam(Object key, Object val) {
        helperParamShareMap.put(key, val);
    }

    public Object getHelperShareParam(Object key) {
        Object ret = null;
        if (helperParamShareMap.containsKey(key)) {
            ret = helperParamShareMap.get(key);
        }
        return ret;
    }

    public Object removeHelperShareParam(Object key) {
        if (helperParamShareMap.containsKey(key)) {
            return helperParamShareMap.remove(key);
        }
        return null;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setReturnParameter(Object value) {
        this.returnParameter = value;
    }

    public Object getReturnParameter() {
        return this.returnParameter;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public void setReboot(boolean reboot) {
        this.reboot = reboot;
    }

    public boolean getReboot() {
        return this.reboot;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean getThreadEnd() {
        return this.threadEnd;
    }

    static {
        SUCCESS = END = "job_end";
        ERROR = ERR;
        helperParamShareMap = new ConcurrentHashMap(1024, 512.0f, 1024);
    }
}

