/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import okuyama.base.job.AbstractHelper;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.util.KeyMapManager;

public class TransactionManagerHelper
extends AbstractHelper {
    private KeyMapManager keyMapManager = null;
    private Socket soc = null;
    private static ILogger logger = LoggerFactory.createLogger(TransactionManagerHelper.class);

    @Override
    public void initHelper(String initValue) {
    }

    @Override
    public String executeHelper(String optionParam) throws BatchException {
        logger.debug("TransactionManagerHelper - executeHelper - start");
        String ret = null;
        boolean closeFlg = false;
        try {
            String[] retParams = null;
            StringBuilder retParamBuf = null;
            Object[] parameters = super.getParameters();
            String clientParametersStr = null;
            String[] clientParameterList = null;
            String requestKeyCode = null;
            String transactionCode = null;
            int lockWaitingTime = 0;
            int lockingTime = 0;
            this.keyMapManager = (KeyMapManager)parameters[0];
            this.soc = (Socket)parameters[1];
            OutputStreamWriter osw = new OutputStreamWriter(this.soc.getOutputStream(), "UTF-8");
            PrintWriter pw = new PrintWriter(new BufferedWriter(osw));
            InputStreamReader isr = new InputStreamReader(this.soc.getInputStream(), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            while (!closeFlg) {
                try {
                    clientParametersStr = br.readLine();
                    if (clientParametersStr == null || clientParametersStr.equals("") || clientParametersStr.equals("(&imdst9999&)")) {
                        logger.debug("Client Connect Exit Request");
                        closeFlg = true;
                        break;
                    }
                    clientParameterList = clientParametersStr.split(",");
                    retParamBuf = new StringBuilder();
                    if (clientParameterList[0].equals("30")) {
                        requestKeyCode = clientParameterList[1];
                        transactionCode = clientParameterList[2];
                        lockingTime = Integer.parseInt(clientParameterList[3]);
                        lockWaitingTime = Integer.parseInt(clientParameterList[4]);
                        retParams = this.lockDatanode(requestKeyCode, transactionCode, lockingTime, lockWaitingTime);
                        retParamBuf.append(retParams[0]);
                        retParamBuf.append(",");
                        retParamBuf.append(retParams[1]);
                        if (retParams.length > 2) {
                            retParamBuf.append(",");
                            retParamBuf.append(retParams[2]);
                        }
                    } else if (clientParameterList[0].equals("31")) {
                        requestKeyCode = clientParameterList[1];
                        transactionCode = clientParameterList[2];
                        retParams = this.releaseLockDatanode(requestKeyCode, transactionCode);
                        retParamBuf.append(retParams[0]);
                        retParamBuf.append(",");
                        retParamBuf.append(retParams[1]);
                        if (retParams.length > 2) {
                            retParamBuf.append(",");
                            retParamBuf.append(retParams[2]);
                        }
                    } else if (clientParameterList[0].equals("32")) {
                        requestKeyCode = clientParameterList[1];
                        retParams = this.hasLockDatanode(requestKeyCode);
                        retParamBuf.append(retParams[0]);
                        retParamBuf.append(",");
                        retParamBuf.append(retParams[1]);
                        if (retParams.length > 2) {
                            retParamBuf.append(",");
                            retParamBuf.append(retParams[2]);
                        }
                    }
                    if (retParamBuf == null) continue;
                    pw.println(retParamBuf.toString());
                    pw.flush();
                }
                catch (SocketException se) {
                    closeFlg = true;
                }
            }
            pw.close();
            br.close();
            ret = AbstractHelper.SUCCESS;
        }
        catch (Exception e) {
            logger.error("TransactionManagerHelper - executeHelper - Error", e);
            ret = AbstractHelper.ERROR;
            throw new BatchException(e);
        }
        finally {
            try {
                if (this.soc != null) {
                    this.soc.close();
                    this.soc = null;
                }
            }
            catch (Exception e2) {
                logger.error("TransactionManagerHelper - executeHelper - Error2", e2);
                ret = AbstractHelper.ERROR;
                throw new BatchException(e2);
            }
        }
        logger.debug("TransactionManagerHelper - executeHelper - end");
        return ret;
    }

    @Override
    public void endHelper() {
        logger.debug("TransactionManagerHelper - endHelper - start");
        try {
            if (this.soc != null) {
                this.soc.close();
                this.soc = null;
            }
        }
        catch (Exception e2) {
            logger.error("TransactionManagerHelper - executeHelper - Error2", e2);
        }
        logger.debug("TransactionManagerHelper - endHelper - end");
    }

    private String[] lockDatanode(String key, String transactionCode, int lockingTime, int lockWaitingTime) {
        String[] retStrs = null;
        long counter = 0L;
        String retTranCd = null;
        int miniCounter = 0;
        try {
            if (!this.keyMapManager.checkError()) {
                while (true) {
                    for (miniCounter = 0; 10 > miniCounter && (retTranCd = this.keyMapManager.locking(key, transactionCode, lockingTime)) == null && counter != (long)lockWaitingTime; ++miniCounter) {
                        Thread.sleep(100L);
                    }
                    if (counter == (long)lockWaitingTime || retTranCd != null) break;
                    ++counter;
                }
                retStrs = retTranCd != null ? new String[]{"30", "true", transactionCode} : new String[]{"30", "false"};
            } else {
                retStrs = new String[]{"30", "false"};
            }
        }
        catch (Exception e) {
            logger.error("TransactionManagerHelper - lockDatanode - Error", e);
            retStrs = new String[]{"30", "false"};
        }
        return retStrs;
    }

    private String[] releaseLockDatanode(String key, String transactionCode) {
        String[] retStrs = null;
        try {
            retStrs = !this.keyMapManager.checkError() ? (this.keyMapManager.isLock(key) ? (this.keyMapManager.removeLock(key, transactionCode) != null ? new String[]{"31", "true", transactionCode} : new String[]{"31", "false"}) : new String[]{"31", "true", transactionCode}) : new String[]{"31", "false"};
        }
        catch (Exception e) {
            logger.error("TransactionManagerHelper - releaseLockDatanode - Error", e);
            retStrs = new String[]{"31", "false"};
        }
        return retStrs;
    }

    private String[] hasLockDatanode(String key) {
        String[] retStrs = null;
        try {
            String transactionCode;
            retStrs = !this.keyMapManager.checkError() ? ((transactionCode = this.keyMapManager.getLockedTransactionCode(key)) != null ? new String[]{"32", "true", transactionCode} : new String[]{"32", "false"}) : new String[]{"32", "false"};
        }
        catch (Exception e) {
            logger.error("TransactionManagerHelper - isLockDatanode - Error", e);
            retStrs = new String[]{"32", "false"};
        }
        return retStrs;
    }
}

