/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.job;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;
import okuyama.base.job.AbstractJob;
import okuyama.base.job.IJob;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.util.JavaSystemApi;
import okuyama.imdst.util.KeyMapManager;
import okuyama.imdst.util.StatusUtil;

public class KeyManagerJob
extends AbstractJob
implements IJob {
    private String myPrefix = null;
    private String bindIpAddress = null;
    private int portNo = 5553;
    private int backLog = 50;
    private String keySizeStr = null;
    private int keySize = 500000;
    private boolean workFileMemoryMode = false;
    private String workFileMemoryModeStr = null;
    private boolean dataMemoryMode = true;
    private String dataMemoryModeStr = null;
    private int maxConnectParallelExecution = 10;
    private long maxConnectParallelQueue = 3L;
    private String[] maxConnectParallelQueueNames = null;
    private int maxAcceptParallelExecution = 4;
    private long maxAcceptParallelQueue = 2L;
    private String[] maxAcceptParallelQueueNames = null;
    private int maxWorkerParallelExecution = 4;
    private int maxWorkerParallelQueue = 2;
    private String[] maxWorkerParallelQueueNames = null;
    private long multiQueue = 5L;
    ServerSocket serverSocket = null;
    private KeyMapManager keyMapManager = null;
    private static ILogger logger = LoggerFactory.createLogger(KeyManagerJob.class);

    @Override
    public void initJob(String initValue) {
        String queueSizeStr;
        String[] splitInitVal;
        logger.debug("KeyManagerJob - initJob - start");
        logger.info("okuyama DataNode Initialization Start ...");
        System.out.println("okuyama DataNode Initialization Start ...");
        if (initValue.indexOf(":") != -1) {
            splitInitVal = initValue.split(":");
            this.bindIpAddress = splitInitVal[0];
            if (splitInitVal[1].indexOf("&") != -1) {
                splitInitVal = splitInitVal[1].split("&");
                this.portNo = Integer.parseInt(splitInitVal[0]);
                this.backLog = Integer.parseInt(splitInitVal[1]);
            } else {
                this.portNo = Integer.parseInt(splitInitVal[1]);
            }
        } else if (initValue.indexOf("&") != -1) {
            splitInitVal = initValue.split("&");
            this.portNo = Integer.parseInt(splitInitVal[0]);
            this.backLog = Integer.parseInt(splitInitVal[1]);
        } else {
            this.portNo = Integer.parseInt(initValue);
        }
        this.myPrefix = super.getJobName();
        String sizeStr = super.getPropertiesValue("KeyNodeMaxConnectParallelExecution");
        if (sizeStr != null && Integer.parseInt(sizeStr) > this.maxConnectParallelExecution) {
            this.maxConnectParallelExecution = Integer.parseInt(sizeStr);
        }
        if ((queueSizeStr = super.getPropertiesValue("KeyNodeMaxConnectParallelQueue")) != null && this.maxConnectParallelExecution >= Integer.parseInt(queueSizeStr)) {
            this.maxConnectParallelQueue = Integer.parseInt(queueSizeStr);
        } else if (queueSizeStr != null) {
            this.maxConnectParallelQueue = this.maxConnectParallelExecution / 2;
        }
        this.maxConnectParallelQueueNames = new String[new Long(this.maxConnectParallelQueue).intValue()];
        sizeStr = super.getPropertiesValue("KeyNodeMaxAcceptParallelExecution");
        if (sizeStr != null && Integer.parseInt(sizeStr) > this.maxAcceptParallelExecution) {
            this.maxAcceptParallelExecution = Integer.parseInt(sizeStr);
        }
        if ((queueSizeStr = super.getPropertiesValue("KeyNodeMaxAcceptParallelQueue")) != null && this.maxAcceptParallelExecution >= Integer.parseInt(queueSizeStr)) {
            this.maxAcceptParallelQueue = Integer.parseInt(queueSizeStr);
        } else if (queueSizeStr != null) {
            this.maxAcceptParallelQueue = this.maxAcceptParallelExecution / 2;
        }
        this.maxAcceptParallelQueueNames = new String[new Long(this.maxAcceptParallelQueue).intValue()];
        sizeStr = super.getPropertiesValue("KeyNodeMaxWorkerParallelExecution");
        if (sizeStr != null && Integer.parseInt(sizeStr) > this.maxWorkerParallelExecution) {
            this.maxWorkerParallelExecution = Integer.parseInt(sizeStr);
        }
        if ((queueSizeStr = super.getPropertiesValue("KeyNodeMaxWorkerParallelQueue")) != null && this.maxWorkerParallelExecution >= Integer.parseInt(queueSizeStr)) {
            this.maxWorkerParallelQueue = Integer.parseInt(queueSizeStr);
        } else if (queueSizeStr != null) {
            this.maxWorkerParallelQueue = this.maxWorkerParallelExecution / 2;
        }
        this.maxWorkerParallelQueueNames = new String[new Long(this.maxWorkerParallelQueue).intValue()];
        logger.debug("KeyManagerJob - initJob - end");
    }

    @Override
    public String executeJob(String optionParam) throws BatchException {
        logger.debug("KeyManagerJob - executeJob - start");
        String ret = SUCCESS;
        Socket socket = null;
        String keyManagerConnectHelperQueuePrefix = "KeyManagerConnectHelper" + this.myPrefix;
        long accessCount = 0L;
        try {
            this.initDataPersistentConfig(optionParam);
            this.initHelperTaskQueue();
            InetSocketAddress bindAddress = null;
            bindAddress = this.bindIpAddress == null ? new InetSocketAddress(this.portNo) : new InetSocketAddress(this.bindIpAddress, this.portNo);
            this.serverSocket = new ServerSocket();
            this.serverSocket.bind(bindAddress, this.backLog);
            super.setJobShareParam(super.getJobName() + "_ServeSocket", this.serverSocket);
            logger.info("okuyama DataNode Initialization End ...");
            System.out.println("okuyama DataNode Initialization End ...");
            logger.info("okuyama DataNode start ...");
            logger.info("listening on " + bindAddress);
            System.out.println("okuyama DataNode start");
            System.out.println("listening on " + bindAddress);
            while (StatusUtil.getStatus() != 1 && StatusUtil.getStatus() != 2) {
                try {
                    socket = this.serverSocket.accept();
                    Object[] helperParam = new Object[]{socket};
                    super.addSpecificationParameterQueue(keyManagerConnectHelperQueuePrefix + ++accessCount % this.maxConnectParallelQueue, helperParam);
                }
                catch (Exception e) {
                    if (StatusUtil.getStatus() == 2) {
                        logger.info("KeyManagerJob - executeJob - ServerEnd");
                        break;
                    }
                    logger.error("", e);
                }
            }
        }
        catch (Exception e) {
            logger.error("KeyManagerJob - executeJob - Error", e);
            throw new BatchException(e);
        }
        return ret;
    }

    private void initDataPersistentConfig(String optionParam) {
        String[] keyMapFiles = null;
        String keyStoreForFileStr = null;
        boolean keyStoreForFileFlg = false;
        String keyStoreDirsStr = null;
        String[] keyStoreDirs = null;
        String memoryLimitSize = null;
        int memoryLimitSizeInt = -1;
        String virtualStorageDirsStr = null;
        String[] virtualStorageDirs = null;
        try {
            keyMapFiles = optionParam.split(",");
            this.workFileMemoryModeStr = super.getPropertiesValue(super.getJobName() + ".memoryMode");
            this.dataMemoryModeStr = super.getPropertiesValue(super.getJobName() + ".dataMemory");
            keyStoreForFileStr = super.getPropertiesValue(super.getJobName() + ".keyMemory");
            if ((keyStoreForFileStr != null || !keyStoreForFileStr.equals("")) && keyStoreForFileStr.equals("false")) {
                keyStoreForFileFlg = true;
            }
            if ((keyStoreDirsStr = super.getPropertiesValue(super.getJobName() + ".keyStoreDirs")) != null) {
                keyStoreDirs = keyStoreDirsStr.split(",");
            }
            this.keySizeStr = super.getPropertiesValue(super.getJobName() + ".keySize");
            if (this.workFileMemoryModeStr != null && this.workFileMemoryModeStr.equals("true")) {
                this.workFileMemoryMode = true;
            }
            if (this.dataMemoryModeStr != null && this.dataMemoryModeStr.equals("false")) {
                this.dataMemoryMode = false;
            }
            if (this.keySizeStr != null) {
                this.keySize = Integer.parseInt(this.keySizeStr);
            }
            if (!(this.workFileMemoryMode || keyStoreForFileFlg || (memoryLimitSize = super.getPropertiesValue(super.getJobName() + ".memoryLimitSize")) == null || memoryLimitSize.trim().equals("") || new Integer(memoryLimitSize) <= 0 || (virtualStorageDirsStr = super.getPropertiesValue(super.getJobName() + ".virtualStoreDirs")) == null || virtualStorageDirsStr.trim().equals(""))) {
                memoryLimitSizeInt = new Integer(memoryLimitSize);
                virtualStorageDirs = virtualStorageDirsStr.split(",");
            }
            this.keyMapManager = keyStoreForFileFlg ? new KeyMapManager(keyMapFiles[0], keyMapFiles[1], this.workFileMemoryMode, this.keySize, this.dataMemoryMode, keyStoreDirs) : new KeyMapManager(keyMapFiles[0], keyMapFiles[1], this.workFileMemoryMode, this.keySize, this.dataMemoryMode, memoryLimitSizeInt, virtualStorageDirs);
            this.keyMapManager.start();
            if (this.keyMapManager.getSaveDataCount() > 50) {
                JavaSystemApi.manualGc();
                Thread.sleep(60000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initHelperTaskQueue() {
        long queueIndex = 0L;
        try {
            int i;
            Object[] queueParam;
            int i2 = 0;
            while ((long)i2 < this.maxConnectParallelQueue) {
                super.createUniqueHelperParamQueue("KeyManagerConnectHelper" + this.myPrefix + i2, 7000);
                this.maxConnectParallelQueueNames[i2] = "KeyManagerConnectHelper" + this.myPrefix + i2;
                ++i2;
            }
            i2 = 0;
            while ((long)i2 < this.maxAcceptParallelQueue) {
                super.createUniqueHelperParamQueue("KeyManagerAcceptHelper" + this.myPrefix + i2, 5000);
                this.maxAcceptParallelQueueNames[i2] = "KeyManagerAcceptHelper" + this.myPrefix + i2;
                ++i2;
            }
            for (i2 = 0; i2 < this.maxWorkerParallelQueue; ++i2) {
                super.createUniqueHelperParamQueue("KeyManagerHelper" + this.myPrefix + i2, 5000);
                this.maxWorkerParallelQueueNames[i2] = "KeyManagerHelper" + this.myPrefix + i2;
            }
            for (i2 = 0; i2 < this.maxConnectParallelExecution; ++i2) {
                queueIndex = (long)(i2 + 1) % this.maxConnectParallelQueue;
                queueParam = new Object[]{"KeyManagerConnectHelper" + this.myPrefix + queueIndex, this.maxAcceptParallelQueueNames};
                super.executeHelper("KeyManagerConnectHelper", queueParam, true);
            }
            for (i2 = 0; i2 < this.maxAcceptParallelExecution; ++i2) {
                queueIndex = (long)(i2 + 1) % this.maxAcceptParallelQueue;
                queueParam = new Object[]{"KeyManagerAcceptHelper" + this.myPrefix + queueIndex, this.maxWorkerParallelQueueNames};
                super.executeHelper("KeyManagerAcceptHelper", queueParam, true);
            }
            Object[] helperShareParams = new Object[this.maxWorkerParallelQueue * 2];
            queueIndex = 0L;
            for (i = 0; i < this.maxWorkerParallelQueue * 2; i += 2) {
                helperShareParams[i] = "Bind-KeyManagerHelper" + this.myPrefix + queueIndex;
                helperShareParams[i + 1] = new AtomicInteger(0);
                ++queueIndex;
            }
            queueIndex = 0L;
            for (i = 0; i < this.maxWorkerParallelExecution; ++i) {
                queueIndex = (i + 1) % this.maxWorkerParallelQueue;
                AtomicInteger queueBindHelperCount = (AtomicInteger)helperShareParams[new Long(queueIndex).intValue() * 2 + 1];
                queueBindHelperCount.getAndIncrement();
                helperShareParams[new Long((long)queueIndex).intValue() * 2 + 1] = queueBindHelperCount;
            }
            for (i = 0; i < this.maxWorkerParallelExecution; ++i) {
                queueIndex = (i + 1) % this.maxWorkerParallelQueue;
                Object[] queueParam2 = new Object[]{this.keyMapManager, "KeyManagerHelper" + this.myPrefix + queueIndex, this.maxAcceptParallelQueueNames, "Bind-KeyManagerHelper" + this.myPrefix + queueIndex};
                if (i == 0) {
                    super.executeHelper("KeyManagerHelper", queueParam2, true, helperShareParams);
                    continue;
                }
                super.executeHelper("KeyManagerHelper", queueParam2, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

