/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.job;

import java.net.ServerSocket;
import java.net.Socket;
import okuyama.base.job.AbstractJob;
import okuyama.base.job.IJob;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.util.KeyMapManager;
import okuyama.imdst.util.StatusUtil;

public class TransactionManagerJob
extends AbstractJob
implements IJob {
    private int portNo = 10060;
    ServerSocket serverSocket = null;
    private KeyMapManager keyMapManager = null;
    private static ILogger logger = LoggerFactory.createLogger(TransactionManagerJob.class);

    @Override
    public void initJob(String initValue) {
        logger.debug("TransactionManagerJob - initJob - start");
        this.portNo = Integer.parseInt(initValue);
        logger.debug("TransactionManagerJob - initJob - end");
    }

    @Override
    public String executeJob(String optionParam) throws BatchException {
        logger.debug("TransactionManagerJob - executeJob - start");
        String ret = SUCCESS;
        Object[] helperParams = null;
        String[] keyMapFiles = null;
        String keySizeStr = null;
        int keySize = 500000;
        boolean workFileMemoryMode = false;
        String workFileMemoryModeStr = null;
        boolean dataMemoryMode = true;
        String dataMemoryModeStr = null;
        Socket socket = null;
        try {
            keyMapFiles = optionParam.split(",");
            workFileMemoryModeStr = super.getPropertiesValue(super.getJobName() + ".memoryMode");
            dataMemoryModeStr = super.getPropertiesValue(super.getJobName() + ".dataMemory");
            keySizeStr = super.getPropertiesValue(super.getJobName() + ".keySize");
            if (workFileMemoryModeStr != null && workFileMemoryModeStr.equals("true")) {
                workFileMemoryMode = true;
            }
            if (dataMemoryModeStr != null && dataMemoryModeStr.equals("false")) {
                dataMemoryMode = false;
            }
            if (keySizeStr != null) {
                keySize = Integer.parseInt(keySizeStr);
            }
            this.keyMapManager = new KeyMapManager(keyMapFiles[0], keyMapFiles[1], workFileMemoryMode, keySize, dataMemoryMode, false);
            this.keyMapManager.start();
            this.serverSocket = new ServerSocket(this.portNo);
            super.setJobShareParam(super.getJobName() + "_ServeSocket", this.serverSocket);
            while (StatusUtil.getStatus() != 1 && StatusUtil.getStatus() != 2) {
                try {
                    socket = this.serverSocket.accept();
                    helperParams = new Object[]{this.keyMapManager, socket};
                    super.executeHelper("TransactionManagerHelper", helperParams);
                }
                catch (Exception e) {
                    if (StatusUtil.getStatus() == 2) {
                        logger.info("TransactionManagerJob - executeJob - ServerEnd");
                        break;
                    }
                    logger.error(e);
                }
            }
        }
        catch (Exception e) {
            logger.error("TransactionManagerJob - executeJob - Error", e);
            throw new BatchException(e);
        }
        return ret;
    }
}

