/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.SocketException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.util.DataDispatcher;
import okuyama.imdst.util.FileBaseDataList;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.JavaSystemApi;
import okuyama.imdst.util.KeyManagerValueMap;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.SystemUtil;

public class KeyMapManager
extends Thread {
    private static ILogger logger = LoggerFactory.createLogger(KeyMapManager.class);
    private KeyManagerValueMap keyMapObj = null;
    private int mapSize = 0;
    private static final String tagStartStr = "{imdst_tag#9641";
    private static final String tagEndStr = "1469#tag_imdst}";
    private static final String tagKeySep = ":";
    private int putValueMaxSize = new Double((double)ImdstDefine.saveDataMaxSize * 1.38).intValue();
    private Object poolKeyLock = new Object();
    private Object setKeyLock = new Object();
    private Object lockKeyLock = new Object();
    private static final int parallelSize = 5000;
    private Integer[] parallelSyncObjs = new Integer[5000];
    private static final int tagSetParallelSize = 5000;
    private Integer[] tagSetParallelSyncObjs = new Integer[5000];
    private Object setTagLock = new Object();
    private String nodeKeyMapFilePath = null;
    private String workKeyFilePath = null;
    private String[] keyFileDirs = null;
    private FileOutputStream fos = null;
    private OutputStreamWriter osw = null;
    private BufferedWriter bw = null;
    private boolean blocking = false;
    private boolean initFlg = false;
    private boolean writeMapFileFlg = false;
    private static int updateInterval = 1500;
    private static int intervalCount = 40;
    private static String workFileSeq = ",";
    private static String workMapFileEnc = "UTF-8";
    private static String workFileEndPoint = ";";
    private boolean workFileMemory = false;
    private Object lockWorkFileSync = new Object();
    private static final long workFileChangeNewFileSize = 0x60000000L;
    private static final int workFileChangeCheckLimit = 2;
    private boolean dataMemory = true;
    private boolean allDataForFile = false;
    private String diskModeRestoreFile = null;
    private long lastAccess = 0L;
    private boolean vacuumExec = false;
    private int vacuumStartLimit = 100000;
    private int vacuumStartCompulsionLimit = 1000000;
    private int vacuumExecAfterAccessTime = 200;
    private boolean dataManege = true;
    private String lockKeyTimeSep = "_";
    private boolean diffDataPoolingFlg = false;
    private Object diffSync = new Object();
    private List diffDataPoolingListForFileBase = null;
    private ConcurrentHashMap moveAdjustmentDataMap = null;
    private Object moveAdjustmentSync = new Object();
    private int memoryLimitSize = -1;
    private String[] virtualStorageDirs = null;

    public KeyMapManager(String keyMapFilePath, String workKeyMapFilePath, boolean workFileMemory, int keySize, boolean dataMemory, boolean dataManage) throws BatchException {
        this.init(keyMapFilePath, workKeyMapFilePath, workFileMemory, keySize, dataMemory, null);
        this.dataManege = dataManage;
    }

    public KeyMapManager(String keyMapFilePath, String workKeyMapFilePath, boolean workFileMemory, int keySize, boolean dataMemory) throws BatchException {
        this.init(keyMapFilePath, workKeyMapFilePath, workFileMemory, keySize, dataMemory, null);
    }

    public KeyMapManager(String keyMapFilePath, String workKeyMapFilePath, boolean workFileMemory, int keySize, boolean dataMemory, int memoryLimitSize, String[] virtualStorageDirs) throws BatchException {
        this.memoryLimitSize = memoryLimitSize;
        this.virtualStorageDirs = virtualStorageDirs;
        this.init(keyMapFilePath, workKeyMapFilePath, workFileMemory, keySize, dataMemory, null);
    }

    public KeyMapManager(String keyMapFilePath, String workKeyMapFilePath, boolean workFileMemory, int keySize, boolean dataMemory, String[] dirs) throws BatchException {
        this.init(keyMapFilePath, workKeyMapFilePath, workFileMemory, keySize, dataMemory, dirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String keyMapFilePath, String workKeyMapFilePath, boolean workFileMemory, int keySize, boolean dataMemory, String[] dirs) throws BatchException {
        logger.debug("init - start");
        if (!this.initFlg) {
            int i;
            this.initFlg = true;
            this.nodeKeyMapFilePath = keyMapFilePath;
            this.workFileMemory = workFileMemory;
            this.dataMemory = dataMemory;
            this.mapSize = keySize;
            this.workKeyFilePath = workKeyMapFilePath;
            FileInputStream workKeyFilefis = null;
            InputStreamReader isr = null;
            Object fr = null;
            BufferedReader br = null;
            String line = null;
            String[] workSplitStrs = null;
            if (dirs != null) {
                this.dataMemory = false;
                this.allDataForFile = true;
                this.keyFileDirs = dirs;
            }
            if (!this.dataMemory) {
                this.diskModeRestoreFile = keyMapFilePath + ".data";
            }
            for (i = 0; i < 5000; ++i) {
                this.parallelSyncObjs[i] = new Integer(i);
            }
            for (i = 0; i < 5000; ++i) {
                this.tagSetParallelSyncObjs[i] = new Integer(i + 5000);
            }
            Object object = this.poolKeyLock;
            synchronized (object) {
                try {
                    boolean mapFileRead = true;
                    this.keyMapObj = !this.allDataForFile ? new KeyManagerValueMap(this.mapSize, this.dataMemory, this.virtualStorageDirs) : new KeyManagerValueMap(this.keyFileDirs, this.mapSize);
                    if (!dataMemory) {
                        File dataFile = new File(this.diskModeRestoreFile);
                        if (dataFile.exists()) {
                            dataFile.delete();
                        }
                        this.keyMapObj.initNoMemoryModeSetting(this.diskModeRestoreFile);
                    }
                    int i2 = 0;
                    while (true) {
                        boolean endFlg = false;
                        File workKeyFile = new File(this.workKeyFilePath + i2);
                        if (!workKeyFile.exists()) {
                            workKeyFile = new File(this.workKeyFilePath);
                            endFlg = true;
                        }
                        if (workKeyFile.exists()) {
                            logger.info("workKeyMapFile - Read - start");
                            workKeyFilefis = new FileInputStream(workKeyFile);
                            isr = new InputStreamReader((InputStream)workKeyFilefis, workMapFileEnc);
                            br = new BufferedReader(isr);
                            int counter = 1;
                            while ((line = br.readLine()) != null) {
                                if (counter % 100 == 0) {
                                    logger.info("workKeyMapFile - Read - Count =[" + counter + "]");
                                }
                                if (!line.equals("")) {
                                    workSplitStrs = line.split(workFileSeq);
                                    if (workSplitStrs.length == 5) {
                                        if (workSplitStrs[0].equals("+")) {
                                            this.keyMapObjPutSetTime(workSplitStrs[1], workSplitStrs[2], new Long(workSplitStrs[3]));
                                        } else if (workSplitStrs[0].equals("-")) {
                                            this.keyMapObjRemoveSetTime(workSplitStrs[1], new Long(workSplitStrs[3]));
                                        }
                                    } else if (workSplitStrs.length == 6) {
                                        if (workSplitStrs[0].equals("+")) {
                                            this.keyMapObjPutSetTime(workSplitStrs[1], workSplitStrs[2] + workFileSeq + workSplitStrs[3], new Long(workSplitStrs[4]));
                                        } else if (workSplitStrs[0].equals("-")) {
                                            this.keyMapObjRemoveSetTime(workSplitStrs[1], new Long(workSplitStrs[3]));
                                        }
                                    } else {
                                        logger.error("workKeyMapFile - Read - Error " + counter + "Line Data = [" + workSplitStrs + "]");
                                    }
                                } else {
                                    logger.info("workKeyMapFile - Read - Info " + counter + "Line Blank");
                                }
                                ++counter;
                            }
                            br.close();
                            isr.close();
                            workKeyFilefis.close();
                            logger.info("workKeyMapFile - Read - end");
                        }
                        if (endFlg) break;
                        ++i2;
                    }
                    this.fos = new FileOutputStream(new File(this.workKeyFilePath), true);
                    this.osw = new OutputStreamWriter((OutputStream)this.fos, workMapFileEnc);
                    this.bw = new BufferedWriter(this.osw);
                    this.bw.newLine();
                    this.bw.flush();
                }
                catch (Exception e) {
                    logger.error("KeyMapManager - init - Error" + e);
                    this.blocking = true;
                    StatusUtil.setStatusAndMessage(1, "KeyMapManager - init - Error [" + e.getMessage() + "]");
                    throw new BatchException(e);
                }
            }
        }
        logger.debug("init - end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int sizeCheckCounter = 0;
        int vacuumInvalidDataCount = 0;
        while (true) {
            if (StatusUtil.getStatus() != 0) break;
            try {
                for (int count = 0; count < intervalCount; ++count) {
                    if (StatusUtil.getStatus() != 0) {
                        logger.info("KeyMapManager - run - System Shutdown 2");
                        break;
                    }
                    if (!this.dataManege) {
                        this.autoLockRelease(JavaSystemApi.currentTimeMillis);
                    }
                    if (this.memoryLimitSize > 0 && JavaSystemApi.getUseMemoryPercentCache() > this.memoryLimitSize) {
                        StatusUtil.useMemoryLimitOver();
                    }
                    Thread.sleep(updateInterval);
                }
                logger.debug("Transaction Log Size Check - Start");
                if (!this.workFileMemory && ++sizeCheckCounter > 2) {
                    File nowWorkFile = new File(this.workKeyFilePath);
                    if (nowWorkFile.length() > 0x60000000L) {
                        Object object = this.poolKeyLock;
                        synchronized (object) {
                            Object object2 = this.lockWorkFileSync;
                            synchronized (object2) {
                                logger.debug("Transaction Log File Change - Start");
                                this.fos.close();
                                this.fos = null;
                                this.osw.close();
                                this.osw = null;
                                this.bw.close();
                                this.bw = null;
                                int nextWorkFileName = 0;
                                File checkWorkKeyFile = null;
                                nextWorkFileName = 0;
                                while ((checkWorkKeyFile = new File(this.workKeyFilePath + nextWorkFileName)).exists()) {
                                    ++nextWorkFileName;
                                }
                                if (!nowWorkFile.renameTo(checkWorkKeyFile)) {
                                    throw new Exception("Work File Name Change Error");
                                }
                                nowWorkFile = null;
                                checkWorkKeyFile = null;
                                this.fos = new FileOutputStream(new File(this.workKeyFilePath), true);
                                this.osw = new OutputStreamWriter((OutputStream)this.fos, workMapFileEnc);
                                this.bw = new BufferedWriter(this.osw);
                                this.bw.newLine();
                                this.bw.flush();
                                logger.debug("Transaction Log File Change - End");
                            }
                        }
                    }
                    sizeCheckCounter = 0;
                }
                logger.debug("Transaction Log Size Check - End");
                logger.info("VacuumCheck - Start");
                if (!this.dataMemory && this.vacuumExec) {
                    logger.debug("vacuumCheck - Start - 1");
                    Object nowWorkFile = this.poolKeyLock;
                    synchronized (nowWorkFile) {
                        logger.debug("VacuumCheck - DifferenceCount = [" + (this.keyMapObj.getAllDataCount() - this.keyMapObj.getKeySize()) + "]");
                        if (this.keyMapObj.getAllDataCount() - this.keyMapObj.getKeySize() > this.vacuumStartLimit) {
                            logger.debug("VacuumCheck - Start - 2");
                            if (JavaSystemApi.currentTimeMillis - this.lastAccess > (long)this.vacuumExecAfterAccessTime || this.keyMapObj.getAllDataCount() - this.keyMapObj.getKeySize() > this.vacuumStartCompulsionLimit) {
                                logger.info("Vacuum - Start Vacuum Data Count=[" + (this.keyMapObj.getAllDataCount() - this.keyMapObj.getKeySize()) + "]");
                                long vacuumStart = JavaSystemApi.currentTimeMillis;
                                this.keyMapObj.vacuumData();
                                long vacuumEnd = JavaSystemApi.currentTimeMillis;
                                logger.info("Vacuum - End - VacuumTime [" + (vacuumEnd - vacuumStart) + "] Milli Second");
                            }
                        }
                    }
                }
                logger.info("VacuumCheck - End");
                if (this.dataMemory && ImdstDefine.vacuumInvalidDataFlg && vacuumInvalidDataCount > ImdstDefine.startVaccumInvalidCount) {
                    logger.info("VacuumInvalidData - Start - 1");
                    Object nowWorkFile = this.poolKeyLock;
                    synchronized (nowWorkFile) {
                        Set entrySet = this.keyMapObj.entrySet();
                        Iterator entryIte = entrySet.iterator();
                        long removeTagetData = 0L;
                        long counter = 0L;
                        while (entryIte.hasNext()) {
                            String[] metaColumns;
                            Map.Entry obj;
                            if (++counter % 5000L == 0L) {
                                logger.info("VacuumInvalidData - Exec Count[" + counter + "]");
                            }
                            if ((obj = (Map.Entry)entryIte.next()) == null) continue;
                            Object key = null;
                            key = obj.getKey();
                            String valStr = this.getKeyPair(key);
                            String[] valStrSplit = valStr.split("!");
                            String[] checkValueSplit = (valStr = valStrSplit[0]).split(",");
                            if (checkValueSplit.length <= 1 || SystemUtil.expireCheck((metaColumns = checkValueSplit[1].split("-"))[1], 60000L)) continue;
                            this.removeKeyPair(key, "0");
                            ++removeTagetData;
                        }
                        logger.info("RemoveInvalidData - Count [" + removeTagetData + "]");
                    }
                    logger.info("VacuumInvalidData - End - 1");
                    vacuumInvalidDataCount = 0;
                }
                ++vacuumInvalidDataCount;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("KeyMapManager - run - Error" + e);
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "KeyMapManager - run - Error [" + e.getMessage() + "]");
            }
        }
        logger.info("KeyMapManager - run - System Shutdown [1] Msg=[" + StatusUtil.getStatusMessage() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long truncateData(String uniqueKey) {
        long truncateTagetData = 0L;
        try {
            String tagUniqueKey = tagStartStr + uniqueKey;
            logger.info("truncateData - Start");
            Object object = this.poolKeyLock;
            synchronized (object) {
                Set entrySet = this.keyMapObj.entrySet();
                Iterator entryIte = entrySet.iterator();
                long counter = 0L;
                while (entryIte.hasNext()) {
                    Map.Entry obj;
                    if (++counter % 5000L == 0L) {
                        logger.info("TruncateData - Exec Count[" + counter + "]");
                    }
                    if ((obj = (Map.Entry)entryIte.next()) == null) continue;
                    String key = null;
                    key = (String)obj.getKey();
                    if (!uniqueKey.equals("#all") && key.indexOf(uniqueKey) != 0 && key.indexOf(tagUniqueKey) != 0) continue;
                    this.removeKeyPair(key, "0");
                    ++truncateTagetData;
                }
                logger.info("TruncateData - TotalTargetCount [" + counter + "]");
                logger.info("TruncateData - TotalRemoveCount [" + truncateTagetData + "]");
            }
            logger.info("truncateData - End");
        }
        catch (BatchException be) {
            logger.error("truncateData - InnerError", be);
            be.printStackTrace();
        }
        catch (Exception e) {
            logger.error("truncateData - Error" + e);
            e.printStackTrace();
        }
        return truncateTagetData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyPair(String key, String keyNode, String transactionCode) throws BatchException {
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(keyNode.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    Object object;
                    if (this.moveAdjustmentDataMap != null) {
                        Object object2 = this.moveAdjustmentSync;
                        synchronized (object2) {
                            if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(key)) {
                                this.moveAdjustmentDataMap.remove(key);
                            }
                        }
                    }
                    String data = null;
                    boolean containsKeyRet = this.containsKeyPair(key);
                    if (!containsKeyRet) {
                        String[] keyNoddes = keyNode.split("!");
                        data = keyNoddes.length > 1 ? keyNoddes[0] + "!" + keyNoddes[1] : keyNoddes[0] + "!" + "0";
                    } else if (containsKeyRet) {
                        String tmp = this.keyMapObjGet(key);
                        String[] keyNoddes = keyNode.split("!");
                        if (tmp != null) {
                            if (keyNoddes.length > 1) {
                                String[] tmps = tmp.split("!");
                                data = keyNoddes[1].equals("0") ? keyNoddes[0] + "!" + (Long.parseLong(tmps[1]) + 1L) : keyNode;
                            } else {
                                data = keyNoddes[0] + "!" + "0";
                            }
                        } else {
                            data = keyNode;
                        }
                    }
                    this.keyMapObjPut(key, data);
                    if (!this.workFileMemory) {
                        object = this.lockWorkFileSync;
                        synchronized (object) {
                            this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                            this.bw.flush();
                        }
                    }
                    if (this.diffDataPoolingFlg) {
                        object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("+" + workFileSeq + key + workFileSeq + data);
                            }
                        }
                    }
                }
                this.writeMapFileFlg = true;
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("setKeyPair - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "setKeyPair - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
    }

    public boolean setKeyPairOnlyOnce(String key, String keyNode, String transactionCode) throws BatchException {
        return this.setKeyPairOnlyOnce(key, keyNode, transactionCode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setKeyPairOnlyOnce(String key, String keyNode, String transactionCode, boolean moveData) throws BatchException {
        boolean ret = false;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(key.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    Object object;
                    if (this.containsKeyPair(key)) {
                        return ret;
                    }
                    if (this.moveAdjustmentDataMap != null) {
                        Object object2 = this.moveAdjustmentSync;
                        synchronized (object2) {
                            if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(key) && !moveData) {
                                this.moveAdjustmentDataMap.remove(key);
                            }
                        }
                    }
                    String data = null;
                    if (keyNode.indexOf("-1") == -1) {
                        data = keyNode;
                    } else {
                        String[] keyNoddes = keyNode.split("!");
                        data = keyNoddes[0] + "!" + "0";
                    }
                    this.keyMapObjPut(key, data);
                    ret = true;
                    if (!this.workFileMemory) {
                        object = this.lockWorkFileSync;
                        synchronized (object) {
                            this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                            this.bw.flush();
                        }
                    }
                    if (this.diffDataPoolingFlg) {
                        object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("+" + workFileSeq + key + workFileSeq + data);
                            }
                        }
                    }
                }
                this.writeMapFileFlg = true;
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("setKeyPairOnlyOnce - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "setKeyPairOnlyOnce - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setKeyPairVersionCheck(String key, String keyNode, String transactionCode, String updateVersionNo, boolean execCheck) throws BatchException {
        boolean ret = false;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(key.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    Object object;
                    Object checkValue;
                    if (execCheck && this.containsKeyPair(key) && !((String)(checkValue = this.getKeyPair(key))).split("!")[1].equals(updateVersionNo)) {
                        return ret;
                    }
                    if (this.moveAdjustmentDataMap != null) {
                        checkValue = this.moveAdjustmentSync;
                        synchronized (checkValue) {
                            if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(key)) {
                                this.moveAdjustmentDataMap.remove(key);
                            }
                        }
                    }
                    String data = null;
                    String[] keyNoddes = keyNode.split("!");
                    data = keyNoddes[0] + "!" + (new Long(updateVersionNo) + 1L);
                    this.keyMapObjPut(key, data);
                    ret = true;
                    if (!this.workFileMemory) {
                        object = this.lockWorkFileSync;
                        synchronized (object) {
                            this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                            this.bw.flush();
                        }
                    }
                    if (this.diffDataPoolingFlg) {
                        object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("+" + workFileSeq + key + workFileSeq + data);
                            }
                        }
                    }
                }
                this.writeMapFileFlg = true;
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("setKeyPairVersionCheck - Error", e);
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "setKeyPairVersionCheck - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    public String getKeyPair(String key) {
        String ret = null;
        if (!this.blocking) {
            try {
                ret = this.keyMapObjGet(key);
            }
            catch (BatchException be) {
                ret = null;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeKeyPair(String key, String transactionCode) throws BatchException {
        String ret = null;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(key.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    Object object;
                    ret = this.keyMapObjGet(key);
                    if (this.moveAdjustmentDataMap != null) {
                        object = this.moveAdjustmentSync;
                        synchronized (object) {
                            if (this.moveAdjustmentDataMap != null) {
                                this.moveAdjustmentDataMap.put(key, "");
                            }
                        }
                    }
                    if (ret == null) {
                        return null;
                    }
                    this.keyMapObjRemove(key);
                    if (!this.workFileMemory) {
                        object = this.lockWorkFileSync;
                        synchronized (object) {
                            this.bw.write(new StringBuilder(160).append("-").append(workFileSeq).append(key).append(workFileSeq).append(" ").append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                            this.bw.flush();
                        }
                    }
                    if (this.diffDataPoolingFlg) {
                        object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("-" + workFileSeq + key);
                            }
                        }
                    }
                }
                this.writeMapFileFlg = true;
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                logger.error("removeKeyPair - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "removeKeyPair - Error[" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTagPair(String tag, String key, String transactionCode) throws BatchException {
        if (!this.blocking) {
            try {
                String keyStrs = null;
                int counter = 0;
                boolean appendFlg = true;
                String tagCnv = null;
                Object lastTagCnv = null;
                int dataPutCounter = 0;
                boolean firsrtRegist = true;
                dataPutCounter = counter = (key.hashCode() << 1 >>> 1) % 10 * 5000000;
                Integer n = this.tagSetParallelSyncObjs[(tag.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    while (true) {
                        if (this.containsKeyPair(tagCnv = tagStartStr + tag + "_" + new Integer(counter).toString() + tagEndStr)) {
                            firsrtRegist = false;
                            keyStrs = this.getKeyPair(tagCnv);
                            String[] workStrs = keyStrs.split("!");
                            if ((keyStrs = workStrs[0]).indexOf(key.split("!")[0]) != -1) {
                                appendFlg = false;
                                break;
                            }
                        } else {
                            if (counter > (key.hashCode() << 1 >>> 1) % 10 * 5000000) {
                                dataPutCounter = counter - 1;
                                break;
                            }
                            dataPutCounter = counter;
                            break;
                        }
                        ++counter;
                    }
                    if (appendFlg) {
                        if (firsrtRegist) {
                            this.setKeyPair(tagCnv, key, transactionCode);
                        } else if (keyStrs.getBytes().length + tagKeySep.getBytes().length + key.getBytes().length + 16 >= ImdstDefine.dataFileWriteMaxSize) {
                            ++counter;
                            tagCnv = tagStartStr + tag + "_" + (dataPutCounter + 1) + tagEndStr;
                            this.setKeyPair(tagCnv, key, transactionCode);
                        } else {
                            tagCnv = tagStartStr + tag + "_" + dataPutCounter + tagEndStr;
                            keyStrs = keyStrs + tagKeySep + key;
                            this.setKeyPair(tagCnv, keyStrs, transactionCode);
                        }
                    }
                }
            }
            catch (BatchException be) {
                logger.error("setTagPair - InnerError", be);
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("setTagPair - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "setTagPair - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getTagPair(String tag) {
        String keyStrs = "";
        String[] setTimeSplitWork = null;
        boolean isMatch = false;
        StringBuilder tmpBuf = new StringBuilder(2048);
        String tmpStr = null;
        String tmpSep = "";
        String lastSetTime = "";
        String counterSep = "";
        StringBuilder ret = new StringBuilder();
        if (!this.blocking) {
            int counter = 0;
            for (int idx = 0; idx < 45000001; idx += 5000000) {
                block6: {
                    String tagCnv;
                    keyStrs = "";
                    setTimeSplitWork = null;
                    isMatch = false;
                    tmpBuf = new StringBuilder(2048);
                    tmpStr = null;
                    tmpSep = "";
                    counter = idx;
                    while (this.containsKeyPair(tagCnv = tagStartStr + tag + "_" + counter + tagEndStr)) {
                        tmpStr = this.getKeyPair(tagCnv);
                        if (tmpStr != null) {
                            isMatch = true;
                            tmpBuf.append(tmpSep);
                            setTimeSplitWork = tmpStr.split("!");
                            if (setTimeSplitWork.length > 1) {
                                lastSetTime = setTimeSplitWork[1];
                            }
                            tmpBuf.append(setTimeSplitWork[0]);
                            tmpSep = tagKeySep;
                            ++counter;
                            continue;
                        }
                        keyStrs = !isMatch ? null : tmpBuf.toString();
                        break block6;
                    }
                    keyStrs = !isMatch ? null : tmpBuf.toString();
                }
                if (keyStrs == null) continue;
                ret.append(counterSep);
                ret.append(keyStrs);
                counterSep = tagKeySep;
            }
        }
        if (ret.toString().equals("")) {
            return null;
        }
        ret.append("!").append(lastSetTime);
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String calcValue(String key, int calcVal, String transactionCode) throws BatchException {
        String ret = null;
        String data = null;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(key.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    boolean containsKeyRet = this.containsKeyPair(key);
                    if (containsKeyRet) {
                        String tmp = this.keyMapObjGet(key);
                        String[] keyNoddes = tmp.split("!");
                        String setDataStr = null;
                        if (tmp != null) {
                            String targetData = keyNoddes[0];
                            if (keyNoddes[0].indexOf(",") != -1) {
                                String[] workSplitData = keyNoddes[0].split(",");
                                targetData = workSplitData[0];
                            }
                            String nowData = new String(BASE64DecoderStream.decode((byte[])targetData.getBytes()));
                            int nowDataInt = 0;
                            try {
                                nowDataInt = Integer.parseInt(nowData);
                                if ((nowDataInt += calcVal) < 0) {
                                    nowDataInt = 0;
                                }
                                setDataStr = new Long(nowDataInt).toString();
                            }
                            catch (Exception e) {
                                setDataStr = calcVal > 0 ? new Long(calcVal).toString() : new Long(nowDataInt).toString();
                            }
                            data = keyNoddes.length > 1 ? new String(BASE64EncoderStream.encode((byte[])setDataStr.getBytes())) + "!" + (Long.parseLong(keyNoddes[1]) + 1L) : new String(BASE64EncoderStream.encode((byte[])setDataStr.getBytes())) + "!" + "0";
                        }
                    }
                    if (data != null) {
                        Object object;
                        this.keyMapObjPut(key, data);
                        if (!this.workFileMemory) {
                            object = this.lockWorkFileSync;
                            synchronized (object) {
                                this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                this.bw.flush();
                            }
                        }
                        if (this.diffDataPoolingFlg) {
                            object = this.diffSync;
                            synchronized (object) {
                                if (this.diffDataPoolingFlg) {
                                    this.diffDataPoolingListForFileBase.add("+" + workFileSeq + key + workFileSeq + data);
                                }
                            }
                        }
                        this.writeMapFileFlg = true;
                        ret = data.split("!")[0];
                    }
                }
            }
            catch (BatchException be) {
                logger.error("calcValue - InnerError", be);
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("setKeyPair - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "setKeyPair - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    public boolean containsKeyPair(String key) {
        boolean ret = false;
        if (!this.blocking && key != null && this.keyMapObj != null) {
            ret = this.keyMapObj.containsKey(key);
        }
        return ret;
    }

    public boolean containsTagPair(String tag) {
        boolean ret = false;
        if (!this.blocking) {
            String tagCnv;
            for (int idx = 0; idx < 45000001 && !(ret = this.containsKeyPair(tagCnv = tagStartStr + tag + "_" + idx + tagEndStr)); idx += 5000000) {
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String locking(String key, String transactionCode, int lockingTime) throws BatchException {
        block15: {
            if (!this.blocking) {
                try {
                    String saveTransactionStr = null;
                    Object object = this.lockKeyLock;
                    synchronized (object) {
                        if (this.containsKeyPair(key)) {
                            return null;
                        }
                        saveTransactionStr = lockingTime == 0 ? transactionCode + this.lockKeyTimeSep + new Long(Long.MAX_VALUE).toString() : transactionCode + this.lockKeyTimeSep + new Long(JavaSystemApi.currentTimeMillis + (long)(lockingTime * 1000)).toString();
                        this.keyMapObjPut(key, saveTransactionStr);
                    }
                    this.writeMapFileFlg = true;
                    if (!this.workFileMemory) {
                        object = this.lockWorkFileSync;
                        synchronized (object) {
                            this.bw.write("+" + workFileSeq + key + workFileSeq + saveTransactionStr + workFileSeq + JavaSystemApi.currentTimeMillis + workFileSeq + workFileEndPoint + "\n");
                            this.bw.flush();
                        }
                    }
                    if (!this.diffDataPoolingFlg) break block15;
                    object = this.diffSync;
                    synchronized (object) {
                        if (this.diffDataPoolingFlg) {
                            this.diffDataPoolingListForFileBase.add("+" + workFileSeq + key + workFileSeq + saveTransactionStr);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("locking - Error");
                    this.blocking = true;
                    StatusUtil.setStatusAndMessage(1, "locking - Error [" + e.getMessage() + "]");
                    throw new BatchException(e);
                }
            }
        }
        return transactionCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeLock(String key, String transactionCode) throws BatchException {
        String ret;
        block16: {
            ret = null;
            if (!this.blocking) {
                try {
                    Object object = this.lockKeyLock;
                    synchronized (object) {
                        if (!this.containsKeyPair(key)) {
                            return transactionCode;
                        }
                        if (!this.keyMapObjGet(key).split(this.lockKeyTimeSep)[0].equals(transactionCode)) {
                            return null;
                        }
                        ret = ((String)this.keyMapObj.remove(key)).split(this.lockKeyTimeSep)[0];
                        this.keyMapObj.setKLastDataChangeTime(JavaSystemApi.currentTimeMillis);
                        this.lastAccess = JavaSystemApi.currentTimeMillis;
                    }
                    this.writeMapFileFlg = true;
                    if (!this.workFileMemory) {
                        object = this.lockWorkFileSync;
                        synchronized (object) {
                            this.bw.write("-" + workFileSeq + key + workFileSeq + " " + workFileSeq + JavaSystemApi.currentTimeMillis + workFileSeq + workFileEndPoint + "\n");
                            this.bw.flush();
                        }
                    }
                    if (!this.diffDataPoolingFlg) break block16;
                    object = this.diffSync;
                    synchronized (object) {
                        if (this.diffDataPoolingFlg) {
                            this.diffDataPoolingListForFileBase.add("-" + workFileSeq + key);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("removeLock - Error");
                    this.blocking = true;
                    StatusUtil.setStatusAndMessage(1, "removeLock - Error[" + e.getMessage() + "]");
                    throw new BatchException(e);
                }
            }
        }
        return ret;
    }

    public boolean isLock(String key) {
        return this.containsKeyPair(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockedTransactionCode(String key) {
        Object object = this.lockKeyLock;
        synchronized (object) {
            try {
                if (!this.containsKeyPair(key)) {
                    return null;
                }
                return this.keyMapObjGet(key).split(this.lockKeyTimeSep)[0];
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoLockRelease(long time) throws BatchException {
        Object object = this.setKeyLock;
        synchronized (object) {
            Object object2 = this.lockKeyLock;
            synchronized (object2) {
                try {
                    int idx;
                    Object key = null;
                    Set set = this.keyMapObj.entrySet();
                    Iterator iterator = set.iterator();
                    String[] keyList = new String[this.keyMapObj.size()];
                    for (idx = 0; idx < keyList.length; ++idx) {
                        Map.Entry map = (Map.Entry)iterator.next();
                        keyList[idx] = (String)map.getKey();
                    }
                    for (idx = 0; idx < keyList.length; ++idx) {
                        Object object3;
                        String transactionLine = (String)this.keyMapObj.get(keyList[idx]);
                        String[] codeList = transactionLine.split(this.lockKeyTimeSep);
                        if (Long.parseLong(codeList[1]) >= time) continue;
                        this.keyMapObj.remove(keyList[idx]);
                        this.writeMapFileFlg = true;
                        if (!this.workFileMemory) {
                            object3 = this.lockWorkFileSync;
                            synchronized (object3) {
                                this.bw.write("-" + workFileSeq + keyList[idx] + workFileSeq + " " + workFileSeq + JavaSystemApi.currentTimeMillis + workFileSeq + workFileEndPoint + "\n");
                                this.bw.flush();
                            }
                        }
                        if (!this.diffDataPoolingFlg) continue;
                        object3 = this.diffSync;
                        synchronized (object3) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("-" + workFileSeq + keyList[idx]);
                            }
                            continue;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("autoLockRelease - Error");
                    this.blocking = true;
                    StatusUtil.setStatusAndMessage(1, "autoLockRelease - Error[" + e.getMessage() + "]");
                    throw new BatchException(e);
                }
            }
        }
    }

    private void keyMapObjPut(String key, String val) throws BatchException {
        try {
            if (val.length() < this.putValueMaxSize && key != null && val != null) {
                this.keyMapObj.put(key, val);
                this.keyMapObj.setKLastDataChangeTime(JavaSystemApi.currentTimeMillis);
            }
            this.lastAccess = JavaSystemApi.currentTimeMillis;
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
    }

    private void setLastDataChangeTime() {
        this.keyMapObj.setKLastDataChangeTime(JavaSystemApi.currentTimeMillis);
    }

    private void keyMapObjPutNoChange(String key, String val) {
        if (val.length() < this.putValueMaxSize && key != null && val != null) {
            this.keyMapObj.put(key, val);
        }
        this.lastAccess = JavaSystemApi.currentTimeMillis;
    }

    private void keyMapObjPutSetTime(String key, String val, long execTime) {
        if (val.length() < this.putValueMaxSize && key != null && val != null) {
            this.keyMapObj.put(key, val);
            this.keyMapObj.setKLastDataChangeTime(execTime);
        }
        this.lastAccess = JavaSystemApi.currentTimeMillis;
    }

    private String keyMapObjGet(String key) throws BatchException {
        try {
            this.lastAccess = JavaSystemApi.currentTimeMillis;
            if (key != null) {
                return (String)this.keyMapObj.get(key);
            }
            return null;
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
    }

    private void keyMapObjRemove(String key) throws BatchException {
        try {
            if (key != null) {
                this.keyMapObj.remove(key);
                this.keyMapObj.setKLastDataChangeTime(JavaSystemApi.currentTimeMillis);
                this.lastAccess = JavaSystemApi.currentTimeMillis;
            }
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
    }

    private void keyMapObjRemoveNoChange(String key) {
        if (key != null) {
            this.keyMapObj.remove(key);
            this.lastAccess = JavaSystemApi.currentTimeMillis;
        }
    }

    private void keyMapObjRemoveSetTime(String key, long execTime) {
        if (key != null) {
            this.keyMapObj.remove(key);
            this.keyMapObj.setKLastDataChangeTime(execTime);
            this.lastAccess = JavaSystemApi.currentTimeMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diffDataMode(boolean flg, PrintWriter pw) {
        Object object = this.diffSync;
        synchronized (object) {
            if (flg) {
                this.diffDataPoolingListForFileBase = new FileBaseDataList(this.nodeKeyMapFilePath + ".difftmplist");
            } else if (this.diffDataPoolingListForFileBase != null) {
                this.diffDataPoolingListForFileBase.clear();
                this.diffDataPoolingListForFileBase = null;
            }
            this.diffDataPoolingFlg = flg;
            try {
                pw.println("1");
                pw.flush();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diffDataMode(boolean flg) {
        Object object = this.diffSync;
        synchronized (object) {
            if (flg) {
                this.diffDataPoolingListForFileBase = new FileBaseDataList(this.nodeKeyMapFilePath + ".difftmplist");
            } else if (this.diffDataPoolingListForFileBase != null) {
                this.diffDataPoolingListForFileBase.clear();
                this.diffDataPoolingListForFileBase = null;
            }
            this.diffDataPoolingFlg = flg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diffDataModeOff() {
        Object object = this.diffSync;
        synchronized (object) {
            if (this.diffDataPoolingListForFileBase != null) {
                this.diffDataPoolingListForFileBase.clear();
                this.diffDataPoolingListForFileBase = null;
            }
            this.diffDataPoolingFlg = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputKeyMapObj2Stream(PrintWriter pw) throws BatchException {
        if (!this.blocking) {
            try {
                Object object = this.poolKeyLock;
                synchronized (object) {
                    logger.info("outputKeyMapObj2Stream - synchronized - start");
                    String allDataSep = "";
                    StringBuilder allDataBuf = new StringBuilder(8192);
                    Set entrySet = this.keyMapObj.entrySet();
                    int printLineCount = 0;
                    int maxLineCount = new Double((double)JavaSystemApi.getRuntimeFreeMem("") * 0.5 / (double)(ImdstDefine.saveDataMaxSize / 100)).intValue();
                    if (entrySet.size() > 0) {
                        if (maxLineCount == 0) {
                            maxLineCount = 1;
                        }
                        printLineCount = new Double(entrySet.size() / maxLineCount).intValue();
                        if (entrySet.size() % maxLineCount > 0) {
                            ++printLineCount;
                        }
                    }
                    pw.println(printLineCount);
                    pw.flush();
                    Iterator entryIte = entrySet.iterator();
                    long counter = 0L;
                    while (entryIte.hasNext()) {
                        Map.Entry obj;
                        if (counter % 1000L == 0L) {
                            logger.info("outputKeyMapObj2Stream - output count[" + counter + "]");
                        }
                        if ((obj = (Map.Entry)entryIte.next()) == null) continue;
                        String key = null;
                        key = (String)obj.getKey();
                        allDataBuf.append(allDataSep);
                        allDataBuf.append(key);
                        allDataBuf.append(workFileSeq);
                        allDataBuf.append(this.keyMapObjGet(key));
                        allDataSep = ";";
                        if (++counter <= (long)(maxLineCount - 1)) continue;
                        pw.println(allDataBuf.toString());
                        allDataBuf = new StringBuilder(8192);
                        counter = 0L;
                    }
                    String lastSendStr = allDataBuf.toString();
                    if (!lastSendStr.equals("")) {
                        pw.println(lastSendStr);
                        pw.flush();
                    }
                    allDataBuf = null;
                    pw.println("-1");
                    pw.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("outputKeyMapObj2Stream - Error =[" + e.getMessage() + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputDiffKeyMapObj2Stream(PrintWriter pw, BufferedReader br) throws BatchException {
        if (!this.blocking) {
            try {
                Object object = this.poolKeyLock;
                synchronized (object) {
                    int i;
                    String nextWrite = null;
                    logger.info("outputDiffKeyMapObj2Stream - synchronized - start");
                    String allDataSep = "";
                    StringBuilder allDataBuf = new StringBuilder(8192);
                    for (i = 0; i < this.diffDataPoolingListForFileBase.size() - 10; ++i) {
                        allDataBuf.append(allDataSep);
                        allDataBuf.append(this.diffDataPoolingListForFileBase.get(i));
                        allDataSep = ";";
                        if (i <= 0 || i % 30 != 0) continue;
                        logger.info("outputDiffKeyMapObj2Stream - Diff Data Normal Send Count[" + i + "]");
                        pw.println(allDataBuf.toString());
                        pw.flush();
                        allDataBuf = null;
                        allDataBuf = new StringBuilder(8192);
                        allDataSep = "";
                        nextWrite = br.readLine();
                        if (nextWrite == null || !nextWrite.equals("-1") && !nextWrite.equals("2")) {
                            throw new Exception("NextWriteMessage= [" + nextWrite + "]");
                        }
                        nextWrite = null;
                    }
                    String lastSendData = allDataBuf.toString();
                    if (!lastSendData.equals("")) {
                        logger.info("outputDiffKeyMapObj2Stream - Diff Data Normal Send2 Count[" + i + "]");
                        pw.println(lastSendData);
                        pw.flush();
                        nextWrite = br.readLine();
                        if (nextWrite == null || !nextWrite.equals("-1") && !nextWrite.equals("2")) {
                            throw new Exception("NextWriteMessage= [" + nextWrite + "]");
                        }
                        nextWrite = null;
                    }
                    Object object2 = this.diffSync;
                    synchronized (object2) {
                        allDataBuf = null;
                        allDataBuf = new StringBuilder(8192);
                        allDataSep = "";
                        while (i < this.diffDataPoolingListForFileBase.size()) {
                            allDataBuf.append(allDataSep);
                            allDataBuf.append(this.diffDataPoolingListForFileBase.get(i));
                            allDataSep = ";";
                            if (i > 0 && i % 20 == 0) {
                                logger.info("outputDiffKeyMapObj2Stream - Diff Data Last Send Count[" + i + "]");
                                pw.println(allDataBuf.toString());
                                pw.flush();
                                allDataBuf = null;
                                allDataBuf = new StringBuilder(8192);
                                allDataSep = "";
                                nextWrite = br.readLine();
                                if (nextWrite == null || !nextWrite.equals("-1") && !nextWrite.equals("2")) {
                                    throw new Exception("Erro Target Read End Message= [" + nextWrite + "]");
                                }
                                nextWrite = null;
                            }
                            ++i;
                        }
                        lastSendData = allDataBuf.toString();
                        if (!lastSendData.equals("")) {
                            pw.println(lastSendData);
                            pw.flush();
                            nextWrite = br.readLine();
                            if (nextWrite == null || !nextWrite.equals("-1") && !nextWrite.equals("2")) {
                                throw new Exception("Erro Target Read End Message= [" + nextWrite + "]");
                            }
                            nextWrite = null;
                        }
                        pw.println("-1");
                        pw.flush();
                        allDataBuf = null;
                        String outputRet = br.readLine();
                        if (outputRet == null || !outputRet.equals("1")) {
                            throw new Exception("outputDiffKeyMapObj2Stream - Error Ret=[" + outputRet + "]");
                        }
                        pw.println("1");
                        pw.flush();
                        this.diffDataMode(false);
                    }
                }
                logger.info("outputDiffKeyMapObj2Stream - synchronized - end");
            }
            catch (Exception e) {
                logger.error("outputDiffKeyMapObj2Stream - Error [" + e.getMessage() + "]", e);
                this.diffDataMode(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputKeyMapObj2Stream(BufferedReader br, PrintWriter pw, int dataLineCount) throws BatchException {
        if (!this.blocking) {
            try {
                int i = 0;
                String[] oneDatas = null;
                boolean setDataExec = false;
                logger.info("inputKeyMapObj2Stream - synchronized - start");
                Object object = this.poolKeyLock;
                synchronized (object) {
                    Object object2 = this.lockWorkFileSync;
                    synchronized (object2) {
                        File workKeyMapObjFile = new File(this.workKeyFilePath);
                        if (workKeyMapObjFile.exists()) {
                            if (this.bw != null) {
                                this.bw.close();
                            }
                            if (this.osw != null) {
                                this.osw.close();
                            }
                            if (this.fos != null) {
                                this.fos.close();
                            }
                            workKeyMapObjFile.delete();
                        }
                        this.keyMapObj.clear();
                        if (this.dataMemory) {
                            if (this.keyMapObj != null) {
                                this.keyMapObj.close();
                            }
                        } else {
                            this.keyMapObj.deleteMapDataFile();
                        }
                        this.keyMapObj = null;
                        JavaSystemApi.manualGc();
                        Thread.sleep(1000L);
                        this.keyMapObj = !this.allDataForFile ? new KeyManagerValueMap(this.mapSize, this.dataMemory, this.virtualStorageDirs) : new KeyManagerValueMap(this.keyFileDirs, this.mapSize);
                        if (!this.dataMemory) {
                            this.keyMapObj.initNoMemoryModeSetting(this.diskModeRestoreFile);
                        }
                        this.fos = new FileOutputStream(new File(this.workKeyFilePath));
                        this.osw = new OutputStreamWriter((OutputStream)this.fos, workMapFileEnc);
                        this.bw = new BufferedWriter(this.osw);
                        long inputStartTime = JavaSystemApi.currentTimeMillis;
                        long counter = 0L;
                        for (int idx = 0; idx < Integer.MAX_VALUE; ++idx) {
                            String allDataStr = br.readLine();
                            if (allDataStr == null || allDataStr.trim().equals("-1")) {
                                logger.info("inputKeyMapObj2Stream ReadLine End");
                                break;
                            }
                            String[] allDataLines = allDataStr.split(";");
                            allDataStr = null;
                            for (i = 0; i < allDataLines.length; ++i) {
                                if (++counter % 500L == 0L) {
                                    logger.info("inputKeyMapObj2Stream Input Count[" + counter + "]");
                                }
                                if (allDataLines[i].trim().equals("")) continue;
                                oneDatas = allDataLines[i].split(workFileSeq);
                                if (oneDatas.length == 2) {
                                    setDataExec = true;
                                    this.keyMapObjPutNoChange(oneDatas[0], oneDatas[1]);
                                    if (this.workFileMemory) continue;
                                    this.bw.write("+" + workFileSeq + oneDatas[0] + workFileSeq + oneDatas[1] + workFileSeq + inputStartTime + workFileSeq + workFileEndPoint + "\n");
                                    continue;
                                }
                                if (oneDatas.length != 3) continue;
                                setDataExec = true;
                                this.keyMapObjPutNoChange(oneDatas[0], oneDatas[1] + workFileSeq + oneDatas[2]);
                                if (this.workFileMemory) continue;
                                this.bw.write("+" + workFileSeq + oneDatas[0] + workFileSeq + oneDatas[1] + workFileSeq + oneDatas[2] + workFileSeq + inputStartTime + workFileSeq + workFileEndPoint + "\n");
                            }
                            allDataLines = null;
                        }
                        if (setDataExec) {
                            this.setLastDataChangeTime();
                        }
                        pw.println("1");
                        pw.flush();
                    }
                }
                logger.info("inputKeyMapObj2Stream - synchronized - end");
            }
            catch (Exception e) {
                try {
                    pw.println("-1");
                    pw.flush();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                logger.error("inputKeyMapObj2Stream - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "inputKeyMapObj2Stream - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputDiffKeyMapObj2Stream(BufferedReader br, PrintWriter pw) throws BatchException {
        if (!this.blocking) {
            try {
                int i = 0;
                String[] oneDatas = null;
                logger.info("inputDiffKeyMapObj2Stream - synchronized - start");
                Object object = this.poolKeyLock;
                synchronized (object) {
                    Object object2 = this.lockWorkFileSync;
                    synchronized (object2) {
                        long writeCurrentTime = this.lastAccess;
                        int counter = 0;
                        String allDataStr = null;
                        while ((allDataStr = br.readLine()) != null && !allDataStr.trim().equals("-1")) {
                            if (allDataStr != null && !allDataStr.trim().equals("")) {
                                String[] allDataLines = allDataStr.split(";");
                                allDataStr = null;
                                for (i = 0; i < allDataLines.length; ++i) {
                                    if (allDataLines[i].trim().equals("")) continue;
                                    oneDatas = allDataLines[i].split(workFileSeq);
                                    if (allDataLines.length == i + 1) {
                                        if (oneDatas[0].equals("+")) {
                                            if (oneDatas.length == 3) {
                                                this.keyMapObjPut(oneDatas[1], oneDatas[2]);
                                            } else if (oneDatas.length == 4) {
                                                this.keyMapObjPut(oneDatas[1], oneDatas[2] + workFileSeq + oneDatas[3]);
                                            }
                                        } else if (oneDatas[0].equals("-")) {
                                            this.keyMapObjRemove(oneDatas[1]);
                                        }
                                    } else if (oneDatas[0].equals("+")) {
                                        if (oneDatas.length == 3) {
                                            this.keyMapObjPutNoChange(oneDatas[1], oneDatas[2]);
                                        } else if (oneDatas.length == 4) {
                                            this.keyMapObjPutNoChange(oneDatas[1], oneDatas[2] + workFileSeq + oneDatas[3]);
                                        }
                                    } else if (oneDatas[0].equals("-")) {
                                        this.keyMapObjRemoveNoChange(oneDatas[1]);
                                    }
                                    if (this.workFileMemory) continue;
                                    ++counter;
                                    String writeValueStr = " ";
                                    String dataType = "+";
                                    if (oneDatas[0].equals("-")) {
                                        dataType = "-";
                                    } else if (oneDatas.length == 3) {
                                        writeValueStr = oneDatas[2];
                                    } else if (oneDatas.length == 4) {
                                        writeValueStr = oneDatas[2] + workFileSeq + oneDatas[3];
                                    }
                                    this.bw.write(new StringBuilder(512).append(dataType).append(workFileSeq).append(oneDatas[1]).append(workFileSeq).append(writeValueStr).append(workFileSeq).append(writeCurrentTime).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                    if (counter % 100 != 0) continue;
                                    this.bw.flush();
                                }
                                if (!this.workFileMemory) {
                                    this.bw.flush();
                                }
                                allDataLines = null;
                            }
                            pw.println("2");
                            pw.flush();
                        }
                        if (!this.workFileMemory) {
                            this.bw.flush();
                        }
                        pw.println("1");
                        pw.flush();
                    }
                }
                logger.info("inputDiffKeyMapObj2Stream - synchronized - end");
            }
            catch (Exception e) {
                logger.error("inputDiffKeyMapObj2Stream - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "inputDiffKeyMapObj2Stream - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
    }

    public void outputNoMatchKeyMapKey2Stream(PrintWriter pw, int matchNo, String rulesStr) throws BatchException {
        if (!this.blocking) {
            try {
                String[] rules = null;
                int[] rulesInt = null;
                rules = rulesStr.split(",");
                rulesInt = new int[rules.length];
                for (int i = 0; i < rules.length; ++i) {
                    rulesInt[i] = Integer.parseInt(rules[i]);
                }
                String allDataSep = "";
                StringBuilder allDataBuf = new StringBuilder(8192);
                Set entrySet = this.keyMapObj.entrySet();
                int printLineCount = 0;
                int maxLineCount = new Double((double)JavaSystemApi.getRuntimeFreeMem("") * 0.1 / ((670.68 + (double)ImdstDefine.saveDataMaxSize * 1.38) / 50.0)).intValue();
                if (entrySet.size() > 0) {
                    if (maxLineCount == 0) {
                        maxLineCount = 1;
                    }
                    printLineCount = new Double(entrySet.size() / maxLineCount).intValue();
                    if (entrySet.size() % maxLineCount > 0) {
                        ++printLineCount;
                    }
                }
                Iterator entryIte = entrySet.iterator();
                int counter = 0;
                while (entryIte.hasNext()) {
                    Map.Entry obj = (Map.Entry)entryIte.next();
                    if (obj == null) continue;
                    String key = null;
                    String sendTagKey = null;
                    boolean sendFlg = true;
                    boolean tagFlg = false;
                    key = (String)obj.getKey();
                    if (key.indexOf(tagStartStr) == 0) {
                        tagFlg = true;
                        int startIdx = 15;
                        int endIdx = key.lastIndexOf(tagEndStr);
                        String checkKey = key.substring(startIdx, endIdx);
                        sendTagKey = key.substring(startIdx, endIdx);
                        int lastIdx = checkKey.lastIndexOf("_");
                        for (int idx = 0; idx < rulesInt.length; ++idx) {
                            if (!DataDispatcher.isRuleMatchKey(checkKey.substring(0, lastIdx), rulesInt[idx], matchNo)) continue;
                            sendFlg = false;
                            break;
                        }
                    } else {
                        for (int idx = 0; idx < rulesInt.length; ++idx) {
                            if (!DataDispatcher.isRuleMatchKey(key, rulesInt[idx], matchNo)) continue;
                            sendFlg = false;
                            break;
                        }
                    }
                    if (sendFlg) {
                        SystemUtil.debugLine("outputNoMatchKeyMapKey2Stream - MoveTargetKey[" + key + "]");
                        String data = this.keyMapObjGet(key);
                        if (data != null) {
                            if (tagFlg) {
                                String[] tagDatas = data.split(tagKeySep);
                                for (int idx = 0; idx < tagDatas.length; ++idx) {
                                    allDataBuf.append(allDataSep);
                                    allDataBuf.append("2");
                                    allDataBuf.append(workFileSeq);
                                    allDataBuf.append(sendTagKey);
                                    allDataBuf.append(workFileSeq);
                                    allDataBuf.append(tagDatas[idx]);
                                    allDataBuf.append("!");
                                    allDataBuf.append("0");
                                    allDataSep = ";";
                                    ++counter;
                                }
                            } else {
                                allDataBuf.append(allDataSep);
                                allDataBuf.append("1");
                                allDataBuf.append(workFileSeq);
                                allDataBuf.append(key);
                                allDataBuf.append(workFileSeq);
                                allDataBuf.append(data);
                                allDataSep = ";";
                            }
                        }
                    }
                    if (++counter <= maxLineCount - 1) continue;
                    pw.println(allDataBuf.toString());
                    allDataBuf = new StringBuilder(8192);
                    counter = 0;
                    allDataSep = "";
                }
                pw.println(allDataBuf.toString());
                pw.println("-1");
                pw.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("outputNoMatchKeyMapKey2Stream - Error =[" + e.getMessage() + "]");
            }
        }
    }

    public void outputConsistentHashMoveData2Stream(PrintWriter pw, String targetRangStr) throws BatchException {
        if (!this.blocking) {
            try {
                String allDataSep = "";
                StringBuilder allDataBuf = new StringBuilder(8192);
                int counter = 0;
                int[][] rangs = this.convertRangeData(targetRangStr);
                Set entrySet = this.keyMapObj.entrySet();
                int printLineCount = 0;
                int maxLineCount = new Double((double)JavaSystemApi.getRuntimeFreeMem("") * 0.1 / ((670.68 + (double)ImdstDefine.saveDataMaxSize * 1.38) / 50.0)).intValue();
                if (entrySet.size() > 0) {
                    if (maxLineCount == 0) {
                        maxLineCount = 1;
                    }
                    printLineCount = new Double(entrySet.size() / maxLineCount).intValue();
                    if (entrySet.size() % maxLineCount > 0) {
                        ++printLineCount;
                    }
                }
                for (Map.Entry obj : entrySet) {
                    if (obj == null) continue;
                    String key = null;
                    String sendTagKey = null;
                    boolean sendFlg = false;
                    boolean tagFlg = false;
                    key = (String)obj.getKey();
                    if (key.indexOf(tagStartStr) == 0) {
                        tagFlg = true;
                        int startIdx = 15;
                        int endIdx = key.lastIndexOf(tagEndStr);
                        String checkKey = key.substring(startIdx, endIdx);
                        sendTagKey = key.substring(startIdx, endIdx);
                        int lastIdx = checkKey.lastIndexOf("_");
                        sendFlg = DataDispatcher.isRangeData(checkKey.substring(0, lastIdx), rangs);
                    } else {
                        sendFlg = DataDispatcher.isRangeData(key, rangs);
                    }
                    if (sendFlg) {
                        SystemUtil.debugLine("outputConsistentHashMoveData2Stream - MoveTargetKey[" + key + "]");
                        String data = this.keyMapObjGet(key);
                        if (data != null) {
                            if (tagFlg) {
                                String[] tagDatas = data.split(tagKeySep);
                                for (int idx = 0; idx < tagDatas.length; ++idx) {
                                    if (tagDatas[idx].indexOf("!") == -1) {
                                        tagDatas[idx] = tagDatas[idx] + "!0";
                                    }
                                    allDataBuf.append(allDataSep);
                                    allDataBuf.append("2");
                                    allDataBuf.append(workFileSeq);
                                    allDataBuf.append(sendTagKey);
                                    allDataBuf.append(workFileSeq);
                                    allDataBuf.append(tagDatas[idx]);
                                    allDataSep = ";";
                                    ++counter;
                                }
                            } else {
                                allDataBuf.append(allDataSep);
                                allDataBuf.append("1");
                                allDataBuf.append(workFileSeq);
                                allDataBuf.append(key);
                                allDataBuf.append(workFileSeq);
                                allDataBuf.append(data);
                                allDataSep = ";";
                            }
                        }
                    }
                    if (++counter <= maxLineCount - 1) continue;
                    pw.println(allDataBuf.toString());
                    pw.flush();
                    allDataBuf = new StringBuilder(8192);
                    counter = 0;
                    allDataSep = "";
                }
                pw.println(allDataBuf.toString());
                pw.println("-1");
                pw.flush();
            }
            catch (Exception e) {
                logger.error("outputConsistentHashMoveData2Stream - Error =[" + e.getMessage() + "]");
            }
        }
    }

    public void inputNoMatchKeyMapKey2Stream(PrintWriter pw, BufferedReader br) throws BatchException {
        this.inputConsistentHashMoveData2Stream(pw, br);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputConsistentHashMoveData2Stream(PrintWriter pw, BufferedReader br) throws BatchException {
        if (!this.blocking) {
            try {
                this.moveAdjustmentDataMap = new ConcurrentHashMap(1024, 1000.0f, 512);
                int i = 0;
                String[] oneDatas = null;
                String dataStr = null;
                while (true) {
                    logger.info("inputConsistentHashMoveData2Stream - synchronized - start");
                    Object object = this.poolKeyLock;
                    synchronized (object) {
                        dataStr = br.readLine();
                        if (dataStr == null || dataStr.equals("-1")) {
                            break;
                        }
                        String[] dataLines = dataStr.split(";");
                        for (i = 0; i < dataLines.length; ++i) {
                            if (dataLines[i].trim().equals("")) continue;
                            oneDatas = dataLines[i].split(workFileSeq);
                            if (oneDatas[0].equals("1")) {
                                this.setKeyPairOnlyOnce(oneDatas[1], oneDatas[2], "0", true);
                                continue;
                            }
                            if (!oneDatas[0].equals("2")) continue;
                            int lastIdx = oneDatas[1].lastIndexOf("_");
                            oneDatas[1] = oneDatas[1].substring(0, lastIdx);
                            this.setTagPair(oneDatas[1], oneDatas[2], "0");
                        }
                        pw.println("next");
                        pw.flush();
                    }
                    logger.info("inputConsistentHashMoveData2Stream - synchronized - end");
                }
                pw.println("end");
                pw.flush();
            }
            catch (SocketException se) {
                logger.error("", se);
            }
            catch (Exception e) {
                if (pw != null) {
                    try {
                        pw.println("error");
                        pw.flush();
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                }
                logger.error("inputConsistentHashMoveData2Stream - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "inputConsistentHashMoveData2Stream - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
            finally {
                Object se = this.moveAdjustmentSync;
                synchronized (se) {
                    Set entrySet = this.moveAdjustmentDataMap.entrySet();
                    for (Map.Entry obj : entrySet) {
                        if (obj == null) continue;
                        String key = null;
                        key = (String)obj.getKey();
                        this.keyMapObjRemove(key);
                    }
                    this.moveAdjustmentDataMap = null;
                }
            }
        }
    }

    public void removeConsistentHashMoveData2Stream(PrintWriter pw, String targetRangStr) throws BatchException {
        if (!this.blocking) {
            try {
                int[][] rangs = this.convertRangeData(targetRangStr);
                Set entrySet = this.keyMapObj.entrySet();
                for (Map.Entry obj : entrySet) {
                    if (obj == null) continue;
                    String key = null;
                    key = (String)obj.getKey();
                    if (key.indexOf(tagStartStr) == 0) {
                        int lastIdx;
                        int startIdx = 15;
                        int endIdx = key.lastIndexOf(tagEndStr);
                        String checkKey = key.substring(startIdx, endIdx);
                        if (!DataDispatcher.isRangeData(checkKey.substring(0, lastIdx = checkKey.lastIndexOf("_")), rangs)) continue;
                        this.removeKeyPair(key, "0");
                        continue;
                    }
                    if (!DataDispatcher.isRangeData(key, rangs)) continue;
                    this.removeKeyPair(key, "0");
                }
                pw.println("-1");
                pw.flush();
            }
            catch (Exception e) {
                if (pw != null) {
                    try {
                        pw.println("error");
                        pw.flush();
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                }
                logger.error("removeConsistentHashMoveData2Stream - Error =[" + e.getMessage() + "]");
            }
        }
    }

    public void removeModMoveData2Stream(PrintWriter pw, BufferedReader br) throws BatchException {
        if (!this.blocking) {
            try {
                boolean i = false;
                String[] oneDatas = null;
                String dataStr = null;
                while (true) {
                    logger.info("removeModMoveData2Stream - synchronized - start");
                    dataStr = br.readLine();
                    if (dataStr != null && !dataStr.equals("-1")) {
                        oneDatas = dataStr.split(workFileSeq);
                        if (oneDatas[0].equals("1")) {
                            this.removeKeyPair(oneDatas[1], "0");
                        } else if (oneDatas[0].equals("2")) {
                            this.removeKeyPair(tagStartStr + oneDatas[1] + tagEndStr, "0");
                        }
                        pw.println("next");
                        pw.flush();
                        logger.info("inputConsistentHashMoveData2Stream - synchronized - end");
                        continue;
                    }
                    break;
                }
            }
            catch (SocketException se) {
                logger.error("", se);
            }
            catch (Exception e) {
                if (pw != null) {
                    try {
                        pw.println("error");
                        pw.flush();
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                }
                logger.error("inputConsistentHashMoveData2Stream - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "inputConsistentHashMoveData2Stream - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
    }

    private int[][] convertRangeData(String rangsStr) {
        String[] targetRangs = rangsStr.split("_");
        int[][] rangs = new int[targetRangs.length][2];
        for (int ii = 0; ii < targetRangs.length; ++ii) {
            String[] workRangs = targetRangs[ii].split("-");
            rangs[ii][0] = Integer.parseInt(workRangs[0]);
            rangs[ii][1] = Integer.parseInt(workRangs[1]);
        }
        return rangs;
    }

    public long getLastDataChangeTime() {
        return this.keyMapObj.getKLastDataChangeTime();
    }

    public int getSaveDataCount() {
        return this.keyMapObj.size();
    }

    public long getSaveDataSize(String uniqueKey) {
        return this.keyMapObj.getDataUseSize(uniqueKey);
    }

    public String[] getAllSaveDataSize() {
        return this.keyMapObj.getAllDataUseSize();
    }

    public boolean checkError() {
        return this.blocking;
    }

    public void dump() {
        try {
            System.out.println("-------------------------------------- Dump Start ------------------------------------");
            System.out.println("ALL Data Count = [" + this.getSaveDataCount() + "]");
            System.out.println("======================================================================================");
            Set entrySet = this.keyMapObj.entrySet();
            for (Map.Entry obj : entrySet) {
                if (obj == null) continue;
                String key = null;
                key = (String)obj.getKey();
                if (key.indexOf(tagStartStr) == 0) {
                    String tag = key;
                    int startIdx = 15;
                    int endIdx = key.lastIndexOf(tagEndStr);
                    key = key.substring(startIdx, endIdx);
                    int lastIdx = key.lastIndexOf("_");
                    key = key.substring(0, lastIdx);
                    System.out.println("Tag=[" + new String(BASE64DecoderStream.decode((byte[])key.getBytes())) + "], Value=[" + this.keyMapObjGet(tag) + "]");
                    continue;
                }
                System.out.println("Key=[" + new String(BASE64DecoderStream.decode((byte[])key.getBytes())) + "], Value=[" + this.keyMapObjGet(key) + "]");
            }
            System.out.println("-------------------------------------- Dump End --------------------------------------");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

