/*
 * Decompiled with CFR 0.152.
 */
package test.job;

import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import okuyama.base.job.AbstractJob;
import okuyama.base.job.IJob;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.client.OkuyamaClient;

public class MethodPatterTestJob
extends AbstractJob
implements IJob {
    private String masterNodeName = "127.0.0.1";
    private int masterNodePort = 8888;
    private int nowCount = 0;
    private ILogger logger = LoggerFactory.createLogger(MethodPatterTestJob.class);

    @Override
    public void initJob(String initValue) {
        if (initValue != null && !initValue.equals("")) {
            String[] master = initValue.split(":");
            this.masterNodeName = master[0];
            this.masterNodePort = Integer.parseInt(master[1]);
        }
    }

    @Override
    public String executeJob(String optionParam) throws BatchException {
        String ret = SUCCESS;
        String[] execMethods = null;
        int count = 5000;
        HashMap<String, Boolean> retMap = new HashMap<String, Boolean>();
        try {
            execMethods = optionParam.split(",");
            int port = this.masterNodePort;
            OkuyamaClient okuyamaClient = null;
            String startStr = super.getPropertiesValue(super.getJobName() + "start");
            int start = Integer.parseInt(startStr);
            count += start;
            for (int cy = 0; cy < 1; ++cy) {
                for (int t = 0; t < Integer.parseInt(execMethods[0]); ++t) {
                    this.nowCount = t;
                    System.out.println("Test Count =[" + t + "]");
                    for (int i = 1; i < execMethods.length; ++i) {
                        if (execMethods[i].equals("set")) {
                            retMap.put("set", this.execSet(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("get")) {
                            retMap.put("get", this.execGet(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("settag")) {
                            retMap.put("settag", this.execTagSet(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("gettag")) {
                            retMap.put("gettag", this.execTagGet(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("remove")) {
                            retMap.put("remove", this.execRemove(okuyamaClient, start, 500));
                        }
                        if (execMethods[i].equals("script")) {
                            retMap.put("script", this.execScript(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("add")) {
                            retMap.put("add", this.execAdd(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("gets-cas")) {
                            retMap.put("cas", this.execGetsCas(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("incr")) {
                            retMap.put("incr", this.execIncr(okuyamaClient, start, count));
                        }
                        if (!execMethods[i].equals("decr")) continue;
                        retMap.put("decr", this.execDecr(okuyamaClient, start, count));
                    }
                    System.out.println("ErrorMap=" + retMap.toString());
                    System.out.println("---------------------------------------------");
                    okuyamaClient = new OkuyamaClient();
                    okuyamaClient.connect(this.masterNodeName, port);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(new Date());
            System.out.println(retMap);
            throw new BatchException(e);
        }
        return ret;
    }

    private boolean execSet(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execSet - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        for (int i = start; i < count; ++i) {
            if (!okuyamaClient.setValue(this.nowCount + "datasavekey_" + new Integer(i).toString(), this.nowCount + "testdata1234567891011121314151617181920212223242526272829_savedatavaluestr_" + new Integer(i).toString())) {
                System.out.println("Set - Error=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + ", " + this.nowCount + "testdata1234567891011121314151617181920212223242526272829_savedatavaluestr_" + new Integer(i).toString());
                errorFlg = true;
            }
            if (i % 10000 != 0) continue;
            System.out.println(i);
        }
        long endTime = new Date().getTime();
        System.out.println("Set Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execSet - End");
        return errorFlg;
    }

    private boolean execGet(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execGet - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        String[] ret = null;
        long startTime = new Date().getTime();
        for (int i = start; i < count; ++i) {
            ret = okuyamaClient.getValue(this.nowCount + "datasavekey_" + new Integer(i).toString());
            if (ret[0].equals("true")) {
                if (ret[1].equals(this.nowCount + "testdata1234567891011121314151617181920212223242526272829_savedatavaluestr_" + new Integer(i).toString())) continue;
                System.out.println("\u30c7\u30fc\u30bf\u304c\u5408\u3063\u3066\u3044\u306a\u3044 key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]  value=[" + ret[1] + "]");
                errorFlg = true;
                continue;
            }
            if (ret[0].equals("false")) {
                System.out.println("\u30c7\u30fc\u30bf\u306a\u3057 key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]");
                this.logger.error("\u30c7\u30fc\u30bf\u306a\u3057 key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]");
                errorFlg = true;
                continue;
            }
            if (!ret[0].equals("error")) continue;
            System.out.println("Error key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]" + ret[1]);
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("Get Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execGet - End");
        return errorFlg;
    }

    private boolean execTagSet(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execTagSet - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        String[] tag1 = new String[]{start + "_" + this.nowCount + "_tag1"};
        String[] tag2 = new String[]{start + "_" + this.nowCount + "_tag1", start + "_" + this.nowCount + "_tag2"};
        String[] tag3 = new String[]{start + "_" + this.nowCount + "_tag1", start + "_" + this.nowCount + "_tag2", start + "_" + this.nowCount + "_tag3"};
        String[] tag4 = new String[]{start + "_" + this.nowCount + "_tag4"};
        String[] setTag = null;
        int counter = 0;
        long startTime = new Date().getTime();
        for (int i = start; i < count; ++i) {
            if (counter == 0) {
                setTag = tag1;
                ++counter;
            } else if (counter == 1) {
                setTag = tag2;
                ++counter;
            } else if (counter == 2) {
                setTag = tag3;
                ++counter;
            } else if (counter == 3) {
                setTag = tag4;
                counter = 0;
            }
            if (okuyamaClient.setValue(this.nowCount + "tagsampledatakey_" + new Integer(i).toString(), setTag, this.nowCount + "tagsamplesavedata_" + new Integer(i).toString())) continue;
            System.out.println("Tag Set - Error=[" + this.nowCount + "tagsampledatakey_" + new Integer(i).toString() + ", " + this.nowCount + "tagsamplesavedata_" + new Integer(i).toString());
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("Tag Set Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execTagSet - End");
        return errorFlg;
    }

    private boolean execTagGet(OkuyamaClient client, int start, int count) throws Exception {
        String[] getRet;
        int ii;
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execTagGet - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        String[] tag1 = new String[]{start + "_" + this.nowCount + "_tag1"};
        String[] tag2 = new String[]{start + "_" + this.nowCount + "_tag1", start + "_" + this.nowCount + "_tag2"};
        String[] tag3 = new String[]{start + "_" + this.nowCount + "_tag1", start + "_" + this.nowCount + "_tag2", start + "_" + this.nowCount + "_tag3"};
        String[] tag4 = new String[]{start + "_" + this.nowCount + "_tag4"};
        Object setTag = null;
        String[] keys = null;
        long startTime = new Date().getTime();
        Object[] ret = okuyamaClient.getTagKeys(start + "_" + this.nowCount + "_tag1");
        if (ret[0].equals("true")) {
            keys = (String[])ret[1];
            for (ii = start; ii < keys.length; ++ii) {
                getRet = okuyamaClient.getValue(keys[ii]);
                if (getRet[0].equals("true")) continue;
                if (getRet[0].equals("false")) {
                    System.out.println("\u30c7\u30fc\u30bf\u306a\u3057 key=[" + keys[ii] + "]");
                    this.logger.error("Tag Get \u30c7\u30fc\u30bf\u306a\u3057 key=[" + keys[ii] + "]");
                    errorFlg = true;
                    continue;
                }
                if (!getRet[0].equals("error")) continue;
                System.out.println("Error key=[" + keys[ii] + "]");
                errorFlg = true;
            }
        } else if (ret[0].equals("false")) {
            System.out.println(start + "tag1=\u30c7\u30fc\u30bf\u306a\u3057");
            errorFlg = true;
        } else if (ret[0].equals("error")) {
            System.out.println(start + "tag1=Error[" + ret[1] + "]");
            errorFlg = true;
        }
        ret = okuyamaClient.getTagKeys(start + "_" + this.nowCount + "_tag2");
        if (ret[0].equals("true")) {
            keys = (String[])ret[1];
            for (ii = start; ii < keys.length; ++ii) {
                getRet = okuyamaClient.getValue(keys[ii]);
                if (getRet[0].equals("true")) continue;
                if (getRet[0].equals("false")) {
                    System.out.println("\u30c7\u30fc\u30bf\u306a\u3057 key=[" + keys[ii] + "]");
                    errorFlg = true;
                    continue;
                }
                if (!getRet[0].equals("error")) continue;
                System.out.println("Error key=[" + keys[ii] + "]");
                errorFlg = true;
            }
        } else if (ret[0].equals("false")) {
            System.out.println(start + "_tag2=\u30c7\u30fc\u30bf\u306a\u3057");
            errorFlg = true;
        } else if (ret[0].equals("error")) {
            System.out.println(start + "tag2=Error[" + ret[1] + "]");
            errorFlg = true;
        }
        ret = okuyamaClient.getTagKeys(start + "_" + this.nowCount + "_tag3");
        if (ret[0].equals("true")) {
            keys = (String[])ret[1];
            for (ii = start; ii < keys.length; ++ii) {
                getRet = okuyamaClient.getValue(keys[ii]);
                if (getRet[0].equals("true")) continue;
                if (getRet[0].equals("false")) {
                    System.out.println("\u30c7\u30fc\u30bf\u306a\u3057 key=[" + keys[ii] + "]");
                    errorFlg = true;
                    continue;
                }
                if (!getRet[0].equals("error")) continue;
                System.out.println("Error key=[" + keys[ii] + "]");
                errorFlg = true;
            }
        } else if (ret[0].equals("false")) {
            System.out.println(start + "_tag3=\u30c7\u30fc\u30bf\u306a\u3057");
            errorFlg = true;
        } else if (ret[0].equals("error")) {
            System.out.println(start + "tag3=Error[" + ret[1] + "]");
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("Tag Get Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execTagGet - End");
        return errorFlg;
    }

    private boolean execRemove(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execRemove - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        String[] ret = null;
        long startTime = new Date().getTime();
        for (int i = start; i < count; ++i) {
            ret = okuyamaClient.removeValue(this.nowCount + "datasavekey_" + new Integer(i).toString());
            if (ret[0].equals("true")) {
                if (ret[1].equals(this.nowCount + "testdata1234567891011121314151617181920212223242526272829_savedatavaluestr_" + new Integer(i).toString())) continue;
                System.out.println("\u30c7\u30fc\u30bf\u304c\u5408\u3063\u3066\u3044\u306a\u3044 key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]  value=[" + ret[1] + "]");
                errorFlg = true;
                continue;
            }
            if (ret[0].equals("false")) {
                System.out.println("\u30c7\u30fc\u30bf\u306a\u3057 key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]");
                errorFlg = true;
                continue;
            }
            if (!ret[0].equals("error")) continue;
            System.out.println("Error key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]" + ret[1]);
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("Remove Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execRemove - End");
        return errorFlg;
    }

    private boolean execScript(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execScript - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        String[] ret = okuyamaClient.getValueScript(this.nowCount + "datasavekey_" + (start + 600), "var dataValue; var retValue = dataValue.replace('data', 'dummy'); var execRet = '1';");
        if (ret[0].equals("true")) {
            if (!ret[1].equals(this.nowCount + "savedummyvaluestr_" + (start + 600))) {
                System.out.println("\u30c7\u30fc\u30bf\u304c\u5408\u3063\u3066\u3044\u306a\u3044" + ret[1]);
                errorFlg = true;
            }
        } else if (ret[0].equals("false")) {
            System.out.println("\u30c7\u30fc\u30bf\u306a\u3057 key=[" + this.nowCount + "datasavekey_" + (start + 600));
            errorFlg = true;
        } else if (ret[0].equals("error")) {
            System.out.println("Error key=[" + this.nowCount + "datasavekey_" + (start + 600));
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("GetScript Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execScript - End");
        return errorFlg;
    }

    private boolean execAdd(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execAdd - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        String[] retParam = okuyamaClient.setNewValue(this.nowCount + "Key_ABCDE" + start, this.nowCount + "AAAAAAAAABBBBBBBBBBBBCCCCCCCCCC" + start);
        if (retParam[0].equals("false")) {
            System.out.println("Key=[" + this.nowCount + "Key_ABCDE] Error=[" + retParam[1] + "]");
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("New Value Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execAdd - End");
        return errorFlg;
    }

    private boolean execGetsCas(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execCas - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        int casCount = 0;
        for (int i = start; i < count; ++i) {
            if (!okuyamaClient.setValue(casCount + "_castest_datasavekey", "castest_testdata1234567891011121314151617181920212223242526272829_savedatavaluestr_" + casCount + "_" + new Integer(i).toString())) {
                System.out.println("Set - Error=[" + casCount + "_castest_datasavekey] Value[" + this.nowCount + "castest_testdata1234567891011121314151617181920212223242526272829_savedatavaluestr_" + casCount + "_" + new Integer(i).toString() + "]");
                errorFlg = true;
            }
            ++casCount;
        }
        Random rndIdx = new Random();
        int casSuccessCount = 0;
        int casErrorCount = 0;
        for (int casIdx = 0; casIdx < 6000; ++casIdx) {
            int rndSet = rndIdx.nextInt(casCount);
            String[] getsRet = okuyamaClient.getValueVersionCheck(rndSet + "_castest_datasavekey");
            String[] retParam = okuyamaClient.setValueVersionCheck(rndSet + "_castest_datasavekey", "updated-" + rndSet, getsRet[2]);
            if (retParam[0].equals("true")) {
                ++casSuccessCount;
                continue;
            }
            ++casErrorCount;
        }
        long endTime = new Date().getTime();
        System.out.println("Cas Method= " + (endTime - startTime) + " milli second Suucess=" + casSuccessCount + "  Error=" + casErrorCount);
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execCas - End");
        return errorFlg;
    }

    private boolean execIncr(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execIncr - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        String[] work = okuyamaClient.setNewValue("calcKeyIncr", "0");
        for (int i = start; i < count; ++i) {
            Object[] ret = okuyamaClient.incrValue("calcKeyIncr", 1L);
            if (!ret[0].equals("false")) continue;
            errorFlg = true;
            System.out.println(ret[0]);
            System.out.println(ret[1]);
        }
        long endTime = new Date().getTime();
        String[] nowVal = okuyamaClient.getValue("calcKeyIncr");
        System.out.println("IncrValue Method= " + (endTime - startTime) + " milli second Value=[" + nowVal[1] + "]");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execAdd - End");
        return errorFlg;
    }

    private boolean execDecr(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execDecr - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        String[] work = okuyamaClient.setNewValue("calcKeyDecr", "1000000");
        for (int i = start; i < count; ++i) {
            Object[] ret = okuyamaClient.decrValue("calcKeyDecr", 1L);
            if (!ret[0].equals("false")) continue;
            errorFlg = true;
            System.out.println(ret[0]);
            System.out.println(ret[1]);
        }
        long endTime = new Date().getTime();
        String[] nowVal = okuyamaClient.getValue("calcKeyDecr");
        System.out.println("DecrValue Method= " + (endTime - startTime) + " milli second Value=[" + nowVal[1] + "]");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execDecr - End");
        return errorFlg;
    }
}

