/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import okuyama.imdst.util.CoreValueMap;
import okuyama.imdst.util.FileBaseDataList;
import okuyama.imdst.util.FileBaseDataMap;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.JavaSystemApi;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.SystemUtil;
import okuyama.imdst.util.io.CustomRandomAccess;

public class KeyManagerValueMap
extends CoreValueMap
implements Cloneable,
Serializable {
    private boolean memoryMode = true;
    private transient BufferedWriter bw = null;
    private transient AtomicInteger dataFileBufferUseCount = null;
    private transient RandomAccessFile raf = null;
    private transient FileBaseDataMap overSizeDataStore = null;
    private transient Object sync = new Object();
    private transient boolean vacuumExecFlg = false;
    private transient List vacuumDiffDataList = null;
    private ConcurrentHashMap dataSizeMap = new ConcurrentHashMap(20, 16.0f, 16);
    private ArrayBlockingQueue deletedDataPointList = null;
    private String lineFile = null;
    private String tmpVacuumeLineFile = null;
    private String[] tmpVacuumeCopyMapDirs = null;
    private int lineCount = 0;
    private int oneDataLength = ImdstDefine.dataFileWriteMaxSize;
    private int seekOneDataLength = ImdstDefine.dataFileWriteMaxSize + 1;
    private long lastDataChangeTime = 0L;
    private int nowKeySize = 0;
    private transient boolean readObjectFlg = false;

    public KeyManagerValueMap(int size, boolean memoryMode, String[] virtualStoreDirs) {
        super(size, new Double((double)size * 0.9).intValue(), 512, memoryMode, virtualStoreDirs);
        this.memoryMode = memoryMode;
    }

    public KeyManagerValueMap(String[] dirs, int numberOfDataSize) {
        super(dirs, numberOfDataSize);
        this.memoryMode = false;
    }

    public void initNoMemoryModeSetting(String lineFile) {
        try {
            if (this.sync == null) {
                this.sync = new Object();
            }
            this.readObjectFlg = true;
            this.tmpVacuumeLineFile = lineFile + ".vacuumtmp";
            this.tmpVacuumeCopyMapDirs = new String[5];
            this.tmpVacuumeCopyMapDirs[0] = lineFile + ".cpmapdir1/";
            this.tmpVacuumeCopyMapDirs[1] = lineFile + ".cpmapdir2/";
            this.tmpVacuumeCopyMapDirs[2] = lineFile + ".cpmapdir3/";
            this.tmpVacuumeCopyMapDirs[3] = lineFile + ".cpmapdir4/";
            this.tmpVacuumeCopyMapDirs[4] = lineFile + ".cpmapdir5/";
            String[] overSizeDataStoreDirs = new String[1];
            for (int dirIdx = 0; dirIdx < 1; ++dirIdx) {
                overSizeDataStoreDirs[dirIdx] = lineFile + "_" + dirIdx + "/";
            }
            if (this.overSizeDataStore == null) {
                this.overSizeDataStore = new FileBaseDataMap(overSizeDataStoreDirs, 100000, 0.01, ImdstDefine.saveDataMaxSize, ImdstDefine.dataFileWriteMaxSize * 5, ImdstDefine.dataFileWriteMaxSize * 15);
            }
            this.bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(lineFile), true), "UTF-8"), 262144);
            this.dataFileBufferUseCount = new AtomicInteger(0);
            this.raf = ImdstDefine.dataFileWriteDelayFlg ? new CustomRandomAccess(new File(lineFile), "rw") : new RandomAccessFile(new File(lineFile), "rw");
            this.deletedDataPointList = new ArrayBlockingQueue(ImdstDefine.numberOfDeletedDataPoint);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(lineFile)), "UTF-8"));
            this.lineFile = lineFile;
            int counter = 0;
            while (br.readLine() != null) {
                ++counter;
            }
            this.lineCount = counter;
            br.close();
            this.nowKeySize = super.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - init - Error [" + e.getMessage() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNoCnv(Object key) {
        Object ret = null;
        if (this.memoryMode) {
            ret = super.get(key);
        } else {
            try {
                boolean i = false;
                long seekPoint = 0L;
                byte[] buf = new byte[this.oneDataLength];
                seekPoint = this.calcSeekDataPoint(key);
                if (seekPoint == -1L) {
                    return null;
                }
                Object object = this.sync;
                synchronized (object) {
                    if (this.vacuumExecFlg && seekPoint != this.calcSeekDataPoint(key)) {
                        return this.get(key);
                    }
                    this.readDataFile(buf, seekPoint, this.oneDataLength);
                }
                ret = new String(buf, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
                StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - get - Error [" + e.getMessage() + "]");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        Object ret;
        block15: {
            ret = null;
            if (this.memoryMode) {
                ret = super.get(key);
            } else {
                try {
                    if (this.vacuumExecFlg) {
                        ret = this.syncGet(key);
                        break block15;
                    }
                    int i = 0;
                    int readRet = 0;
                    long seekPoint = 0L;
                    byte[] buf = new byte[this.oneDataLength];
                    seekPoint = this.calcSeekDataPoint(key);
                    if (seekPoint == -1L) {
                        return null;
                    }
                    Object object = this.sync;
                    synchronized (object) {
                        readRet = this.readDataFile(buf, seekPoint, this.oneDataLength);
                        if (readRet == -1) {
                            return null;
                        }
                        boolean overSizeData = false;
                        if (buf[this.oneDataLength - 1] != 38 || readRet > this.oneDataLength) {
                            overSizeData = true;
                            if (!this.overSizeDataStore.containsKey(key)) {
                                overSizeData = false;
                            }
                        }
                        if (overSizeData) {
                            ret = this.readOverSizeData(key, buf);
                        } else {
                            while (i < buf.length && buf[i] != 38) {
                                ++i;
                            }
                            ret = new String(buf, 0, i, "UTF-8");
                        }
                        buf = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - get - Error [" + e.getMessage() + "]");
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object syncGet(Object key) {
        String ret = null;
        try {
            int i = 0;
            byte[] buf = new byte[this.oneDataLength];
            long seekPoint = 0L;
            int readRet = 0;
            Object object = this.sync;
            synchronized (object) {
                seekPoint = this.calcSeekDataPoint(key);
                if (seekPoint == -1L) {
                    return null;
                }
                readRet = this.readDataFile(buf, seekPoint, this.oneDataLength);
                boolean overSizeData = false;
                if (buf[this.oneDataLength - 1] != 38 || readRet > this.oneDataLength) {
                    overSizeData = true;
                    if (!this.overSizeDataStore.containsKey(key)) {
                        overSizeData = false;
                    }
                }
                if (overSizeData) {
                    ret = this.readOverSizeData(key, buf);
                } else {
                    while (i < buf.length && buf[i] != 38) {
                        ++i;
                    }
                    ret = new String(buf, 0, i, "UTF-8");
                }
                buf = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - syncGet - Error [" + e.getMessage() + "]");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        Object ret;
        block22: {
            ret = null;
            this.totalDataSizeCalc(key, value);
            if (this.memoryMode) {
                ret = super.put(key, value);
            } else {
                StringBuilder writeBuf = new StringBuilder(this.oneDataLength + 2);
                int valueSize = value.toString().length();
                try {
                    if (this.readObjectFlg) {
                        long seekPoint = 0L;
                        boolean overSizeFlg = false;
                        if (((String)value).length() > this.oneDataLength) {
                            writeBuf.append(((String)value).substring(0, this.oneDataLength));
                            overSizeFlg = true;
                            valueSize = this.oneDataLength;
                        } else {
                            writeBuf.append((String)value);
                        }
                        byte[] appendDatas = new byte[this.oneDataLength - valueSize];
                        for (int i = 0; i < appendDatas.length; ++i) {
                            appendDatas[i] = 38;
                        }
                        writeBuf.append(new String(appendDatas));
                        writeBuf.append("\n");
                        seekPoint = this.calcSeekDataPoint(key);
                        if (seekPoint == -1L) {
                            Object object = this.sync;
                            synchronized (object) {
                                Integer deletedLine = (Integer)this.deletedDataPointList.poll();
                                if (this.vacuumExecFlg) {
                                    Object[] diffObj = new Object[]{"1", (String)key, (String)value};
                                    this.vacuumDiffDataList.add(diffObj);
                                }
                                if (deletedLine == null) {
                                    this.bw.write(writeBuf.toString());
                                    SystemUtil.diskAccessSync(this.bw);
                                    ++this.lineCount;
                                    super.put(key, new Integer(this.lineCount));
                                    this.checkDataFileWriterLimit(this.dataFileBufferUseCount.incrementAndGet());
                                } else {
                                    this.raf.seek(this.convertLineToSeekPoint(deletedLine));
                                    this.raf.write(writeBuf.toString().getBytes(), 0, this.oneDataLength);
                                    super.put(key, new Integer(deletedLine));
                                }
                                this.nowKeySize = super.size();
                                if (overSizeFlg) {
                                    this.writeOverSizeData(key, value);
                                }
                                break block22;
                            }
                        }
                        Object object = this.sync;
                        synchronized (object) {
                            if (this.vacuumExecFlg) {
                                Object[] diffObj = new Object[]{"1", key, value};
                                this.vacuumDiffDataList.add(diffObj);
                            }
                            if (this.raf != null) {
                                this.raf.seek(seekPoint);
                                this.raf.write(writeBuf.toString().getBytes(), 0, this.oneDataLength);
                            }
                            if (overSizeFlg) {
                                this.writeOverSizeData(key, value);
                            }
                            break block22;
                        }
                    }
                    super.put(key, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - put - Error [" + e.getMessage() + "]");
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        Object ret = null;
        Object object = this.sync;
        synchronized (object) {
            this.totalDataSizeCalc(key, null);
            ret = super.remove(key);
            if (this.overSizeDataStore != null && this.overSizeDataStore.containsKey(key)) {
                this.overSizeDataStore.remove(key);
            }
            this.nowKeySize = super.size();
            if (ret != null && !this.memoryMode) {
                this.deletedDataPointList.offer(ret);
            }
            if (this.vacuumExecFlg) {
                Object[] diffObj = new Object[]{"2", (String)key};
                this.vacuumDiffDataList.add(diffObj);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (this.vacuumExecFlg) {
            Object object = this.sync;
            synchronized (object) {
                return super.containsKey(key);
            }
        }
        return super.containsKey(key);
    }

    private void totalDataSizeCalc(Object key, Object value) {
        long addSize = 0L;
        if (value != null) {
            addSize = new Double((double)(((String)key).length() + ((String)value).length()) * 0.8).longValue();
        }
        if (addSize != 0L) {
            addSize += 20L;
        }
        String unique = null;
        String keyStr = (String)key;
        int beforeSize = 0;
        AtomicLong size = null;
        int nowValLen = 0;
        unique = keyStr.indexOf("#") == 0 ? keyStr.substring(0, 6) : "all";
        Object val = this.get(key);
        if (val != null) {
            nowValLen = new Double((double)(((String)key).length() + ((String)val).length()) * 0.8).intValue() + 20;
        }
        if (nowValLen != 0) {
            beforeSize = nowValLen * -1;
        }
        if (!this.dataSizeMap.containsKey(unique)) {
            size = new AtomicLong(0L);
            this.dataSizeMap.put(unique, size);
        } else {
            size = (AtomicLong)this.dataSizeMap.get(unique);
        }
        size.getAndAdd(beforeSize);
        size.getAndAdd(addSize);
    }

    public long getDataUseSize(String unique) {
        AtomicLong size = new AtomicLong(0L);
        if (unique == null) {
            unique = "all";
        }
        if (this.dataSizeMap.containsKey(unique)) {
            size = (AtomicLong)this.dataSizeMap.get(unique);
        }
        return size.longValue();
    }

    public String[] getAllDataUseSize() {
        if (this.dataSizeMap == null || this.dataSizeMap.size() == 0) {
            return null;
        }
        String[] sizeList = new String[this.dataSizeMap.size()];
        Set entrySet = this.dataSizeMap.entrySet();
        Iterator entryIte = entrySet.iterator();
        int idx = 0;
        while (entryIte.hasNext()) {
            Map.Entry obj = entryIte.next();
            if (obj == null) continue;
            String key = (String)obj.getKey();
            AtomicLong size = (AtomicLong)obj.getValue();
            sizeList[idx] = key + "=" + size.toString();
            ++idx;
        }
        return sizeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean vacuumData() {
        boolean ret;
        block59: {
            ret = false;
            BufferedWriter tmpBw = null;
            RandomAccessFile raf = null;
            AbstractMap vacuumWorkMap = null;
            boolean userMap = false;
            String dataStr = null;
            Set entrySet = null;
            Iterator entryIte = null;
            String key = null;
            int putCounter = 0;
            Object object = this.sync;
            synchronized (object) {
                if (this.vacuumDiffDataList != null) {
                    this.vacuumDiffDataList.clear();
                    this.vacuumDiffDataList = null;
                }
                this.vacuumDiffDataList = new FileBaseDataList(this.tmpVacuumeLineFile);
                this.vacuumExecFlg = true;
            }
            if (JavaSystemApi.getUseMemoryPercent() > 40) {
                userMap = true;
                vacuumWorkMap = new FileBaseDataMap(this.tmpVacuumeCopyMapDirs, super.size(), 0.2);
            } else {
                vacuumWorkMap = new HashMap(super.size());
            }
            tmpBw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.lineFile + ".tmp"), true), "UTF-8"), 262144);
            raf = new RandomAccessFile(new File(this.lineFile), "r");
            entrySet = super.entrySet();
            for (Object obj : entrySet) {
                key = (String)obj.getKey();
                if (key == null || (dataStr = (String)this.getNoCnv(key)) == null) continue;
                tmpBw.write(dataStr);
                tmpBw.write("\n");
                vacuumWorkMap.put(key, new Integer(++putCounter).toString());
            }
            try {
                Object obj;
                if (StatusUtil.getStatus() != 0) break block59;
                SystemUtil.diskAccessSync(tmpBw);
                tmpBw.close();
                obj = this.sync;
                synchronized (obj) {
                    File dataFile;
                    raf.close();
                    if (this.raf != null) {
                        this.raf.close();
                    }
                    if (this.bw != null) {
                        this.bw.close();
                    }
                    if ((dataFile = new File(this.lineFile)).exists()) {
                        dataFile.delete();
                    }
                    dataFile = null;
                    File tmpFile = new File(this.lineFile + ".tmp");
                    tmpFile.renameTo(new File(this.lineFile));
                    super.clear();
                    Integer workMapData = null;
                    Set workEntrySet = vacuumWorkMap.entrySet();
                    Iterator workEntryIte = workEntrySet.iterator();
                    String workKey = null;
                    while (workEntryIte.hasNext()) {
                        Map.Entry obj2 = workEntryIte.next();
                        workKey = (String)obj2.getKey();
                        if (workKey == null) continue;
                        workMapData = new Integer((String)vacuumWorkMap.get(workKey));
                        super.put(workKey, workMapData);
                    }
                    this.nowKeySize = super.size();
                    this.initNoMemoryModeSetting(this.lineFile);
                    int vacuumDiffDataSize = this.vacuumDiffDataList.size();
                    if (vacuumDiffDataSize > 0) {
                        Object[] diffObj = null;
                        for (int i = 0; i < vacuumDiffDataSize; ++i) {
                            diffObj = (Object[])this.vacuumDiffDataList.get(i);
                            if (diffObj[0].equals("1")) {
                                this.put(diffObj[1], diffObj[2]);
                                continue;
                            }
                            if (!diffObj[0].equals("2")) continue;
                            this.remove(diffObj[1]);
                        }
                    }
                    this.vacuumDiffDataList.clear();
                    this.vacuumDiffDataList = null;
                    if (userMap) {
                        ((FileBaseDataMap)vacuumWorkMap).finishClear();
                    }
                    vacuumWorkMap = null;
                    this.vacuumExecFlg = false;
                    ret = true;
                    break block59;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                try {
                    File tmpFile = new File(this.lineFile + ".tmp");
                    if (tmpFile.exists()) {
                        tmpFile.delete();
                    }
                    break block59;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                    StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - vacuumData - Error [" + e3.getMessage() + e3.getMessage() + "]");
                }
            }
            break block59;
            catch (Exception e222222) {
                e222222.printStackTrace();
                StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - vacuumData - Error [" + e222222.getMessage() + "]");
                try {
                    if (StatusUtil.getStatus() != 0) break block59;
                    SystemUtil.diskAccessSync(tmpBw);
                    tmpBw.close();
                    Object e222222 = this.sync;
                    synchronized (e222222) {
                        File dataFile;
                        raf.close();
                        if (this.raf != null) {
                            this.raf.close();
                        }
                        if (this.bw != null) {
                            this.bw.close();
                        }
                        if ((dataFile = new File(this.lineFile)).exists()) {
                            dataFile.delete();
                        }
                        dataFile = null;
                        File tmpFile = new File(this.lineFile + ".tmp");
                        tmpFile.renameTo(new File(this.lineFile));
                        super.clear();
                        Integer workMapData = null;
                        Set workEntrySet = vacuumWorkMap.entrySet();
                        Iterator workEntryIte = workEntrySet.iterator();
                        String workKey = null;
                        while (workEntryIte.hasNext()) {
                            Map.Entry obj = workEntryIte.next();
                            workKey = (String)obj.getKey();
                            if (workKey == null) continue;
                            workMapData = new Integer((String)vacuumWorkMap.get(workKey));
                            super.put(workKey, workMapData);
                        }
                        this.nowKeySize = super.size();
                        this.initNoMemoryModeSetting(this.lineFile);
                        int vacuumDiffDataSize = this.vacuumDiffDataList.size();
                        if (vacuumDiffDataSize > 0) {
                            Object[] diffObj = null;
                            for (int i = 0; i < vacuumDiffDataSize; ++i) {
                                diffObj = (Object[])this.vacuumDiffDataList.get(i);
                                if (diffObj[0].equals("1")) {
                                    this.put(diffObj[1], diffObj[2]);
                                    continue;
                                }
                                if (!diffObj[0].equals("2")) continue;
                                this.remove(diffObj[1]);
                            }
                        }
                        this.vacuumDiffDataList.clear();
                        this.vacuumDiffDataList = null;
                        if (userMap) {
                            ((FileBaseDataMap)vacuumWorkMap).finishClear();
                        }
                        vacuumWorkMap = null;
                        this.vacuumExecFlg = false;
                        ret = true;
                    }
                }
                catch (Exception e23) {
                    e23.printStackTrace();
                    try {
                        File tmpFile = new File(this.lineFile + ".tmp");
                        if (tmpFile.exists()) {
                            tmpFile.delete();
                        }
                        break block59;
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                        StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - vacuumData - Error [" + e3.getMessage() + e3.getMessage() + "]");
                    }
                }
                catch (Throwable throwable) {
                    block60: {
                        try {
                            if (StatusUtil.getStatus() != 0) break block60;
                            SystemUtil.diskAccessSync(tmpBw);
                            tmpBw.close();
                            Object object2 = this.sync;
                            synchronized (object2) {
                                File dataFile;
                                raf.close();
                                if (this.raf != null) {
                                    this.raf.close();
                                }
                                if (this.bw != null) {
                                    this.bw.close();
                                }
                                if ((dataFile = new File(this.lineFile)).exists()) {
                                    dataFile.delete();
                                }
                                dataFile = null;
                                File tmpFile = new File(this.lineFile + ".tmp");
                                tmpFile.renameTo(new File(this.lineFile));
                                super.clear();
                                Integer workMapData = null;
                                Set workEntrySet = vacuumWorkMap.entrySet();
                                Iterator workEntryIte = workEntrySet.iterator();
                                String workKey = null;
                                while (workEntryIte.hasNext()) {
                                    Map.Entry obj = workEntryIte.next();
                                    workKey = (String)obj.getKey();
                                    if (workKey == null) continue;
                                    workMapData = new Integer((String)vacuumWorkMap.get(workKey));
                                    super.put(workKey, workMapData);
                                }
                                this.nowKeySize = super.size();
                                this.initNoMemoryModeSetting(this.lineFile);
                                int vacuumDiffDataSize = this.vacuumDiffDataList.size();
                                if (vacuumDiffDataSize > 0) {
                                    Object[] diffObj = null;
                                    for (int i = 0; i < vacuumDiffDataSize; ++i) {
                                        diffObj = (Object[])this.vacuumDiffDataList.get(i);
                                        if (diffObj[0].equals("1")) {
                                            this.put(diffObj[1], diffObj[2]);
                                            continue;
                                        }
                                        if (!diffObj[0].equals("2")) continue;
                                        this.remove(diffObj[1]);
                                    }
                                }
                                this.vacuumDiffDataList.clear();
                                this.vacuumDiffDataList = null;
                                if (userMap) {
                                    ((FileBaseDataMap)vacuumWorkMap).finishClear();
                                }
                                vacuumWorkMap = null;
                                this.vacuumExecFlg = false;
                                ret = true;
                            }
                        }
                        catch (Exception e24) {
                            e24.printStackTrace();
                            try {
                                File tmpFile = new File(this.lineFile + ".tmp");
                                if (tmpFile.exists()) {
                                    tmpFile.delete();
                                }
                            }
                            catch (Exception e3) {
                                e3.printStackTrace();
                                StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - vacuumData - Error [" + e3.getMessage() + e3.getMessage() + "]");
                            }
                        }
                    }
                    throw throwable;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDataFileWriterLimit(int nowCount) {
        if (nowCount > ImdstDefine.maxDataFileBufferUseCount) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.bw.flush();
                    this.bw.close();
                    this.bw = null;
                }
                catch (Exception e) {
                    this.bw = null;
                }
                finally {
                    try {
                        this.bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.lineFile), true), "UTF-8"), 262144);
                        this.dataFileBufferUseCount = new AtomicInteger(0);
                    }
                    catch (Exception e) {
                        this.bw = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object object = this.sync;
            synchronized (object) {
                if (this.deletedDataPointList != null) {
                    this.deletedDataPointList.clear();
                }
                if (this.raf != null) {
                    this.raf.close();
                }
                if (this.bw != null) {
                    this.bw.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMapDataFile() throws Exception {
        try {
            Object object = this.sync;
            synchronized (object) {
                File dataFile;
                if (this.deletedDataPointList != null) {
                    this.deletedDataPointList.clear();
                }
                if (this.raf != null) {
                    this.raf.close();
                    this.raf = null;
                }
                if (this.bw != null) {
                    this.bw.close();
                    this.bw = null;
                }
                if ((dataFile = new File(this.lineFile)).exists()) {
                    dataFile.delete();
                }
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw e3;
        }
    }

    private int readDataFile(byte[] buf, long seekPoint, int readLength) throws Exception {
        int ret = readLength;
        if (this.raf == null) {
            return -1;
        }
        this.raf.seek(seekPoint);
        SystemUtil.diskAccessSync(this.raf, buf, 0, this.oneDataLength);
        if (buf[buf.length - 1] != 38 && buf[buf.length - 2] != 33 && buf[buf.length - 1] != 48) {
            ++ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOverSizeData(Object key, Object value) {
        try {
            this.overSizeDataStore.put((String)key, ((String)value).substring(this.oneDataLength, ((String)value).length()));
        }
        catch (Exception inE) {
            inE.printStackTrace();
            StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - Inner File Write - Error [" + inE.getMessage() + "]");
        }
    }

    private String readOverSizeData(Object key, byte[] buf) {
        String ret = null;
        try {
            String readStr = (String)this.overSizeDataStore.get((String)key);
            StringBuilder retTmpBuf = new StringBuilder(this.oneDataLength);
            retTmpBuf.append(new String(buf, 0, this.oneDataLength, "UTF-8"));
            retTmpBuf.append(readStr);
            ret = retTmpBuf.toString();
        }
        catch (Exception inE) {
            inE.printStackTrace();
            StatusUtil.setStatusAndMessage(1, "KeyManagerValueMap - Inner File Read[get] - Error [" + inE.getMessage() + "]");
        }
        return ret;
    }

    private long calcSeekDataPoint(Object key) {
        Integer lineInteger = (Integer)super.get(key);
        return this.convertLineToSeekPoint(lineInteger);
    }

    private long convertLineToSeekPoint(Integer lineInteger) {
        int line = 0;
        if (lineInteger == null) {
            return -1L;
        }
        line = lineInteger;
        return new Long(this.seekOneDataLength) * new Long(line - 1);
    }

    public int getKeySize() {
        return this.nowKeySize;
    }

    public int getAllDataCount() {
        return this.lineCount;
    }

    public void setKLastDataChangeTime(long time) {
        this.lastDataChangeTime = time;
    }

    public long getKLastDataChangeTime() {
        return this.lastDataChangeTime;
    }
}

