/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util.serializemap;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import okuyama.imdst.util.serializemap.ISerializer;
import okuyama.imdst.util.serializemap.SerializeMapSet;

public class SerializeMap
extends AbstractMap
implements Cloneable,
Serializable {
    private AtomicInteger nowSize = new AtomicInteger(0);
    int parallelControl = 19999;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    final Lock r = this.rwl.readLock();
    final Lock w = this.rwl.writeLock();
    private Integer[] syncObjs = null;
    private Map baseMap = null;
    private ISerializer serializer = null;
    private boolean classFix = false;
    private Class keyClass = null;
    private Class valueClass = null;

    public SerializeMap(int size, int upper, int multi, String serializeClassName) {
        System.out.println("SerializeMap BucketSize= " + multi);
        System.out.println("SerializeMap SerializerClassName= " + serializeClassName);
        this.parallelControl = multi;
        this.syncObjs = new Integer[multi];
        for (int i = 0; i < this.parallelControl; ++i) {
            this.syncObjs[i] = new Integer(i);
        }
        this.baseMap = new ConcurrentHashMap(multi, multi - 1, 64);
        try {
            this.serializer = (ISerializer)Class.forName(serializeClassName).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int hashPointCalc(int hash) {
        return (hash << 1 >>> 1) % this.parallelControl;
    }

    public byte[] dataSerialize(Map data, Class keyClazz, Class valueClazz) {
        return this.serializer.serialize(data, keyClazz, valueClazz);
    }

    public Map dataDeserialize(byte[] data) {
        return this.serializer.deSerialize(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        boolean incrFlg = false;
        this.r.lock();
        if (!this.classFix) {
            this.classFix = true;
            this.keyClass = key.getClass();
            this.valueClass = value.getClass();
        }
        try {
            int poitnInt = this.hashPointCalc(key.hashCode());
            Integer point = new Integer(poitnInt);
            byte[] target = null;
            Integer n = this.syncObjs[poitnInt];
            synchronized (n) {
                target = (byte[])this.baseMap.get(point);
                if (target != null) {
                    Map targetMap = this.dataDeserialize(target);
                    if (!targetMap.containsKey(key)) {
                        incrFlg = true;
                    }
                    targetMap.put(key, value);
                    target = this.dataSerialize(targetMap, this.keyClass, this.valueClass);
                } else {
                    HashMap<Object, Object> targetMap = new HashMap<Object, Object>();
                    targetMap.put(key, value);
                    target = this.dataSerialize(targetMap, this.keyClass, this.valueClass);
                    incrFlg = true;
                }
                this.baseMap.put(point, target);
            }
            if (incrFlg) {
                this.nowSize.incrementAndGet();
            }
        }
        finally {
            this.r.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        this.r.lock();
        try {
            int poitnInt = this.hashPointCalc(key.hashCode());
            Integer point = new Integer(poitnInt);
            byte[] target = null;
            Integer n = this.syncObjs[poitnInt];
            synchronized (n) {
                target = (byte[])this.baseMap.get(point);
            }
            if (target == null) {
                n = null;
                return n;
            }
            Map targetMap = this.dataDeserialize(target);
            Object v = targetMap.get(key);
            return v;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        boolean decrFlg = false;
        Object ret = null;
        this.r.lock();
        try {
            int poitnInt = this.hashPointCalc(key.hashCode());
            Integer point = new Integer(poitnInt);
            byte[] target = null;
            Integer n = this.syncObjs[poitnInt];
            synchronized (n) {
                block10: {
                    target = (byte[])this.baseMap.get(point);
                    if (target != null) break block10;
                    Object var8_8 = null;
                    return var8_8;
                }
                Map targetMap = this.dataDeserialize(target);
                ret = targetMap.remove(key);
                if (ret != null) {
                    target = this.dataSerialize(targetMap, this.keyClass, this.valueClass);
                    decrFlg = true;
                }
                this.baseMap.put(point, target);
            }
            if (decrFlg) {
                this.nowSize.decrementAndGet();
            }
        }
        finally {
            this.r.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        boolean ret = false;
        this.r.lock();
        try {
            int poitnInt = this.hashPointCalc(key.hashCode());
            Integer point = new Integer(poitnInt);
            byte[] target = null;
            Integer n = this.syncObjs[poitnInt];
            synchronized (n) {
                block8: {
                    target = (byte[])this.baseMap.get(point);
                    if (target != null) break block8;
                    boolean bl = false;
                    return bl;
                }
                Map targetMap = this.dataDeserialize(target);
                ret = targetMap.containsKey(key);
            }
        }
        finally {
            this.r.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.w.lock();
        try {
            this.baseMap.clear();
            this.nowSize = new AtomicInteger(0);
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public int size() {
        return this.nowSize.intValue();
    }

    @Override
    public Set entrySet() {
        return new SerializeMapSet(this.baseMap.entrySet(), this);
    }
}

