/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import okuyama.imdst.util.CacheContainer;
import okuyama.imdst.util.CoreFileBaseKeyMap;
import okuyama.imdst.util.FileBaseDataMap;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.InnerCache;
import okuyama.imdst.util.SystemUtil;

class FixWriteCoreFileBaseKeyMap
implements CoreFileBaseKeyMap {
    private String[] baseFileDirs = null;
    private String[] fileDirs = null;
    private int keyDataLength = new Double((double)ImdstDefine.saveKeyMaxSize * 1.33).intValue() + 1;
    private int oneDataLength = 11;
    private int lineDataSize = this.keyDataLength + this.oneDataLength;
    private int getDataSize = this.lineDataSize * (8192 / this.lineDataSize) * 5;
    private int numberOfDataFiles = 1024;
    private int dataDirsFactor = 40;
    private File[] dataFileList = null;
    private InnerCache innerCache = null;
    private AtomicInteger totalSize = null;
    private int innerCacheSize = 128;
    private int numberOfOneFileKey = ImdstDefine.fileBaseMapNumberOfOneFileKey;
    private int nowIterationFileIndex = 0;
    private long nowIterationFpPosition = 0L;

    public FixWriteCoreFileBaseKeyMap(String[] dirs, int innerCacheSize, int numberOfKeyData) {
        try {
            this.baseFileDirs = dirs;
            this.innerCacheSize = innerCacheSize;
            if (numberOfKeyData <= this.numberOfOneFileKey) {
                numberOfKeyData = this.numberOfOneFileKey * 2;
            }
            this.numberOfDataFiles = numberOfKeyData / this.numberOfOneFileKey;
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FixWriteCoreFileBaseKeyMap(String[] dirs, int innerCacheSize, int numberOfKeyData, int numberOfValueSize) {
        try {
            this.oneDataLength = numberOfValueSize;
            this.lineDataSize = this.keyDataLength + this.oneDataLength;
            if (8192 > this.lineDataSize) {
                this.getDataSize = this.lineDataSize * (8192 / this.lineDataSize) * 5;
            } else {
                this.getDataSize = this.lineDataSize;
                this.numberOfOneFileKey = 100;
            }
            this.baseFileDirs = dirs;
            this.innerCacheSize = innerCacheSize;
            if (numberOfKeyData <= this.numberOfOneFileKey) {
                numberOfKeyData = this.numberOfOneFileKey * 2;
            }
            this.numberOfDataFiles = numberOfKeyData / this.numberOfOneFileKey;
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
        this.innerCache = new InnerCache(this.innerCacheSize);
        this.totalSize = new AtomicInteger(0);
        this.dataFileList = new File[this.numberOfDataFiles];
        try {
            this.fileDirs = new String[this.baseFileDirs.length * this.dataDirsFactor];
            int counter = 0;
            for (int idx = 0; idx < this.baseFileDirs.length; ++idx) {
                for (int idx2 = 0; idx2 < this.dataDirsFactor; ++idx2) {
                    this.fileDirs[counter] = this.baseFileDirs[idx] + idx2 + "/";
                    File dir = new File(this.fileDirs[counter]);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    ++counter;
                }
            }
            for (int i = 0; i < this.numberOfDataFiles; ++i) {
                File file = new File(this.fileDirs[i % this.fileDirs.length] + i + ".data");
                if (file.exists()) {
                    file.delete();
                }
                this.dataFileList[i] = file;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void clear() {
        if (this.innerCache != null) {
            this.innerCache.clear();
        }
    }

    @Override
    public void put(String key, String value, int hashCode) {
        try {
            File file = this.dataFileList[hashCode % this.numberOfDataFiles];
            StringBuilder buf = new StringBuilder(this.keyDataLength);
            buf.append(this.fillCharacter(key, this.keyDataLength));
            CacheContainer accessor = (CacheContainer)this.innerCache.get(file.getAbsolutePath());
            RandomAccessFile raf = null;
            BufferedWriter wr = null;
            if (accessor == null || accessor.isClosed) {
                raf = new RandomAccessFile(file, "rwd");
                wr = new BufferedWriter(new FileWriter(file, true));
                accessor = new CacheContainer();
                accessor.raf = raf;
                accessor.wr = wr;
                accessor.file = file;
                this.innerCache.put(file.getAbsolutePath(), accessor);
            } else {
                raf = accessor.raf;
                wr = accessor.wr;
            }
            for (int tryIdx = 0; tryIdx < 2; ++tryIdx) {
                try {
                    long[] dataLineNoRet = this.getLinePoint(key, raf);
                    if (dataLineNoRet[0] == -1L) {
                        wr.write(buf.toString());
                        SystemUtil.diskAccessSync(wr);
                        wr.write(value);
                        SystemUtil.diskAccessSync(wr);
                        int valueSize = value.length();
                        byte[] fillByte = new byte[]{new Integer(FileBaseDataMap.paddingSymbol).byteValue()};
                        int paddingSize = this.oneDataLength - valueSize;
                        int writeSetCount = paddingSize / 512;
                        int singleWriteCount = paddingSize % 512;
                        for (int i = 0; i < writeSetCount; ++i) {
                            wr.write(FileBaseDataMap.paddingSymbolSetString);
                            if (i % 14 != 0) continue;
                            SystemUtil.diskAccessSync(wr);
                        }
                        SystemUtil.diskAccessSync(wr);
                        byte[] fillBytes = new byte[singleWriteCount];
                        for (int i = 0; i < singleWriteCount; ++i) {
                            fillBytes[i] = fillByte[0];
                        }
                        wr.write(new String(fillBytes));
                        SystemUtil.diskAccessSync(wr);
                        this.totalSize.getAndIncrement();
                    } else {
                        boolean increMentFlg = false;
                        if (dataLineNoRet[1] == -1L) {
                            increMentFlg = true;
                        }
                        raf.seek(dataLineNoRet[0] * (long)this.lineDataSize);
                        raf.write(buf.toString().getBytes(), 0, this.keyDataLength);
                        raf.write(value.getBytes());
                        int valueSize = value.length();
                        byte[] fillByte = new byte[]{new Integer(FileBaseDataMap.paddingSymbol).byteValue()};
                        int paddingSize = this.oneDataLength - valueSize;
                        int writeSetCount = paddingSize / 4096;
                        int singleWriteCount = paddingSize % 4096;
                        for (int i = 0; i < writeSetCount; ++i) {
                            raf.write(FileBaseDataMap.fillStream.toByteArray());
                        }
                        byte[] remainderPaddingBytes = new byte[singleWriteCount];
                        for (int i = 0; i < singleWriteCount; ++i) {
                            remainderPaddingBytes[i] = fillByte[0];
                        }
                        if (remainderPaddingBytes.length > 0) {
                            raf.write(remainderPaddingBytes);
                        }
                        if (increMentFlg) {
                            this.totalSize.getAndIncrement();
                        }
                    }
                    break;
                }
                catch (IOException ie) {
                    if (tryIdx == 1) {
                        throw ie;
                    }
                    if (raf != null) {
                        raf.close();
                    }
                    if (wr != null) {
                        wr.close();
                    }
                    raf = new RandomAccessFile(file, "rwd");
                    wr = new BufferedWriter(new FileWriter(file, true));
                    accessor = new CacheContainer();
                    accessor.raf = raf;
                    accessor.wr = wr;
                    accessor.file = file;
                    this.innerCache.put(file.getAbsolutePath(), accessor);
                    continue;
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private long[] getLinePoint(String key, RandomAccessFile raf) throws Exception {
        long[] ret = new long[]{-1L, 0L};
        long line = -1L;
        long lineCount = 0L;
        byte[] keyBytes = key.getBytes();
        byte[] equalKeyBytes = new byte[keyBytes.length + 1];
        byte[] lineBufs = new byte[this.getDataSize];
        boolean matchFlg = true;
        for (int idx = 0; idx < keyBytes.length; ++idx) {
            equalKeyBytes[idx] = keyBytes[idx];
        }
        equalKeyBytes[equalKeyBytes.length - 1] = new Integer(FileBaseDataMap.paddingSymbol).byteValue();
        try {
            raf.seek(0L);
            int readLen = -1;
            while ((readLen = SystemUtil.diskAccessSync(raf, lineBufs)) != -1) {
                matchFlg = true;
                int loop = readLen / this.lineDataSize;
                for (int loopIdx = 0; loopIdx < loop; ++loopIdx) {
                    int assist = this.lineDataSize * loopIdx;
                    matchFlg = true;
                    if (equalKeyBytes[equalKeyBytes.length - 1] == lineBufs[assist + (equalKeyBytes.length - 1)]) {
                        for (int i = 0; i < equalKeyBytes.length; ++i) {
                            if (equalKeyBytes[i] == lineBufs[assist + i]) continue;
                            matchFlg = false;
                            break;
                        }
                    } else {
                        matchFlg = false;
                    }
                    if (matchFlg) {
                        line = lineCount;
                        if (lineBufs[assist + this.keyDataLength] != FileBaseDataMap.paddingSymbol) break;
                        ret[1] = -1L;
                        break;
                    }
                    ++lineCount;
                }
                if (!matchFlg) continue;
                break;
            }
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception e) {
            throw e;
        }
        ret[0] = line;
        return ret;
    }

    @Override
    public String get(String key, int hashCode) {
        byte[] tmpBytes = null;
        String ret = null;
        byte[] keyBytes = key.getBytes();
        byte[] equalKeyBytes = new byte[keyBytes.length + 1];
        byte[] lineBufs = new byte[this.getDataSize];
        boolean matchFlg = true;
        for (int idx = 0; idx < keyBytes.length; ++idx) {
            equalKeyBytes[idx] = keyBytes[idx];
        }
        equalKeyBytes[equalKeyBytes.length - 1] = new Integer(FileBaseDataMap.paddingSymbol).byteValue();
        try {
            File file = this.dataFileList[hashCode % this.numberOfDataFiles];
            CacheContainer accessor = (CacheContainer)this.innerCache.get(file.getAbsolutePath());
            RandomAccessFile raf = null;
            BufferedWriter wr = null;
            if (accessor == null || accessor.isClosed) {
                raf = new RandomAccessFile(file, "rwd");
                wr = new BufferedWriter(new FileWriter(file, true));
                accessor = new CacheContainer();
                accessor.raf = raf;
                accessor.wr = wr;
                accessor.file = file;
                this.innerCache.put(file.getAbsolutePath(), accessor);
            } else {
                raf = accessor.raf;
            }
            block7: for (int tryIdx = 0; tryIdx < 2; ++tryIdx) {
                try {
                    raf.seek(0L);
                    int readLen = -1;
                    while ((readLen = SystemUtil.diskAccessSync(raf, lineBufs)) != -1) {
                        matchFlg = true;
                        int loop = readLen / this.lineDataSize;
                        for (int loopIdx = 0; loopIdx < loop; ++loopIdx) {
                            int i;
                            int assist = this.lineDataSize * loopIdx;
                            matchFlg = true;
                            if (equalKeyBytes[equalKeyBytes.length - 1] == lineBufs[assist + (equalKeyBytes.length - 1)]) {
                                for (i = 0; i < equalKeyBytes.length; ++i) {
                                    if (equalKeyBytes[i] == lineBufs[assist + i]) continue;
                                    matchFlg = false;
                                    break;
                                }
                            } else {
                                matchFlg = false;
                            }
                            if (!matchFlg) continue;
                            tmpBytes = new byte[this.lineDataSize];
                            for (i = 0; i < this.lineDataSize; ++i) {
                                tmpBytes[i] = lineBufs[assist + i];
                            }
                            break;
                        }
                        if (!matchFlg) continue;
                        break block7;
                    }
                    break;
                }
                catch (IOException ie) {
                    if (tryIdx == 1) {
                        throw ie;
                    }
                    if (raf != null) {
                        raf.close();
                    }
                    if (wr != null) {
                        wr.close();
                    }
                    raf = new RandomAccessFile(file, "rwd");
                    wr = new BufferedWriter(new FileWriter(file, true));
                    accessor = new CacheContainer();
                    accessor.raf = raf;
                    accessor.wr = wr;
                    accessor.file = file;
                    this.innerCache.put(file.getAbsolutePath(), accessor);
                    continue;
                }
            }
            if (tmpBytes != null && tmpBytes[this.keyDataLength] != FileBaseDataMap.paddingSymbol) {
                int counter = 0;
                for (int i = this.keyDataLength; i < tmpBytes.length && tmpBytes[i] != FileBaseDataMap.paddingSymbol; ++i) {
                    ++counter;
                }
                ret = new String(tmpBytes, this.keyDataLength, counter, "UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public String remove(String key, int hashCode) {
        String ret = null;
        ret = this.get(key, hashCode);
        if (ret != null) {
            this.put(key, "&&&&&&&&&&&", hashCode);
            this.totalSize.getAndDecrement();
        }
        return ret;
    }

    @Override
    public AtomicInteger getTotalSize() {
        return this.totalSize;
    }

    private String fillCharacter(String data, int fixSize) {
        return SystemUtil.fillCharacter(data, fixSize, FileBaseDataMap.paddingSymbol);
    }

    public int getCacheSize() {
        return this.innerCache.getSize();
    }

    @Override
    public void startKeyIteration() {
        this.nowIterationFileIndex = 0;
        this.nowIterationFpPosition = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getAllOneFileInKeys() {
        ArrayList<String> keys = null;
        byte[] datas = null;
        StringBuilder keysBuf = null;
        RandomAccessFile raf = null;
        try {
            if (this.nowIterationFileIndex < this.dataFileList.length) {
                keys = new ArrayList<String>();
                long oneFileLength = new Long(this.dataFileList[this.nowIterationFileIndex].length());
                long readSize = this.lineDataSize * 10;
                int readLoop = new Long(oneFileLength / readSize).intValue();
                if (oneFileLength % readSize > 0L) {
                    ++readLoop;
                }
                raf = new RandomAccessFile(this.dataFileList[this.nowIterationFileIndex], "rwd");
                raf.seek(0L);
                for (int readLoopIdx = 0; readLoopIdx < readLoop; ++readLoopIdx) {
                    datas = new byte[new Long(readSize).intValue()];
                    int readLen = -1;
                    readLen = SystemUtil.diskAccessSync(raf, datas);
                    if (readLen <= 0) continue;
                    int loop = readLen / this.lineDataSize;
                    for (int loopIdx = 0; loopIdx < loop; ++loopIdx) {
                        int assist = this.lineDataSize * loopIdx;
                        keysBuf = new StringBuilder(8192);
                        int idx = 0;
                        while (datas[assist + idx] != FileBaseDataMap.paddingSymbol) {
                            keysBuf.append(new String(datas, assist + idx, 1));
                            ++idx;
                        }
                        keys.add(keysBuf.toString());
                        keysBuf = null;
                    }
                }
            }
            ++this.nowIterationFileIndex;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
                raf = null;
                datas = null;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return keys;
    }
}

