/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import okuyama.base.job.AbstractHelper;
import okuyama.base.util.ILogger;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.io.KeyNodeConnector;

public abstract class AbstractMasterManagerHelper
extends AbstractHelper {
    private static AtomicInteger connPoolCount = new AtomicInteger(0);
    private int nowSt = 0;
    private static ConcurrentHashMap allConnectionMap = new ConcurrentHashMap(40, 30.0f, 64);
    protected static ConcurrentHashMap keyNodeConnectPool = new ConcurrentHashMap(1024, 1000.0f, 256);
    private static HashMap moveData4ConsistentHash = null;
    private static boolean executeKeyNodeOptimizationFlg = false;
    private static boolean nowNodeDataOptimization = false;
    protected static boolean recoverProcessed = false;

    protected void setRecoverProcessed(boolean flg) {
        recoverProcessed = flg;
    }

    protected boolean getRecoverProcessed() {
        return recoverProcessed;
    }

    protected boolean isNodeArrival(String nodeInfo) {
        return StatusUtil.isNodeArrival(nodeInfo);
    }

    protected void setDeadNode(String nodeInfo, int setPoint, Throwable te) {
        this.setDeadNode(nodeInfo, setPoint, te, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDeadNode(String nodeInfo, int setPoint, Throwable te, boolean reportMasterNode) {
        if (keyNodeConnectPool.containsKey(nodeInfo)) {
            KeyNodeConnector keyNodeConnector = null;
            while ((keyNodeConnector = (KeyNodeConnector)((ArrayBlockingQueue)keyNodeConnectPool.get(nodeInfo)).poll()) != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            ((ArrayBlockingQueue)keyNodeConnectPool.get(nodeInfo)).clear();
        }
        if (StatusUtil.isMainMasterNode() && (reportMasterNode || StatusUtil.isNodeArrival(nodeInfo))) {
            StatusUtil.setDeadNode(nodeInfo);
            String slaves = StatusUtil.getSlaveMasterNodes();
            if (slaves != null && !slaves.trim().equals("")) {
                String[] slaveList = slaves.split(",");
                for (int execCounter = 0; execCounter < 1; ++execCounter) {
                    for (int i = 0; i < slaveList.length; ++i) {
                        if (slaveList[i] == null) continue;
                        Socket socket = null;
                        PrintWriter pw = null;
                        BufferedReader br = null;
                        try {
                            String[] slaveNodeDt = slaveList[i].split(":");
                            InetSocketAddress inetAddr = new InetSocketAddress(slaveNodeDt[0], Integer.parseInt(slaveNodeDt[1]));
                            socket = new Socket();
                            socket.connect(inetAddr, 1000);
                            socket.setSoTimeout(1500);
                            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8")));
                            br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
                            StringBuilder serverRequestBuf = new StringBuilder();
                            serverRequestBuf.append("95");
                            serverRequestBuf.append(",");
                            serverRequestBuf.append(nodeInfo);
                            pw.println(serverRequestBuf.toString());
                            pw.flush();
                            String serverRetStr = br.readLine();
                            String[] serverRet = serverRetStr.split(",");
                            if (!serverRet[0].equals("95")) continue;
                            if (!serverRet[1].equals("true")) {
                                continue;
                            }
                            slaveList[i] = null;
                            continue;
                        }
                        catch (Exception e) {
                            continue;
                        }
                        finally {
                            try {
                                if (pw != null) {
                                    pw.println("(&imdst9999&)");
                                    pw.flush();
                                    pw.close();
                                    pw = null;
                                }
                                if (br != null) {
                                    br.close();
                                    br = null;
                                }
                                if (socket != null) {
                                    socket.close();
                                    socket = null;
                                }
                            }
                            catch (Exception e2) {}
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setArriveNode(String nodeInfo) {
        String slaves;
        StatusUtil.setArriveNode(nodeInfo);
        if (keyNodeConnectPool.containsKey(nodeInfo)) {
            KeyNodeConnector keyNodeConnector = null;
            while ((keyNodeConnector = (KeyNodeConnector)((ArrayBlockingQueue)keyNodeConnectPool.get(nodeInfo)).poll()) != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            ((ArrayBlockingQueue)keyNodeConnectPool.get(nodeInfo)).clear();
        }
        if (StatusUtil.isMainMasterNode() && (slaves = StatusUtil.getSlaveMasterNodes()) != null && !slaves.trim().equals("")) {
            String[] slaveList = slaves.split(",");
            block14: for (int i = 0; i < slaveList.length; ++i) {
                for (int msIdx = 0; msIdx < 4; ++msIdx) {
                    Socket socket = null;
                    PrintWriter pw = null;
                    BufferedReader br = null;
                    try {
                        Thread.sleep(200L);
                        String[] slaveNodeDt = slaveList[i].split(":");
                        InetSocketAddress inetAddr = new InetSocketAddress(slaveNodeDt[0], Integer.parseInt(slaveNodeDt[1]));
                        socket = new Socket();
                        socket.connect(inetAddr, 1000);
                        socket.setSoTimeout(1500);
                        pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8")));
                        br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
                        StringBuilder serverRequestBuf = new StringBuilder();
                        serverRequestBuf.append("92");
                        serverRequestBuf.append(",");
                        serverRequestBuf.append(nodeInfo);
                        pw.println(serverRequestBuf.toString());
                        pw.flush();
                        String serverRetStr = br.readLine();
                        String[] serverRet = serverRetStr.split(",");
                        if (!serverRet[0].equals("92")) continue;
                        if (serverRet[1].equals("true")) continue block14;
                        continue;
                    }
                    catch (Exception e) {
                        continue;
                    }
                    finally {
                        try {
                            if (pw != null) {
                                pw.println("(&imdst9999&)");
                                pw.flush();
                                pw.close();
                                pw = null;
                            }
                            if (br != null) {
                                br.close();
                                br = null;
                            }
                            if (socket != null) {
                                socket.close();
                                socket = null;
                            }
                        }
                        catch (Exception e2) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRecoverNode(boolean recoverMode, String nodeInfo) {
        KeyNodeConnector.setRecoverMode(recoverMode, nodeInfo);
        if (StatusUtil.isMainMasterNode()) {
            String slaves;
            String sendCheckStr = null;
            if (StatusUtil.isNodeArrival(nodeInfo) && (slaves = StatusUtil.getSlaveMasterNodes()) != null && !slaves.trim().equals("")) {
                String[] slaveList = slaves.split(",");
                for (int execCounter = 0; execCounter < 2; ++execCounter) {
                    for (int i = 0; i < slaveList.length; ++i) {
                        if (slaveList[i] == null) continue;
                        Socket socket = null;
                        PrintWriter pw = null;
                        BufferedReader br = null;
                        try {
                            String[] slaveNodeDt = slaveList[i].split(":");
                            InetSocketAddress inetAddr = new InetSocketAddress(slaveNodeDt[0], Integer.parseInt(slaveNodeDt[1]));
                            socket = new Socket();
                            socket.connect(inetAddr, 1000);
                            socket.setSoTimeout(ImdstDefine.nodeConnectionTimeout);
                            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8")));
                            br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
                            StringBuilder serverRequestBuf = new StringBuilder();
                            if (recoverMode) {
                                serverRequestBuf.append("96");
                                serverRequestBuf.append(",");
                                serverRequestBuf.append(nodeInfo);
                                sendCheckStr = "96";
                            } else {
                                serverRequestBuf.append("97");
                                serverRequestBuf.append(",");
                                sendCheckStr = "97";
                            }
                            pw.println(serverRequestBuf.toString());
                            pw.flush();
                            String serverRetStr = br.readLine();
                            String[] serverRet = serverRetStr.split(",");
                            if (!serverRet[0].equals(sendCheckStr)) continue;
                            if (!serverRet[1].equals("true")) {
                                continue;
                            }
                            slaveList[i] = null;
                            continue;
                        }
                        catch (Exception e) {
                            continue;
                        }
                        finally {
                            try {
                                if (pw != null) {
                                    pw.println("(&imdst9999&)");
                                    pw.flush();
                                    pw.close();
                                    pw = null;
                                }
                                if (br != null) {
                                    br.close();
                                    br = null;
                                }
                                if (socket != null) {
                                    socket.close();
                                    socket = null;
                                }
                            }
                            catch (Exception e2) {}
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRecoverSuccess(String nodeInfo) {
        KeyNodeConnector.setRecoverMode(false, nodeInfo);
        StatusUtil.setArriveNode(nodeInfo);
        if (StatusUtil.isMainMasterNode()) {
            String slaves;
            Object sendCheckStr = null;
            if (StatusUtil.isNodeArrival(nodeInfo) && (slaves = StatusUtil.getSlaveMasterNodes()) != null && !slaves.trim().equals("")) {
                String[] slaveList = slaves.split(",");
                for (int execCounter = 0; execCounter < 2; ++execCounter) {
                    for (int i = 0; i < slaveList.length; ++i) {
                        if (slaveList[i] == null) continue;
                        Socket socket = null;
                        PrintWriter pw = null;
                        BufferedReader br = null;
                        try {
                            String[] slaveNodeDt = slaveList[i].split(":");
                            InetSocketAddress inetAddr = new InetSocketAddress(slaveNodeDt[0], Integer.parseInt(slaveNodeDt[1]));
                            socket = new Socket();
                            socket.connect(inetAddr, 1000);
                            socket.setSoTimeout(ImdstDefine.nodeConnectionTimeout);
                            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8")));
                            br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
                            StringBuilder serverRequestBuf = new StringBuilder();
                            serverRequestBuf.append("97");
                            serverRequestBuf.append(",");
                            pw.println(serverRequestBuf.toString());
                            pw.flush();
                            String serverRetStr = br.readLine();
                            String[] serverRet = serverRetStr.split(",");
                            if (serverRet[0].equals("97") && serverRet[1].equals("true")) {
                                slaveList[i] = null;
                            }
                            serverRequestBuf = new StringBuilder();
                            serverRequestBuf.append("92");
                            serverRequestBuf.append(",");
                            serverRequestBuf.append(nodeInfo);
                            pw.println(serverRequestBuf.toString());
                            pw.flush();
                            serverRetStr = br.readLine();
                            serverRet = serverRetStr.split(",");
                            if (!serverRet[0].equals("92") || serverRet[1].equals("true")) continue;
                            continue;
                        }
                        catch (Exception e) {
                            continue;
                        }
                        finally {
                            try {
                                if (pw != null) {
                                    pw.println("(&imdst9999&)");
                                    pw.flush();
                                    pw.close();
                                    pw = null;
                                }
                                if (br != null) {
                                    br.close();
                                    br = null;
                                }
                                if (socket != null) {
                                    socket.close();
                                    socket = null;
                                }
                            }
                            catch (Exception e2) {}
                        }
                    }
                }
            }
        }
    }

    protected boolean checkConnectionEffective(String nodeInfo, Long time) {
        if (time == null) {
            return true;
        }
        Long rebootTime = StatusUtil.getNodeRebootTime(nodeInfo);
        if (rebootTime == null) {
            return true;
        }
        return rebootTime <= time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNodeWaitStatus(String nodeInfo) {
        String slaves;
        StatusUtil.setWaitStatus(nodeInfo);
        if (StatusUtil.isMainMasterNode() && (slaves = StatusUtil.getSlaveMasterNodes()) != null && !slaves.trim().equals("")) {
            String[] slaveList = slaves.split(",");
            for (int i = 0; i < slaveList.length; ++i) {
                Socket socket = null;
                PrintWriter pw = null;
                BufferedReader br = null;
                try {
                    String[] slaveNodeDt = slaveList[i].split(":");
                    InetSocketAddress inetAddr = new InetSocketAddress(slaveNodeDt[0], Integer.parseInt(slaveNodeDt[1]));
                    socket = new Socket();
                    socket.connect(inetAddr, ImdstDefine.nodeConnectionOpenTimeout);
                    socket.setSoTimeout(ImdstDefine.nodeConnectionTimeout);
                    pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8")));
                    br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
                    StringBuilder serverRequestBuf = new StringBuilder();
                    serverRequestBuf.append("90");
                    serverRequestBuf.append(",");
                    serverRequestBuf.append(nodeInfo);
                    pw.println(serverRequestBuf.toString());
                    pw.flush();
                    String serverRetStr = br.readLine();
                    String[] serverRet = serverRetStr.split(",");
                    if (!serverRet[0].equals("90") || serverRet[1].equals("true")) continue;
                    continue;
                }
                catch (Exception e) {
                    continue;
                }
                finally {
                    try {
                        if (pw != null) {
                            pw.println("(&imdst9999&)");
                            pw.flush();
                            pw.close();
                            pw = null;
                        }
                        if (br != null) {
                            br.close();
                            br = null;
                        }
                        if (socket != null) {
                            socket.close();
                            socket = null;
                        }
                    }
                    catch (Exception e2) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNodeWaitStatus(String nodeInfo) {
        String slaves;
        StatusUtil.removeWaitStatus(nodeInfo);
        if (StatusUtil.isMainMasterNode() && (slaves = StatusUtil.getSlaveMasterNodes()) != null && !slaves.trim().equals("")) {
            String[] slaveList = slaves.split(",");
            for (int i = 0; i < slaveList.length; ++i) {
                Socket socket = null;
                PrintWriter pw = null;
                BufferedReader br = null;
                try {
                    String[] slaveNodeDt = slaveList[i].split(":");
                    InetSocketAddress inetAddr = new InetSocketAddress(slaveNodeDt[0], Integer.parseInt(slaveNodeDt[1]));
                    socket = new Socket();
                    socket.connect(inetAddr, ImdstDefine.nodeConnectionOpenTimeout);
                    socket.setSoTimeout(ImdstDefine.nodeConnectionTimeout);
                    pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8")));
                    br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
                    StringBuilder serverRequestBuf = new StringBuilder();
                    serverRequestBuf.append("91");
                    serverRequestBuf.append(",");
                    serverRequestBuf.append(nodeInfo);
                    pw.println(serverRequestBuf.toString());
                    pw.flush();
                    String serverRetStr = br.readLine();
                    String[] serverRet = serverRetStr.split(",");
                    if (!serverRet[0].equals("91") || serverRet[1].equals("true")) continue;
                    continue;
                }
                catch (Exception e) {
                    continue;
                }
                finally {
                    try {
                        if (pw != null) {
                            pw.println("(&imdst9999&)");
                            pw.flush();
                            pw.close();
                            pw = null;
                        }
                        if (br != null) {
                            br.close();
                            br = null;
                        }
                        if (socket != null) {
                            socket.close();
                            socket = null;
                        }
                    }
                    catch (Exception e2) {}
                }
            }
        }
    }

    protected void execNodeUseEnd(String nodeInfo) {
        StatusUtil.endNodeUse(nodeInfo);
    }

    protected int getNodeUseStatus(String nodeInfo) {
        return StatusUtil.getNodeUseStatus(nodeInfo);
    }

    protected String[] execNodePing(String nodeName, int port, ILogger logger) {
        return this.execNodePing(nodeName, port, logger, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] execNodePing(String nodeName, int port, ILogger logger, int deadCount) {
        String[] retStrs = new String[2];
        retStrs[0] = "true";
        String connectionFullName = nodeName + ":" + port;
        KeyNodeConnector keyNodeConnector = null;
        String[] retParams = null;
        boolean cacheConnectUse = false;
        for (int tryCount = 0; tryCount < deadCount; ++tryCount) {
            retStrs = new String[2];
            retStrs[0] = "true";
            keyNodeConnector = null;
            retParams = null;
            try {
                if (tryCount == 0 && keyNodeConnectPool.containsKey(connectionFullName) && (keyNodeConnector = (KeyNodeConnector)((ArrayBlockingQueue)keyNodeConnectPool.get(connectionFullName)).poll()) != null && !this.checkConnectionEffective(connectionFullName, keyNodeConnector.getConnetTime())) {
                    keyNodeConnector = null;
                }
                if (keyNodeConnector == null) {
                    keyNodeConnector = new KeyNodeConnector(nodeName, port, connectionFullName);
                    if (tryCount > 0) {
                        keyNodeConnector.connect(15000);
                    } else {
                        keyNodeConnector.connect(3000);
                    }
                }
                if (tryCount > 0) {
                    keyNodeConnector.setSoTimeout(20000);
                } else {
                    keyNodeConnector.setSoTimeout(4000);
                }
                StringBuilder buf = new StringBuilder(25);
                buf.append("10");
                buf.append(",");
                buf.append("PING_CHECK");
                buf.append(",");
                buf.append("Check");
                keyNodeConnector.println(buf.toString());
                keyNodeConnector.flush();
                String retParam = keyNodeConnector.readLineWithReady();
                retParams = retParam.split(",");
                if (!retParams[1].equals("true")) {
                    retStrs[0] = "false";
                } else {
                    retStrs[0] = "true";
                    retStrs[1] = retParams[2];
                }
                if (!retStrs[0].equals("true")) continue;
                try {
                    if (keyNodeConnector == null) break;
                    keyNodeConnector.setSoTimeout(ImdstDefine.nodeConnectionTimeout);
                    this.addKeyNodeCacheConnectionPool(keyNodeConnector);
                    keyNodeConnector = null;
                }
                catch (Exception e1) {
                    logger.error("", e1);
                }
                break;
            }
            catch (Exception e) {
                retStrs[0] = "false";
                logger.info("Node Ping Chekc Error Node Name = [" + nodeName + "] Port [" + port + "]");
                logger.info(e);
                continue;
            }
            finally {
                try {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                    }
                }
                catch (Exception e2) {
                    logger.error("", e2);
                }
            }
        }
        return retStrs;
    }

    protected void setActiveConnection(String connectionName, KeyNodeConnector keyNodeConnector) {
        ArrayBlockingQueue<KeyNodeConnector> connList = null;
        connList = (ArrayBlockingQueue<KeyNodeConnector>)allConnectionMap.get(connectionName);
        if (connList == null) {
            connList = new ArrayBlockingQueue<KeyNodeConnector>(512);
        }
        if (connList.offer(keyNodeConnector)) {
            allConnectionMap.put(connectionName, connList);
            connPoolCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addKeyNodeCacheConnectionPool(KeyNodeConnector keyNodeConnector) {
        String connectionFullName = null;
        if (keyNodeConnector != null) {
            connectionFullName = keyNodeConnector.getNodeFullName();
            if (keyNodeConnectPool.containsKey(connectionFullName)) {
                ((ArrayBlockingQueue)keyNodeConnectPool.get(connectionFullName)).offer(keyNodeConnector);
            } else {
                ConcurrentHashMap concurrentHashMap = keyNodeConnectPool;
                synchronized (concurrentHashMap) {
                    if (!keyNodeConnectPool.containsKey(connectionFullName)) {
                        ArrayBlockingQueue<KeyNodeConnector> connPoolQueue = new ArrayBlockingQueue<KeyNodeConnector>(20000);
                        connPoolQueue.offer(keyNodeConnector);
                        keyNodeConnectPool.put(connectionFullName, connPoolQueue);
                    } else {
                        this.addKeyNodeCacheConnectionPool(keyNodeConnector);
                    }
                }
            }
        }
    }

    protected void executeKeyNodeOptimization(boolean flg) {
        executeKeyNodeOptimizationFlg = flg;
    }

    protected boolean isExecuteKeyNodeOptimization() {
        return executeKeyNodeOptimizationFlg;
    }

    protected HashMap getConsistentHashMoveData() {
        return moveData4ConsistentHash;
    }

    protected void setConsistentHashMoveData(HashMap map) {
        moveData4ConsistentHash = map;
    }

    protected void removeConsistentHashMoveData() {
        moveData4ConsistentHash = null;
    }

    protected void setNowNodeDataOptimization(boolean flg) {
        nowNodeDataOptimization = flg;
    }

    protected boolean getNowNodeDataOptimization() {
        return nowNodeDataOptimization;
    }

    protected KeyNodeConnector getActiveConnection(String connectionName) {
        KeyNodeConnector keyNodeConnector = null;
        ArrayBlockingQueue connList = (ArrayBlockingQueue)allConnectionMap.get(connectionName);
        if (connList != null && (keyNodeConnector = (KeyNodeConnector)connList.poll()) != null) {
            connPoolCount.decrementAndGet();
            if (!this.checkConnectionEffective(connectionName, keyNodeConnector.getConnetTime())) {
                return null;
            }
        }
        return keyNodeConnector;
    }

    protected int getNowConnectionPoolCount() {
        return connPoolCount.intValue();
    }
}

