/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import okuyama.imdst.util.CoreMapKey;
import okuyama.imdst.util.ICoreValueConverter;
import okuyama.imdst.util.SystemUtil;

public class MemoryModeCoreValueCnv
implements ICoreValueConverter {
    public static volatile int compressUnderLimitSize = 128;

    @Override
    public Object convertEncodeKey(Object key) {
        if (key == null) {
            return null;
        }
        return new CoreMapKey(((String)key).getBytes());
    }

    @Override
    public Object convertEncodeValue(Object value) {
        if (value == null) {
            return null;
        }
        byte[] valueBytes = ((String)value).getBytes();
        if (valueBytes.length < compressUnderLimitSize) {
            int size = valueBytes.length + 1;
            byte[] returnBytes = new byte[size];
            returnBytes[0] = 33;
            for (int i = 1; i < size; ++i) {
                returnBytes[i] = valueBytes[i - 1];
            }
            return returnBytes;
        }
        return SystemUtil.valueCompress(valueBytes);
    }

    @Override
    public Object convertDecodeKey(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof CoreMapKey) {
            return new String(((CoreMapKey)key).getDatas());
        }
        return key;
    }

    @Override
    public Object convertDecodeValue(Object value) {
        if (value == null) {
            return null;
        }
        byte[] valueBytes = (byte[])value;
        String returnStr = null;
        returnStr = valueBytes[0] == 33 ? new String(valueBytes, 1, valueBytes.length - 1) : new String(SystemUtil.valueDecompress(valueBytes));
        return returnStr;
    }
}

