/*
 * Decompiled with CFR 0.152.
 */
package okuyama.base.job;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okuyama.base.job.AbstractHelper;
import okuyama.base.lang.BatchException;
import okuyama.base.parameter.config.ConfigFolder;
import okuyama.base.parameter.config.JobConfigMap;
import okuyama.base.util.HelperPool;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;

public abstract class AbstractJob
extends Thread {
    private ILogger logger = LoggerFactory.createLogger(AbstractJob.class);
    private String preProcessRet = null;
    private String postProcessRet = null;
    public static String WAIT = "job_wait";
    public static String RUN = "job_run";
    public static String ERR = "job_err";
    public static String END;
    protected static String SUCCESS;
    protected static String ERROR;
    protected String status = WAIT;
    protected JobConfigMap jobConfigMap = null;
    private static ConcurrentHashMap jobParamShareMap;

    public void setConfig(JobConfigMap jobConfigMap) {
        this.jobConfigMap = jobConfigMap;
    }

    public abstract void initJob(String var1);

    public abstract String executeJob(String var1) throws BatchException;

    @Override
    public void run() {
        block6: {
            this.logger.debug("Execution - Start");
            String retStatus = null;
            this.status = RUN;
            try {
                this.initJob(this.jobConfigMap.getJobInit());
                retStatus = this.executeJob(this.jobConfigMap.getJobOption());
                if (retStatus != null) {
                    if (retStatus.equals(SUCCESS)) {
                        this.status = retStatus;
                        break block6;
                    }
                    if (retStatus.equals(ERROR)) {
                        this.status = retStatus;
                        break block6;
                    }
                    throw new BatchException("Job End Return Value Error");
                }
                throw new BatchException("Job End Return Value Error");
            }
            catch (BatchException be) {
                this.logger.error("AbstractJob - Error", be);
                this.status = ERR;
            }
            catch (Exception e) {
                this.logger.error("AbstractJob - Error", e);
                this.status = ERR;
            }
        }
        this.logger.debug("Execution End");
    }

    protected int executeHelperQueue(String helperName, Object[] helpreParams, Object[] inputHelperShareParam) throws BatchException {
        this.logger.debug("executeHelperQueue - start");
        int ret = 0;
        AbstractHelper helper = null;
        try {
            while ((helper = HelperPool.getHelper(helperName)) == null) {
            }
            for (int i = 0; i < inputHelperShareParam.length; i += 2) {
                helper.setHelperShareParam(inputHelperShareParam[i], inputHelperShareParam[i + 1]);
            }
            helper.addParameterQueue(helpreParams);
            helper.setParameters(null);
            HelperPool.returnHelper(helperName, helper);
            ret = helper.hashCode();
        }
        catch (BatchException be) {
            this.logger.error("createHelper - BatchException");
            throw be;
        }
        catch (Exception e) {
            this.logger.error("createHelper - Exception");
            throw new BatchException(e);
        }
        this.logger.debug("executeHelper - end");
        return ret;
    }

    protected int executeHelperQueue(String helperName, Object[] helpreParams) throws BatchException {
        this.logger.debug("executeHelperQueue - start");
        int ret = 0;
        AbstractHelper helper = null;
        try {
            while ((helper = HelperPool.getHelper(helperName)) == null) {
            }
            helper.addParameterQueue(helpreParams);
            helper.setParameters(null);
            HelperPool.returnHelper(helperName, helper);
            ret = helper.hashCode();
        }
        catch (BatchException be) {
            this.logger.error("createHelper - BatchException");
            throw be;
        }
        catch (Exception e) {
            this.logger.error("createHelper - Exception");
            throw new BatchException(e);
        }
        this.logger.debug("executeHelper - end");
        return ret;
    }

    protected void createUniqueHelperParamQueue(String helperName, int size) throws Exception {
        HelperPool.createUniqueHelperParamQueue(helperName, size);
    }

    protected void addSpecificationParameterQueue(String helperName, Object[] params) throws Exception {
        HelperPool.addSpecificationParameterQueue(helperName, params);
    }

    protected void addHelperQueueParam(Object[] params) throws Exception {
        HelperPool.addParameterQueue(params);
    }

    protected int executeHelper(String helperName, Object[] helpreParams) throws BatchException {
        return this.executeHelper(helperName, helpreParams, false);
    }

    protected int executeHelper(String helperName, Object[] helpreParams, boolean reboot) throws BatchException {
        this.logger.debug("executeHelper - start");
        int ret = 0;
        AbstractHelper helper = null;
        try {
            while ((helper = HelperPool.getHelper(helperName)) == null) {
            }
            helper.setParameters(helpreParams);
            helper.setReboot(reboot);
            HelperPool.returnHelper(helperName, helper);
            ret = helper.hashCode();
        }
        catch (BatchException be) {
            this.logger.error("createHelper - BatchException");
            throw be;
        }
        catch (Exception e) {
            this.logger.error("createHelper - Exception");
            throw new BatchException(e);
        }
        this.logger.debug("executeHelper - end");
        return ret;
    }

    protected int executeHelper(String helperName, Object[] helpreParams, boolean reboot, Object[] inputHelperShareParam) throws BatchException {
        this.logger.debug("executeHelper - start");
        int ret = 0;
        AbstractHelper helper = null;
        try {
            while ((helper = HelperPool.getHelper(helperName)) == null) {
            }
            for (int i = 0; i < inputHelperShareParam.length; i += 2) {
                helper.setHelperShareParam(inputHelperShareParam[i], inputHelperShareParam[i + 1]);
            }
            helper.setParameters(helpreParams);
            helper.setReboot(reboot);
            HelperPool.returnHelper(helperName, helper);
            ret = helper.hashCode();
        }
        catch (BatchException be) {
            this.logger.error("createHelper - BatchException");
            throw be;
        }
        catch (Exception e) {
            this.logger.error("createHelper - Exception");
            throw new BatchException(e);
        }
        this.logger.debug("executeHelper - end");
        return ret;
    }

    protected String getPropertiesValue(String key) {
        return ConfigFolder.getJobUserParam(key);
    }

    protected boolean isJobFileChange() throws BatchException {
        return ConfigFolder.isJobFileChange();
    }

    protected void reloadJobFileParameter(String[] keys) throws BatchException {
        ConfigFolder.reloadJobFileParameter(keys);
    }

    public String getStatus() {
        return this.status;
    }

    public String getHelperStatus(int code) {
        return HelperPool.getHelperStatus(code);
    }

    public int getActiveHelperCount(String helperName) {
        return HelperPool.getActiveHelperInstanceCount(helperName);
    }

    public Object removeHelperReturnParam(int code) throws BatchException {
        Object ret = null;
        if (!HelperPool.getHelperStatus(code).equals("job_end")) {
            throw new BatchException("Helper No End Status!!");
        }
        ret = HelperPool.getReturnParam(code);
        HelperPool.cleanEndHelper(code);
        return ret;
    }

    public Object[] waitGetHelperReturnParam(int helperCode, int limitTime) throws BatchException {
        Object[] ret = null;
        Object helperRet = null;
        try {
            for (int i = 0; i < limitTime; ++i) {
                if (this.getHelperStatus(helperCode).equals("job_end")) {
                    helperRet = this.removeHelperReturnParam(helperCode);
                    ret = new Object[]{"job_end", helperRet};
                    break;
                }
                if (this.getHelperStatus(helperCode).equals("job_err")) {
                    ret = new Object[]{"job_err", null};
                    break;
                }
                Thread.sleep(980L);
            }
        }
        catch (BatchException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return ret;
    }

    public String getJobName() {
        return this.jobConfigMap.getJobName();
    }

    public void setJobShareParam(Object key, Object val) {
        jobParamShareMap.put(key, val);
    }

    public Object getJobShareParam(Object key) {
        Object ret = null;
        if (jobParamShareMap.containsKey(key)) {
            ret = jobParamShareMap.get(key);
        }
        return ret;
    }

    public Object[] getJobShareParamKeys() {
        Set keys = jobParamShareMap.keySet();
        Object[] keyList = new Object[keys.size()];
        int index = 0;
        if (keys != null) {
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                keyList[index] = iterator.next();
                ++index;
            }
        }
        return keyList;
    }

    public void setPreProcess(String preProcessRet) {
        this.preProcessRet = preProcessRet;
    }

    public void setPostProcess(String postProcessRet) {
        this.postProcessRet = postProcessRet;
    }

    protected String getPreProcess() {
        return this.preProcessRet;
    }

    protected String getPostProcess() {
        return this.postProcessRet;
    }

    static {
        SUCCESS = END = "job_end";
        ERROR = ERR;
        jobParamShareMap = new ConcurrentHashMap(10, 10.0f, 10);
    }
}

