/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

public class UtilClient {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("args[0]=Command");
            System.out.println("Command1. DataExport args1=bkup args2=DataNode-IPAdress args3=DataNode-Port");
            System.out.println("Command2. TruncateData args1=truncatedata args2=MainMasterNode-IPAdress args3=MainMasterNode-Port args4=IsolationName or 'all'");
            System.out.println("Command3. MasterNodeConfigCheck args1=masterconfig args2=MainMasterNode-IPAdress args3=MainMasterNode-Port");
            System.exit(1);
        }
        if (args[0].trim().equals("dataexport") || args[0].trim().equals("bkup")) {
            if (args.length != 3) {
                System.out.println("Argument Error! args[0]=dataexport or bkup, args[1]=serverip, args[2]=port");
                System.exit(1);
            }
            UtilClient.dataExport(args[1], Integer.parseInt(args[2]));
        }
        if (args[0].trim().equals("truncatedata")) {
            if (args.length != 4) {
                System.out.println("Argument Error! args[0]=truncatedata, args[1]=MainMasterNodeServerIp, args[2]=port, args[3]=IsolationPrefix or 'all'");
                System.exit(1);
            }
            UtilClient.truncateData(args[1], Integer.parseInt(args[2]), args[3]);
        }
        if (args[0].trim().equals("masterconfig")) {
            if (args.length != 3) {
                System.out.println("Argument Error! args[0]=masterconfig, args[1]=MainMasterNodeServerIp, args[2]=port");
                System.exit(1);
            }
            UtilClient.masterNodeConfigCheck(args[1], Integer.parseInt(args[2]));
        }
        if (args[0].equals("fulldataexport")) {
            if (args.length != 3) {
                System.out.println("Argument Error! args[0]=Command, args[1]=serverip, args[2]=port");
                System.exit(1);
            }
            UtilClient.dataExport(args[1], Integer.parseInt(args[2]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dataExport(String serverip, int port) {
        Socket socket = null;
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            socket = new Socket();
            InetSocketAddress inetAddr = new InetSocketAddress(serverip, port);
            socket.connect(inetAddr, 10000);
            socket.setSoTimeout(60000);
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8")));
            br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
            pw.println("101");
            pw.flush();
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.equals("-1")) {
                    break;
                }
                System.out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateData(String serverip, int port, String isolationPrefix) {
        Socket socket = null;
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            socket = new Socket();
            InetSocketAddress inetAddr = new InetSocketAddress(serverip, port);
            socket.connect(inetAddr, 10000);
            socket.setSoTimeout(13600000);
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8")));
            br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
            pw.println("61," + isolationPrefix);
            pw.flush();
            System.out.println("Truncate Execute");
            String line = null;
            line = br.readLine();
            if (line != null) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void masterNodeConfigCheck(String serverip, int port) {
        Socket socket = null;
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            socket = new Socket();
            InetSocketAddress inetAddr = new InetSocketAddress(serverip, port);
            socket.connect(inetAddr, 10000);
            socket.setSoTimeout(10000);
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8")));
            br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
            pw.println("998");
            pw.flush();
            String line = null;
            line = br.readLine();
            if (line != null) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

