/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import okuyama.imdst.util.CacheContainer;
import okuyama.imdst.util.CoreFileBaseKeyMap;
import okuyama.imdst.util.FileBaseDataMap;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.InnerCache;
import okuyama.imdst.util.SystemUtil;

class DelayWriteCoreFileBaseKeyMap
extends Thread
implements CoreFileBaseKeyMap {
    private String[] baseFileDirs = null;
    private String[] fileDirs = null;
    private int keyDataLength = new Double((double)ImdstDefine.saveKeyMaxSize * 1.33).intValue() + 1;
    private int oneDataLength = 11;
    private int lineDataSize = this.keyDataLength + this.oneDataLength;
    private int getDataSize = 32768 / this.lineDataSize * this.lineDataSize;
    private int numberOfDataFiles = 1024;
    private int dataDirsFactor = 20;
    private File[] dataFileList = null;
    private InnerCache innerCache = null;
    private AtomicInteger totalSize = null;
    private int innerCacheSize = 128;
    private int numberOfOneFileKey = ImdstDefine.fileBaseMapNumberOfOneFileKey;
    private int nowIterationFileIndex = 0;
    private long nowIterationFpPosition = 0L;
    private ArrayBlockingQueue delayWriteQueue = new ArrayBlockingQueue(8000);
    private ConcurrentHashMap delayWriteDifferenceMap = new ConcurrentHashMap(8000, 7900.0f, 32);
    private long delayWriteRequestCount = 0L;
    private long delayWriteExecCount = 0L;

    public DelayWriteCoreFileBaseKeyMap(String[] dirs, int innerCacheSize, int numberOfKeyData) {
        try {
            this.baseFileDirs = dirs;
            this.innerCacheSize = innerCacheSize;
            if (numberOfKeyData <= this.numberOfOneFileKey) {
                numberOfKeyData = this.numberOfOneFileKey * 2;
            }
            this.numberOfDataFiles = numberOfKeyData / this.numberOfOneFileKey;
            this.init();
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DelayWriteCoreFileBaseKeyMap(String[] dirs, int innerCacheSize, int numberOfKeyData, int numberOfValueSize) {
        try {
            this.oneDataLength = numberOfValueSize;
            this.lineDataSize = this.keyDataLength + this.oneDataLength;
            this.getDataSize = 8192 > this.lineDataSize ? this.lineDataSize * (8192 / this.lineDataSize) * 5 : this.lineDataSize * 1 * 2;
            this.baseFileDirs = dirs;
            this.innerCacheSize = innerCacheSize;
            if (numberOfKeyData <= this.numberOfOneFileKey) {
                numberOfKeyData = this.numberOfOneFileKey * 2;
            }
            this.numberOfDataFiles = numberOfKeyData / this.numberOfOneFileKey;
            this.init();
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
        this.innerCache = new InnerCache(this.innerCacheSize);
        this.totalSize = new AtomicInteger(0);
        this.dataFileList = new File[this.numberOfDataFiles];
        try {
            this.fileDirs = new String[this.baseFileDirs.length * this.dataDirsFactor];
            int counter = 0;
            for (int idx = 0; idx < this.baseFileDirs.length; ++idx) {
                for (int idx2 = 0; idx2 < this.dataDirsFactor; ++idx2) {
                    this.fileDirs[counter] = this.baseFileDirs[idx] + idx2 + "/";
                    File dir = new File(this.fileDirs[counter]);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    ++counter;
                }
            }
            for (int i = 0; i < this.numberOfDataFiles; ++i) {
                File file = new File(this.fileDirs[i % this.fileDirs.length] + i + ".data");
                file.delete();
                this.dataFileList[i] = file;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Object[] instructionObj = (Object[])this.delayWriteQueue.take();
                    String key = (String)instructionObj[0];
                    String value = (String)instructionObj[1];
                    int hashCode = (Integer)instructionObj[2];
                    StringBuilder buf = new StringBuilder(this.lineDataSize);
                    CacheContainer accessor = null;
                    RandomAccessFile raf = null;
                    BufferedWriter wr = null;
                    buf.append(this.fillCharacter(key, this.keyDataLength));
                    buf.append(this.fillCharacter(value, this.oneDataLength));
                    File file = this.dataFileList[hashCode % this.numberOfDataFiles];
                    if (this.innerCache != null) {
                        accessor = (CacheContainer)this.innerCache.get(file.getAbsolutePath());
                    }
                    Serializable serializable = this.dataFileList[hashCode % this.numberOfDataFiles];
                    synchronized (serializable) {
                        if (accessor == null || accessor.isClosed) {
                            raf = new RandomAccessFile(file, "rwd");
                            wr = new BufferedWriter(new FileWriter(file, true));
                            accessor = new CacheContainer();
                            accessor.raf = raf;
                            accessor.wr = wr;
                            accessor.file = file;
                            this.innerCache.put(file.getAbsolutePath(), accessor);
                        } else {
                            raf = accessor.raf;
                            wr = accessor.wr;
                        }
                        for (int tryIdx = 0; tryIdx < 2; ++tryIdx) {
                            try {
                                long[] dataLineNoRet = this.getLinePoint(key, raf);
                                if (dataLineNoRet[0] == -1L) {
                                    wr.write(buf.toString());
                                    SystemUtil.diskAccessSync(wr);
                                    this.totalSize.getAndIncrement();
                                    break;
                                }
                                boolean increMentFlg = false;
                                if (dataLineNoRet[1] == -1L) {
                                    increMentFlg = true;
                                }
                                raf.seek(dataLineNoRet[0] * (long)this.lineDataSize);
                                raf.write(buf.toString().getBytes(), 0, this.lineDataSize);
                                if (!increMentFlg) break;
                                this.totalSize.getAndIncrement();
                                break;
                            }
                            catch (IOException ie) {
                                if (tryIdx == 1) {
                                    throw ie;
                                }
                                if (raf != null) {
                                    raf.close();
                                }
                                if (wr != null) {
                                    wr.close();
                                }
                                raf = new RandomAccessFile(file, "rwd");
                                wr = new BufferedWriter(new FileWriter(file, true));
                                accessor = new CacheContainer();
                                accessor.raf = raf;
                                accessor.wr = wr;
                                accessor.file = file;
                                this.innerCache.put(file.getAbsolutePath(), accessor);
                                continue;
                            }
                        }
                    }
                    if (value.indexOf("&&&&&&&&&&&") == 0) {
                        this.totalSize.getAndDecrement();
                    }
                    serializable = this.delayWriteDifferenceMap;
                    synchronized (serializable) {
                        String removeChcek = (String)this.delayWriteDifferenceMap.get(key);
                        if (removeChcek != null && removeChcek.equals(value)) {
                            this.delayWriteDifferenceMap.remove(key);
                        }
                    }
                    ++this.delayWriteExecCount;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void clear() {
        if (this.innerCache != null) {
            this.innerCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String value, int hashCode) {
        Object[] instructionObj = new Object[]{key, value, new Integer(hashCode)};
        try {
            ConcurrentHashMap concurrentHashMap = this.delayWriteDifferenceMap;
            synchronized (concurrentHashMap) {
                this.delayWriteDifferenceMap.put(key, value);
            }
            this.delayWriteQueue.put(instructionObj);
            ++this.delayWriteRequestCount;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long[] getLinePoint(String key, RandomAccessFile raf) throws Exception {
        long[] ret = new long[]{-1L, 0L};
        long line = -1L;
        long lineCount = 0L;
        byte[] keyBytes = key.getBytes();
        byte[] equalKeyBytes = new byte[keyBytes.length + 1];
        byte[] lineBufs = new byte[this.getDataSize];
        boolean matchFlg = true;
        for (int idx = 0; idx < keyBytes.length; ++idx) {
            equalKeyBytes[idx] = keyBytes[idx];
        }
        equalKeyBytes[equalKeyBytes.length - 1] = new Integer(FileBaseDataMap.paddingSymbol).byteValue();
        try {
            raf.seek(0L);
            int readLen = -1;
            while ((readLen = SystemUtil.diskAccessSync(raf, lineBufs)) != -1) {
                matchFlg = true;
                int loop = readLen / this.lineDataSize;
                for (int loopIdx = 0; loopIdx < loop; ++loopIdx) {
                    int assist = this.lineDataSize * loopIdx;
                    matchFlg = true;
                    if (equalKeyBytes[equalKeyBytes.length - 1] == lineBufs[assist + (equalKeyBytes.length - 1)]) {
                        for (int i = 0; i < equalKeyBytes.length; ++i) {
                            if (equalKeyBytes[i] == lineBufs[assist + i]) continue;
                            matchFlg = false;
                            break;
                        }
                    } else {
                        matchFlg = false;
                    }
                    if (matchFlg) {
                        line = lineCount;
                        if (lineBufs[assist + this.keyDataLength] != FileBaseDataMap.paddingSymbol) break;
                        ret[1] = -1L;
                        break;
                    }
                    ++lineCount;
                }
                if (!matchFlg) continue;
                break;
            }
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception e) {
            throw e;
        }
        ret[0] = line;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key, int hashCode) {
        if (this.delayWriteDifferenceMap.containsKey(key)) {
            String retStr = (String)this.delayWriteDifferenceMap.get(key);
            if (retStr == null) {
                return null;
            }
            if (retStr.equals("&&&&&&&&&&&")) {
                return null;
            }
            return retStr;
        }
        byte[] tmpBytes = null;
        String ret = null;
        byte[] keyBytes = key.getBytes();
        byte[] equalKeyBytes = new byte[keyBytes.length + 1];
        byte[] lineBufs = new byte[this.getDataSize];
        boolean matchFlg = true;
        for (int idx = 0; idx < keyBytes.length; ++idx) {
            equalKeyBytes[idx] = keyBytes[idx];
        }
        equalKeyBytes[equalKeyBytes.length - 1] = new Integer(FileBaseDataMap.paddingSymbol).byteValue();
        try {
            File file = this.dataFileList[hashCode % this.numberOfDataFiles];
            CacheContainer accessor = null;
            RandomAccessFile raf = null;
            BufferedWriter wr = null;
            if (this.innerCache != null) {
                accessor = (CacheContainer)this.innerCache.get(file.getAbsolutePath());
            }
            File file2 = this.dataFileList[hashCode % this.numberOfDataFiles];
            synchronized (file2) {
                if (accessor == null || accessor.isClosed) {
                    raf = new RandomAccessFile(file, "rwd");
                    wr = new BufferedWriter(new FileWriter(file, true));
                    accessor = new CacheContainer();
                    accessor.raf = raf;
                    accessor.wr = wr;
                    accessor.file = file;
                    this.innerCache.put(file.getAbsolutePath(), accessor);
                } else {
                    raf = accessor.raf;
                }
                block10: for (int tryIdx = 0; tryIdx < 2; ++tryIdx) {
                    try {
                        raf.seek(0L);
                        int readLen = -1;
                        while ((readLen = SystemUtil.diskAccessSync(raf, lineBufs)) != -1) {
                            matchFlg = true;
                            int loop = readLen / this.lineDataSize;
                            for (int loopIdx = 0; loopIdx < loop; ++loopIdx) {
                                int i;
                                int assist = this.lineDataSize * loopIdx;
                                matchFlg = true;
                                if (equalKeyBytes[equalKeyBytes.length - 1] == lineBufs[assist + (equalKeyBytes.length - 1)]) {
                                    for (i = 0; i < equalKeyBytes.length; ++i) {
                                        if (equalKeyBytes[i] == lineBufs[assist + i]) continue;
                                        matchFlg = false;
                                        break;
                                    }
                                } else {
                                    matchFlg = false;
                                }
                                if (!matchFlg) continue;
                                tmpBytes = new byte[this.lineDataSize];
                                for (i = 0; i < this.lineDataSize; ++i) {
                                    tmpBytes[i] = lineBufs[assist + i];
                                }
                                break;
                            }
                            if (!matchFlg) continue;
                            break block10;
                        }
                        break;
                    }
                    catch (IOException ie) {
                        if (tryIdx == 1) {
                            throw ie;
                        }
                        if (raf != null) {
                            raf.close();
                        }
                        if (wr != null) {
                            wr.close();
                        }
                        raf = new RandomAccessFile(file, "rwd");
                        wr = new BufferedWriter(new FileWriter(file, true));
                        accessor = new CacheContainer();
                        accessor.raf = raf;
                        accessor.wr = wr;
                        accessor.file = file;
                        this.innerCache.put(file.getAbsolutePath(), accessor);
                        continue;
                    }
                }
            }
            if (tmpBytes != null && tmpBytes[this.keyDataLength] != FileBaseDataMap.paddingSymbol) {
                int counter = 0;
                for (int i = this.keyDataLength; i < tmpBytes.length && tmpBytes[i] != FileBaseDataMap.paddingSymbol; ++i) {
                    ++counter;
                }
                ret = new String(tmpBytes, this.keyDataLength, counter, "UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public String remove(String key, int hashCode) {
        String ret = null;
        ret = this.get(key, hashCode);
        if (ret != null) {
            this.put(key, "&&&&&&&&&&&", hashCode);
        }
        return ret;
    }

    @Override
    public AtomicInteger getTotalSize() {
        return this.totalSize;
    }

    private String fillCharacter(String data, int fixSize) {
        return SystemUtil.fillCharacter(data, fixSize, FileBaseDataMap.paddingSymbol);
    }

    public int getCacheSize() {
        return this.innerCache.getSize();
    }

    @Override
    public void startKeyIteration() {
        this.nowIterationFileIndex = 0;
        this.nowIterationFpPosition = 0L;
        long nowDelayRequestCount = this.delayWriteRequestCount;
        while (nowDelayRequestCount > this.delayWriteExecCount) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getAllOneFileInKeys() {
        ArrayList<String> keys = null;
        byte[] datas = null;
        StringBuilder keysBuf = null;
        RandomAccessFile raf = null;
        try {
            if (this.nowIterationFileIndex < this.dataFileList.length) {
                keys = new ArrayList<String>();
                datas = new byte[new Long(this.dataFileList[this.nowIterationFileIndex].length()).intValue()];
                raf = new RandomAccessFile(this.dataFileList[this.nowIterationFileIndex], "rwd");
                raf.seek(0L);
                int readLen = -1;
                readLen = SystemUtil.diskAccessSync(raf, datas);
                if (readLen > 0) {
                    int loop = readLen / this.lineDataSize;
                    for (int loopIdx = 0; loopIdx < loop; ++loopIdx) {
                        int assist = this.lineDataSize * loopIdx;
                        keysBuf = new StringBuilder(8192);
                        int idx = 0;
                        while (datas[assist + idx] != FileBaseDataMap.paddingSymbol) {
                            keysBuf.append(new String(datas, assist + idx, 1));
                            ++idx;
                        }
                        keys.add(keysBuf.toString());
                        keysBuf = null;
                    }
                }
            }
            ++this.nowIterationFileIndex;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
                raf = null;
                datas = null;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return keys;
    }
}

