/*
 * Decompiled with CFR 0.152.
 */
package com.danga.MemCached;

import com.danga.MemCached.Logger;
import com.danga.MemCached.NativeHandler;
import com.danga.MemCached.NestedIOException;
import com.danga.MemCached.SockIOPool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class MemCachedClient {
    private static Logger log = Logger.getLogger(MemCachedClient.class.getName());
    private static final String VALUE = "VALUE";
    private static final String STATS = "STAT";
    private static final String DELETED = "DELETED";
    private static final String NOTFOUND = "NOT_FOUND";
    private static final String STORED = "STORED";
    private static final String NOTSTORED = "NOT_STORED";
    private static final String OK = "OK";
    private static final String END = "END";
    private static final String ERROR = "ERROR";
    private static final String CLIENT_ERROR = "CLIENT_ERROR";
    private static final String SERVER_ERROR = "SERVER_ERROR";
    private static final int F_COMPRESSED = 2;
    private static final int F_SERIALIZED = 8;
    private boolean primitiveAsString;
    private boolean compressEnable;
    private long compressThreshold;
    private String defaultEncoding;

    public MemCachedClient() {
        this.init();
    }

    private void init() {
        this.primitiveAsString = false;
        this.compressEnable = true;
        this.compressThreshold = 15360L;
        this.defaultEncoding = "UTF-8";
    }

    public void setPrimitiveAsString(boolean primitiveAsString) {
        this.primitiveAsString = primitiveAsString;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setCompressEnable(boolean compressEnable) {
        this.compressEnable = compressEnable;
    }

    public void setCompressThreshold(long compressThreshold) {
        this.compressThreshold = compressThreshold;
    }

    public boolean delete(String key) {
        return this.delete(key, null, null);
    }

    public boolean delete(String key, Date expiry) {
        return this.delete(key, null, expiry);
    }

    public boolean delete(String key, Integer hashCode, Date expiry) {
        SockIOPool.SockIO sock = SockIOPool.getInstance().getSock(key, hashCode);
        if (sock == null) {
            return false;
        }
        StringBuffer command = new StringBuffer("delete " + key);
        if (expiry != null) {
            command.append(" " + expiry.getTime() / 1000L);
        }
        command.append("\r\n");
        try {
            sock.write(command.toString().getBytes());
            sock.flush();
            String line = sock.readLine();
            if (DELETED.equals(line)) {
                sock.close();
                return true;
            }
            if (!NOTFOUND.equals(line)) {
                log.error("++++ error deleting key: " + key);
                log.error(line);
            }
        }
        catch (IOException e) {
            log.error("++++ exception thrown while writing bytes to server on delete");
            log.error(e.getMessage(), e);
            try {
                sock.trueClose();
            }
            catch (IOException ioe) {
                log.error("++++ failed to close socket : " + sock.toString());
            }
            sock = null;
        }
        if (sock != null) {
            sock.close();
        }
        return false;
    }

    public boolean set(String key, Object value) {
        return this.set("set", key, value, null, null, this.primitiveAsString);
    }

    public boolean set(String key, Object value, Integer hashCode) {
        return this.set("set", key, value, null, hashCode, this.primitiveAsString);
    }

    public boolean set(String key, Object value, Date expiry) {
        return this.set("set", key, value, expiry, null, this.primitiveAsString);
    }

    public boolean set(String key, Object value, Date expiry, Integer hashCode) {
        return this.set("set", key, value, expiry, hashCode, this.primitiveAsString);
    }

    public boolean add(String key, Object value) {
        return this.set("add", key, value, null, null, this.primitiveAsString);
    }

    public boolean add(String key, Object value, Integer hashCode) {
        return this.set("add", key, value, null, hashCode, this.primitiveAsString);
    }

    public boolean add(String key, Object value, Date expiry) {
        return this.set("add", key, value, expiry, null, this.primitiveAsString);
    }

    public boolean add(String key, Object value, Date expiry, Integer hashCode) {
        return this.set("add", key, value, expiry, hashCode, this.primitiveAsString);
    }

    public boolean replace(String key, Object value) {
        return this.set("replace", key, value, null, null, this.primitiveAsString);
    }

    public boolean replace(String key, Object value, Integer hashCode) {
        return this.set("replace", key, value, null, hashCode, this.primitiveAsString);
    }

    public boolean replace(String key, Object value, Date expiry) {
        return this.set("replace", key, value, expiry, null, this.primitiveAsString);
    }

    public boolean replace(String key, Object value, Date expiry, Integer hashCode) {
        return this.set("replace", key, value, expiry, hashCode, this.primitiveAsString);
    }

    private boolean set(String cmdname, String key, Object value, Date expiry, Integer hashCode, boolean asString) {
        ByteArrayOutputStream bos;
        byte[] val;
        SockIOPool.SockIO sock = SockIOPool.getInstance().getSock(key, hashCode);
        if (sock == null) {
            return false;
        }
        if (expiry == null) {
            expiry = new Date(0L);
        }
        int flags = 0;
        if (NativeHandler.isHandled(value)) {
            if (asString) {
                try {
                    val = value.toString().getBytes(this.defaultEncoding);
                }
                catch (UnsupportedEncodingException ue) {
                    log.error("invalid encoding type used: " + this.defaultEncoding);
                    sock.close();
                    return false;
                }
            } else {
                try {
                    val = NativeHandler.encode(value);
                }
                catch (Exception e) {
                    log.error("Failed to native handle obj", e);
                    sock.close();
                    return false;
                }
            }
        } else {
            try {
                bos = new ByteArrayOutputStream();
                new ObjectOutputStream(bos).writeObject(value);
                val = bos.toByteArray();
                flags |= 8;
            }
            catch (IOException e) {
                log.error("failed to serialize obj", e);
                log.error(value.toString());
                sock.close();
                return false;
            }
        }
        if (this.compressEnable && (long)val.length > this.compressThreshold) {
            try {
                bos = new ByteArrayOutputStream(val.length);
                GZIPOutputStream gos = new GZIPOutputStream(bos);
                gos.write(val, 0, val.length);
                gos.finish();
                val = bos.toByteArray();
                flags |= 2;
            }
            catch (IOException e) {
                log.error("IOException while compressing stream: " + e.getMessage());
                log.error("storing data uncompressed");
            }
        }
        try {
            String cmd = cmdname + " " + key + " " + flags + " " + expiry.getTime() / 1000L + " " + val.length + "\r\n";
            sock.write(cmd.getBytes());
            sock.write(val);
            sock.write("\r\n".getBytes());
            sock.flush();
            String line = sock.readLine();
            if (STORED.equals(line)) {
                sock.close();
                return true;
            }
            if (!NOTSTORED.equals(line)) {
                log.error("++++ error storing data in cache for key: " + key + " -- length: " + val.length);
                log.error(line);
            }
        }
        catch (IOException e) {
            log.error("++++ exception thrown while writing bytes to server on delete");
            log.error(e.getMessage(), e);
            try {
                sock.trueClose();
            }
            catch (IOException ioe) {
                log.error("++++ failed to close socket : " + sock.toString());
            }
            sock = null;
        }
        if (sock != null) {
            sock.close();
        }
        return false;
    }

    public boolean storeCounter(String key, long counter) {
        return this.set("set", key, new Long(counter), null, null, true);
    }

    public boolean storeCounter(String key, Long counter) {
        return this.set("set", key, counter, null, null, true);
    }

    public boolean storeCounter(String key, Long counter, Integer hashCode) {
        return this.set("set", key, counter, null, hashCode, true);
    }

    public long getCounter(String key) {
        return this.getCounter(key, null);
    }

    public long getCounter(String key, Integer hashCode) {
        long counter = -1L;
        try {
            counter = (Long)this.get(key, hashCode);
        }
        catch (Exception ex) {
            log.error("counter not found at key: " + key);
        }
        return counter;
    }

    public long incr(String key) {
        return this.incrdecr("incr", key, 1L, null);
    }

    public long incr(String key, long inc) {
        return this.incrdecr("incr", key, inc, null);
    }

    public long incr(String key, long inc, Integer hashCode) {
        return this.incrdecr("incr", key, inc, hashCode);
    }

    public long decr(String key) {
        return this.incrdecr("decr", key, 1L, null);
    }

    public long decr(String key, long inc) {
        return this.incrdecr("decr", key, inc, null);
    }

    public long decr(String key, long inc, Integer hashCode) {
        return this.incrdecr("decr", key, inc, hashCode);
    }

    private long incrdecr(String cmdname, String key, long inc, Integer hashCode) {
        SockIOPool.SockIO sock = SockIOPool.getInstance().getSock(key, hashCode);
        if (sock == null) {
            return -1L;
        }
        try {
            String cmd = cmdname + " " + key + " " + inc + "\r\n";
            log.debug("++++ memcache incr/decr command: " + cmd);
            sock.write(cmd.getBytes());
            sock.flush();
            String line = sock.readLine();
            if (line.matches("\\d+")) {
                sock.close();
                return Long.parseLong(line);
            }
            if (!NOTFOUND.equals(line)) {
                log.error("error incr/decr key: " + key);
            }
        }
        catch (IOException e) {
            log.error("++++ exception thrown while writing bytes to server on incr/decr");
            log.error(e.getMessage(), e);
            try {
                sock.trueClose();
            }
            catch (IOException ioe) {
                log.error("++++ failed to close socket : " + sock.toString());
            }
            sock = null;
        }
        if (sock != null) {
            sock.close();
        }
        return -1L;
    }

    public Object get(String key) {
        return this.get(key, null);
    }

    public Object get(String key, Integer hashCode) {
        SockIOPool.SockIO sock = SockIOPool.getInstance().getSock(key, hashCode);
        if (sock == null) {
            return null;
        }
        try {
            String cmd = "get " + key + "\r\n";
            log.debug("++++ memcache get command: " + cmd);
            sock.write(cmd.getBytes());
            sock.flush();
            HashMap hm = new HashMap();
            this.loadItems(sock, hm);
            log.debug("++++ memcache: got back " + hm.size() + " results");
            sock.close();
            return hm.get(key);
        }
        catch (IOException e) {
            log.error("++++ exception thrown while trying to get object from cache for key: " + key);
            log.error(e.getMessage(), e);
            try {
                sock.trueClose();
            }
            catch (IOException ioe) {
                log.error("++++ failed to close socket : " + sock.toString());
            }
            sock = null;
            if (sock != null) {
                sock.close();
            }
            return null;
        }
    }

    public Object[] getMultiArray(String[] keys) {
        return this.getMultiArray(keys, null);
    }

    public Object[] getMultiArray(String[] keys, Integer[] hashCodes) {
        Map data = this.getMulti(keys, hashCodes);
        Object[] res = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            res[i] = data.get(keys[i]);
        }
        return res;
    }

    public Map getMulti(String[] keys) {
        return this.getMulti(keys, null);
    }

    public Map getMulti(String[] keys, Integer[] hashCodes) {
        HashMap<String, StringBuffer> sockKeys = new HashMap<String, StringBuffer>();
        for (int i = 0; i < keys.length; ++i) {
            SockIOPool.SockIO sock;
            Integer hash = null;
            if (hashCodes != null && hashCodes.length > i) {
                hash = hashCodes[i];
            }
            if ((sock = SockIOPool.getInstance().getSock(keys[i], hash)) == null) continue;
            if (!sockKeys.containsKey(sock.getHost())) {
                sockKeys.put(sock.getHost(), new StringBuffer());
            }
            ((StringBuffer)sockKeys.get(sock.getHost())).append(" " + keys[i]);
            sock.close();
        }
        HashMap ret = new HashMap();
        Iterator i = sockKeys.keySet().iterator();
        while (i.hasNext()) {
            String host = (String)i.next();
            SockIOPool.SockIO sock = SockIOPool.getInstance().getConnection(host);
            try {
                String cmd = "get" + (StringBuffer)sockKeys.get(host) + "\r\n";
                log.debug("++++ memcache getMulti cmd: " + cmd);
                sock.write(cmd.getBytes());
                sock.flush();
                this.loadItems(sock, ret);
            }
            catch (IOException e) {
                log.error("++++ exception thrown while getting from cache on getMulti");
                log.error(e.getMessage(), e);
                i.remove();
                try {
                    sock.trueClose();
                }
                catch (IOException ioe) {
                    log.error("++++ failed to close socket : " + sock.toString());
                }
                sock = null;
            }
            if (sock == null) continue;
            sock.close();
        }
        log.debug("++++ memcache: got back " + ret.size() + " results");
        return ret;
    }

    private void loadItems(SockIOPool.SockIO sock, Map hm) throws IOException {
        while (true) {
            String line = sock.readLine();
            log.debug("++++ line: " + line);
            if (line.startsWith(VALUE)) {
                Object o;
                String[] info = line.split(" ");
                String key = info[1];
                int flag = Integer.parseInt(info[2]);
                int length = Integer.parseInt(info[3]);
                log.debug("++++ key: " + key);
                log.debug("++++ flags: " + flag);
                log.debug("++++ length: " + length);
                byte[] buf = new byte[length];
                sock.read(buf);
                sock.clearEOL();
                if ((flag & 2) != 0) {
                    try {
                        int count;
                        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(buf.length);
                        byte[] tmp = new byte[2048];
                        while ((count = gzi.read(tmp)) != -1) {
                            bos.write(tmp, 0, count);
                        }
                        buf = bos.toByteArray();
                        gzi.close();
                    }
                    catch (IOException e) {
                        log.error("++++ IOException thrown while trying to uncompress input stream for key: " + key);
                        log.error(e.getMessage(), e);
                        throw new NestedIOException("++++ IOException thrown while trying to uncompress input stream for key: " + key, e);
                    }
                }
                if ((flag & 8) == 0) {
                    if (this.primitiveAsString) {
                        o = new String(buf, this.defaultEncoding);
                    } else {
                        try {
                            o = NativeHandler.decode(buf);
                        }
                        catch (Exception e) {
                            log.error("++++ Exception thrown while trying to deserialize for key: " + key, e);
                            throw new NestedIOException(e);
                        }
                    }
                } else {
                    ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buf));
                    try {
                        o = ois.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        log.error("++++ ClassNotFoundException thrown while trying to deserialize for key: " + key, e);
                        throw new NestedIOException("+++ failed while trying to deserialize for key: " + key, e);
                    }
                }
                hm.put(key, o);
                continue;
            }
            if (END.equals(line)) break;
        }
        log.debug("++++ finished reading from cache server");
    }

    public boolean flushAll() {
        return this.flushAll(null);
    }

    public boolean flushAll(String[] servers) {
        SockIOPool pool = SockIOPool.getInstance();
        if (pool == null) {
            log.error("++++ unable to get SockIOPool instance");
            return false;
        }
        String[] stringArray = servers = servers == null ? pool.getServers() : servers;
        if (servers == null || servers.length <= 0) {
            log.error("++++ no servers to flush");
            return false;
        }
        boolean success = true;
        for (int i = 0; i < servers.length; ++i) {
            SockIOPool.SockIO sock = pool.getConnection(servers[i]);
            if (sock == null) {
                log.error("++++ unable to get connection to : " + servers[i]);
                success = false;
                continue;
            }
            String command = "flush_all\r\n";
            try {
                sock.write(command.getBytes());
                sock.flush();
                String line = sock.readLine();
                success = OK.equals(line) ? success : false;
            }
            catch (IOException e) {
                log.error("++++ exception thrown while writing bytes to server on delete");
                log.error(e.getMessage(), e);
                try {
                    sock.trueClose();
                }
                catch (IOException ioe) {
                    log.error("++++ failed to close socket : " + sock.toString());
                }
                success = false;
                sock = null;
            }
            if (sock == null) continue;
            sock.close();
        }
        return success;
    }

    public Map stats() {
        return this.stats(null);
    }

    public Map stats(String[] servers) {
        SockIOPool pool = SockIOPool.getInstance();
        if (pool == null) {
            log.error("++++ unable to get SockIOPool instance");
            return null;
        }
        String[] stringArray = servers = servers == null ? pool.getServers() : servers;
        if (servers == null || servers.length <= 0) {
            log.error("++++ no servers to check stats");
            return null;
        }
        HashMap statsMaps = new HashMap();
        for (int i = 0; i < servers.length; ++i) {
            SockIOPool.SockIO sock = pool.getConnection(servers[i]);
            if (sock == null) {
                log.error("++++ unable to get connection to : " + servers[i]);
                continue;
            }
            String command = "stats\r\n";
            try {
                sock.write(command.getBytes());
                sock.flush();
                HashMap<String, String> stats = new HashMap<String, String>();
                while (true) {
                    String line = sock.readLine();
                    log.debug("++++ line: " + line);
                    if (line.startsWith(STATS)) {
                        String[] info = line.split(" ");
                        String key = info[1];
                        String value = info[2];
                        log.debug("++++ key  : " + key);
                        log.debug("++++ value: " + value);
                        stats.put(key, value);
                    } else if (END.equals(line)) {
                        log.debug("++++ finished reading from cache server");
                        break;
                    }
                    statsMaps.put(servers[i], stats);
                }
            }
            catch (IOException e) {
                log.error("++++ exception thrown while writing bytes to server on delete");
                log.error(e.getMessage(), e);
                try {
                    sock.trueClose();
                }
                catch (IOException ioe) {
                    log.error("++++ failed to close socket : " + sock.toString());
                }
                sock = null;
            }
            if (sock == null) continue;
            sock.close();
        }
        return statsMaps;
    }
}

