/*
 * Decompiled with CFR 0.152.
 */
package com.danga.MemCached.test;

import com.danga.MemCached.MemCachedClient;
import com.danga.MemCached.SockIOPool;
import java.util.Date;

public class UnitTests {
    public static MemCachedClient mc = null;

    public static void test1() throws Exception {
        mc.set("foo", Boolean.TRUE);
        Boolean b = (Boolean)mc.get("foo");
        if (!b.booleanValue()) {
            throw new Exception();
        }
    }

    public static void test2() throws Exception {
        mc.set("foo", new Integer(Integer.MAX_VALUE));
        Integer i = (Integer)mc.get("foo");
        if (i != Integer.MAX_VALUE) {
            throw new Exception();
        }
    }

    public static void test3() throws Exception {
        String input = "test of string encoding";
        mc.set("foo", input);
        String s = (String)mc.get("foo");
        if (!s.equals(input)) {
            throw new Exception();
        }
    }

    public static void test4() throws Exception {
        mc.set("foo", new Character('z'));
        Character c = (Character)mc.get("foo");
        if (c.charValue() != 'z') {
            throw new Exception();
        }
    }

    public static void test5() throws Exception {
        mc.set("foo", new Byte(127));
        Byte b = (Byte)mc.get("foo");
        if (b != 127) {
            throw new Exception();
        }
    }

    public static void test6() throws Exception {
        mc.set("foo", new StringBuffer("hello"));
        StringBuffer o = (StringBuffer)mc.get("foo");
        if (!o.toString().equals("hello")) {
            throw new Exception();
        }
    }

    public static void test7() throws Exception {
        mc.set("foo", new Short(100));
        Short o = (Short)mc.get("foo");
        if (o != 100) {
            throw new Exception();
        }
    }

    public static void test8() throws Exception {
        mc.set("foo", new Long(Long.MAX_VALUE));
        Long o = (Long)mc.get("foo");
        if (o != Long.MAX_VALUE) {
            throw new Exception();
        }
        mc.getCounter("foo");
    }

    public static void test9() throws Exception {
        mc.set("foo", new Double(1.1));
        Double o = (Double)mc.get("foo");
        if (o != 1.1) {
            throw new Exception();
        }
    }

    public static void test10() throws Exception {
        mc.set("foo", new Float(1.1f));
        Float o = (Float)mc.get("foo");
        System.out.println(o.floatValue());
        if (o.floatValue() != 1.1f) {
            throw new Exception();
        }
    }

    public static void test11() throws Exception {
        mc.set("foo", new Integer(100));
        long l = mc.decr("foo");
    }

    public static void test12() throws Exception {
        mc.set("foo", (Object)new Integer(100), new Date(System.currentTimeMillis()));
        Thread.sleep(1000L);
        if (mc.get("foo") != null) {
            throw new Exception();
        }
    }

    public static void test13() throws Exception {
        long i = 0L;
        mc.storeCounter("foo", i);
        mc.incr("foo");
        mc.incr("foo", 5L);
        long j = mc.decr("foo", 2L);
        if (j != 4L) {
            throw new Exception();
        }
    }

    public static void test14() throws Exception {
        Date d1 = new Date();
        mc.set("foo", d1);
        Date d2 = (Date)mc.get("foo");
        if (d1.compareTo(d2) != 0) {
            throw new Exception("date mismatch");
        }
    }

    public static void main(String[] args) throws Exception {
        String[] serverlist = new String[]{"cache0.int.meetup.com:1624"};
        SockIOPool pool = SockIOPool.getInstance();
        pool.setServers(serverlist);
        pool.initialize();
        mc = new MemCachedClient();
        mc.setCompressEnable(false);
        UnitTests.test1();
        UnitTests.test2();
        UnitTests.test3();
        UnitTests.test4();
        UnitTests.test5();
        UnitTests.test6();
        UnitTests.test7();
        UnitTests.test8();
        UnitTests.test9();
        UnitTests.test10();
        UnitTests.test11();
        UnitTests.test12();
        UnitTests.test13();
        UnitTests.test14();
    }
}

