/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.Collection;
import java.util.HashMap;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;

class ReplicasMap {
    private HashMap<Long, ReplicaInfo> map = new HashMap();

    ReplicasMap() {
    }

    ReplicaInfo get(Block block) {
        if (block == null) {
            throw new IllegalArgumentException("Do not expect null block");
        }
        ReplicaInfo replicaInfo = this.get(block.getBlockId());
        if (replicaInfo != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
            return replicaInfo;
        }
        return null;
    }

    ReplicaInfo get(long blockId) {
        return this.map.get(blockId);
    }

    ReplicaInfo add(ReplicaInfo replicaInfo) {
        if (replicaInfo == null) {
            throw new IllegalArgumentException("Do not expect null block");
        }
        return this.map.put(replicaInfo.getBlockId(), replicaInfo);
    }

    ReplicaInfo remove(Block block) {
        if (block == null) {
            throw new IllegalArgumentException("Do not expect null block");
        }
        Long key = block.getBlockId();
        ReplicaInfo replicaInfo = this.map.get(key);
        if (replicaInfo != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
            return this.remove(key);
        }
        return null;
    }

    ReplicaInfo remove(long blockId) {
        return this.map.remove(blockId);
    }

    int size() {
        return this.map.size();
    }

    Collection<ReplicaInfo> replicas() {
        return this.map.values();
    }
}

