/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

abstract class DfsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    static final Log LOG = LogFactory.getLog((String)DfsServlet.class.getCanonicalName());

    DfsServlet() {
    }

    protected ClientProtocol createNameNodeProxy() throws IOException {
        ServletContext context = this.getServletContext();
        InetSocketAddress nnAddr = (InetSocketAddress)context.getAttribute("name.node.address");
        HdfsConfiguration conf = new HdfsConfiguration((Configuration)context.getAttribute("name.conf"));
        return DFSClient.createNamenode(nnAddr, conf);
    }

    protected URI createRedirectUri(String servletpath, UserGroupInformation ugi, DatanodeID host, HttpServletRequest request, NameNode nn) throws IOException, URISyntaxException {
        String hostname = host instanceof DatanodeInfo ? ((DatanodeInfo)host).getHostName() : host.getHost();
        String scheme = request.getScheme();
        int port = "https".equals(scheme) ? ((Integer)this.getServletContext().getAttribute("datanode.https.port")).intValue() : host.getInfoPort();
        String filename = request.getPathInfo();
        StringBuilder params = new StringBuilder();
        params.append("filename=");
        params.append(filename);
        if (UserGroupInformation.isSecurityEnabled()) {
            params.append("&delegation=");
            params.append(((Token)ugi.getTokens().iterator().next()).encodeToUrlString());
        } else {
            params.append("&ugi=");
            params.append(ugi.getShortUserName());
        }
        return new URI(scheme, null, hostname, port, servletpath, params.toString(), null);
    }

    protected String getFilename(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filename = request.getParameter("filename");
        if (filename == null || filename.length() == 0) {
            throw new IOException("Invalid filename");
        }
        return filename;
    }

    protected UserGroupInformation getUGI(HttpServletRequest request, Configuration conf) throws IOException {
        return JspHelper.getUGI(request, conf);
    }
}

