/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryWithQuota;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.UserGroupInformation;

class FSDirectory
implements Closeable {
    INodeDirectoryWithQuota rootDir;
    FSImage fsImage;
    private volatile boolean ready = false;
    private static final long UNKNOWN_DISK_SPACE = -1L;
    private final int lsLimit;

    FSDirectory(FSNamesystem ns, Configuration conf) {
        this(new FSImage(), ns, conf);
        if (conf.getBoolean("dfs.namenode.name.dir.restore", false)) {
            NameNode.LOG.info((Object)"set FSImage.restoreFailedStorage");
            this.fsImage.setRestoreFailedStorage(true);
        }
        this.fsImage.setCheckpointDirectories(FSImage.getCheckpointDirs(conf, null), FSImage.getCheckpointEditsDirs(conf, null));
    }

    FSDirectory(FSImage fsImage, FSNamesystem ns, Configuration conf) {
        fsImage.setFSNamesystem(ns);
        this.rootDir = new INodeDirectoryWithQuota("", ns.createFsOwnerPermissions(new FsPermission(493)), Integer.MAX_VALUE, -1L);
        this.fsImage = fsImage;
        int configuredLimit = conf.getInt("dfs.ls.limit", 1000);
        this.lsLimit = configuredLimit > 0 ? configuredLimit : 1000;
    }

    private FSNamesystem getFSNamesystem() {
        return this.fsImage.getFSNamesystem();
    }

    private BlockManager getBlockManager() {
        return this.getFSNamesystem().blockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFSImage(Collection<URI> dataDirs, Collection<URI> editsDirs, HdfsConstants.StartupOption startOpt) throws IOException {
        if (startOpt == HdfsConstants.StartupOption.FORMAT) {
            this.fsImage.setStorageDirectories(dataDirs, editsDirs);
            this.fsImage.format();
            startOpt = HdfsConstants.StartupOption.REGULAR;
        }
        try {
            if (this.fsImage.recoverTransitionRead(dataDirs, editsDirs, startOpt)) {
                this.fsImage.saveNamespace(true);
            }
            FSEditLog editLog = this.fsImage.getEditLog();
            assert (editLog != null) : "editLog must be initialized";
            this.fsImage.setCheckpointDirectories(null, null);
        }
        catch (IOException e) {
            this.fsImage.close();
            throw e;
        }
        FSDirectory fSDirectory = this;
        synchronized (fSDirectory) {
            this.ready = true;
            this.notifyAll();
        }
    }

    private void incrDeletedFileCount(int count) {
        if (this.getFSNamesystem() != null) {
            NameNode.getNameNodeMetrics().numFilesDeleted.inc(count);
        }
    }

    @Override
    public void close() throws IOException {
        this.fsImage.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForReady() {
        if (!this.ready) {
            FSDirectory fSDirectory = this;
            synchronized (fSDirectory) {
                while (!this.ready) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeFileUnderConstruction addFile(String path, PermissionStatus permissions, short replication, long preferredBlockSize, String clientName, String clientMachine, DatanodeDescriptor clientNode, long generationStamp) throws IOException, UnresolvedLinkException {
        this.waitForReady();
        long modTime = FSNamesystem.now();
        if (!this.mkdirs(new Path(path).getParent().toString(), permissions, true, modTime)) {
            return null;
        }
        INodeFileUnderConstruction newNode = new INodeFileUnderConstruction(permissions, replication, preferredBlockSize, modTime, clientName, clientMachine, clientNode);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            newNode = this.addNode(path, newNode, -1L, false);
        }
        if (newNode == null) {
            NameNode.stateChangeLog.info((Object)("DIR* FSDirectory.addFile: failed to add " + path + " to the file system"));
            return null;
        }
        this.fsImage.getEditLog().logOpenFile(path, newNode);
        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " is added to the file system"));
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedAddFile(String path, PermissionStatus permissions, BlockInfo[] blocks, short replication, long modificationTime, long atime, long preferredBlockSize) throws UnresolvedLinkException {
        INode newNode;
        long diskspace = -1L;
        if (blocks == null) {
            newNode = new INodeDirectory(permissions, modificationTime);
        } else {
            newNode = new INodeFile(permissions, blocks.length, replication, modificationTime, atime, preferredBlockSize);
            diskspace = ((INodeFile)newNode).diskspaceConsumed(blocks);
        }
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            try {
                newNode = this.addNode(path, newNode, diskspace, false);
                if (newNode != null && blocks != null) {
                    int nrBlocks = blocks.length;
                    INodeFile newF = (INodeFile)newNode;
                    for (int i = 0; i < nrBlocks; ++i) {
                        newF.setBlock(i, this.getBlockManager().addINode(blocks[i], newF));
                    }
                }
            }
            catch (IOException e) {
                return null;
            }
            return newNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeDirectory addToParent(String src, INodeDirectory parentINode, PermissionStatus permissions, Block[] blocks, String symlink, short replication, long modificationTime, long atime, long nsQuota, long dsQuota, long preferredBlockSize) throws UnresolvedLinkException {
        INode newNode;
        if (blocks == null) {
            newNode = nsQuota >= 0L || dsQuota >= 0L ? new INodeDirectoryWithQuota(permissions, modificationTime, nsQuota, dsQuota) : new INodeDirectory(permissions, modificationTime);
        } else if (symlink.length() != 0) {
            newNode = new INodeSymlink(symlink, modificationTime, atime, permissions);
            ((INodeSymlink)newNode).setLinkValue(symlink);
        } else {
            newNode = new INodeFile(permissions, blocks.length, replication, modificationTime, atime, preferredBlockSize);
        }
        INodeDirectory newParent = null;
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            try {
                newParent = this.rootDir.addToParent(src, newNode, parentINode, false);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            if (newParent == null) {
                return null;
            }
            if (blocks != null) {
                int nrBlocks = blocks.length;
                assert (!newNode.isLink());
                INodeFile newF = (INodeFile)newNode;
                for (int i = 0; i < nrBlocks; ++i) {
                    BlockInfo blockInfo = new BlockInfo(blocks[i], newF.getReplication());
                    newF.setBlock(i, this.getBlockManager().addINode(blockInfo, newF));
                }
            }
        }
        return newParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlockInfo addBlock(String path, INode[] inodes, Block block, DatanodeDescriptor[] targets) throws QuotaExceededException, IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            assert (inodes[inodes.length - 1].isUnderConstruction()) : "INode should correspond to a file under construction";
            INodeFileUnderConstruction fileINode = (INodeFileUnderConstruction)inodes[inodes.length - 1];
            this.updateCount(inodes, inodes.length - 1, 0L, fileINode.getPreferredBlockSize() * (long)fileINode.getReplication(), true);
            BlockInfoUnderConstruction blockInfo = new BlockInfoUnderConstruction(block, fileINode.getReplication(), HdfsConstants.BlockUCState.UNDER_CONSTRUCTION, targets);
            this.getBlockManager().addINode(blockInfo, fileINode);
            fileINode.addBlock(blockInfo);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " with " + block + " block is added to the in-memory " + "file system"));
            return blockInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistBlocks(String path, INodeFileUnderConstruction file) {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.fsImage.getEditLog().logOpenFile(path, file);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.persistBlocks: " + path + " with " + file.getBlocks().length + " blocks is persisted to the file system"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFile(String path, INodeFile file) {
        this.waitForReady();
        long now = FSNamesystem.now();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            file.setModificationTimeForce(now);
            this.fsImage.getEditLog().logCloseFile(path, file);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.closeFile: " + path + " with " + file.getBlocks().length + " blocks is persisted to the file system"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeBlock(String path, INodeFileUnderConstruction fileNode, Block block) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            fileNode.removeLastBlock(block);
            this.getBlockManager().removeBlockFromMap(block);
            this.getBlockManager().removeFromCorruptReplicasMap(block);
            this.fsImage.getEditLog().logOpenFile(path, fileNode);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " with " + block + " block is added to the file system"));
        }
        return true;
    }

    @Deprecated
    boolean renameTo(String src, String dst) throws QuotaExceededException, UnresolvedLinkException, FileAlreadyExistsException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.renameTo: " + src + " to " + dst));
        }
        this.waitForReady();
        long now = FSNamesystem.now();
        if (!this.unprotectedRenameTo(src, dst, now)) {
            return false;
        }
        this.fsImage.getEditLog().logRename(src, dst, now);
        return true;
    }

    void renameTo(String src, String dst, Options.Rename ... options) throws IOException, UnresolvedLinkException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.renameTo: " + src + " to " + dst));
        }
        this.waitForReady();
        long now = FSNamesystem.now();
        if (this.unprotectedRenameTo(src, dst, now, options)) {
            this.incrDeletedFileCount(1);
        }
        this.fsImage.getEditLog().logRename(src, dst, now, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    boolean unprotectedRenameTo(String src, String dst, long timestamp) throws QuotaExceededException, UnresolvedLinkException, FileAlreadyExistsException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            String srcChildName;
            INode srcChild;
            INode dstChild;
            INode[] srcInodes;
            block18: {
                boolean bl;
                block19: {
                    INode[] dstInodes;
                    byte[][] dstComponents;
                    block16: {
                        boolean bl2;
                        block17: {
                            srcInodes = this.rootDir.getExistingPathINodes(src, false);
                            INode srcInode = srcInodes[srcInodes.length - 1];
                            if (srcInode == null) {
                                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source does not exist"));
                                return false;
                            }
                            if (srcInodes.length == 1) {
                                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source is the root"));
                                return false;
                            }
                            if (this.isDir(dst)) {
                                dst = dst + "/" + new Path(src).getName();
                            }
                            if (dst.equals(src)) {
                                return true;
                            }
                            if (srcInode.isLink() && dst.equals(((INodeSymlink)srcInode).getLinkValue())) {
                                throw new FileAlreadyExistsException("Cannot rename symlink " + src + " to its target " + dst);
                            }
                            if (dst.startsWith(src) && dst.charAt(src.length()) == '/') {
                                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination starts with src"));
                                return false;
                            }
                            dstComponents = INode.getPathComponents(dst);
                            dstInodes = new INode[dstComponents.length];
                            this.rootDir.getExistingPathINodes(dstComponents, dstInodes, false);
                            if (dstInodes[dstInodes.length - 1] != null) {
                                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination exists"));
                                return false;
                            }
                            if (dstInodes[dstInodes.length - 2] == null) {
                                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination's parent does not exist"));
                                return false;
                            }
                            this.verifyQuotaForRename(srcInodes, dstInodes);
                            dstChild = null;
                            srcChild = null;
                            srcChildName = null;
                            try {
                                srcChild = this.removeChild(srcInodes, srcInodes.length - 1);
                                if (srcChild != null) break block16;
                                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because the source can not be removed"));
                                bl2 = false;
                                if (dstChild != null || srcChild == null) break block17;
                                srcChild.setLocalName(srcChildName);
                                this.addChildNoQuotaCheck(srcInodes, srcInodes.length - 1, srcChild, -1L, false);
                            }
                            catch (Throwable throwable) {
                                if (dstChild == null && srcChild != null) {
                                    srcChild.setLocalName(srcChildName);
                                    this.addChildNoQuotaCheck(srcInodes, srcInodes.length - 1, srcChild, -1L, false);
                                }
                                throw throwable;
                            }
                        }
                        return bl2;
                    }
                    srcChildName = srcChild.getLocalName();
                    srcChild.setLocalName(dstComponents[dstInodes.length - 1]);
                    dstChild = this.addChildNoQuotaCheck(dstInodes, dstInodes.length - 1, srcChild, -1L, false);
                    if (dstChild == null) break block18;
                    srcChild = null;
                    if (NameNode.stateChangeLog.isDebugEnabled()) {
                        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst));
                    }
                    srcInodes[srcInodes.length - 2].setModificationTime(timestamp);
                    dstInodes[dstInodes.length - 2].setModificationTime(timestamp);
                    bl = true;
                    if (dstChild != null || srcChild == null) break block19;
                    srcChild.setLocalName(srcChildName);
                    this.addChildNoQuotaCheck(srcInodes, srcInodes.length - 1, srcChild, -1L, false);
                }
                return bl;
            }
            if (dstChild == null && srcChild != null) {
                srcChild.setLocalName(srcChildName);
                this.addChildNoQuotaCheck(srcInodes, srcInodes.length - 1, srcChild, -1L, false);
            }
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean unprotectedRenameTo(String src, String dst, long timestamp, Options.Rename ... options) throws IOException, UnresolvedLinkException {
        boolean overwrite = false;
        if (null != options) {
            for (Options.Rename option : options) {
                if (option != Options.Rename.OVERWRITE) continue;
                overwrite = true;
            }
        }
        String error = null;
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode removedDst;
            String dstChildName;
            String srcChildName;
            INode removedSrc;
            INode[] dstInodes;
            INode[] srcInodes;
            block28: {
                boolean bl;
                srcInodes = this.rootDir.getExistingPathINodes(src, false);
                INode srcInode = srcInodes[srcInodes.length - 1];
                if (srcInode == null) {
                    error = "rename source " + src + " is not found.";
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new FileNotFoundException(error);
                }
                if (srcInodes.length == 1) {
                    error = "rename source cannot be the root";
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new IOException(error);
                }
                if (dst.equals(src)) {
                    throw new FileAlreadyExistsException("The source " + src + " and destination " + dst + " are the same");
                }
                if (srcInode.isLink() && dst.equals(((INodeSymlink)srcInode).getLinkValue())) {
                    throw new FileAlreadyExistsException("Cannot rename symlink " + src + " to its target " + dst);
                }
                if (dst.startsWith(src) && dst.charAt(src.length()) == '/') {
                    error = "Rename destination " + dst + " is a directory or file under source " + src;
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new IOException(error);
                }
                byte[][] dstComponents = INode.getPathComponents(dst);
                dstInodes = new INode[dstComponents.length];
                this.rootDir.getExistingPathINodes(dstComponents, dstInodes, false);
                INode dstInode = dstInodes[dstInodes.length - 1];
                if (dstInodes.length == 1) {
                    error = "rename destination cannot be the root";
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new IOException(error);
                }
                if (dstInode != null) {
                    List<INode> children;
                    if (dstInode.isDirectory() != srcInode.isDirectory()) {
                        error = "Source " + src + " and destination " + dst + " must both be directories";
                        NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                        throw new IOException(error);
                    }
                    if (!overwrite) {
                        error = "rename destination " + dst + " already exists";
                        NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                        throw new FileAlreadyExistsException(error);
                    }
                    List<INode> list = children = dstInode.isDirectory() ? ((INodeDirectory)dstInode).getChildrenRaw() : null;
                    if (children != null && children.size() != 0) {
                        error = "rename cannot overwrite non empty destination directory " + dst;
                        NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                        throw new IOException(error);
                    }
                }
                if (dstInodes[dstInodes.length - 2] == null) {
                    error = "rename destination parent " + dst + " not found.";
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new FileNotFoundException(error);
                }
                if (!dstInodes[dstInodes.length - 2].isDirectory()) {
                    error = "rename destination parent " + dst + " is a file.";
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new ParentNotDirectoryException(error);
                }
                this.verifyQuotaForRename(srcInodes, dstInodes);
                removedSrc = this.removeChild(srcInodes, srcInodes.length - 1);
                if (removedSrc == null) {
                    error = "Failed to rename " + src + " to " + dst + " because the source can not be removed";
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new IOException(error);
                }
                srcChildName = removedSrc.getLocalName();
                dstChildName = null;
                removedDst = null;
                try {
                    if (dstInode != null) {
                        removedDst = this.removeChild(dstInodes, dstInodes.length - 1);
                        dstChildName = removedDst.getLocalName();
                    }
                    INode dstChild = null;
                    removedSrc.setLocalName(dstComponents[dstInodes.length - 1]);
                    dstChild = this.addChildNoQuotaCheck(dstInodes, dstInodes.length - 1, removedSrc, -1L, false);
                    int filesDeleted = 0;
                    if (dstChild == null) break block28;
                    removedSrc = null;
                    if (NameNode.stateChangeLog.isDebugEnabled()) {
                        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst));
                    }
                    srcInodes[srcInodes.length - 2].setModificationTime(timestamp);
                    dstInodes[dstInodes.length - 2].setModificationTime(timestamp);
                    if (removedDst != null) {
                        INode rmdst = removedDst;
                        removedDst = null;
                        ArrayList<Block> collectedBlocks = new ArrayList<Block>();
                        filesDeleted = rmdst.collectSubtreeBlocksAndClear(collectedBlocks);
                        this.getFSNamesystem().removePathAndBlocks(src, collectedBlocks);
                    }
                    boolean bl2 = bl = filesDeleted > 0;
                    if (removedSrc != null) {
                        removedSrc.setLocalName(srcChildName);
                        this.addChildNoQuotaCheck(srcInodes, srcInodes.length - 1, removedSrc, -1L, false);
                    }
                }
                catch (Throwable throwable) {
                    if (removedSrc != null) {
                        removedSrc.setLocalName(srcChildName);
                        this.addChildNoQuotaCheck(srcInodes, srcInodes.length - 1, removedSrc, -1L, false);
                    }
                    if (removedDst != null) {
                        removedDst.setLocalName(dstChildName);
                        this.addChildNoQuotaCheck(dstInodes, dstInodes.length - 1, removedDst, -1L, false);
                    }
                    throw throwable;
                }
                if (removedDst != null) {
                    removedDst.setLocalName(dstChildName);
                    this.addChildNoQuotaCheck(dstInodes, dstInodes.length - 1, removedDst, -1L, false);
                }
                return bl;
            }
            if (removedSrc != null) {
                removedSrc.setLocalName(srcChildName);
                this.addChildNoQuotaCheck(srcInodes, srcInodes.length - 1, removedSrc, -1L, false);
            }
            if (removedDst != null) {
                removedDst.setLocalName(dstChildName);
                this.addChildNoQuotaCheck(dstInodes, dstInodes.length - 1, removedDst, -1L, false);
            }
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst));
            throw new IOException("rename from " + src + " to " + dst + " failed.");
        }
    }

    Block[] setReplication(String src, short replication, int[] oldReplication) throws QuotaExceededException, UnresolvedLinkException {
        this.waitForReady();
        Block[] fileBlocks = this.unprotectedSetReplication(src, replication, oldReplication);
        if (fileBlocks != null) {
            this.fsImage.getEditLog().logSetReplication(src, replication);
        }
        return fileBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] unprotectedSetReplication(String src, short replication, int[] oldReplication) throws QuotaExceededException, UnresolvedLinkException {
        if (oldReplication == null) {
            oldReplication = new int[]{-1};
        }
        Block[] fileBlocks = null;
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode[] inodes = this.rootDir.getExistingPathINodes(src, true);
            INode inode = inodes[inodes.length - 1];
            if (inode == null) {
                return null;
            }
            assert (!inode.isLink());
            if (inode.isDirectory()) {
                return null;
            }
            INodeFile fileNode = (INodeFile)inode;
            oldReplication[0] = fileNode.getReplication();
            long dsDelta = (long)(replication - oldReplication[0]) * (fileNode.diskspaceConsumed() / (long)oldReplication[0]);
            this.updateCount(inodes, inodes.length - 1, 0L, dsDelta, true);
            fileNode.setReplication(replication);
            fileBlocks = fileNode.getBlocks();
        }
        return fileBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPreferredBlockSize(String filename) throws IOException, UnresolvedLinkException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(filename, false);
            if (inode == null) {
                throw new FileNotFoundException("File does not exist: " + filename);
            }
            if (inode.isDirectory() || inode.isLink()) {
                throw new IOException("Getting block size of non-file: " + filename);
            }
            return ((INodeFile)inode).getPreferredBlockSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean exists(String src) throws UnresolvedLinkException {
        src = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src, false);
            if (inode == null) {
                return false;
            }
            return inode.isDirectory() || inode.isLink() ? true : ((INodeFile)inode).getBlocks() != null;
        }
    }

    void setPermission(String src, FsPermission permission) throws FileNotFoundException, UnresolvedLinkException {
        this.unprotectedSetPermission(src, permission);
        this.fsImage.getEditLog().logSetPermissions(src, permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprotectedSetPermission(String src, FsPermission permissions) throws FileNotFoundException, UnresolvedLinkException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src, true);
            if (inode == null) {
                throw new FileNotFoundException("File does not exist: " + src);
            }
            inode.setPermission(permissions);
        }
    }

    void setOwner(String src, String username, String groupname) throws FileNotFoundException, UnresolvedLinkException {
        this.unprotectedSetOwner(src, username, groupname);
        this.fsImage.getEditLog().logSetOwner(src, username, groupname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprotectedSetOwner(String src, String username, String groupname) throws FileNotFoundException, UnresolvedLinkException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src, true);
            if (inode == null) {
                throw new FileNotFoundException("File does not exist: " + src);
            }
            if (username != null) {
                inode.setUser(username);
            }
            if (groupname != null) {
                inode.setGroup(groupname);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concatInternal(String target, String[] srcs) throws IOException, UnresolvedLinkException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.waitForReady();
            this.unprotectedConcat(target, srcs);
            this.fsImage.getEditLog().logConcat(target, srcs, FSNamesystem.now());
        }
    }

    public void unprotectedConcat(String target, String[] srcs) throws IOException, UnresolvedLinkException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSNamesystem.concat to " + target));
        }
        INode[] trgINodes = this.getExistingPathINodes(target);
        INodeFile trgInode = (INodeFile)trgINodes[trgINodes.length - 1];
        INodeDirectory trgParent = (INodeDirectory)trgINodes[trgINodes.length - 2];
        INodeFile[] allSrcInodes = new INodeFile[srcs.length];
        int i = 0;
        int totalBlocks = 0;
        for (String src : srcs) {
            INodeFile srcInode = this.getFileINode(src);
            allSrcInodes[i++] = srcInode;
            totalBlocks += srcInode.blocks.length;
        }
        trgInode.appendBlocks(allSrcInodes, totalBlocks);
        int count = 0;
        for (INodeFile nodeToRemove : allSrcInodes) {
            if (nodeToRemove == null) continue;
            nodeToRemove.blocks = null;
            trgParent.removeChild(nodeToRemove);
            ++count;
        }
        long now = FSNamesystem.now();
        trgInode.setModificationTime(now);
        trgParent.setModificationTime(now);
        this.unprotectedUpdateCount(trgINodes, trgINodes.length - 1, -count, 0L);
    }

    boolean delete(String src, List<Block> collectedBlocks) throws UnresolvedLinkException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.delete: " + src));
        }
        this.waitForReady();
        long now = FSNamesystem.now();
        int filesRemoved = this.unprotectedDelete(src, collectedBlocks, now);
        if (filesRemoved <= 0) {
            return false;
        }
        this.incrDeletedFileCount(filesRemoved);
        this.getFSNamesystem().removePathAndBlocks(src, null);
        this.fsImage.getEditLog().logDelete(src, now);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDirEmpty(String src) throws UnresolvedLinkException {
        boolean dirNotEmpty = true;
        if (!this.isDir(src)) {
            return true;
        }
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(src, false);
            assert (targetNode != null) : "should be taken care in isDir() above";
            if (((INodeDirectory)targetNode).getChildren().size() != 0) {
                dirNotEmpty = false;
            }
        }
        return dirNotEmpty;
    }

    boolean isEmpty() {
        try {
            return this.isDirEmpty("/");
        }
        catch (UnresolvedLinkException e) {
            NameNode.stateChangeLog.debug((Object)"/ cannot be a symlink");
            assert (false) : "/ cannot be a symlink";
            return true;
        }
    }

    void unprotectedDelete(String src, long mtime) throws UnresolvedLinkException {
        ArrayList<Block> collectedBlocks = new ArrayList<Block>();
        int filesRemoved = this.unprotectedDelete(src, collectedBlocks, mtime);
        if (filesRemoved > 0) {
            this.getFSNamesystem().removePathAndBlocks(src, collectedBlocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int unprotectedDelete(String src, List<Block> collectedBlocks, long mtime) throws UnresolvedLinkException {
        src = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode[] inodes = this.rootDir.getExistingPathINodes(src, false);
            INode targetNode = inodes[inodes.length - 1];
            if (targetNode == null) {
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not exist"));
                return 0;
            }
            if (inodes.length == 1) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because the root is not allowed to be deleted"));
                return 0;
            }
            int pos = inodes.length - 1;
            targetNode = this.removeChild(inodes, pos);
            if (targetNode == null) {
                return 0;
            }
            inodes[pos - 1].setModificationTime(mtime);
            int filesRemoved = targetNode.collectSubtreeBlocksAndClear(collectedBlocks);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedDelete: " + src + " is removed"));
            }
            return filesRemoved;
        }
    }

    void replaceNode(String path, INodeFile oldnode, INodeFile newnode) throws IOException, UnresolvedLinkException {
        this.replaceNode(path, oldnode, newnode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceNode(String path, INodeFile oldnode, INodeFile newnode, boolean updateDiskspace) throws IOException, UnresolvedLinkException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            long dsOld = oldnode.diskspaceConsumed();
            if (!oldnode.removeNode()) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.replaceNode: failed to remove " + path));
                throw new IOException("FSDirectory.replaceNode: failed to remove " + path);
            }
            this.rootDir.addNode(path, newnode);
            long dsNew = 0L;
            if (updateDiskspace && (dsNew = newnode.diskspaceConsumed()) != dsOld) {
                try {
                    this.updateSpaceConsumed(path, 0L, dsNew - dsOld);
                }
                catch (QuotaExceededException e) {
                    this.replaceNode(path, newnode, oldnode, false);
                    throw e;
                }
            }
            int index = 0;
            for (BlockInfo b : newnode.getBlocks()) {
                BlockInfo info = this.getBlockManager().addINode(b, newnode);
                newnode.setBlock(index, info);
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryListing getListing(String src, byte[] startAfter) throws UnresolvedLinkException {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(srcs, true);
            if (targetNode == null) {
                return null;
            }
            if (!targetNode.isDirectory()) {
                return new DirectoryListing(new HdfsFileStatus[]{FSDirectory.createFileStatus(HdfsFileStatus.EMPTY_NAME, targetNode)}, 0);
            }
            INodeDirectory dirInode = (INodeDirectory)targetNode;
            List<INode> contents = dirInode.getChildren();
            int startChild = dirInode.nextChild(startAfter);
            int totalNumChildren = contents.size();
            int numOfListing = Math.min(totalNumChildren - startChild, this.lsLimit);
            HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
            for (int i = 0; i < numOfListing; ++i) {
                INode cur = contents.get(startChild + i);
                listing[i] = FSDirectory.createFileStatus(cur.name, cur);
            }
            return new DirectoryListing(listing, totalNumChildren - startChild - numOfListing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdfsFileStatus getFileInfo(String src, boolean resolveLink) throws UnresolvedLinkException {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(srcs, resolveLink);
            if (targetNode == null) {
                return null;
            }
            return FSDirectory.createFileStatus(HdfsFileStatus.EMPTY_NAME, targetNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] getFileBlocks(String src) throws UnresolvedLinkException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(src, false);
            if (targetNode == null) {
                return null;
            }
            if (targetNode.isDirectory()) {
                return null;
            }
            if (targetNode.isLink()) {
                return null;
            }
            return ((INodeFile)targetNode).getBlocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeFile getFileINode(String src) throws UnresolvedLinkException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src, true);
            if (inode == null || inode.isDirectory()) {
                return null;
            }
            assert (!inode.isLink());
            return (INodeFile)inode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode[] getExistingPathINodes(String path) throws UnresolvedLinkException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return this.rootDir.getExistingPathINodes(path, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidToCreate(String src) throws UnresolvedLinkException {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return srcs.startsWith("/") && !srcs.endsWith("/") && this.rootDir.getNode(srcs, false) == null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDir(String src) throws UnresolvedLinkException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode node = this.rootDir.getNode(this.normalizePath(src), false);
            return node != null && node.isDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSpaceConsumed(String path, long nsDelta, long dsDelta) throws QuotaExceededException, FileNotFoundException, UnresolvedLinkException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode[] inodes = this.rootDir.getExistingPathINodes(path, false);
            int len = inodes.length;
            if (inodes[len - 1] == null) {
                throw new FileNotFoundException(path + " does not exist under rootDir.");
            }
            this.updateCount(inodes, len - 1, nsDelta, dsDelta, true);
        }
    }

    private void updateCount(INode[] inodes, int numOfINodes, long nsDelta, long dsDelta, boolean checkQuota) throws QuotaExceededException {
        if (!this.ready) {
            return;
        }
        if (numOfINodes > inodes.length) {
            numOfINodes = inodes.length;
        }
        if (checkQuota) {
            this.verifyQuota(inodes, numOfINodes, nsDelta, dsDelta, null);
        }
        for (int i = 0; i < numOfINodes; ++i) {
            if (!inodes[i].isQuotaSet()) continue;
            INodeDirectoryWithQuota node = (INodeDirectoryWithQuota)inodes[i];
            node.updateNumItemsInTree(nsDelta, dsDelta);
        }
    }

    private void updateCountNoQuotaCheck(INode[] inodes, int numOfINodes, long nsDelta, long dsDelta) {
        try {
            this.updateCount(inodes, numOfINodes, nsDelta, dsDelta, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.warn((Object)"FSDirectory.updateCountNoQuotaCheck - unexpected ", (Throwable)e);
        }
    }

    void unprotectedUpdateCount(INode[] inodes, int numOfINodes, long nsDelta, long dsDelta) {
        for (int i = 0; i < numOfINodes; ++i) {
            if (!inodes[i].isQuotaSet()) continue;
            INodeDirectoryWithQuota node = (INodeDirectoryWithQuota)inodes[i];
            node.unprotectedUpdateNumItemsInTree(nsDelta, dsDelta);
        }
    }

    private static String getFullPathName(INode[] inodes, int pos) {
        StringBuilder fullPathName = new StringBuilder();
        for (int i = 1; i <= pos; ++i) {
            fullPathName.append('/').append(inodes[i].getLocalName());
        }
        return fullPathName.toString();
    }

    static String getFullPathName(INode inode) {
        int depth = 0;
        INode i = inode;
        while (i != null) {
            ++depth;
            i = i.parent;
        }
        INode[] inodes = new INode[depth];
        for (int i2 = 0; i2 < depth; ++i2) {
            inodes[depth - i2 - 1] = inode;
            inode = inode.parent;
        }
        return FSDirectory.getFullPathName(inodes, depth - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mkdirs(String src, PermissionStatus permissions, boolean inheritPermission, long now) throws FileAlreadyExistsException, QuotaExceededException, UnresolvedLinkException {
        src = this.normalizePath(src);
        String[] names = INode.getPathNames(src);
        byte[][] components = INode.getPathComponents(names);
        INode[] inodes = new INode[components.length];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            int i;
            this.rootDir.getExistingPathINodes(components, inodes, false);
            StringBuilder pathbuilder = new StringBuilder();
            for (i = 1; i < inodes.length && inodes[i] != null; ++i) {
                pathbuilder.append("/" + names[i]);
                if (inodes[i].isDirectory()) continue;
                throw new FileAlreadyExistsException("Parent path is not a directory: " + pathbuilder + " " + inodes[i].getLocalName());
            }
            while (i < inodes.length) {
                pathbuilder.append("/" + names[i]);
                String cur = pathbuilder.toString();
                this.unprotectedMkdir(inodes, i, components[i], permissions, inheritPermission || i != components.length - 1, now);
                if (inodes[i] == null) {
                    return false;
                }
                if (this.getFSNamesystem() != null) {
                    NameNode.getNameNodeMetrics().numFilesCreated.inc();
                }
                this.fsImage.getEditLog().logMkDir(cur, inodes[i]);
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.mkdirs: created directory " + cur));
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedMkdir(String src, PermissionStatus permissions, long timestamp) throws QuotaExceededException, UnresolvedLinkException {
        byte[][] components = INode.getPathComponents(src);
        INode[] inodes = new INode[components.length];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.rootDir.getExistingPathINodes(components, inodes, false);
            this.unprotectedMkdir(inodes, inodes.length - 1, components[inodes.length - 1], permissions, false, timestamp);
            return inodes[inodes.length - 1];
        }
    }

    private void unprotectedMkdir(INode[] inodes, int pos, byte[] name, PermissionStatus permission, boolean inheritPermission, long timestamp) throws QuotaExceededException {
        inodes[pos] = this.addChild(inodes, pos, new INodeDirectory(name, permission, timestamp), -1L, inheritPermission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends INode> T addNode(String src, T child, long childDiskspace, boolean inheritPermission) throws QuotaExceededException, UnresolvedLinkException {
        byte[][] components = INode.getPathComponents(src);
        child.setLocalName(components[components.length - 1]);
        INode[] inodes = new INode[components.length];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.rootDir.getExistingPathINodes(components, inodes, false);
            return this.addChild(inodes, inodes.length - 1, child, childDiskspace, inheritPermission);
        }
    }

    private void verifyQuota(INode[] inodes, int pos, long nsDelta, long dsDelta, INode commonAncestor) throws QuotaExceededException {
        int i;
        if (!this.ready) {
            return;
        }
        if (nsDelta <= 0L && dsDelta <= 0L) {
            return;
        }
        if (pos > inodes.length) {
            pos = inodes.length;
        }
        try {
            for (i = pos - 1; i >= 0; --i) {
                if (commonAncestor == inodes[i]) {
                    return;
                }
                if (!inodes[i].isQuotaSet()) continue;
                INodeDirectoryWithQuota node = (INodeDirectoryWithQuota)inodes[i];
                node.verifyQuota(nsDelta, dsDelta);
            }
        }
        catch (QuotaExceededException e) {
            e.setPathName(FSDirectory.getFullPathName(inodes, i));
            throw e;
        }
    }

    private void verifyQuotaForRename(INode[] srcInodes, INode[] dstInodes) throws QuotaExceededException {
        if (!this.ready) {
            return;
        }
        INode srcInode = srcInodes[srcInodes.length - 1];
        INode commonAncestor = null;
        int i = 0;
        while (srcInodes[i] == dstInodes[i]) {
            commonAncestor = srcInodes[i];
            ++i;
        }
        INode.DirCounts srcCounts = new INode.DirCounts();
        srcInode.spaceConsumedInTree(srcCounts);
        long nsDelta = srcCounts.getNsCount();
        long dsDelta = srcCounts.getDsCount();
        INode dstInode = dstInodes[dstInodes.length - 1];
        if (dstInode != null) {
            INode.DirCounts dstCounts = new INode.DirCounts();
            dstInode.spaceConsumedInTree(dstCounts);
            nsDelta -= dstCounts.getNsCount();
            dsDelta -= dstCounts.getDsCount();
        }
        this.verifyQuota(dstInodes, dstInodes.length - 1, nsDelta, dsDelta, commonAncestor);
    }

    private <T extends INode> T addChild(INode[] pathComponents, int pos, T child, long childDiskspace, boolean inheritPermission, boolean checkQuota) throws QuotaExceededException {
        INode.DirCounts counts = new INode.DirCounts();
        child.spaceConsumedInTree(counts);
        if (childDiskspace < 0L) {
            childDiskspace = counts.getDsCount();
        }
        this.updateCount(pathComponents, pos, counts.getNsCount(), childDiskspace, checkQuota);
        if (pathComponents[pos - 1] == null) {
            throw new NullPointerException("Panic: parent does not exist");
        }
        T addedNode = ((INodeDirectory)pathComponents[pos - 1]).addChild(child, inheritPermission);
        if (addedNode == null) {
            this.updateCount(pathComponents, pos, -counts.getNsCount(), -childDiskspace, true);
        }
        return addedNode;
    }

    private <T extends INode> T addChild(INode[] pathComponents, int pos, T child, long childDiskspace, boolean inheritPermission) throws QuotaExceededException {
        return this.addChild(pathComponents, pos, child, childDiskspace, inheritPermission, true);
    }

    private <T extends INode> T addChildNoQuotaCheck(INode[] pathComponents, int pos, T child, long childDiskspace, boolean inheritPermission) {
        T inode = null;
        try {
            inode = this.addChild(pathComponents, pos, child, childDiskspace, inheritPermission, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.warn((Object)"FSDirectory.addChildNoQuotaCheck - unexpected", (Throwable)e);
        }
        return inode;
    }

    private INode removeChild(INode[] pathComponents, int pos) {
        INode removedNode = ((INodeDirectory)pathComponents[pos - 1]).removeChild(pathComponents[pos]);
        if (removedNode != null) {
            INode.DirCounts counts = new INode.DirCounts();
            removedNode.spaceConsumedInTree(counts);
            this.updateCountNoQuotaCheck(pathComponents, pos, -counts.getNsCount(), -counts.getDsCount());
        }
        return removedNode;
    }

    String normalizePath(String src) {
        if (src.length() > 1 && src.endsWith("/")) {
            src = src.substring(0, src.length() - 1);
        }
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentSummary getContentSummary(String src) throws FileNotFoundException, UnresolvedLinkException {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(srcs, false);
            if (targetNode == null) {
                throw new FileNotFoundException("File does not exist: " + srcs);
            }
            return targetNode.computeContentSummary();
        }
    }

    void updateCountForINodeWithQuota() {
        FSDirectory.updateCountForINodeWithQuota(this.rootDir, new INode.DirCounts(), new ArrayList<INode>(50));
    }

    private static void updateCountForINodeWithQuota(INodeDirectory dir, INode.DirCounts counts, ArrayList<INode> nodesInPath) {
        long parentNamespace = counts.nsCount;
        long parentDiskspace = counts.dsCount;
        counts.nsCount = 1L;
        counts.dsCount = 0L;
        nodesInPath.add(dir);
        for (INode child : dir.getChildren()) {
            if (child.isDirectory()) {
                FSDirectory.updateCountForINodeWithQuota((INodeDirectory)child, counts, nodesInPath);
                continue;
            }
            if (child.isLink()) {
                ++counts.nsCount;
                continue;
            }
            ++counts.nsCount;
            counts.dsCount += ((INodeFile)child).diskspaceConsumed();
        }
        if (dir.isQuotaSet()) {
            ((INodeDirectoryWithQuota)dir).setSpaceConsumed(counts.nsCount, counts.dsCount);
            if (dir.getNsQuota() >= 0L && counts.nsCount > dir.getNsQuota() || dir.getDsQuota() >= 0L && counts.dsCount > dir.getDsQuota()) {
                StringBuilder path = new StringBuilder(512);
                for (INode n : nodesInPath) {
                    path.append('/');
                    path.append(n.getLocalName());
                }
                NameNode.LOG.warn((Object)("Quota violation in image for " + path + " (Namespace quota : " + dir.getNsQuota() + " consumed : " + counts.nsCount + ")" + " (Diskspace quota : " + dir.getDsQuota() + " consumed : " + counts.dsCount + ")."));
            }
        }
        nodesInPath.remove(nodesInPath.size() - 1);
        counts.nsCount += parentNamespace;
        counts.dsCount += parentDiskspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeDirectory unprotectedSetQuota(String src, long nsQuota, long dsQuota) throws FileNotFoundException, QuotaExceededException, UnresolvedLinkException {
        if (nsQuota < 0L && nsQuota != Long.MAX_VALUE && nsQuota < -1L || dsQuota < 0L && dsQuota != Long.MAX_VALUE && dsQuota < -1L) {
            throw new IllegalArgumentException("Illegal value for nsQuota or dsQuota : " + nsQuota + " and " + dsQuota);
        }
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode[] inodes = this.rootDir.getExistingPathINodes(src, true);
            INode targetNode = inodes[inodes.length - 1];
            if (targetNode == null) {
                throw new FileNotFoundException("Directory does not exist: " + srcs);
            }
            if (!targetNode.isDirectory()) {
                throw new FileNotFoundException("Cannot set quota on a file: " + srcs);
            }
            if (targetNode.isRoot() && nsQuota == -1L) {
                throw new IllegalArgumentException("Cannot clear namespace quota on root.");
            }
            INodeDirectory dirNode = (INodeDirectory)targetNode;
            long oldNsQuota = dirNode.getNsQuota();
            long oldDsQuota = dirNode.getDsQuota();
            if (nsQuota == Long.MAX_VALUE) {
                nsQuota = oldNsQuota;
            }
            if (dsQuota == Long.MAX_VALUE) {
                dsQuota = oldDsQuota;
            }
            if (dirNode instanceof INodeDirectoryWithQuota) {
                ((INodeDirectoryWithQuota)dirNode).setQuota(nsQuota, dsQuota);
            } else {
                INodeDirectoryWithQuota newNode = new INodeDirectoryWithQuota(nsQuota, dsQuota, dirNode);
                INodeDirectory parent = (INodeDirectory)inodes[inodes.length - 2];
                dirNode = newNode;
                parent.replaceChild(newNode);
            }
            return oldNsQuota != nsQuota || oldDsQuota != dsQuota ? dirNode : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQuota(String src, long nsQuota, long dsQuota) throws FileNotFoundException, QuotaExceededException, UnresolvedLinkException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodeDirectory dir = this.unprotectedSetQuota(src, nsQuota, dsQuota);
            if (dir != null) {
                this.fsImage.getEditLog().logSetQuota(src, dir.getNsQuota(), dir.getDsQuota());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long totalInodes() {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return this.rootDir.numItemsInTree();
        }
    }

    void setTimes(String src, INodeFile inode, long mtime, long atime, boolean force) {
        if (this.unprotectedSetTimes(src, inode, mtime, atime, force)) {
            this.fsImage.getEditLog().logTimes(src, mtime, atime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unprotectedSetTimes(String src, long mtime, long atime, boolean force) throws UnresolvedLinkException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodeFile inode = this.getFileINode(src);
            return this.unprotectedSetTimes(src, inode, mtime, atime, force);
        }
    }

    private boolean unprotectedSetTimes(String src, INodeFile inode, long mtime, long atime, boolean force) {
        boolean status = false;
        if (mtime != -1L) {
            inode.setModificationTimeForce(mtime);
            status = true;
        }
        if (atime != -1L) {
            long inodeTime = inode.getAccessTime();
            if (atime <= inodeTime + this.getFSNamesystem().getAccessTimePrecision() && !force) {
                status = false;
            } else {
                inode.setAccessTime(atime);
                status = true;
            }
        }
        return status;
    }

    void reset() {
        this.rootDir = new INodeDirectoryWithQuota("", this.getFSNamesystem().createFsOwnerPermissions(new FsPermission(493)), Integer.MAX_VALUE, -1L);
    }

    private static HdfsFileStatus createFileStatus(byte[] path, INode node) {
        return new HdfsFileStatus(node instanceof INodeFile ? ((INodeFile)node).computeFileSize(true) : 0L, node.isDirectory(), node.isDirectory() || node.isLink() ? (short)0 : ((INodeFile)node).getReplication(), node.isDirectory() || node.isLink() ? 0L : ((INodeFile)node).getPreferredBlockSize(), node.getModificationTime(), node.getAccessTime(), node.getFsPermission(), node.getUserName(), node.getGroupName(), node.isLink() ? ((INodeSymlink)node).getSymlink() : null, path);
    }

    INodeSymlink addSymlink(String path, String target, PermissionStatus dirPerms, boolean createParent) throws IOException, UnresolvedLinkException {
        String parent;
        this.waitForReady();
        long modTime = FSNamesystem.now();
        if (createParent && !this.mkdirs(parent = new Path(path).getParent().toString(), dirPerms, true, modTime)) {
            return null;
        }
        String userName = UserGroupInformation.getCurrentUser().getUserName();
        INodeSymlink newNode = this.unprotectedSymlink(path, target, modTime, modTime, new PermissionStatus(userName, null, FsPermission.getDefault()));
        if (newNode == null) {
            NameNode.stateChangeLog.info((Object)("DIR* FSDirectory.addSymlink: failed to add " + path + " to the file system"));
            return null;
        }
        this.fsImage.getEditLog().logSymlink(path, target, modTime, modTime, newNode);
        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addSymlink: " + path + " is added to the file system"));
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeSymlink unprotectedSymlink(String path, String target, long modTime, long atime, PermissionStatus perm) throws UnresolvedLinkException {
        INodeSymlink newNode = new INodeSymlink(target, modTime, atime, perm);
        try {
            INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
            synchronized (iNodeDirectoryWithQuota) {
                newNode = this.addNode(path, newNode, -1L, false);
            }
        }
        catch (UnresolvedLinkException e) {
            throw e;
        }
        catch (IOException e) {
            return null;
        }
        return newNode;
    }
}

