/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Counters
implements Writable,
Iterable<CounterGroup> {
    private Map<Enum<?>, Counter> cache = new IdentityHashMap();
    private TreeMap<String, CounterGroup> groups = new TreeMap();

    public Counters() {
    }

    public Counters(org.apache.hadoop.mapred.Counters counters) {
        for (Counters.Group group : counters) {
            String name = group.getName();
            CounterGroup newGroup = new CounterGroup(name, group.getDisplayName());
            this.groups.put(name, newGroup);
            for (Counters.Counter counter : group) {
                newGroup.addCounter(counter);
            }
        }
    }

    public void addGroup(CounterGroup group) {
        this.groups.put(group.getName(), group);
    }

    public Counter findCounter(String groupName, String counterName) {
        CounterGroup grp = this.getGroup(groupName);
        return grp.findCounter(counterName);
    }

    public synchronized Counter findCounter(Enum<?> key) {
        Counter counter = this.cache.get(key);
        if (counter == null) {
            counter = this.findCounter(key.getDeclaringClass().getName(), key.toString());
            this.cache.put(key, counter);
        }
        return counter;
    }

    public synchronized Collection<String> getGroupNames() {
        return this.groups.keySet();
    }

    @Override
    public Iterator<CounterGroup> iterator() {
        return this.groups.values().iterator();
    }

    public synchronized CounterGroup getGroup(String groupName) {
        CounterGroup grp = this.groups.get(groupName);
        if (grp == null) {
            grp = new CounterGroup(groupName);
            this.groups.put(groupName, grp);
        }
        return grp;
    }

    public synchronized int countCounters() {
        int result = 0;
        for (CounterGroup group : this) {
            result += group.size();
        }
        return result;
    }

    public synchronized void write(DataOutput out) throws IOException {
        out.writeInt(this.groups.size());
        for (CounterGroup group : this.groups.values()) {
            Text.writeString((DataOutput)out, (String)group.getName());
            group.write(out);
        }
    }

    public synchronized void readFields(DataInput in) throws IOException {
        int numClasses = in.readInt();
        this.groups.clear();
        while (numClasses-- > 0) {
            String groupName = Text.readString((DataInput)in);
            CounterGroup group = new CounterGroup(groupName);
            group.readFields(in);
            this.groups.put(groupName, group);
        }
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("Counters: " + this.countCounters());
        for (CounterGroup group : this) {
            sb.append("\n\t" + group.getDisplayName());
            for (Counter counter : group) {
                sb.append("\n\t\t" + counter.getDisplayName() + "=" + counter.getValue());
            }
        }
        return sb.toString();
    }

    public synchronized void incrAllCounters(Counters other) {
        for (Map.Entry<String, CounterGroup> rightEntry : other.groups.entrySet()) {
            CounterGroup left = this.groups.get(rightEntry.getKey());
            CounterGroup right = rightEntry.getValue();
            if (left == null) {
                left = new CounterGroup(right.getName(), right.getDisplayName());
                this.groups.put(rightEntry.getKey(), left);
            }
            left.incrAllCounters(right);
        }
    }

    public boolean equals(Object genericRight) {
        if (genericRight instanceof Counters) {
            Iterator<CounterGroup> right = ((Counters)genericRight).groups.values().iterator();
            Iterator<CounterGroup> left = this.groups.values().iterator();
            while (left.hasNext()) {
                if (right.hasNext() && left.next().equals(right.next())) continue;
                return false;
            }
            return !right.hasNext();
        }
        return false;
    }

    public int hashCode() {
        return this.groups.hashCode();
    }
}

