/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.Checksum;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.PureJavaCrc32;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class DataChecksum
implements Checksum {
    public static final int HEADER_LEN = 5;
    public static final int CHECKSUM_NULL = 0;
    public static final int CHECKSUM_CRC32 = 1;
    private static final int CHECKSUM_NULL_SIZE = 0;
    private static final int CHECKSUM_CRC32_SIZE = 4;
    private final int type;
    private final int size;
    private final Checksum summer;
    private final int bytesPerChecksum;
    private int inSum = 0;
    public static final int SIZE_OF_INTEGER = 4;

    public static DataChecksum newDataChecksum(int type, int bytesPerChecksum) {
        if (bytesPerChecksum <= 0) {
            return null;
        }
        switch (type) {
            case 0: {
                return new DataChecksum(0, new ChecksumNull(), 0, bytesPerChecksum);
            }
            case 1: {
                return new DataChecksum(1, new PureJavaCrc32(), 4, bytesPerChecksum);
            }
        }
        return null;
    }

    public static DataChecksum newDataChecksum(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 5) {
            return null;
        }
        int bytesPerChecksum = (bytes[offset + 1] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 8 | bytes[offset + 4] & 0xFF;
        return DataChecksum.newDataChecksum(bytes[0], bytesPerChecksum);
    }

    public static DataChecksum newDataChecksum(DataInputStream in) throws IOException {
        int bpc;
        byte type = in.readByte();
        DataChecksum summer = DataChecksum.newDataChecksum(type, bpc = in.readInt());
        if (summer == null) {
            throw new IOException("Could not create DataChecksum of type " + type + " with bytesPerChecksum " + bpc);
        }
        return summer;
    }

    public void writeHeader(DataOutputStream out) throws IOException {
        out.writeByte(this.type);
        out.writeInt(this.bytesPerChecksum);
    }

    public byte[] getHeader() {
        byte[] header = new byte[]{(byte)(this.type & 0xFF), (byte)(this.bytesPerChecksum >>> 24 & 0xFF), (byte)(this.bytesPerChecksum >>> 16 & 0xFF), (byte)(this.bytesPerChecksum >>> 8 & 0xFF), (byte)(this.bytesPerChecksum & 0xFF)};
        return header;
    }

    public int writeValue(DataOutputStream out, boolean reset) throws IOException {
        if (this.size <= 0) {
            return 0;
        }
        if (this.type != 1) {
            throw new IOException("Unknown Checksum " + this.type);
        }
        out.writeInt((int)this.summer.getValue());
        if (reset) {
            this.reset();
        }
        return this.size;
    }

    public int writeValue(byte[] buf, int offset, boolean reset) throws IOException {
        if (this.size <= 0) {
            return 0;
        }
        if (this.type != 1) {
            throw new IOException("Unknown Checksum " + this.type);
        }
        int checksum = (int)this.summer.getValue();
        buf[offset + 0] = (byte)(checksum >>> 24 & 0xFF);
        buf[offset + 1] = (byte)(checksum >>> 16 & 0xFF);
        buf[offset + 2] = (byte)(checksum >>> 8 & 0xFF);
        buf[offset + 3] = (byte)(checksum & 0xFF);
        if (reset) {
            this.reset();
        }
        return this.size;
    }

    public boolean compare(byte[] buf, int offset) {
        if (this.size > 0 && this.type == 1) {
            int checksum = (buf[offset + 0] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
            return checksum == (int)this.summer.getValue();
        }
        return this.size == 0;
    }

    private DataChecksum(int checksumType, Checksum checksum, int sumSize, int chunkSize) {
        this.type = checksumType;
        this.summer = checksum;
        this.size = sumSize;
        this.bytesPerChecksum = chunkSize;
    }

    public int getChecksumType() {
        return this.type;
    }

    public int getChecksumSize() {
        return this.size;
    }

    public int getBytesPerChecksum() {
        return this.bytesPerChecksum;
    }

    public int getNumBytesInSum() {
        return this.inSum;
    }

    public static int getChecksumHeaderSize() {
        return 5;
    }

    @Override
    public long getValue() {
        return this.summer.getValue();
    }

    @Override
    public void reset() {
        this.summer.reset();
        this.inSum = 0;
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (len > 0) {
            this.summer.update(b, off, len);
            this.inSum += len;
        }
    }

    @Override
    public void update(int b) {
        this.summer.update(b);
        ++this.inSum;
    }

    static class ChecksumNull
    implements Checksum {
        @Override
        public long getValue() {
            return 0L;
        }

        @Override
        public void reset() {
        }

        @Override
        public void update(byte[] b, int off, int len) {
        }

        @Override
        public void update(int b) {
        }
    }
}

