/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.helper;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.helper.AbstractMasterManagerHelper;
import okuyama.imdst.util.DataDispatcher;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.JavaSystemApi;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.SystemUtil;
import okuyama.imdst.util.io.CustomReader;
import okuyama.imdst.util.io.KeyNodeConnector;
import okuyama.imdst.util.protocol.AbstractProtocolTaker;
import okuyama.imdst.util.protocol.IProtocolTaker;
import okuyama.imdst.util.protocol.ProtocolTakerFactory;

public class MasterManagerHelper
extends AbstractMasterManagerHelper {
    private String protocolMode = null;
    private IProtocolTaker porotocolTaker = null;
    private boolean isProtocolOkuyama = true;
    private String myPollQueue = "";
    private boolean reverseAccess = false;
    private short dataConsistencyMode = 0;
    private boolean transactionMode = false;
    private String[] transactionManagerInfo = null;
    private AtomicInteger numberOfQueueBindWaitCounter = null;
    private static final int returnProccessingCount = 2;
    private long setTime = 0L;
    private Random rnd = new Random();
    private StringBuilder getSendData = new StringBuilder(128);
    private StringBuilder setSendData = new StringBuilder(512);
    private boolean isolationMode = false;
    private short isolationPrefixLength = 0;
    private boolean slaveNodeDelayWriteMode = false;
    private boolean thridNodeDelayWriteMode = false;
    private static volatile int maxGetSize = ImdstDefine.maxMultiGetRequestSize;
    private boolean longReadTimeout = false;
    private static String[] initReturnParam = new String[]{"0", "true", new Integer(ImdstDefine.saveDataMaxSize).toString()};
    private int encodeMaxDataSize = new Double((double)ImdstDefine.saveDataMaxSize * 1.38).intValue();
    private static ConcurrentHashMap searchIndexDictionaryMap = new ConcurrentHashMap(500, 480.0f, 1024);
    private static String[] searchIndexDictionaryList = new String[0];
    private static boolean initDictionaryFlg = false;
    private boolean execMethodReportQueue = false;
    private static ILogger logger = LoggerFactory.createLogger(MasterManagerHelper.class);

    @Override
    public void initHelper(String initValue) {
        String consistencyModeStr = super.getPropertiesValue("DataConsistencyMode");
        if (consistencyModeStr != null && !consistencyModeStr.trim().equals("")) {
            this.dataConsistencyMode = Short.parseShort(consistencyModeStr);
        }
        if (StatusUtil.getIsolationMode()) {
            this.isolationMode = true;
            String isolationPrefixStr = StatusUtil.getIsolationPrefix();
            this.isolationPrefixLength = new Integer(isolationPrefixStr.length()).shortValue();
        }
        if (!initDictionaryFlg) {
            initDictionaryFlg = true;
            String dictonaryStr = super.getPropertiesValue("DictonaryCharacters");
            if (dictonaryStr != null && !dictonaryStr.trim().equals("")) {
                searchIndexDictionaryList = dictonaryStr.split("|");
                for (int i = 0; i < searchIndexDictionaryList.length; ++i) {
                    searchIndexDictionaryMap.put(searchIndexDictionaryList[i], "");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeHelper(String optionParam) throws BatchException {
        String ret = null;
        Object[] parameters = null;
        boolean closeFlg = false;
        boolean serverRunning = true;
        String pollQueueName = null;
        String[] addQueueNames = null;
        String bindQueueWaitHelperCountKey = "";
        boolean reloopSameClient = false;
        String[] retParams = null;
        String retParamStr = null;
        Object clientParametersStr = null;
        String[] clientParameterList = null;
        String[] clientTargetNodes = null;
        IProtocolTaker okuyamaPorotocolTaker = null;
        PrintWriter pw = null;
        CustomReader br = null;
        Object bis = null;
        BufferedOutputStream bos = null;
        Socket socket = null;
        String socketString = null;
        try {
            parameters = super.getParameters();
            this.protocolMode = (String)parameters[2];
            this.porotocolTaker = ProtocolTakerFactory.getProtocolTaker(this.protocolMode);
            if (!this.protocolMode.equals("okuyama")) {
                this.isProtocolOkuyama = false;
                okuyamaPorotocolTaker = ProtocolTakerFactory.getProtocolTaker("okuyama");
            }
            this.transactionMode = (Boolean)parameters[4];
            if (this.transactionMode) {
                this.transactionManagerInfo = (String[])parameters[5];
            }
            this.initConsistencyMode();
            pollQueueName = (String)parameters[6];
            this.myPollQueue = (String)parameters[6];
            addQueueNames = (String[])parameters[7];
            bindQueueWaitHelperCountKey = (String)parameters[8];
            this.numberOfQueueBindWaitCounter = (AtomicInteger)super.getHelperShareParam(bindQueueWaitHelperCountKey);
            Object[] queueParam = null;
            Object[] queueMap = null;
            while (serverRunning) {
                try {
                    retParams = null;
                    retParamStr = "";
                    if (closeFlg) {
                        this.closeClientConnect(pw, br, bos, socket);
                    }
                    this.porotocolTaker.init();
                    String rndVerStr1 = new Integer(this.rnd.nextInt(99)).toString();
                    String rndVerStr2 = new Integer(this.rnd.nextInt(99)).toString();
                    if (closeFlg || !reloopSameClient) {
                        queueParam = super.pollSpecificationParameterQueue(pollQueueName);
                        queueMap = (Object[])queueParam[0];
                        this.reverseAccess = (Boolean)queueMap[5];
                        if (this.dataConsistencyMode == 1) {
                            this.reverseAccess = true;
                        }
                        pw = (PrintWriter)queueMap[1];
                        br = (CustomReader)queueMap[2];
                        socket = (Socket)queueMap[0];
                        bos = (BufferedOutputStream)queueMap[8];
                        socket.setSoTimeout(0);
                        socketString = socket.toString();
                        this.porotocolTaker.setClientInfo(socketString);
                        closeFlg = false;
                    }
                    if (!reloopSameClient) {
                        this.numberOfQueueBindWaitCounter.getAndDecrement();
                    }
                    reloopSameClient = false;
                    clientParameterList = this.isProtocolOkuyama ? this.porotocolTaker.takeRequestLine4List(br, pw) : this.porotocolTaker.takeRequestLine4List(br, pw);
                    if (this.porotocolTaker.nextExecution() != 1) {
                        if (this.porotocolTaker.nextExecution() == 2) {
                            queueMap[4] = new Long(JavaSystemApi.currentTimeMillis);
                            queueParam[0] = queueMap;
                            super.addSmallSizeParameterQueue(addQueueNames, queueParam);
                            continue;
                        }
                        if (this.porotocolTaker.nextExecution() == 3) {
                            closeFlg = true;
                            continue;
                        }
                    }
                    try {
                        this.setTime = new Long(rndVerStr1 + System.nanoTime() + rndVerStr2);
                    }
                    catch (NumberFormatException ne1) {
                        try {
                            this.setTime = System.nanoTime() + (long)new Integer(this.rnd.nextInt(99)).intValue();
                        }
                        catch (NumberFormatException ne2) {
                            this.setTime = System.nanoTime();
                        }
                    }
                    this.longReadTimeout = false;
                    switch (StatusUtil.isExecuteMethod(Integer.parseInt(clientParameterList[0]))) {
                        case 0: {
                            retParams = this.initClient();
                            break;
                        }
                        case 1: {
                            retParams = this.setKeyValue(clientParameterList[1], clientParameterList[2], clientParameterList[3], clientParameterList[4]);
                            break;
                        }
                        case 2: {
                            retParams = this.getKeyValue(clientParameterList[1]);
                            break;
                        }
                        case 3: {
                            boolean noExistsData = true;
                            if (clientParameterList.length > 2) {
                                noExistsData = new Boolean(clientParameterList[2]);
                            }
                            retParams = this.getTagKeys(clientParameterList[1], noExistsData);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            retParams = this.removeKeyValue(clientParameterList[1], clientParameterList[2]);
                            break;
                        }
                        case 6: {
                            if (clientParameterList.length > 5) {
                                clientParameterList[4] = clientParameterList[4] + "," + clientParameterList[5];
                            }
                            retParams = this.setKeyValueOnlyOnce(clientParameterList[1], clientParameterList[2], clientParameterList[3], clientParameterList[4]);
                            break;
                        }
                        case 8: {
                            retParams = this.getKeyValueScript(clientParameterList[1], clientParameterList[2]);
                            break;
                        }
                        case 9: {
                            retParams = this.getKeyValueScriptForUpdate(clientParameterList[1], clientParameterList[2]);
                            break;
                        }
                        case 10: {
                            String[] nodeDt = new String[]{"10", "true", StatusUtil.getNodeStatusDt(clientParameterList[1])};
                            retParams = nodeDt;
                            break;
                        }
                        case 12: {
                            retParams = new String[]{"12", "true", ""};
                            break;
                        }
                        case 13: {
                            retParams = this.incrValue(clientParameterList[1], clientParameterList[2], clientParameterList[3]);
                            break;
                        }
                        case 14: {
                            retParams = this.decrValue(clientParameterList[1], clientParameterList[2], clientParameterList[3]);
                            break;
                        }
                        case 15: {
                            retParams = this.getKeyValueAndVersion(clientParameterList[1]);
                            break;
                        }
                        case 16: {
                            retParams = this.setKeyValueVersionCheck(clientParameterList[1], clientParameterList[2], clientParameterList[3], clientParameterList[4], clientParameterList[5]);
                            break;
                        }
                        case 17: {
                            retParams = this.getValueAndUpdateExpireTime(clientParameterList[1]);
                            break;
                        }
                        case 18: {
                            break;
                        }
                        case 22: {
                            int mIdx;
                            this.longReadTimeout = true;
                            int innerIdx = 0;
                            String sep = "";
                            StringBuilder requestKeysBuf = new StringBuilder();
                            ArrayList<String> requestKeyList = new ArrayList<String>();
                            for (mIdx = 1; mIdx < clientParameterList.length - 1; ++mIdx) {
                                int i;
                                ++innerIdx;
                                requestKeysBuf.append(sep);
                                requestKeysBuf.append(clientParameterList[mIdx]);
                                sep = ";";
                                requestKeyList.add(clientParameterList[mIdx]);
                                if (innerIdx != maxGetSize && mIdx + 1 < clientParameterList.length - 1) continue;
                                innerIdx = 0;
                                sep = "";
                                String mRetParamStr = "";
                                String[] mRetParams = null;
                                if (requestKeysBuf.indexOf(";") != -1) {
                                    mRetParams = this.getKeyValue(requestKeysBuf.toString(), true);
                                } else {
                                    mRetParams = this.getKeyValue(requestKeysBuf.toString());
                                    mRetParams[2] = mRetParams[1].equals("true") ? requestKeysBuf.toString() + ":" + mRetParams[2] : requestKeysBuf.toString() + ":" + "*";
                                }
                                String[] responseWork = mRetParams[2].split(";");
                                HashMap<String, String> resultMap = new HashMap<String, String>(maxGetSize);
                                for (i = 0; i < responseWork.length; ++i) {
                                    String[] oneRet = responseWork[i].split(":");
                                    resultMap.put(oneRet[0], oneRet[1]);
                                }
                                for (i = 0; i < requestKeyList.size(); ++i) {
                                    String retVal = (String)resultMap.get((String)requestKeyList.get(i));
                                    String[] oneRetParams = new String[3];
                                    oneRetParams[0] = "22";
                                    if (retVal.equals("*")) {
                                        oneRetParams[1] = "false";
                                        oneRetParams[2] = "";
                                    } else {
                                        oneRetParams[1] = "true";
                                        oneRetParams[2] = retVal;
                                    }
                                    if (this.porotocolTaker.isMatchMethod()) {
                                        mRetParamStr = this.porotocolTaker.takeResponseLine(oneRetParams, bos);
                                    } else {
                                        okuyamaPorotocolTaker.setClientInfo(socketString);
                                        mRetParamStr = okuyamaPorotocolTaker.takeResponseLine(oneRetParams, bos);
                                    }
                                    if (mRetParamStr == null || mRetParamStr.equals("")) continue;
                                    pw.print(mRetParamStr);
                                    pw.flush();
                                }
                                requestKeysBuf = new StringBuilder();
                                requestKeyList = new ArrayList();
                            }
                            retParams = this.getKeyValue(clientParameterList[mIdx]);
                            if (retParams == null || !retParams[0].equals("2")) break;
                            retParams[0] = "22-f";
                            break;
                        }
                        case 23: {
                            int tagkeysIdx;
                            retParams = this.getTagKeys(clientParameterList[1], true);
                            String[] keys = new String[]{};
                            if (retParams[1].equals("true")) {
                                keys = retParams[2].split(":");
                            }
                            for (tagkeysIdx = 0; tagkeysIdx < keys.length - 1; ++tagkeysIdx) {
                                String mRetParamStr = "";
                                String[] mRetParams = this.getKeyValue(keys[tagkeysIdx]);
                                if (mRetParams != null) {
                                    mRetParams[0] = "23";
                                }
                                if (!mRetParams[1].equals("true")) continue;
                                String[] realRetParams = new String[mRetParams.length + 1];
                                realRetParams[0] = mRetParams[0];
                                realRetParams[1] = mRetParams[1];
                                realRetParams[2] = keys[tagkeysIdx];
                                realRetParams[3] = mRetParams[2];
                                if (this.porotocolTaker.isMatchMethod()) {
                                    mRetParamStr = this.porotocolTaker.takeResponseLine(realRetParams, bos);
                                } else {
                                    okuyamaPorotocolTaker.setClientInfo(socketString);
                                    mRetParamStr = okuyamaPorotocolTaker.takeResponseLine(realRetParams, bos);
                                }
                                if (mRetParamStr == null || mRetParamStr.equals("")) continue;
                                pw.print(mRetParamStr);
                                pw.flush();
                            }
                            if (keys.length > 0) {
                                retParams = this.getKeyValue(keys[tagkeysIdx]);
                                String[] realRetParams = new String[]{retParams[0], retParams[1], keys[tagkeysIdx], retParams[2]};
                                retParams = realRetParams;
                            } else {
                                retParams = new String[]{"23-f", "false"};
                            }
                            if (retParams == null || !retParams[0].equals("2")) break;
                            retParams[0] = "23-f";
                            break;
                        }
                        case 30: {
                            retParams = this.lockingData(clientParameterList[1], clientParameterList[2], clientParameterList[3], clientParameterList[4]);
                            break;
                        }
                        case 31: {
                            retParams = this.releaseLockingData(clientParameterList[1], clientParameterList[2]);
                            break;
                        }
                        case 37: {
                            retParams = this.startTransaction();
                            break;
                        }
                        case 38: {
                            break;
                        }
                        case 39: {
                            break;
                        }
                        case 40: {
                            retParams = this.removeTargetTagInKey(clientParameterList[1], clientParameterList[2], clientParameterList[3]);
                            break;
                        }
                        case 42: {
                            this.longReadTimeout = true;
                            int createIndexLen = 4;
                            int createIndexMinLen = 0;
                            if (clientParameterList.length > 6) {
                                try {
                                    createIndexLen = Integer.parseInt(clientParameterList[6]) + 1;
                                }
                                catch (NumberFormatException nfe) {
                                    createIndexLen = 4;
                                }
                            }
                            if (clientParameterList.length > 7) {
                                try {
                                    createIndexMinLen = Integer.parseInt(clientParameterList[7]) - 1;
                                }
                                catch (NumberFormatException nfe) {
                                    createIndexMinLen = 0;
                                }
                            }
                            retParams = this.setKeyValueAndCreateIndex(clientParameterList[1], clientParameterList[2], clientParameterList[3], clientParameterList[4], clientParameterList[5], createIndexLen, createIndexMinLen);
                            break;
                        }
                        case 43: {
                            this.longReadTimeout = true;
                            int searchIndexLen = 3;
                            if (clientParameterList.length > 4) {
                                try {
                                    searchIndexLen = Integer.parseInt(clientParameterList[4]);
                                }
                                catch (NumberFormatException nfe) {
                                    searchIndexLen = 3;
                                }
                            }
                            retParams = this.searchValueIndex(clientParameterList[1], clientParameterList[2], clientParameterList[3], searchIndexLen);
                            break;
                        }
                        case 44: {
                            this.longReadTimeout = true;
                            int removeIndexLen = 4;
                            if (clientParameterList.length > 4) {
                                try {
                                    removeIndexLen = Integer.parseInt(clientParameterList[4]) + 1;
                                }
                                catch (NumberFormatException nfe) {
                                    removeIndexLen = 4;
                                }
                            }
                            retParams = this.removeSearchIndex(clientParameterList[1], clientParameterList[2], clientParameterList[3], removeIndexLen);
                            break;
                        }
                        case 45: {
                            retParams = this.getTargetTagIndexList(clientParameterList[1]);
                            break;
                        }
                        case 46: {
                            retParams = this.getTargetIndexTagPair(clientParameterList[1], clientParameterList[2]);
                            break;
                        }
                        case 50: {
                            String dictonaryStr = clientParameterList[1];
                            if (dictonaryStr.trim().length() > 0) {
                                if (dictonaryStr.equals("(B)")) {
                                    searchIndexDictionaryMap = new ConcurrentHashMap(500, 480.0f, 1024);
                                    searchIndexDictionaryList = new String[0];
                                } else {
                                    byte[] dictionaryBytes = dictonaryStr.getBytes(ImdstDefine.characterDecodeSetBySearch);
                                    String decodeDictonaryStr = new String(BASE64DecoderStream.decode((byte[])dictionaryBytes), ImdstDefine.characterDecodeSetBySearch);
                                    searchIndexDictionaryList = decodeDictonaryStr.split("|");
                                    for (int i = 0; i < searchIndexDictionaryList.length; ++i) {
                                        searchIndexDictionaryMap.put(searchIndexDictionaryList[i], "");
                                    }
                                }
                                retParams = new String[]{"50", "true"};
                                break;
                            }
                            retParams = new String[]{"50", "false"};
                            break;
                        }
                        case 61: {
                            if (StatusUtil.isMainMasterNode()) {
                                if (!super.getRecoverProcessed()) {
                                    if (clientParameterList.length == 2 && (clientParameterList[1].length() == 5 || clientParameterList[1].length() == 3)) {
                                        if (this.truncateAllData(clientParameterList[1])) {
                                            retParams = new String[]{"61", "true"};
                                            break;
                                        }
                                        retParams = new String[]{"61", "false"};
                                        break;
                                    }
                                    retParams = new String[]{"61", "error", "The mistake is found in the deletion specification"};
                                    break;
                                }
                                retParams = new String[]{"61", "error", "DataNode cannot be executed while processing the return"};
                                break;
                            }
                            if (this.isolationMode) {
                                if (!super.getRecoverProcessed()) {
                                    String isolationPrefixWork = StatusUtil.getIsolationPrefix();
                                    if (this.truncateAllData(isolationPrefixWork.substring(1, 6))) {
                                        retParams = new String[]{"61", "true"};
                                        break;
                                    }
                                    retParams = new String[]{"61", "false"};
                                    break;
                                }
                                retParams = new String[]{"61", "error", "DataNode cannot be executed while processing the return"};
                                break;
                            }
                            retParams = new String[]{"61", "error", "It is executable only by MainMasterNode"};
                            break;
                        }
                        case 90: {
                            retParams = this.pauseKeyNodeUse(clientParameterList[1]);
                            break;
                        }
                        case 91: {
                            retParams = this.restartKeyNodeUse(clientParameterList[1]);
                            break;
                        }
                        case 92: {
                            retParams = this.arriveKeyNode(clientParameterList[1]);
                            break;
                        }
                        case 93: {
                            clientTargetNodes = clientParameterList[1].split("_");
                            for (int i = 0; i < clientTargetNodes.length; ++i) {
                                retParams = this.pauseKeyNodeUse(clientTargetNodes[i]);
                            }
                            break;
                        }
                        case 94: {
                            clientTargetNodes = clientParameterList[1].split("_");
                            for (int i = 0; i < clientTargetNodes.length; ++i) {
                                retParams = this.restartKeyNodeUse(clientTargetNodes[i]);
                            }
                            break;
                        }
                        case 95: {
                            retParams = this.deadKeyNode(clientParameterList[1]);
                            break;
                        }
                        case 96: {
                            KeyNodeConnector.setRecoverMode(true, clientParameterList[1]);
                            retParams = new String[]{"96", "true", ""};
                            break;
                        }
                        case 97: {
                            KeyNodeConnector.setRecoverMode(false, "");
                            retParams = new String[]{"97", "true", ""};
                            break;
                        }
                        case 998: {
                            if (!this.isProtocolOkuyama) break;
                            String dataNodeString = ((Object)DataDispatcher.getAllDataNodeInfo()).toString();
                            dataNodeString = dataNodeString.replaceAll(",", " ");
                            retParams = new String[]{"998", "true", "MainMasterNode=[" + StatusUtil.isMainMasterNode() + "]- MyInfo=[" + StatusUtil.getMyNodeInfo() + "]- MainMasterNodeInfo=[" + StatusUtil.getMainMasterNodeInfo() + "]- AllMasterNodeInfo=[" + StatusUtil.getAllMasterNodeInfo().replaceAll(",", " ") + "]- CheckMasterNodeTargetInfo=[" + StatusUtil.getCheckTargetMasterNodes().replaceAll(",", " ") + "]- Algorithm [0]:mod [1]:consistenthash=[" + DataDispatcher.getDispatchMode() + "]- AllDataNodeInfo=[" + dataNodeString + "]"};
                            break;
                        }
                        case 999: {
                            retParams = new String[]{"999", "VERSION okuyama-0.9.1", ""};
                            break;
                        }
                        case -1: {
                            logger.info("MasterManagerHelper Execution has not been permitted  MethodNo=[" + clientParameterList[0] + "]");
                            retParams = new String[]{clientParameterList[0], "error", "Execution has not been permitted"};
                            break;
                        }
                        default: {
                            logger.info("MasterManagerHelper No Method =[" + clientParameterList[0] + "]");
                            retParams = new String[]{"-1", "error", "Request Pattern Not Found"};
                        }
                    }
                    if (this.porotocolTaker.isMatchMethod()) {
                        retParamStr = this.porotocolTaker.takeResponseLine(retParams, bos);
                    } else {
                        okuyamaPorotocolTaker.setClientInfo(socketString);
                        retParamStr = okuyamaPorotocolTaker.takeResponseLine(retParams, bos);
                    }
                    if (this.isProtocolOkuyama) {
                        pw.println(retParamStr);
                        pw.flush();
                    } else if (retParamStr != null && !retParamStr.equals("")) {
                        pw.print(retParamStr);
                        pw.print("\r\n");
                        pw.flush();
                    }
                    if (this.execMethodReportQueue) {
                        super.sendExecuteMethodReportQueue(clientParameterList, retParams);
                    }
                    StatusUtil.incrementMethodExecuteCount();
                    if (this.numberOfQueueBindWaitCounter.get() >= 2) {
                        try {
                            if (!br.ready()) {
                                br.mark(1);
                                socket.setSoTimeout(200);
                                int readCheck = br.read();
                                br.reset();
                                reloopSameClient = true;
                                socket.setSoTimeout(0);
                                closeFlg = false;
                                continue;
                            }
                            reloopSameClient = true;
                            socket.setSoTimeout(0);
                            closeFlg = false;
                        }
                        catch (SocketTimeoutException ste) {
                            queueMap[4] = new Long(JavaSystemApi.currentTimeMillis);
                            queueParam[0] = queueMap;
                            super.addSmallSizeParameterQueue(addQueueNames, queueParam);
                            reloopSameClient = false;
                        }
                        catch (Throwable te) {
                            this.closeClientConnect(pw, br, bos, socket);
                            reloopSameClient = false;
                        }
                        continue;
                    }
                    queueMap[4] = new Long(JavaSystemApi.currentTimeMillis);
                    queueParam[0] = queueMap;
                    super.addSmallSizeParameterQueue(addQueueNames, queueParam);
                    reloopSameClient = false;
                }
                catch (ArrayIndexOutOfBoundsException aiobe) {
                    pw.println("-1,false,ERROR,ArgumentException");
                    pw.flush();
                    closeFlg = true;
                    reloopSameClient = false;
                }
                catch (NumberFormatException e) {
                    pw.println("-1,false,ERROR,Request Parameter Error");
                    pw.flush();
                    closeFlg = true;
                    reloopSameClient = false;
                }
                catch (SocketException se) {
                    closeFlg = true;
                    reloopSameClient = false;
                }
                catch (IOException ie) {
                    closeFlg = true;
                    reloopSameClient = false;
                }
                finally {
                    if (reloopSameClient) continue;
                    this.numberOfQueueBindWaitCounter.getAndIncrement();
                }
            }
            ret = AbstractMasterManagerHelper.SUCCESS;
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - executeHelper - Error", e);
            ret = AbstractMasterManagerHelper.ERROR;
        }
        return ret;
    }

    @Override
    public void endHelper() {
    }

    private String[] initClient() throws BatchException {
        return initReturnParam;
    }

    private String[] setKeyValue(String keyStr, String tagStr, String transactionCode, String dataStr) throws BatchException {
        return this.setKeyValue(keyStr, tagStr, transactionCode, dataStr, false);
    }

    private String[] setKeyValue(String keyStr, String tagStr, String transactionCode, String dataStr, boolean fixPrefix) throws BatchException {
        String[] retStrs;
        block24: {
            retStrs = new String[3];
            String[] tagKeyPair = null;
            String[] keyNodeSaveRet = null;
            String[] keyDataNodePair = null;
            if (tagStr.equals("(B)")) {
                tagStr = null;
            }
            try {
                keyStr = this.encodeIsolationConvert(keyStr);
                if (!this.checkKeyLength(keyStr)) {
                    retStrs[0] = "1";
                    retStrs[1] = "false";
                    retStrs[2] = "Key Length Error";
                    return retStrs;
                }
                if (!this.checkValueLength(dataStr)) {
                    retStrs[0] = "1";
                    retStrs[1] = "false";
                    retStrs[2] = "Value Length Error";
                    return retStrs;
                }
                if (tagStr != null && !tagStr.equals("")) {
                    String[] tags = tagStr.split(":");
                    for (int i = 0; i < tags.length; ++i) {
                        String[] tagKeyNodeInfo = null;
                        if (tags[i].indexOf(";") != -1) {
                            String[] workTags = tags[i].split(";");
                            tagKeyNodeInfo = DataDispatcher.dispatchKeyNode(workTags[0], false);
                        } else {
                            if (!fixPrefix) {
                                tags[i] = this.encodeIsolationConvert(tags[i]);
                            }
                            if (!this.checkKeyLength(tags[i])) {
                                retStrs[0] = "1";
                                retStrs[1] = "false";
                                throw new BatchException("Tag Data Length Error");
                            }
                            tagKeyNodeInfo = DataDispatcher.dispatchKeyNode(tags[i], false);
                        }
                        tagKeyPair = new String[]{tags[i], keyStr};
                        if (tagKeyNodeInfo.length == 3) {
                            keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], null, null, null, "3", tagKeyPair, transactionCode);
                        } else if (tagKeyNodeInfo.length == 6) {
                            keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], "3", tagKeyPair, transactionCode, ImdstDefine.delayWriteFlg);
                        } else if (tagKeyNodeInfo.length == 9) {
                            keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], tagKeyNodeInfo[6], tagKeyNodeInfo[7], tagKeyNodeInfo[8], "3", tagKeyPair, transactionCode, ImdstDefine.delayWriteFlg);
                        }
                        if (!keyNodeSaveRet[1].equals("false")) continue;
                        retStrs[0] = "1";
                        retStrs[1] = "false";
                        retStrs[2] = keyNodeSaveRet[2];
                        throw new BatchException("Tag Data Save Error");
                    }
                }
                String[] keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, false);
                keyDataNodePair = new String[]{keyStr, dataStr};
                if (keyNodeInfo.length == 3) {
                    keyNodeSaveRet = this.setKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "1", keyDataNodePair, transactionCode);
                } else if (keyNodeInfo.length == 6) {
                    keyNodeSaveRet = this.setKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "1", keyDataNodePair, transactionCode, ImdstDefine.delayWriteFlg);
                } else if (keyNodeInfo.length == 9) {
                    keyNodeSaveRet = this.setKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "1", keyDataNodePair, transactionCode, ImdstDefine.delayWriteFlg);
                }
                if (keyNodeSaveRet[1].equals("true")) {
                    retStrs[0] = "1";
                    retStrs[1] = "true";
                    retStrs[2] = "OK";
                    break block24;
                }
                if (keyNodeSaveRet[1].equals("false")) {
                    retStrs[0] = "1";
                    retStrs[1] = "false";
                    retStrs[2] = keyNodeSaveRet[2];
                    break block24;
                }
                throw new BatchException("Key Data Save Error");
            }
            catch (BatchException be) {
                logger.info("MasterManagerHelper - setKeyValue - Error", be);
                retStrs[0] = "1";
                retStrs[1] = "error";
                retStrs[2] = "NG:MasterNode - setKeyValue - Exception - " + be.toString();
            }
            catch (Exception e) {
                logger.info("MasterManagerHelper - setKeyValue - Error", e);
                retStrs[0] = "1";
                retStrs[1] = "false";
                retStrs[2] = "NG:MasterNode - Exception";
            }
        }
        return retStrs;
    }

    private String[] setKeyValueAndCreateIndex(String keyStr, String tagStr, String transactionCode, String dataStr, String indexPrefix, int indexLength, int indexMinLength) throws BatchException {
        String[] retStrs = new String[3];
        try {
            String checkStr;
            int i;
            int typeIdx;
            String[] oldValueData;
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "42";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            if (!this.checkValueLength(dataStr)) {
                retStrs[0] = "42";
                retStrs[1] = "false";
                retStrs[2] = "Value Length Error";
                return retStrs;
            }
            if (indexPrefix.equals("(B)")) {
                indexPrefix = "";
            }
            if ((oldValueData = this.getKeyValue(keyStr)) != null && oldValueData[1].equals("true")) {
                byte[] oldTestBytes = BASE64DecoderStream.decode((byte[])oldValueData[2].getBytes(ImdstDefine.characterDecodeSetBySearch));
                String oldSIdx1 = null;
                Object oldSIdx2 = null;
                String oldStrIdx = "";
                String oldPrefix = (keyStr.hashCode() << 1 >>> 1) % ImdstDefine.searchIndexDistributedCount + "_" + indexPrefix + "_";
                String oldRealKeyStr = new String(oldTestBytes, ImdstDefine.characterDecodeSetBySearch);
                for (typeIdx = indexMinLength; typeIdx < indexLength; ++typeIdx) {
                    String[] rmRet;
                    try {
                        for (i = 0; i < ImdstDefine.saveDataMaxSize; ++i) {
                            checkStr = oldRealKeyStr.substring(i, i + typeIdx);
                            if (SystemUtil.checkNoIndexCharacter(checkStr)) continue;
                            oldSIdx1 = new String(BASE64EncoderStream.encode((byte[])(oldPrefix + checkStr).getBytes(ImdstDefine.characterDecodeSetBySearch)));
                            rmRet = this.removeTargetTagInKey(oldSIdx1, keyStr, "0");
                        }
                    }
                    catch (Exception inE) {
                        // empty catch block
                    }
                    for (i = 0; i < searchIndexDictionaryList.length; ++i) {
                        if (oldRealKeyStr.indexOf(searchIndexDictionaryList[i]) == -1) continue;
                        checkStr = searchIndexDictionaryList[i];
                        oldSIdx1 = new String(BASE64EncoderStream.encode((byte[])(oldPrefix + checkStr).getBytes(ImdstDefine.characterDecodeSetBySearch)));
                        rmRet = this.removeTargetTagInKey(oldSIdx1, keyStr, "0");
                    }
                }
            }
            String appendTagSep = "";
            byte[] testBytes = BASE64DecoderStream.decode((byte[])dataStr.getBytes(ImdstDefine.characterDecodeSetBySearch));
            String sIdx1 = null;
            Object sIdx2 = null;
            String strIdx = "";
            String prefix = (keyStr.hashCode() << 1 >>> 1) % ImdstDefine.searchIndexDistributedCount + "_" + indexPrefix + "_";
            String realKeyStr = new String(testBytes, ImdstDefine.characterDecodeSetBySearch);
            for (typeIdx = indexMinLength; typeIdx < indexLength; ++typeIdx) {
                try {
                    for (i = 0; i < ImdstDefine.saveDataMaxSize; ++i) {
                        checkStr = realKeyStr.substring(i, i + typeIdx);
                        if (SystemUtil.checkNoIndexCharacter(checkStr)) continue;
                        sIdx1 = new String(BASE64EncoderStream.encode((byte[])(prefix + checkStr).getBytes(ImdstDefine.characterDecodeSetBySearch)));
                        strIdx = strIdx + appendTagSep + sIdx1;
                        appendTagSep = ":";
                    }
                }
                catch (Exception inE) {
                    // empty catch block
                }
                for (i = 0; i < searchIndexDictionaryList.length; ++i) {
                    if (realKeyStr.indexOf(searchIndexDictionaryList[i]) == -1) continue;
                    checkStr = searchIndexDictionaryList[i];
                    sIdx1 = new String(BASE64EncoderStream.encode((byte[])(prefix + checkStr).getBytes(ImdstDefine.characterDecodeSetBySearch)));
                    strIdx = strIdx + appendTagSep + sIdx1;
                    appendTagSep = ":";
                }
            }
            if (tagStr.equals("(B)")) {
                tagStr = null;
            }
            if ((tagStr = tagStr != null && !tagStr.equals("") ? tagStr + ":" + strIdx : strIdx).indexOf(":") != -1) {
                HashMap<String, StringBuilder> batchTagRegisterMap = new HashMap<String, StringBuilder>(8);
                String[] workTagList = tagStr.split(":");
                for (int i2 = 0; i2 < workTagList.length; ++i2) {
                    StringBuilder buildBatchTagBuf;
                    workTagList[i2] = this.encodeIsolationConvert(workTagList[i2]);
                    if (!this.checkKeyLength(workTagList[i2])) {
                        retStrs[0] = "42";
                        retStrs[1] = "false";
                        throw new BatchException("Tag Data Length Error");
                    }
                    String[] tagKeyNodeInfo = DataDispatcher.dispatchKeyNode(workTagList[i2], false);
                    if (batchTagRegisterMap.containsKey(tagKeyNodeInfo[2])) {
                        buildBatchTagBuf = (StringBuilder)batchTagRegisterMap.get(tagKeyNodeInfo[2]);
                        buildBatchTagBuf.append(";");
                        buildBatchTagBuf.append(workTagList[i2]);
                        batchTagRegisterMap.put(tagKeyNodeInfo[2], buildBatchTagBuf);
                        continue;
                    }
                    buildBatchTagBuf = new StringBuilder(128);
                    buildBatchTagBuf.append(workTagList[i2]);
                    batchTagRegisterMap.put(tagKeyNodeInfo[2], buildBatchTagBuf);
                }
                Set batchTagEntrySet = batchTagRegisterMap.entrySet();
                Iterator batchTagEntryIte = batchTagEntrySet.iterator();
                String registerTagSep = "";
                StringBuilder registerTagStrBuf = new StringBuilder(256);
                while (batchTagEntryIte.hasNext()) {
                    Map.Entry obj = batchTagEntryIte.next();
                    String keyNodeInfoFullName = (String)obj.getKey();
                    StringBuilder buildBatchTagBuf = (StringBuilder)batchTagRegisterMap.get(keyNodeInfoFullName);
                    registerTagStrBuf.append(registerTagSep);
                    registerTagStrBuf.append(buildBatchTagBuf.toString());
                    registerTagSep = ":";
                }
                tagStr = registerTagStrBuf.toString();
            }
            retStrs = this.setKeyValue(keyStr, tagStr, transactionCode, dataStr, true);
            retStrs[0] = "42";
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return retStrs;
    }

    private String[] setKeyValueOnlyOnce(String keyStr, String tagStr, String transactionCode, String dataStr) throws BatchException {
        String[] retStrs = new String[3];
        String[] tagKeyPair = null;
        String[] keyNodeSaveRet = null;
        String[] keyDataNodePair = null;
        if (tagStr.equals("(B)")) {
            tagStr = null;
        }
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "6";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            if (!this.checkValueLength(dataStr)) {
                retStrs[0] = "6";
                retStrs[1] = "false";
                retStrs[2] = "Value Length Error";
                return retStrs;
            }
            String[] keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, false);
            keyDataNodePair = new String[]{keyStr, dataStr};
            if (keyNodeInfo.length == 3) {
                keyNodeSaveRet = this.setKeyNodeValueOnlyOnce(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "1", keyDataNodePair, transactionCode);
            } else if (keyNodeInfo.length == 6) {
                keyNodeSaveRet = this.setKeyNodeValueOnlyOnce(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "1", keyDataNodePair, transactionCode);
            } else if (keyNodeInfo.length == 9) {
                keyNodeSaveRet = this.setKeyNodeValueOnlyOnce(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "1", keyDataNodePair, transactionCode);
            }
            if (keyNodeSaveRet[1].equals("false")) {
                retStrs[0] = "6";
                retStrs[1] = "false";
                retStrs[2] = keyNodeSaveRet[2];
                return retStrs;
            }
            if (tagStr != null && !tagStr.equals("")) {
                String[] tags = tagStr.split(":");
                for (int i = 0; i < tags.length; ++i) {
                    tags[i] = this.encodeIsolationConvert(tags[i]);
                    if (!this.checkKeyLength(tags[i])) {
                        retStrs[0] = "6";
                        retStrs[1] = "false";
                        throw new BatchException("Tag Length Error");
                    }
                    String[] tagKeyNodeInfo = DataDispatcher.dispatchKeyNode(tags[i], false);
                    tagKeyPair = new String[]{tags[i], keyStr};
                    if (tagKeyNodeInfo.length == 3) {
                        keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], null, null, null, "3", tagKeyPair, transactionCode);
                    } else if (tagKeyNodeInfo.length == 6) {
                        keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], "3", tagKeyPair, transactionCode);
                    } else if (tagKeyNodeInfo.length == 9) {
                        keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], tagKeyNodeInfo[6], tagKeyNodeInfo[7], tagKeyNodeInfo[8], "3", tagKeyPair, transactionCode);
                    }
                    if (!keyNodeSaveRet[1].equals("false")) continue;
                    retStrs[0] = "6";
                    retStrs[1] = "false";
                    retStrs[2] = keyNodeSaveRet[2];
                    throw new BatchException("Tag Data Save Error");
                }
            }
            retStrs[0] = "6";
            retStrs[1] = "true";
            retStrs[2] = "OK";
        }
        catch (BatchException be) {
            logger.info("MasterManagerHelper - setKeyValueOnlyOnce - Error", be);
            retStrs[0] = "6";
            retStrs[1] = "error";
            retStrs[2] = "NG:MasterNode - Exception";
        }
        catch (Exception e) {
            logger.info("MasterManagerHelper - setKeyValueOnlyOnce - Error", e);
            retStrs[0] = "6";
            retStrs[1] = "false";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] setKeyValueVersionCheck(String keyStr, String tagStr, String transactionCode, String dataStr, String checkVersionNo) throws BatchException {
        String[] retStrs = new String[3];
        String[] tagKeyPair = null;
        String[] keyNodeSaveRet = null;
        String[] keyDataNodePair = null;
        if (tagStr.equals("(B)")) {
            tagStr = null;
        }
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "16";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            if (!this.checkValueLength(dataStr)) {
                retStrs[0] = "16";
                retStrs[1] = "false";
                retStrs[2] = "Value Length Error";
                return retStrs;
            }
            String[] keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, false);
            keyDataNodePair = new String[]{keyStr, dataStr};
            if (keyNodeInfo.length == 3) {
                keyNodeSaveRet = this.setKeyNodeValueVersionCheck(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "1", keyDataNodePair, transactionCode, checkVersionNo, true);
            } else if (keyNodeInfo.length == 6) {
                keyNodeSaveRet = this.setKeyNodeValueVersionCheck(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "1", keyDataNodePair, transactionCode, checkVersionNo, true);
            } else if (keyNodeInfo.length == 9) {
                keyNodeSaveRet = this.setKeyNodeValueVersionCheck(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "1", keyDataNodePair, transactionCode, checkVersionNo);
            }
            if (keyNodeSaveRet[1].equals("false")) {
                retStrs[0] = "16";
                retStrs[1] = "false";
                retStrs[2] = keyNodeSaveRet[2];
                return retStrs;
            }
            if (tagStr != null && !tagStr.equals("")) {
                String[] tags = tagStr.split(":");
                for (int i = 0; i < tags.length; ++i) {
                    tags[i] = this.encodeIsolationConvert(tags[i]);
                    if (!this.checkKeyLength(tags[i])) {
                        retStrs[0] = "16";
                        retStrs[1] = "false";
                        throw new BatchException("Tag Length Error");
                    }
                    String[] tagKeyNodeInfo = DataDispatcher.dispatchKeyNode(tags[i], false);
                    tagKeyPair = new String[]{tags[i], keyStr};
                    if (tagKeyNodeInfo.length == 3) {
                        keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], null, null, null, "3", tagKeyPair, transactionCode);
                    } else if (tagKeyNodeInfo.length == 6) {
                        keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], "3", tagKeyPair, transactionCode);
                    } else if (tagKeyNodeInfo.length == 9) {
                        keyNodeSaveRet = this.setKeyNodeValue(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], tagKeyNodeInfo[6], tagKeyNodeInfo[7], tagKeyNodeInfo[8], "3", tagKeyPair, transactionCode);
                    }
                    if (!keyNodeSaveRet[1].equals("false")) continue;
                    retStrs[0] = "16";
                    retStrs[1] = "false";
                    retStrs[2] = keyNodeSaveRet[2];
                    throw new BatchException("Tag Data Save Error");
                }
            }
            retStrs[0] = "16";
            retStrs[1] = "true";
            retStrs[2] = "OK";
        }
        catch (BatchException be) {
            logger.info("MasterManagerHelper - setKeyValueVersionCheck - Error", be);
            retStrs[0] = "16";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        catch (Exception e) {
            logger.info("MasterManagerHelper - setKeyValueVersionCheck - Error", e);
            retStrs[0] = "16";
            retStrs[1] = "false";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] getKeyValue(String keyStr) throws BatchException {
        return this.getKeyValue(keyStr, false);
    }

    private String[] getKeyValue(String keyStr, boolean multiGet) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeSaveRet = null;
        String[] keyNodeInfo = null;
        try {
            if (!multiGet) {
                if (!this.checkKeyLength(keyStr = this.encodeIsolationConvert(keyStr))) {
                    retStrs[0] = "2";
                    retStrs[1] = "false";
                    retStrs[2] = "Key Length Error";
                    return retStrs;
                }
                keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess);
                if (keyNodeInfo.length == 3) {
                    keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "2", keyStr);
                } else if (keyNodeInfo.length == 6) {
                    keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "2", keyStr);
                } else if (keyNodeInfo.length == 9) {
                    keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "2", keyStr);
                }
                if (keyNodeSaveRet[1].equals("false")) {
                    int i = 0;
                    while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess, i)) != null) {
                        if (keyNodeInfo.length == 3) {
                            keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "2", keyStr);
                        } else if (keyNodeInfo.length == 6) {
                            keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "2", keyStr);
                        } else if (keyNodeInfo.length == 9) {
                            keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "2", keyStr);
                        }
                        if (keyNodeSaveRet[1].equals("true")) break;
                        ++i;
                    }
                }
                if (keyNodeSaveRet[1].equals("false")) {
                    retStrs[0] = keyNodeSaveRet[0];
                    retStrs[1] = "false";
                    retStrs[2] = "";
                } else {
                    retStrs[0] = keyNodeSaveRet[0];
                    retStrs[1] = "true";
                    retStrs[2] = keyNodeSaveRet[2];
                }
            } else {
                String[] keys = keyStr.split(";");
                HashMap<String, StringBuilder> requestKeyMap = new HashMap<String, StringBuilder>();
                HashMap<String, String[]> requestNodeMap = new HashMap<String, String[]>();
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = this.encodeIsolationConvert(keys[i]);
                    keyNodeInfo = DataDispatcher.dispatchKeyNode(keys[i], this.reverseAccess);
                    StringBuilder buf = (StringBuilder)requestKeyMap.get(keyNodeInfo[2]);
                    if (buf == null) {
                        buf = new StringBuilder();
                        buf.append(keys[i]);
                    } else {
                        buf.append(";");
                        buf.append(keys[i]);
                    }
                    requestKeyMap.put(keyNodeInfo[2], buf);
                    requestNodeMap.put(keyNodeInfo[2], keyNodeInfo);
                }
                Set entrySet = requestNodeMap.entrySet();
                Iterator entryIte = entrySet.iterator();
                StringBuilder lastResultBuf = new StringBuilder(1024);
                String lastRetSep = "";
                while (entryIte.hasNext()) {
                    Map.Entry obj = entryIte.next();
                    String nodeFullName = (String)obj.getKey();
                    keyNodeInfo = (String[])requestNodeMap.get(nodeFullName);
                    StringBuilder buf = (StringBuilder)requestKeyMap.get(nodeFullName);
                    String getKeysStr = buf.toString();
                    if (getKeysStr.indexOf(";") == -1) {
                        buf.append(";");
                    }
                    getKeysStr = null;
                    if (keyNodeInfo.length == 3) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "2", buf.toString());
                    } else if (keyNodeInfo.length == 6) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "2", buf.toString());
                    } else if (keyNodeInfo.length == 9) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "2", buf.toString());
                    }
                    if (keyNodeSaveRet == null || !keyNodeSaveRet[0].equals("2") || !keyNodeSaveRet[1].equals("true")) continue;
                    String resultStr = keyNodeSaveRet[2];
                    String[] multiresult = resultStr.split(";");
                    for (int idx = 0; idx < multiresult.length; ++idx) {
                        String[] isolationWorlRet = multiresult[idx].split(":");
                        isolationWorlRet[0] = this.decodeIsolationConvert(isolationWorlRet[0]);
                        lastResultBuf.append(lastRetSep);
                        lastResultBuf.append(isolationWorlRet[0]);
                        lastResultBuf.append(":");
                        lastResultBuf.append(isolationWorlRet[1]);
                        lastRetSep = ";";
                    }
                }
                retStrs[0] = "2";
                retStrs[1] = "true";
                retStrs[2] = lastResultBuf.toString();
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - getKeyValue - Error", be);
            retStrs[0] = "2";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - getKeyValue - Error", e);
            retStrs[0] = "2";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] getValueAndUpdateExpireTime(String keyStr) throws BatchException {
        String[] retStrs = new String[3];
        try {
            String[] getRet = this.getKeyValueAndVersion(keyStr);
            if (getRet[1].equals("false")) {
                retStrs[0] = "17";
                retStrs[1] = "false";
                retStrs[2] = "";
                return retStrs;
            }
            retStrs[0] = "17";
            retStrs[1] = "true";
            retStrs[2] = getRet[2];
            String[] metaColumns = null;
            String[] valueSplit = getRet[2].split(",");
            if (valueSplit.length > 1) {
                metaColumns = valueSplit[1].split(AbstractProtocolTaker.metaColumnSep);
            }
            if (valueSplit.length > 1 && metaColumns.length > 2 && !metaColumns[2].equals("0") && AbstractProtocolTaker.expireCheck(metaColumns[1])) {
                String[] newSetValue = new String[]{keyStr, "(B)", "0", valueSplit[0] + "," + metaColumns[0] + AbstractProtocolTaker.metaColumnSep + AbstractProtocolTaker.calcExpireTime(metaColumns[2]) + AbstractProtocolTaker.metaColumnSep + metaColumns[2]};
                String[] updateRet = this.setKeyValueVersionCheck(newSetValue[0], newSetValue[1], newSetValue[2], newSetValue[3], getRet[3]);
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - getValueAndUpdateExpireTime - Error", be);
            retStrs[0] = "17";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - getValueAndUpdateExpireTime - Error", e);
            retStrs[0] = "17";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] searchValueIndex(String indexStrs, String searchType, String indexPrefix, int searchIndexLength) throws BatchException {
        String[] retStrs = new String[3];
        StringBuilder retKeysBuf = new StringBuilder();
        String retKeysSep = "";
        try {
            if (indexStrs.length() < 1) {
                retStrs[0] = "43";
                retStrs[1] = "false";
                retStrs[2] = "Search Keyword Length Error";
                retStrs[3] = "";
                return retStrs;
            }
            if (indexPrefix.equals("(B)")) {
                indexPrefix = "";
            }
            String[] workKeywords = indexStrs.split(":");
            ArrayList<String> decodeWorkKeywords = new ArrayList<String>(5);
            ArrayList<String[]> allSearchWordList = new ArrayList<String[]>();
            ArrayList<Boolean> fullMatchList = new ArrayList<Boolean>();
            for (int idx = 0; idx < workKeywords.length; ++idx) {
                boolean fullMatch = false;
                boolean dictionaryMatch = false;
                String workStr = new String(BASE64DecoderStream.decode((byte[])workKeywords[idx].getBytes(ImdstDefine.characterDecodeSetBySearch)), ImdstDefine.characterDecodeSetBySearch);
                String keyword = "";
                if (searchIndexDictionaryMap.containsKey(workStr)) {
                    keyword = workStr;
                    dictionaryMatch = true;
                } else if (workStr.length() > searchIndexLength) {
                    keyword = workStr.substring(0, searchIndexLength);
                } else if (workStr.length() <= searchIndexLength) {
                    keyword = workStr;
                    fullMatch = true;
                } else if (searchIndexLength > 3 && workStr.length() > 3) {
                    searchIndexLength = workStr.length();
                    keyword = workStr.substring(0, searchIndexLength);
                } else {
                    keyword = workStr.length() > 2 ? workStr.substring(0, 3) : (workStr.length() > 1 ? workStr.substring(0, 2) : workStr);
                }
                if (!dictionaryMatch && SystemUtil.checkNoIndexCharacter(keyword)) continue;
                decodeWorkKeywords.add(workStr);
                String[] singleWordList = new String[ImdstDefine.searchIndexDistributedCount];
                StringBuilder workBuf = new StringBuilder(256);
                for (int i = 0; i < ImdstDefine.searchIndexDistributedCount; ++i) {
                    workBuf.delete(0, 1024);
                    workBuf.append(i).append("_").append(indexPrefix).append("_").append(keyword);
                    singleWordList[i] = new String(BASE64EncoderStream.encode((byte[])workBuf.toString().getBytes(ImdstDefine.characterDecodeSetBySearch)));
                }
                allSearchWordList.add(singleWordList);
                fullMatchList.add(new Boolean(fullMatch));
            }
            HashMap<String, String> retMap = new HashMap<String, String>(512);
            HashMap<String, String> fullMatchKeyMap = new HashMap<String, String>(512);
            if (allSearchWordList.size() < 1) {
                retStrs[0] = "43";
                retStrs[1] = "false";
                retStrs[2] = "";
                return retStrs;
            }
            if (searchType.equals("1")) {
                String[] singleWordList = (String[])allSearchWordList.get(0);
                boolean fullMatchFlg = (Boolean)fullMatchList.get(0);
                for (int i = 0; i < singleWordList.length; ++i) {
                    String[] ret = this.getTagKeys(singleWordList[i], true);
                    if (!ret[0].equals("4") || !ret[1].equals("true")) continue;
                    String targetKeysStr = ret[2];
                    String[] targetKeyList = targetKeysStr.split(":");
                    for (int ii = 0; ii < targetKeyList.length; ++ii) {
                        if (!retMap.containsKey(targetKeyList[ii]) && fullMatchFlg) {
                            fullMatchKeyMap.put(targetKeyList[ii], "");
                            continue;
                        }
                        retMap.put(targetKeyList[ii], "");
                        if (!fullMatchKeyMap.containsKey(targetKeyList[ii])) continue;
                        fullMatchKeyMap.remove(targetKeyList[ii]);
                    }
                }
                if (retMap.size() == 0 && fullMatchKeyMap.size() == 0) {
                    retStrs[0] = "43";
                    retStrs[1] = "false";
                    retStrs[2] = "";
                    return retStrs;
                }
            } else {
                for (int idx = 0; idx < allSearchWordList.size(); ++idx) {
                    String[] singleWordList = (String[])allSearchWordList.get(idx);
                    boolean fullMatchFlg = (Boolean)fullMatchList.get(idx);
                    for (int i = 0; i < singleWordList.length; ++i) {
                        String[] ret = this.getTagKeys(singleWordList[i], true);
                        if (!ret[0].equals("4") || !ret[1].equals("true")) continue;
                        String targetKeysStr = ret[2];
                        String[] targetKeyList = targetKeysStr.split(":");
                        for (int ii = 0; ii < targetKeyList.length; ++ii) {
                            if (!retMap.containsKey(targetKeyList[ii]) && fullMatchFlg) {
                                fullMatchKeyMap.put(targetKeyList[ii], "");
                                continue;
                            }
                            retMap.put(targetKeyList[ii], "");
                            if (!fullMatchKeyMap.containsKey(targetKeyList[ii])) continue;
                            fullMatchKeyMap.remove(targetKeyList[ii]);
                        }
                    }
                }
            }
            HashMap<String, StringBuilder> targetSumKeysMap = new HashMap<String, StringBuilder>();
            HashMap<String, Object> targetNodeInfoMap = new HashMap<String, Object>();
            if (retMap.size() > 0 || fullMatchKeyMap.size() > 0 && workKeywords.length > 1 && searchType.equals("1")) {
                KeyNodeConnector keyNodeConnector;
                StringBuilder keys;
                String nodeFullName;
                Map.Entry obj;
                String[] keyNodeInfo;
                if (fullMatchKeyMap.size() > 0) {
                    retMap.putAll(fullMatchKeyMap);
                }
                fullMatchKeyMap.clear();
                Set entrySet = retMap.entrySet();
                Iterator entryIte = entrySet.iterator();
                int nodeNamePrefix = 0;
                int cnt = 0;
                while (entryIte.hasNext()) {
                    StringBuilder keyBuf;
                    if (++cnt % 5000 == 0) {
                        ++nodeNamePrefix;
                    }
                    Map.Entry obj2 = entryIte.next();
                    String key = (String)obj2.getKey();
                    String cnvIsolationKey = this.encodeIsolationConvert(key);
                    keyNodeInfo = DataDispatcher.dispatchKeyNode(cnvIsolationKey, this.reverseAccess);
                    String prefixFullNodeName = nodeNamePrefix + "_" + keyNodeInfo[2];
                    if (targetSumKeysMap.containsKey(prefixFullNodeName)) {
                        keyBuf = (StringBuilder)targetSumKeysMap.get(prefixFullNodeName);
                        keyBuf.append(":");
                        keyBuf.append(cnvIsolationKey);
                        targetSumKeysMap.put(prefixFullNodeName, keyBuf);
                        continue;
                    }
                    targetNodeInfoMap.put(prefixFullNodeName, keyNodeInfo);
                    keyBuf = new StringBuilder(256);
                    keyBuf.append(cnvIsolationKey);
                    targetSumKeysMap.put(prefixFullNodeName, keyBuf);
                }
                Set nodeEntrySet = targetSumKeysMap.entrySet();
                Iterator nodeEntryIte = nodeEntrySet.iterator();
                String matchKeySep = "";
                keyNodeInfo = null;
                String[] keyNodeSaveRet = null;
                while (nodeEntryIte.hasNext()) {
                    obj = nodeEntryIte.next();
                    nodeFullName = (String)obj.getKey();
                    keys = (StringBuilder)targetSumKeysMap.get(nodeFullName);
                    keyNodeInfo = (String[])targetNodeInfoMap.get(nodeFullName);
                    keyNodeConnector = null;
                    int useNodeIdx = 0;
                    try {
                        useNodeIdx = 1;
                        keyNodeConnector = this.createKeyNodeConnection(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], false);
                        if (keyNodeConnector == null && keyNodeInfo.length > 3) {
                            useNodeIdx = 2;
                            keyNodeConnector = this.createKeyNodeConnection(keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], false);
                        }
                        if (keyNodeConnector == null) {
                            useNodeIdx = 1;
                            keyNodeConnector = this.createKeyNodeConnection(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], false);
                        }
                        if (keyNodeConnector == null && keyNodeInfo.length > 6) {
                            useNodeIdx = 3;
                            keyNodeConnector = this.createKeyNodeConnection(keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], false);
                        }
                        if (keyNodeConnector == null) {
                            throw new BatchException("DataNode Connect Error");
                        }
                        StringBuilder buf = new StringBuilder(512);
                        Object sendStr = null;
                        buf.append("50");
                        buf.append(",");
                        buf.append(this.stringCnv(keys.toString()));
                        buf.append(",");
                        buf.append(indexStrs);
                        buf.append(",");
                        buf.append(searchType);
                        keyNodeConnector.println(buf.toString());
                        keyNodeConnector.flush();
                        targetNodeInfoMap.put(nodeFullName + "_CONNECT", keyNodeConnector);
                    }
                    catch (Exception inEx1) {
                        keyNodeConnector = null;
                        targetNodeInfoMap.put(nodeFullName + "_CONNECT", null);
                        throw inEx1;
                    }
                }
                nodeEntrySet = targetSumKeysMap.entrySet();
                nodeEntryIte = nodeEntrySet.iterator();
                matchKeySep = "";
                while (nodeEntryIte.hasNext()) {
                    obj = nodeEntryIte.next();
                    nodeFullName = (String)obj.getKey();
                    keys = (StringBuilder)targetSumKeysMap.get(nodeFullName);
                    keyNodeInfo = (String[])targetNodeInfoMap.get(nodeFullName);
                    keyNodeConnector = (KeyNodeConnector)targetNodeInfoMap.get(nodeFullName + "_CONNECT");
                    if (keyNodeInfo.length == 3) {
                        keyNodeSaveRet = this.matchTargetKeyPairValueCharacter(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, keys.toString(), indexStrs, searchType, keyNodeConnector);
                    } else if (keyNodeInfo.length == 6) {
                        keyNodeSaveRet = this.matchTargetKeyPairValueCharacter(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keys.toString(), indexStrs, searchType, keyNodeConnector);
                    } else if (keyNodeInfo.length == 9) {
                        keyNodeSaveRet = this.matchTargetKeyPairValueCharacter(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], keys.toString(), indexStrs, searchType, keyNodeConnector);
                    }
                    if (!keyNodeSaveRet[1].equals("true")) continue;
                    retKeysBuf.append(matchKeySep);
                    if (keyNodeSaveRet[2].indexOf(":") != -1) {
                        String[] isolationDecodeWorkList = keyNodeSaveRet[2].split(":");
                        StringBuilder newDecodeKeyBuf = new StringBuilder(keyNodeSaveRet[2].length());
                        String newDecodeSep = "";
                        for (int idx = 0; idx < isolationDecodeWorkList.length; ++idx) {
                            newDecodeKeyBuf.append(newDecodeSep);
                            newDecodeKeyBuf.append(this.decodeIsolationConvert(isolationDecodeWorkList[idx]));
                            newDecodeSep = ":";
                        }
                        keyNodeSaveRet[2] = newDecodeKeyBuf.toString();
                        newDecodeKeyBuf = null;
                    } else {
                        keyNodeSaveRet[2] = this.decodeIsolationConvert(keyNodeSaveRet[2]);
                    }
                    retKeysBuf.append(keyNodeSaveRet[2]);
                    matchKeySep = ":";
                }
                retStrs[0] = "43";
                if (fullMatchKeyMap.size() > 0) {
                    String fullMatchKeySep = "";
                    if (retKeysBuf.length() > 0) {
                        fullMatchKeySep = ":";
                    }
                    Set fullMatchEntrySet = fullMatchKeyMap.entrySet();
                    for (Map.Entry obj3 : fullMatchEntrySet) {
                        String fullMatchKeyCharacter = (String)obj3.getKey();
                        retKeysBuf.append(fullMatchKeySep);
                        retKeysBuf.append(fullMatchKeyCharacter);
                        fullMatchKeySep = ":";
                    }
                }
                retStrs[1] = retKeysBuf.length() > 0 ? "true" : "false";
                retStrs[2] = retKeysBuf.toString();
            } else if (fullMatchKeyMap.size() > 0) {
                retStrs[0] = "43";
                if (fullMatchKeyMap.size() > 0) {
                    String fullMatchKeySep = "";
                    if (retKeysBuf.length() > 0) {
                        fullMatchKeySep = ":";
                    }
                    Set fullMatchEntrySet = fullMatchKeyMap.entrySet();
                    for (Map.Entry obj : fullMatchEntrySet) {
                        String fullMatchKeyCharacter = (String)obj.getKey();
                        retKeysBuf.append(fullMatchKeySep);
                        retKeysBuf.append(fullMatchKeyCharacter);
                        fullMatchKeySep = ":";
                    }
                }
                retStrs[1] = retKeysBuf.length() > 0 ? "true" : "false";
                retStrs[2] = retKeysBuf.toString();
            } else {
                retStrs[0] = "43";
                retStrs[1] = "false";
                retStrs[2] = "";
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - searchValueIndex - Error", be);
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - searchValueIndex - Exception", e);
            retStrs[0] = "43";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] getKeyValueAndVersion(String keyStr) throws BatchException {
        String[] retStrs = new String[4];
        String[] keyNodeSaveRet = null;
        String[] keyNodeInfo = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "15";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                retStrs[3] = "";
                return retStrs;
            }
            keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess);
            if (keyNodeInfo.length == 3) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "2", keyStr, true);
            } else if (keyNodeInfo.length == 6) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "2", keyStr, true);
            } else if (keyNodeInfo.length == 9) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "2", keyStr, true);
            }
            if (keyNodeSaveRet[1].equals("false")) {
                int i = 0;
                while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess, i)) != null) {
                    if (keyNodeInfo.length == 3) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "2", keyStr, true);
                    } else if (keyNodeInfo.length == 6) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "2", keyStr, true);
                    } else if (keyNodeInfo.length == 9) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "2", keyStr, true);
                    }
                    if (keyNodeSaveRet[1].equals("true")) break;
                    ++i;
                }
            }
            if (keyNodeSaveRet[1].equals("false")) {
                retStrs[0] = "15";
                retStrs[1] = "false";
                retStrs[2] = "";
                retStrs[3] = "";
            } else {
                retStrs[0] = "15";
                retStrs[1] = "true";
                retStrs[2] = keyNodeSaveRet[2];
                retStrs[3] = keyNodeSaveRet[3];
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - getKeyValueAndVersion - Error", be);
            retStrs[0] = "15";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
            retStrs[3] = "";
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - getKeyValueAndVersion - Error", e);
            retStrs[0] = "15";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
            retStrs[3] = "";
        }
        return retStrs;
    }

    private String[] getKeyValueScript(String keyStr, String scriptStr) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeSaveRet = null;
        String[] keyNodeInfo = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "8";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess);
            if (keyNodeInfo.length == 3) {
                keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "8", keyStr, scriptStr);
            } else if (keyNodeInfo.length == 6) {
                keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "8", keyStr, scriptStr);
            } else if (keyNodeInfo.length == 9) {
                keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "8", keyStr, scriptStr);
            }
            if (keyNodeSaveRet[1].equals("false")) {
                int i = 0;
                while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, this.reverseAccess, i)) != null) {
                    if (keyNodeInfo.length == 3) {
                        keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "8", keyStr, scriptStr);
                    } else if (keyNodeInfo.length == 6) {
                        keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "8", keyStr, scriptStr);
                    } else if (keyNodeInfo.length == 9) {
                        keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "8", keyStr, scriptStr);
                    }
                    if (keyNodeSaveRet[1].equals("true")) break;
                    ++i;
                }
            }
            if (keyNodeSaveRet[1].equals("false")) {
                retStrs[0] = keyNodeSaveRet[0];
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = keyNodeSaveRet[0];
                retStrs[1] = keyNodeSaveRet[1];
                retStrs[2] = keyNodeSaveRet[2];
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - getKeyValueScript - Error", be);
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - getKeyValueScript - Error", e);
            retStrs[0] = "8";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] getKeyValueScriptForUpdate(String keyStr, String scriptStr) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeSaveRet = null;
        String[] keyNodeInfo = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "9";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, false);
            try {
                if (keyNodeInfo.length > 2) {
                    keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "8", keyStr, scriptStr);
                }
            }
            catch (Exception e1) {
                retStrs[0] = "9";
                retStrs[1] = "error";
                retStrs[2] = "MasterNode - Exception";
            }
            try {
                if (keyNodeInfo.length > 5) {
                    keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], null, null, null, "8", keyStr, scriptStr);
                }
            }
            catch (Exception e2) {
                retStrs[0] = "9";
                retStrs[1] = "error";
                retStrs[2] = "MasterNode - Exception";
            }
            try {
                if (keyNodeInfo.length > 8) {
                    keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], null, null, null, "8", keyStr, scriptStr);
                }
            }
            catch (Exception e3) {
                retStrs[0] = "9";
                retStrs[1] = "error";
                retStrs[2] = "MasterNode - Exception";
            }
            if (keyNodeSaveRet == null && retStrs != null) {
                return retStrs;
            }
            if (keyNodeSaveRet[1].equals("false")) {
                int i = 0;
                while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, false, i)) != null) {
                    try {
                        if (keyNodeInfo.length > 2) {
                            keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "8", keyStr, scriptStr);
                        }
                    }
                    catch (Exception e1) {
                        retStrs[0] = "9";
                        retStrs[1] = "error";
                        retStrs[2] = "MasterNode - Exception";
                    }
                    try {
                        if (keyNodeInfo.length > 5) {
                            keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], null, null, null, "8", keyStr, scriptStr);
                        }
                    }
                    catch (Exception e2) {
                        retStrs[0] = "9";
                        retStrs[1] = "error";
                        retStrs[2] = "MasterNode - Exception";
                    }
                    try {
                        if (keyNodeInfo.length > 8) {
                            keyNodeSaveRet = this.getKeyNodeValueScript(keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], null, null, null, "8", keyStr, scriptStr);
                        }
                    }
                    catch (Exception e3) {
                        retStrs[0] = "9";
                        retStrs[1] = "error";
                        retStrs[2] = "MasterNode - Exception";
                    }
                    if (keyNodeSaveRet != null && keyNodeSaveRet[1].equals("true")) break;
                    ++i;
                }
            }
            if (keyNodeSaveRet == null && retStrs != null) {
                return retStrs;
            }
            if (keyNodeSaveRet[1].equals("false")) {
                retStrs[0] = "9";
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = "9";
                retStrs[1] = keyNodeSaveRet[1];
                retStrs[2] = keyNodeSaveRet[2];
            }
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - getKeyValueScriptForUpdate - Error", e);
            retStrs[0] = "9";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] removeKeyValue(String keyStr, String transactionCode) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeRemoveRet = null;
        String[] keyNodeInfo = null;
        String[] oldKeyNodeRemoveRet = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "5";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, false);
            if (keyNodeInfo.length == 3) {
                keyNodeRemoveRet = this.removeKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, keyStr, transactionCode);
            } else if (keyNodeInfo.length == 6) {
                keyNodeRemoveRet = this.removeKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyStr, transactionCode);
            } else if (keyNodeInfo.length == 9) {
                keyNodeRemoveRet = this.removeKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], keyStr, transactionCode);
            }
            int i = 0;
            while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, false, i)) != null) {
                if (keyNodeInfo.length == 3) {
                    oldKeyNodeRemoveRet = this.removeKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, keyStr, transactionCode);
                } else if (keyNodeInfo.length == 6) {
                    oldKeyNodeRemoveRet = this.removeKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyStr, transactionCode);
                } else if (keyNodeInfo.length == 9) {
                    oldKeyNodeRemoveRet = this.removeKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], keyStr, transactionCode);
                }
                if ((keyNodeRemoveRet == null || keyNodeRemoveRet[1].equals("false")) && oldKeyNodeRemoveRet != null && oldKeyNodeRemoveRet[1].equals("true")) {
                    keyNodeRemoveRet = oldKeyNodeRemoveRet;
                }
                ++i;
            }
            if (keyNodeRemoveRet == null || keyNodeRemoveRet.length < 1) {
                throw new BatchException("Key Node IO Error: detail info for log file");
            }
            if (keyNodeRemoveRet[1].equals("false")) {
                retStrs[0] = keyNodeRemoveRet[0];
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = keyNodeRemoveRet[0];
                retStrs[1] = "true";
                retStrs[2] = keyNodeRemoveRet[2];
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - removeKeyValue - Error", be);
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - removeKeyValue - Error", e);
            retStrs[0] = "5";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] removeSearchIndex(String keyStr, String transactionCode, String indexPrefix, int indexLength) throws BatchException {
        String[] retStrs = new String[3];
        try {
            String[] oldValueData;
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "44";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            if (indexPrefix.equals("(B)")) {
                indexPrefix = "";
            }
            if ((oldValueData = this.getKeyValue(keyStr)) != null && oldValueData[1].equals("true")) {
                byte[] oldTestBytes = BASE64DecoderStream.decode((byte[])oldValueData[2].getBytes(ImdstDefine.characterDecodeSetBySearch));
                String oldSIdx1 = null;
                String oldPrefix = (keyStr.hashCode() << 1 >>> 1) % ImdstDefine.searchIndexDistributedCount + "_" + indexPrefix + "_";
                String oldRealKeyStr = new String(oldTestBytes, ImdstDefine.characterDecodeSetBySearch);
                for (int typeIdx = 1; typeIdx < indexLength; ++typeIdx) {
                    try {
                        for (int i = 0; i < ImdstDefine.saveDataMaxSize; ++i) {
                            String checkStr = oldRealKeyStr.substring(i, i + typeIdx);
                            if (SystemUtil.checkNoIndexCharacter(checkStr)) continue;
                            oldSIdx1 = new String(BASE64EncoderStream.encode((byte[])(oldPrefix + checkStr).getBytes(ImdstDefine.characterDecodeSetBySearch)));
                            try {
                                this.removeTargetTagInKey(oldSIdx1, keyStr, "0");
                                continue;
                            }
                            catch (Exception removeE) {
                                retStrs[0] = "44";
                                retStrs[1] = "false";
                                retStrs[2] = "";
                                return retStrs;
                            }
                        }
                        continue;
                    }
                    catch (Exception inE) {
                        // empty catch block
                    }
                }
            }
            retStrs[0] = "44";
            retStrs[1] = "true";
            retStrs[2] = "";
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - removeSearchIndex - Error", be);
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - removeSearchIndex - Error", e);
            retStrs[0] = "44";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] removeTargetTagInKey(String tagStr, String keyStr, String transactionCode) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeRemoveRet = null;
        String[] oldKeyNodeRemoveRet = null;
        try {
            String[] tagKeyNodeInfo;
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "40";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            if (!this.checkKeyLength(tagStr = this.encodeIsolationConvert(tagStr))) {
                retStrs[0] = "40";
                retStrs[1] = "false";
                retStrs[2] = "Tag Data Length Error";
            }
            if ((tagKeyNodeInfo = DataDispatcher.dispatchKeyNode(tagStr, false)).length == 3) {
                keyNodeRemoveRet = this.removeTargetTagInKey(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], null, null, null, tagStr, keyStr, transactionCode);
            } else if (tagKeyNodeInfo.length == 6) {
                keyNodeRemoveRet = this.removeTargetTagInKey(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], tagStr, keyStr, transactionCode);
            } else if (tagKeyNodeInfo.length == 9) {
                keyNodeRemoveRet = this.removeTargetTagInKey(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], tagKeyNodeInfo[6], tagKeyNodeInfo[7], tagKeyNodeInfo[8], tagStr, keyStr, transactionCode);
            }
            int i = 0;
            while ((tagKeyNodeInfo = DataDispatcher.dispatchKeyNode(tagStr, false, i)) != null) {
                if (tagKeyNodeInfo.length == 3) {
                    oldKeyNodeRemoveRet = this.removeTargetTagInKey(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], null, null, null, tagStr, keyStr, transactionCode);
                } else if (tagKeyNodeInfo.length == 6) {
                    oldKeyNodeRemoveRet = this.removeTargetTagInKey(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], tagStr, keyStr, transactionCode);
                } else if (tagKeyNodeInfo.length == 9) {
                    oldKeyNodeRemoveRet = this.removeTargetTagInKey(tagKeyNodeInfo[0], tagKeyNodeInfo[1], tagKeyNodeInfo[2], tagKeyNodeInfo[3], tagKeyNodeInfo[4], tagKeyNodeInfo[5], tagKeyNodeInfo[6], tagKeyNodeInfo[7], tagKeyNodeInfo[8], tagStr, keyStr, transactionCode);
                }
                if ((keyNodeRemoveRet == null || keyNodeRemoveRet[1].equals("false")) && oldKeyNodeRemoveRet != null && oldKeyNodeRemoveRet[1].equals("true")) {
                    keyNodeRemoveRet = oldKeyNodeRemoveRet;
                }
                ++i;
            }
            if (keyNodeRemoveRet == null || keyNodeRemoveRet.length < 1) {
                throw new BatchException("Key Node IO Error: detail info for log file");
            }
            if (keyNodeRemoveRet[1].equals("false")) {
                retStrs[0] = keyNodeRemoveRet[0];
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = keyNodeRemoveRet[0];
                retStrs[1] = "true";
                retStrs[2] = "";
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - removeTargetTagInKey - Error", be);
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - removeTargetTagInKey - Error", e);
            retStrs[0] = "40";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] decrValue(String keyStr, String transactionCode, String decrValue) throws BatchException {
        String[] retStrs = new String[3];
        try {
            String decodeData = new String(BASE64DecoderStream.decode((byte[])decrValue.getBytes()));
            String minus = "";
            if (decodeData.indexOf("-") != 0) {
                minus = "-";
            }
            retStrs = this.incrValue(keyStr, transactionCode, new String(BASE64EncoderStream.encode((byte[])(minus + decodeData).getBytes())));
            retStrs[0] = "14";
        }
        catch (BatchException be) {
            logger.info("MasterManagerHelper - decrValue - Error", be);
        }
        catch (Exception e) {
            logger.info("MasterManagerHelper - decrValue - Error", e);
            retStrs[0] = "14";
            retStrs[1] = "false";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] incrValue(String keyStr, String transactionCode, String incrValue) throws BatchException {
        String[] retStrs = new String[3];
        int idx = 0;
        String[] calcRet = null;
        String[] calcFixValue = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "13";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            String[] keyNodeInfo = DataDispatcher.dispatchKeyNode(keyStr, false);
            for (idx = 0; idx < keyNodeInfo.length; idx += 3) {
                calcRet = null;
                calcRet = this.calcKeyValue(keyNodeInfo[idx], keyNodeInfo[idx + 1], keyNodeInfo[idx + 2], keyStr, incrValue, transactionCode);
                if (calcRet == null || !calcRet[1].equals("true") || calcFixValue != null) continue;
                calcFixValue = new String[]{keyStr, calcRet[2]};
            }
            if (calcFixValue != null) {
                retStrs[0] = "13";
                retStrs[1] = "true";
                retStrs[2] = calcFixValue[1];
            } else {
                retStrs[0] = "13";
                retStrs[1] = "false";
                retStrs[2] = "NG";
            }
        }
        catch (BatchException be) {
            logger.info("MasterManagerHelper - incrValue - Error", be);
        }
        catch (Exception e) {
            logger.info("MasterManagerHelper - incrValue - Error", e);
            retStrs[0] = "13";
            retStrs[1] = "false";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] lockingData(String keyStr, String transactionCode, String lockingTime, String lockingWaitTime) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeLockRet = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.transactionMode) {
                retStrs = new String[]{"30", "false"};
                return retStrs;
            }
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "30";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            keyNodeLockRet = this.lockKeyNodeValue(this.transactionManagerInfo[0], this.transactionManagerInfo[1], keyStr, transactionCode, lockingTime, lockingWaitTime);
            if (keyNodeLockRet[1].equals("false")) {
                retStrs[0] = keyNodeLockRet[0];
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = keyNodeLockRet[0];
                retStrs[1] = "true";
                retStrs[2] = keyNodeLockRet[2];
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - lockingData - Error", be);
        }
        catch (Exception e) {
            retStrs[0] = "30";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] releaseLockingData(String keyStr, String transactionCode) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeReleaseRet = null;
        try {
            keyStr = this.encodeIsolationConvert(keyStr);
            if (!this.transactionMode) {
                retStrs = new String[]{"31", "false"};
                return retStrs;
            }
            if (!this.checkKeyLength(keyStr)) {
                retStrs[0] = "31";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            keyNodeReleaseRet = this.releaseLockKeyNodeValue(this.transactionManagerInfo[0], this.transactionManagerInfo[1], keyStr, transactionCode);
            if (keyNodeReleaseRet[1].equals("false")) {
                retStrs[0] = "31";
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = "31";
                retStrs[1] = "true";
                retStrs[2] = keyNodeReleaseRet[2];
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - releaseLockingData - Error", be);
        }
        catch (Exception e) {
            retStrs[0] = "31";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] startTransaction() throws BatchException {
        String[] retStrs = new String[3];
        if (!this.transactionMode) {
            retStrs[0] = "37";
            retStrs[1] = "false";
            retStrs[2] = "No Transaction Mode";
            return retStrs;
        }
        retStrs[0] = "37";
        retStrs[1] = "true";
        retStrs[2] = Long.valueOf(System.nanoTime()).toString() + new Integer(this.hashCode()).toString();
        return retStrs;
    }

    private boolean truncateAllData(String truncateKey) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        logger.info("TruncateAllData Execute Date[" + new Date().toString() + "] IsolationKey[" + truncateKey + "]");
        Object retParams = null;
        Object cnvConsistencyRet = null;
        boolean slaveUse = false;
        boolean mainRetry = false;
        Object nowUseNodeInfo = null;
        Object se = null;
        Object ie = null;
        try {
            HashMap allNodeInfo = DataDispatcher.getAllDataNodeInfo();
            ArrayList mainNodeList = (ArrayList)allNodeInfo.get("main");
            ArrayList subNodeList = (ArrayList)allNodeInfo.get("sub");
            ArrayList thirdNodeList = (ArrayList)allNodeInfo.get("third");
            for (int idx = 0; idx < mainNodeList.size(); ++idx) {
                String retParam;
                String mainDataNodeInfo = (String)mainNodeList.get(idx);
                String[] workDataNodeInfo = mainDataNodeInfo.split(":");
                keyNodeConnector = this.createKeyNodeConnection(workDataNodeInfo[0], workDataNodeInfo[1], mainDataNodeInfo, false);
                keyNodeConnector.setSoTimeout(300000);
                if (keyNodeConnector != null) {
                    keyNodeConnector.println("61,#" + truncateKey);
                    keyNodeConnector.flush();
                    String retParam2 = keyNodeConnector.readLine("61,#" + truncateKey);
                }
                keyNodeConnector.setSoTimeout(ImdstDefine.nodeConnectionTimeout);
                super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                if (subNodeList != null && subNodeList.size() > idx) {
                    String subDataNodeInfo = (String)subNodeList.get(idx);
                    String[] subWorkDataNodeInfo = subDataNodeInfo.split(":");
                    keyNodeConnector = this.createKeyNodeConnection(subWorkDataNodeInfo[0], subWorkDataNodeInfo[1], subDataNodeInfo, false);
                    keyNodeConnector.setSoTimeout(300000);
                    if (keyNodeConnector != null) {
                        keyNodeConnector.println("61,#" + truncateKey);
                        keyNodeConnector.flush();
                        retParam = keyNodeConnector.readLine("61,#" + truncateKey);
                    }
                    keyNodeConnector.setSoTimeout(ImdstDefine.nodeConnectionTimeout);
                    super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                }
                if (thirdNodeList == null || thirdNodeList.size() <= idx) continue;
                String thirdDataNodeInfo = (String)thirdNodeList.get(idx);
                String[] thirdWorkDataNodeInfo = thirdDataNodeInfo.split(":");
                keyNodeConnector = this.createKeyNodeConnection(thirdWorkDataNodeInfo[0], thirdWorkDataNodeInfo[1], thirdDataNodeInfo, false);
                keyNodeConnector.setSoTimeout(300000);
                if (keyNodeConnector != null) {
                    keyNodeConnector.println("61,#" + truncateKey);
                    keyNodeConnector.flush();
                    retParam = keyNodeConnector.readLine("61,#" + truncateKey);
                }
                keyNodeConnector.setSoTimeout(ImdstDefine.nodeConnectionTimeout);
                super.addKeyNodeCacheConnectionPool(keyNodeConnector);
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - truncateAllData - Error", be);
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - truncateAllData - Error", e);
        }
        return true;
    }

    private String[] getTagKeys(String tagStr, boolean noExistsData) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeSaveRet = null;
        try {
            tagStr = this.encodeIsolationConvert(tagStr);
            if (!this.checkKeyLength(tagStr)) {
                retStrs[0] = "4";
                retStrs[1] = "false";
                retStrs[2] = "Tag Length Error";
                return retStrs;
            }
            String[] keyNodeInfo = DataDispatcher.dispatchKeyNode(tagStr, false);
            if (keyNodeInfo.length == 3) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "4", tagStr);
            } else if (keyNodeInfo.length == 6) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "4", tagStr);
            } else if (keyNodeInfo.length == 9) {
                keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "4", tagStr);
            }
            if (keyNodeSaveRet[1].equals("false")) {
                int i = 0;
                while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(tagStr, this.reverseAccess, i)) != null) {
                    if (keyNodeInfo.length == 3) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "4", tagStr);
                    } else if (keyNodeInfo.length == 6) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "4", tagStr);
                    } else if (keyNodeInfo.length == 9) {
                        keyNodeSaveRet = this.getKeyNodeValue(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "4", tagStr);
                    }
                    if (keyNodeSaveRet[1].equals("true")) break;
                    ++i;
                }
            }
            if (keyNodeSaveRet[1].equals("false")) {
                retStrs[0] = keyNodeSaveRet[0];
                retStrs[1] = "false";
                retStrs[2] = "";
            } else if (noExistsData) {
                retStrs[0] = keyNodeSaveRet[0];
                retStrs[1] = "true";
                if (!this.isolationMode) {
                    retStrs[2] = keyNodeSaveRet[2];
                } else {
                    String[] splitList = keyNodeSaveRet[2].split(":");
                    if (splitList.length > 0) {
                        StringBuilder retBuf = new StringBuilder(1024);
                        String retSep = "";
                        for (int idx = 0; idx < splitList.length; ++idx) {
                            retBuf.append(retSep);
                            retBuf.append(this.decodeIsolationConvert(splitList[idx]));
                            retSep = ":";
                        }
                        retStrs[2] = retBuf.toString();
                    }
                }
            } else {
                retStrs[0] = keyNodeSaveRet[0];
                retStrs[1] = "true";
                String[] splitList = keyNodeSaveRet[2].split(":");
                keyNodeSaveRet[2] = null;
                if (splitList.length > 0) {
                    StringBuilder retBuf = new StringBuilder(1024);
                    String retSep = "";
                    for (int idx = 0; idx < splitList.length; ++idx) {
                        String decodeIsokationCnvKey = this.decodeIsolationConvert(splitList[idx]);
                        String[] retKey = this.getKeyValue(decodeIsokationCnvKey);
                        if (!retKey[1].equals("true")) continue;
                        retBuf.append(retSep);
                        retBuf.append(decodeIsokationCnvKey);
                        retSep = ":";
                    }
                    retStrs[2] = retBuf.toString();
                    if (retStrs[2].length() == 0) {
                        retStrs[1] = "false";
                    }
                } else {
                    retStrs[1] = "false";
                    retStrs[2] = "";
                }
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - getTagKeys - Error", be);
            retStrs[0] = "4";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - getTagKeys - Exception", e);
            retStrs[0] = "4";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] getTargetTagIndexList(String tagStr) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeGetRet = null;
        String[] keyNodeInfo = null;
        try {
            tagStr = this.encodeIsolationConvert(tagStr);
            if (!this.checkKeyLength(tagStr)) {
                retStrs[0] = "45";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            keyNodeInfo = DataDispatcher.dispatchKeyNode(tagStr, this.reverseAccess);
            if (keyNodeInfo.length == 3) {
                keyNodeGetRet = this.getKeyNodeTagIndexList(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "45", tagStr);
            } else if (keyNodeInfo.length == 6) {
                keyNodeGetRet = this.getKeyNodeTagIndexList(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "45", tagStr);
            } else if (keyNodeInfo.length == 9) {
                keyNodeGetRet = this.getKeyNodeTagIndexList(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "45", tagStr);
            }
            if (keyNodeGetRet[1].equals("false")) {
                int i = 0;
                while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(tagStr, this.reverseAccess, i)) != null) {
                    if (keyNodeInfo.length == 3) {
                        keyNodeGetRet = this.getKeyNodeTagIndexList(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "45", tagStr);
                    } else if (keyNodeInfo.length == 6) {
                        keyNodeGetRet = this.getKeyNodeTagIndexList(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "45", tagStr);
                    } else if (keyNodeInfo.length == 9) {
                        keyNodeGetRet = this.getKeyNodeTagIndexList(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "45", tagStr);
                    }
                    if (keyNodeGetRet[1].equals("true")) break;
                    ++i;
                }
            }
            if (keyNodeGetRet[1].equals("false")) {
                retStrs[0] = keyNodeGetRet[0];
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = keyNodeGetRet[0];
                retStrs[1] = keyNodeGetRet[1];
                retStrs[2] = keyNodeGetRet[2];
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - getTargetTagIndexList - Error", be);
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - getTargetTagIndexList - Error", e);
            retStrs[0] = "45";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] getTargetIndexTagPair(String tagStr, String indexStr) throws BatchException {
        String[] retStrs = new String[3];
        String[] keyNodeGetRet = null;
        String[] keyNodeInfo = null;
        try {
            tagStr = this.encodeIsolationConvert(tagStr);
            if (!this.checkKeyLength(tagStr)) {
                retStrs[0] = "46";
                retStrs[1] = "false";
                retStrs[2] = "Key Length Error";
                return retStrs;
            }
            keyNodeInfo = DataDispatcher.dispatchKeyNode(tagStr, this.reverseAccess);
            if (keyNodeInfo.length == 3) {
                keyNodeGetRet = this.getKeyNodeTargetIndexTagKey(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "46", tagStr, indexStr);
            } else if (keyNodeInfo.length == 6) {
                keyNodeGetRet = this.getKeyNodeTargetIndexTagKey(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "46", tagStr, indexStr);
            } else if (keyNodeInfo.length == 9) {
                keyNodeGetRet = this.getKeyNodeTargetIndexTagKey(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "46", tagStr, indexStr);
            }
            if (keyNodeGetRet[1].equals("false")) {
                int i = 0;
                while ((keyNodeInfo = DataDispatcher.dispatchKeyNode(tagStr, this.reverseAccess, i)) != null) {
                    if (keyNodeInfo.length == 3) {
                        keyNodeGetRet = this.getKeyNodeTargetIndexTagKey(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], null, null, null, "46", tagStr, indexStr);
                    } else if (keyNodeInfo.length == 6) {
                        keyNodeGetRet = this.getKeyNodeTargetIndexTagKey(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], "46", tagStr, indexStr);
                    } else if (keyNodeInfo.length == 9) {
                        keyNodeGetRet = this.getKeyNodeTargetIndexTagKey(keyNodeInfo[0], keyNodeInfo[1], keyNodeInfo[2], keyNodeInfo[3], keyNodeInfo[4], keyNodeInfo[5], keyNodeInfo[6], keyNodeInfo[7], keyNodeInfo[8], "46", tagStr, indexStr);
                    }
                    if (keyNodeGetRet[1].equals("true")) break;
                    ++i;
                }
            }
            if (keyNodeGetRet[1].equals("false")) {
                retStrs[0] = keyNodeGetRet[0];
                retStrs[1] = "false";
                retStrs[2] = "";
            } else {
                retStrs[0] = keyNodeGetRet[0];
                retStrs[1] = keyNodeGetRet[1];
                retStrs[2] = keyNodeGetRet[2];
            }
        }
        catch (BatchException be) {
            logger.error("MasterManagerHelper - getTargetIndexTagPair - Error", be);
        }
        catch (Exception e) {
            logger.error("MasterManagerHelper - getTargetIndexTagPair - Error", e);
            retStrs[0] = "46";
            retStrs[1] = "error";
            retStrs[2] = "MasterNode - Exception";
        }
        return retStrs;
    }

    private String[] getKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String key) throws BatchException {
        return this.getKeyNodeValue(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, key, false);
    }

    private String[] getKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String key) throws BatchException {
        return this.getKeyNodeValue(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, type, key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String key, boolean returnVersion) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.getKeyNodeValue(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, key, returnVersion);
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block19: {
                try {
                    if (exceptionFlg) {
                        thirdRet = this.getKeyNodeValue(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, key, returnVersion);
                        ret = thirdRet;
                    } else if (thirdKeyNodeFullName != null) {
                        super.execNodeUseEnd(thirdKeyNodeFullName);
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block19;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] getKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String key, boolean returnVersion) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String[] retParams = null;
        String[] cnvConsistencyRet = null;
        boolean slaveUse = false;
        boolean mainRetry = false;
        int nowUse = 0;
        String[] mainNodeRetParam = null;
        String[] subNodeRetParam = null;
        Object nowUseNodeInfo = null;
        SocketException se = null;
        IOException ie = null;
        try {
            keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, false);
            nowUse = 1;
            while (true) {
                block35: {
                    if (keyNodeConnector == null) {
                        if (subKeyNodeName != null) {
                            keyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false);
                        }
                        if (keyNodeConnector == null) {
                            if (mainNodeRetParam != null) break;
                            throw new BatchException("Key Node IO Error: detail info for log file");
                        }
                        slaveUse = true;
                        nowUse = 2;
                    }
                    try {
                        String[] workRet;
                        String retParam;
                        this.getSendData.delete(0, Integer.MAX_VALUE);
                        String sendStr = null;
                        if (type.equals("2")) {
                            this.getSendData.append(type);
                            this.getSendData.append(",");
                            this.getSendData.append(this.stringCnv(key));
                            sendStr = this.getSendData.toString();
                            keyNodeConnector.println(sendStr);
                            keyNodeConnector.flush();
                            retParam = keyNodeConnector.readLine(sendStr);
                            retParams = retParam.split(",", 3);
                        } else if (type.equals("4")) {
                            this.getSendData.append(type);
                            this.getSendData.append(",");
                            this.getSendData.append(this.stringCnv(key));
                            sendStr = this.getSendData.toString();
                            keyNodeConnector.println(this.getSendData.toString());
                            keyNodeConnector.flush();
                            retParam = new String(SystemUtil.valueDecompress(BASE64DecoderStream.decode((byte[])keyNodeConnector.readLine(sendStr).getBytes())));
                            retParams = retParam.split(",", 3);
                        }
                        super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                        if (type.equals("4")) {
                            if (retParams == null || retParams.length <= 1 || !retParams[1].equals("true")) break;
                            cnvConsistencyRet = this.dataConvert4Consistency(retParams[2]);
                            retParams[2] = cnvConsistencyRet[0];
                            if (returnVersion) {
                                workRet = new String[retParams.length + 1];
                                for (int idx = 0; idx < retParams.length; ++idx) {
                                    workRet[idx] = retParams[idx];
                                }
                                workRet[retParams.length] = cnvConsistencyRet[1];
                                break;
                            }
                            retParams[2] = cnvConsistencyRet[0];
                            break;
                        }
                        if (this.dataConsistencyMode < 2) {
                            if (retParams == null || retParams.length <= 1 || !retParams[1].equals("true")) break;
                            cnvConsistencyRet = this.dataConvert4Consistency(retParams[2]);
                            retParams[2] = cnvConsistencyRet[0];
                            if (returnVersion) {
                                workRet = new String[retParams.length + 1];
                                for (int idx = 0; idx < retParams.length; ++idx) {
                                    workRet[idx] = retParams[idx];
                                }
                                workRet[retParams.length] = cnvConsistencyRet[1];
                                retParams = workRet;
                                break;
                            }
                            retParams[2] = cnvConsistencyRet[0];
                            break;
                        }
                        if (nowUse == 1) {
                            mainNodeRetParam = retParams;
                        }
                        if (nowUse == 2) {
                            subNodeRetParam = retParams;
                        }
                        if (subKeyNodeName == null || mainNodeRetParam != null && subNodeRetParam != null) {
                            break;
                        }
                    }
                    catch (SocketException tSe) {
                        se = tSe;
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                    }
                    catch (IOException tIe) {
                        ie = tIe;
                        if (keyNodeConnector == null) break block35;
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                }
                if (slaveUse) {
                    if (mainRetry) {
                        if (mainNodeRetParam != null || subNodeRetParam != null) break;
                        if (se != null) {
                            throw se;
                        }
                        if (ie != null) {
                            throw ie;
                        }
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, true);
                    if (keyNodeConnector == null) {
                        if (mainNodeRetParam != null || subNodeRetParam != null) break;
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    mainRetry = true;
                    nowUse = 1;
                    continue;
                }
                if (subKeyNodeName == null) {
                    if (mainNodeRetParam != null) break;
                    if (se != null) {
                        throw se;
                    }
                    if (ie == null) continue;
                    throw ie;
                }
                keyNodeConnector = null;
            }
            if (type.equals("2") && this.dataConsistencyMode == 2) {
                retParams = this.strongConsistencyDataConvert(retParams, mainNodeRetParam, subNodeRetParam, type, returnVersion);
            }
        }
        catch (Exception e) {
            logger.error("PollQueue =[" + this.myPollQueue + "] RequestTime=[" + new Date() + "] ErrorKey=[" + new String(BASE64DecoderStream.decode((byte[])this.decodeIsolationConvert(key).getBytes())) + "]");
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            this.getSendData.delete(0, Integer.MAX_VALUE);
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getKeyNodeValueScript(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String key, String scriptStr) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.getKeyNodeValueScript(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, key, scriptStr);
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block19: {
                try {
                    if (exceptionFlg) {
                        thirdRet = this.getKeyNodeValueScript(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, key, scriptStr);
                        ret = thirdRet;
                    } else if (thirdKeyNodeFullName != null) {
                        super.execNodeUseEnd(thirdKeyNodeFullName);
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block19;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] getKeyNodeValueScript(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String key, String scriptStr) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String[] retParams = null;
        String[] cnvConsistencyRet = null;
        boolean slaveUse = false;
        boolean mainRetry = false;
        Object nowUseNodeInfo = null;
        SocketException se = null;
        IOException ie = null;
        try {
            keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, false);
            while (true) {
                block28: {
                    if (keyNodeConnector == null) {
                        if (subKeyNodeName != null) {
                            keyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false);
                        }
                        if (keyNodeConnector == null) {
                            throw new BatchException("Key Node IO Error: detail info for log file");
                        }
                        slaveUse = true;
                    }
                    try {
                        if (type.equals("8")) {
                            StringBuilder buf = new StringBuilder(512);
                            String sendStr = null;
                            buf.append("8");
                            buf.append(",");
                            buf.append(this.stringCnv(key));
                            buf.append(",");
                            buf.append(scriptStr);
                            sendStr = buf.toString();
                            keyNodeConnector.println(buf.toString());
                            keyNodeConnector.flush();
                            String retParam = keyNodeConnector.readLine(sendStr);
                            retParams = retParam.split(",", 3);
                        }
                        super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                        if (this.dataConsistencyMode == 0) {
                            if (retParams != null && retParams.length > 1 && retParams[1].equals("true")) {
                                cnvConsistencyRet = this.dataConvert4Consistency((String)retParams[2]);
                                retParams[2] = cnvConsistencyRet[0];
                            }
                        } else if (retParams != null && retParams.length > 1 && retParams[1].equals("true")) {
                            cnvConsistencyRet = this.dataConvert4Consistency((String)retParams[2]);
                            retParams[2] = cnvConsistencyRet[0];
                        }
                        break;
                    }
                    catch (SocketException tSe) {
                        se = tSe;
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                    }
                    catch (IOException tIe) {
                        ie = tIe;
                        if (keyNodeConnector == null) break block28;
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                }
                if (slaveUse) {
                    if (mainRetry) {
                        if (se != null) {
                            throw se;
                        }
                        if (ie != null) {
                            throw ie;
                        }
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, true);
                    if (keyNodeConnector == null) {
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    mainRetry = true;
                    continue;
                }
                if (subKeyNodeName == null) {
                    if (se != null) {
                        throw se;
                    }
                    if (ie == null) continue;
                    throw ie;
                }
                keyNodeConnector = null;
            }
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getKeyNodeTagIndexList(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String tag) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.getKeyNodeTagIndexList(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, tag);
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block19: {
                try {
                    if (exceptionFlg) {
                        thirdRet = this.getKeyNodeTagIndexList(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, tag);
                        ret = thirdRet;
                    } else if (thirdKeyNodeFullName != null) {
                        super.execNodeUseEnd(thirdKeyNodeFullName);
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block19;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] getKeyNodeTagIndexList(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String tag) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String[] retParams = null;
        Object cnvConsistencyRet = null;
        boolean slaveUse = false;
        boolean mainRetry = false;
        Object nowUseNodeInfo = null;
        SocketException se = null;
        IOException ie = null;
        try {
            keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, false);
            while (true) {
                block24: {
                    if (keyNodeConnector == null) {
                        if (subKeyNodeName != null) {
                            keyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false);
                        }
                        if (keyNodeConnector == null) {
                            throw new BatchException("Key Node IO Error: detail info for log file");
                        }
                        slaveUse = true;
                    }
                    try {
                        if (type.equals("45")) {
                            StringBuilder buf = new StringBuilder(512);
                            String sendStr = null;
                            buf.append("45");
                            buf.append(",");
                            buf.append(this.stringCnv(tag));
                            sendStr = buf.toString();
                            keyNodeConnector.println(buf.toString());
                            keyNodeConnector.flush();
                            String retParam = keyNodeConnector.readLine(sendStr);
                            retParams = retParam.split(",", 3);
                        }
                        super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                        break;
                    }
                    catch (SocketException tSe) {
                        se = tSe;
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                    }
                    catch (IOException tIe) {
                        ie = tIe;
                        if (keyNodeConnector == null) break block24;
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                }
                if (slaveUse) {
                    if (mainRetry) {
                        if (se != null) {
                            throw se;
                        }
                        if (ie != null) {
                            throw ie;
                        }
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, true);
                    if (keyNodeConnector == null) {
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    mainRetry = true;
                    continue;
                }
                if (subKeyNodeName == null) {
                    if (se != null) {
                        throw se;
                    }
                    if (ie == null) continue;
                    throw ie;
                }
                keyNodeConnector = null;
            }
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getKeyNodeTargetIndexTagKey(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String tag, String indexStr) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.getKeyNodeTargetIndexTagKey(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, tag, indexStr);
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block19: {
                try {
                    if (exceptionFlg) {
                        thirdRet = this.getKeyNodeTargetIndexTagKey(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, tag, indexStr);
                        ret = thirdRet;
                    } else if (thirdKeyNodeFullName != null) {
                        super.execNodeUseEnd(thirdKeyNodeFullName);
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block19;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] getKeyNodeTargetIndexTagKey(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String tag, String indexStr) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String[] retParams = null;
        Object cnvConsistencyRet = null;
        boolean slaveUse = false;
        boolean mainRetry = false;
        Object nowUseNodeInfo = null;
        SocketException se = null;
        IOException ie = null;
        try {
            String[] splitList;
            keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, false);
            while (true) {
                block25: {
                    if (keyNodeConnector == null) {
                        if (subKeyNodeName != null) {
                            keyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false);
                        }
                        if (keyNodeConnector == null) {
                            throw new BatchException("Key Node IO Error: detail info for log file");
                        }
                        slaveUse = true;
                    }
                    try {
                        if (type.equals("46")) {
                            StringBuilder buf = new StringBuilder(512);
                            String sendStr = null;
                            buf.append("46");
                            buf.append(",");
                            buf.append(this.stringCnv(tag));
                            buf.append(",");
                            buf.append(this.stringCnv(indexStr));
                            sendStr = buf.toString();
                            keyNodeConnector.println(buf.toString());
                            keyNodeConnector.flush();
                            String retParam = keyNodeConnector.readLine(sendStr);
                            retParams = retParam.split(",", 3);
                        }
                        super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                        break;
                    }
                    catch (SocketException tSe) {
                        se = tSe;
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                    }
                    catch (IOException tIe) {
                        ie = tIe;
                        if (keyNodeConnector == null) break block25;
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                }
                if (slaveUse) {
                    if (mainRetry) {
                        if (se != null) {
                            throw se;
                        }
                        if (ie != null) {
                            throw ie;
                        }
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, true);
                    if (keyNodeConnector == null) {
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    mainRetry = true;
                    continue;
                }
                if (subKeyNodeName == null) {
                    if (se != null) {
                        throw se;
                    }
                    if (ie == null) continue;
                    throw ie;
                }
                keyNodeConnector = null;
            }
            if (retParams != null && retParams[1].equals("true") && this.isolationMode && (splitList = retParams[2].split(":")).length > 0) {
                StringBuilder retBuf = new StringBuilder(1024);
                String retSep = "";
                for (int idx = 0; idx < splitList.length; ++idx) {
                    retBuf.append(retSep);
                    retBuf.append(this.decodeIsolationConvert(splitList[idx]));
                    retSep = ":";
                }
                retParams[2] = retBuf.toString();
            }
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
        }
        return retParams;
    }

    private String[] setKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String[] values, String transactionCode) throws BatchException {
        return this.setKeyNodeValue(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, type, values, transactionCode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] setKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String[] values, String transactionCode, boolean delayFlg) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.setKeyNodeValue(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, values, transactionCode, delayFlg);
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block17: {
                try {
                    thirdRet = !delayFlg ? this.setKeyNodeValue(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, values, transactionCode) : (exceptionFlg ? this.setKeyNodeValue(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, values, transactionCode) : this.setKeyNodeValue(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, values, transactionCode, true));
                    if (exceptionFlg) {
                        ret = thirdRet;
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block17;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] setKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String[] values, String transactionCode) throws BatchException {
        return this.setKeyNodeValue(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, values, transactionCode, false);
    }

    private String[] setKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String[] values, String transactionCode, boolean delayFlg) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        KeyNodeConnector slaveKeyNodeConnector = null;
        String nodeName = keyNodeName;
        String nodePort = keyNodePort;
        String nodeFullName = keyNodeFullName;
        String[] retParams = null;
        boolean counter = false;
        Object tmpSaveHost = null;
        Object tmpSaveData = null;
        String retParam = null;
        boolean mainNodeSave = false;
        boolean subNodeSave = false;
        boolean slaveSendEnd = false;
        this.setSendData.delete(0, Integer.MAX_VALUE);
        String sendStr = null;
        boolean subNodeConnect = false;
        try {
            if (this.transactionMode) {
                String[] keyNodeLockRet;
                while ((keyNodeLockRet = this.hasLockKeyNode(this.transactionManagerInfo[0], this.transactionManagerInfo[1], values[0]))[1].equals("true") && !keyNodeLockRet[2].equals(transactionCode)) {
                }
            }
            this.setSendData.append(type);
            this.setSendData.append(",");
            this.setSendData.append(this.stringCnv(values[0]));
            this.setSendData.append(",");
            this.setSendData.append(transactionCode);
            this.setSendData.append(",");
            this.setSendData.append(values[1]);
            this.setSendData.append("!");
            this.setSendData.append(this.setTime);
            sendStr = this.setSendData.toString();
            keyNodeConnector = this.createKeyNodeConnection(nodeName, nodePort, nodeFullName, false);
            if (keyNodeConnector != null) {
                try {
                    if (!delayFlg) {
                        keyNodeConnector.println(sendStr);
                        keyNodeConnector.flush();
                        if (subKeyNodeName != null && (slaveKeyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false)) != null) {
                            slaveKeyNodeConnector.println(sendStr);
                            slaveKeyNodeConnector.flush();
                            slaveSendEnd = true;
                        }
                        retParam = keyNodeConnector.readLine(sendStr);
                        if (type.equals("1")) {
                            if (retParam != null && retParam.indexOf("1,true") == 0) {
                                mainNodeSave = true;
                            } else {
                                super.setDeadNode(nodeName + ":" + nodePort, 3, null);
                                logger.error("setKeyNodeValue Logical Error Node =[" + nodeName + ":" + nodePort + "] retParam=[" + retParam + "]" + " Connectoer=[" + keyNodeConnector.connectorDump() + "]");
                            }
                        } else if (type.equals("3")) {
                            if (retParam != null && retParam.indexOf("3,true") == 0) {
                                mainNodeSave = true;
                            } else {
                                super.setDeadNode(nodeName + ":" + nodePort, 4, null);
                                logger.error("setKeyNodeValue Logical Error Node =[" + nodeName + ":" + nodePort + "] retParam=[" + retParam + "]" + " Connectoer=[" + keyNodeConnector.connectorDump() + "]");
                            }
                        }
                    } else {
                        if (subKeyNodeName != null) {
                            slaveKeyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false);
                        }
                        keyNodeConnector.print("-");
                        keyNodeConnector.println(sendStr);
                        keyNodeConnector.flush();
                        mainNodeSave = true;
                        if (type.equals("1")) {
                            retParam = "1,true,OK";
                        } else if (type.equals("3")) {
                            retParam = "3,true,OK";
                        }
                    }
                    super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                }
                catch (SocketException se) {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    super.setDeadNode(nodeName + ":" + nodePort, 5, se);
                    logger.error("", se);
                }
                catch (IOException ie) {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    super.setDeadNode(nodeName + ":" + nodePort, 6, ie);
                    logger.error("", ie);
                }
                catch (Exception ee) {
                    super.setDeadNode(nodeName + ":" + nodePort, 7, ee);
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    logger.error("", ee);
                }
            }
            if (subKeyNodeName != null) {
                if (slaveKeyNodeConnector == null) {
                    slaveKeyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false);
                }
                if (slaveKeyNodeConnector != null) {
                    try {
                        if (!delayFlg || !mainNodeSave) {
                            if (!slaveSendEnd) {
                                slaveKeyNodeConnector.println(sendStr);
                                slaveKeyNodeConnector.flush();
                            }
                            if (type.equals("1")) {
                                retParam = slaveKeyNodeConnector.readLine(sendStr);
                                if (retParam != null && retParam.indexOf("1,true") == 0) {
                                    subNodeSave = true;
                                } else {
                                    super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 3, null);
                                    logger.error("setKeyNodeValue Logical Error Node =[" + subKeyNodeName + ":" + subKeyNodePort + "] retParam=[" + retParam + "]" + " Connectoer=[" + slaveKeyNodeConnector.connectorDump() + "]");
                                }
                            } else if (type.equals("3")) {
                                retParam = slaveKeyNodeConnector.readLine(sendStr);
                                if (retParam != null && retParam.indexOf("3,true") == 0) {
                                    subNodeSave = true;
                                } else {
                                    super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 4, null);
                                    logger.error("setKeyNodeValue Logical Error Node =[" + subKeyNodeName + ":" + subKeyNodePort + "] retParam=[" + retParam + "]" + " Connectoer=[" + slaveKeyNodeConnector.connectorDump() + "]");
                                }
                            }
                        } else {
                            slaveKeyNodeConnector.print("-");
                            slaveKeyNodeConnector.println(sendStr);
                            slaveKeyNodeConnector.flush();
                            subNodeSave = true;
                            if (type.equals("1")) {
                                retParam = "1,true,OK";
                            } else if (type.equals("3")) {
                                retParam = "3,true,OK";
                            }
                        }
                        super.addKeyNodeCacheConnectionPool(slaveKeyNodeConnector);
                    }
                    catch (SocketException se) {
                        if (slaveKeyNodeConnector != null) {
                            slaveKeyNodeConnector.close();
                            slaveKeyNodeConnector = null;
                        }
                        super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 5, se);
                        logger.debug(se);
                    }
                    catch (IOException ie) {
                        if (slaveKeyNodeConnector != null) {
                            slaveKeyNodeConnector.close();
                            slaveKeyNodeConnector = null;
                        }
                        super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 6, ie);
                        logger.debug(ie);
                    }
                    catch (Exception ee) {
                        if (slaveKeyNodeConnector != null) {
                            slaveKeyNodeConnector.close();
                            slaveKeyNodeConnector = null;
                        }
                        super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 7, ee);
                        logger.debug(ee);
                    }
                }
            }
            if (!mainNodeSave && !subNodeSave && retParam == null) {
                throw new BatchException("Key Node IO Error: detail info for log file");
            }
        }
        catch (BatchException be) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw be;
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
            if (retParam != null) {
                retParams = retParam.split(",");
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] setKeyNodeValueOnlyOnce(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String[] values, String transactionCode) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.setKeyNodeValueOnlyOnce(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, values, transactionCode);
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block21: {
                try {
                    if (exceptionFlg) {
                        thirdRet = this.setKeyNodeValueOnlyOnce(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, values, transactionCode);
                        ret = thirdRet;
                    } else if (ret[1].equals("true")) {
                        thirdRet = this.setKeyNodeValue(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, "1", values, transactionCode);
                    } else if (thirdKeyNodeFullName != null) {
                        super.execNodeUseEnd(thirdKeyNodeFullName);
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block21;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] setKeyNodeValueOnlyOnce(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String[] values, String transactionCode) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String nodeName = keyNodeName;
        String nodePort = keyNodePort;
        String nodeFullName = keyNodeFullName;
        String[] retParams = null;
        String[] mainRetParams = null;
        String[] subRetParams = null;
        boolean counter = false;
        Object tmpSaveHost = null;
        Object tmpSaveData = null;
        String retParam = null;
        boolean mainNodeSave = false;
        boolean mainNodeNetworkError = false;
        boolean subNodeSave = false;
        boolean subNodeNetworkError = false;
        try {
            block43: {
                block42: {
                    String decodeIsokationCnvKey;
                    String[] checkRet;
                    if (this.transactionMode) {
                        String[] keyNodeLockRet;
                        while ((keyNodeLockRet = this.hasLockKeyNode(this.transactionManagerInfo[0], this.transactionManagerInfo[1], values[0]))[1].equals("true") && !keyNodeLockRet[2].equals(transactionCode)) {
                        }
                    }
                    if (DataDispatcher.hasOldRule() && (checkRet = this.getKeyValue(decodeIsokationCnvKey = this.decodeIsolationConvert(values[0])))[0].equals("true")) {
                        retParams = new String[]{"6", "false", "NG:Data has already been registered"};
                        String[] stringArray = retParams;
                        return stringArray;
                    }
                    keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, false);
                    if (keyNodeConnector != null) {
                        try {
                            StringBuilder buf = new StringBuilder(512);
                            String sendStr = null;
                            buf.append("6");
                            buf.append(",");
                            buf.append(this.stringCnv(values[0]));
                            buf.append(",");
                            buf.append(transactionCode);
                            buf.append(",");
                            buf.append(values[1]);
                            buf.append("!");
                            buf.append(this.setTime);
                            sendStr = buf.toString();
                            keyNodeConnector.println(sendStr);
                            keyNodeConnector.flush();
                            retParam = keyNodeConnector.readLine(sendStr);
                            super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                            if (retParam.indexOf("6,true") == 0) {
                                mainNodeSave = true;
                                mainRetParams = retParam.split(",");
                                break block42;
                            }
                            mainNodeSave = false;
                            mainRetParams = retParam.split(",");
                        }
                        catch (SocketException se) {
                            mainNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(keyNodeName + ":" + keyNodePort, 8, se);
                            logger.debug(se);
                        }
                        catch (IOException ie) {
                            mainNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(keyNodeName + ":" + keyNodePort, 9, ie);
                            logger.debug(ie);
                        }
                        catch (Exception ee) {
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(keyNodeName + ":" + keyNodePort, 10, ee);
                            logger.debug(ee);
                        }
                    } else {
                        mainNodeNetworkError = true;
                    }
                }
                if (subKeyNodeName != null && (mainNodeSave || !mainNodeSave && mainNodeNetworkError)) {
                    String subNodeExecType = "";
                    subNodeExecType = !mainNodeSave ? "6" : "1";
                    keyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false);
                    if (keyNodeConnector != null) {
                        try {
                            StringBuilder buf = new StringBuilder(512);
                            String sendStr = null;
                            buf.append(subNodeExecType);
                            buf.append(",");
                            buf.append(this.stringCnv(values[0]));
                            buf.append(",");
                            buf.append(transactionCode);
                            buf.append(",");
                            buf.append(values[1]);
                            buf.append("!");
                            buf.append(this.setTime);
                            sendStr = buf.toString();
                            keyNodeConnector.println(sendStr);
                            keyNodeConnector.flush();
                            retParam = keyNodeConnector.readLine(sendStr);
                            super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                            if (retParam.indexOf("6,true") == 0) {
                                subNodeSave = true;
                                subRetParams = retParam.split(",");
                                break block43;
                            }
                            subNodeSave = false;
                            subRetParams = retParam.split(",");
                        }
                        catch (SocketException se) {
                            subNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 11, se);
                            logger.debug(se);
                        }
                        catch (IOException ie) {
                            subNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 12, ie);
                            logger.debug(ie);
                        }
                        catch (Exception ee) {
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 13, ee);
                            logger.debug(ee);
                        }
                    } else {
                        subNodeNetworkError = true;
                    }
                }
            }
            if (mainNodeNetworkError && subNodeNetworkError) {
                throw new BatchException("Key Node IO Error: detail info for log file");
            }
            if (!mainNodeSave) {
                if (!mainNodeNetworkError) {
                    retParams = mainRetParams;
                }
            } else {
                retParams = mainRetParams;
            }
            if (subKeyNodeName != null && retParams == null) {
                if (!subNodeSave) {
                    if (!subNodeNetworkError) {
                        retParams = subRetParams;
                    }
                } else {
                    retParams = subRetParams;
                }
            }
        }
        catch (BatchException be) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw be;
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] setKeyNodeValueVersionCheck(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String type, String[] values, String transactionCode, String checkVersionNo) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.setKeyNodeValueVersionCheck(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, type, values, transactionCode, checkVersionNo, true);
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block21: {
                try {
                    if (exceptionFlg) {
                        thirdRet = this.setKeyNodeValueVersionCheck(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, type, values, transactionCode, checkVersionNo, true);
                        ret = thirdRet;
                    } else if (ret[1].equals("true")) {
                        thirdRet = this.setKeyNodeValueVersionCheck(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, "1", values, transactionCode, checkVersionNo, false);
                    } else if (thirdKeyNodeFullName != null) {
                        super.execNodeUseEnd(thirdKeyNodeFullName);
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block21;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] setKeyNodeValueVersionCheck(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String type, String[] values, String transactionCode, String checkVersionNo, boolean execCheck) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String nodeName = keyNodeName;
        String nodePort = keyNodePort;
        String nodeFullName = keyNodeFullName;
        String[] retParams = null;
        String[] mainRetParams = null;
        String[] subRetParams = null;
        boolean counter = false;
        Object tmpSaveHost = null;
        Object tmpSaveData = null;
        String retParam = null;
        boolean mainNodeSave = false;
        boolean mainNodeNetworkError = false;
        boolean subNodeSave = false;
        boolean subNodeNetworkError = false;
        try {
            block41: {
                String sendStr;
                StringBuilder buf;
                block40: {
                    if (this.transactionMode) {
                        String[] keyNodeLockRet;
                        while ((keyNodeLockRet = this.hasLockKeyNode(this.transactionManagerInfo[0], this.transactionManagerInfo[1], values[0]))[1].equals("true") && !keyNodeLockRet[2].equals(transactionCode)) {
                        }
                    }
                    if ((keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, false)) != null) {
                        try {
                            buf = new StringBuilder(512);
                            sendStr = null;
                            buf.append("16");
                            buf.append(",");
                            buf.append(this.stringCnv(values[0]));
                            buf.append(",");
                            buf.append(transactionCode);
                            buf.append(",");
                            buf.append(checkVersionNo);
                            buf.append(",");
                            buf.append(execCheck);
                            buf.append(",");
                            buf.append(values[1]);
                            sendStr = buf.toString();
                            keyNodeConnector.println(sendStr);
                            keyNodeConnector.flush();
                            retParam = keyNodeConnector.readLine(sendStr);
                            super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                            if (retParam.indexOf("16,true") == 0) {
                                mainNodeSave = true;
                                mainRetParams = retParam.split(",");
                                break block40;
                            }
                            mainNodeSave = false;
                            mainRetParams = retParam.split(",");
                        }
                        catch (SocketException se) {
                            mainNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(keyNodeName + ":" + keyNodePort, 115, se);
                            logger.debug(se);
                        }
                        catch (IOException ie) {
                            mainNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(keyNodeName + ":" + keyNodePort, 116, ie);
                            logger.debug(ie);
                        }
                        catch (Exception ee) {
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(keyNodeName + ":" + keyNodePort, 117, ee);
                            logger.debug(ee);
                        }
                    } else {
                        mainNodeNetworkError = true;
                    }
                }
                if (subKeyNodeName != null && (mainNodeSave || !mainNodeSave && mainNodeNetworkError)) {
                    execCheck = !mainNodeSave;
                    keyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false);
                    if (keyNodeConnector != null) {
                        try {
                            buf = new StringBuilder(512);
                            sendStr = null;
                            buf.append("16");
                            buf.append(",");
                            buf.append(this.stringCnv(values[0]));
                            buf.append(",");
                            buf.append(transactionCode);
                            buf.append(",");
                            buf.append(checkVersionNo);
                            buf.append(",");
                            buf.append(execCheck);
                            buf.append(",");
                            buf.append(values[1]);
                            sendStr = buf.toString();
                            keyNodeConnector.println(sendStr);
                            keyNodeConnector.flush();
                            retParam = keyNodeConnector.readLine(sendStr);
                            super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                            if (retParam.indexOf("16,true") == 0) {
                                subNodeSave = true;
                                subRetParams = retParam.split(",");
                                break block41;
                            }
                            subNodeSave = false;
                            subRetParams = retParam.split(",");
                        }
                        catch (SocketException se) {
                            subNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 125, se);
                            logger.debug(se);
                        }
                        catch (IOException ie) {
                            subNodeNetworkError = true;
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 126, ie);
                            logger.debug(ie);
                        }
                        catch (Exception ee) {
                            if (keyNodeConnector != null) {
                                keyNodeConnector.close();
                                keyNodeConnector = null;
                            }
                            super.setDeadNode(subKeyNodeName + ":" + subKeyNodePort, 127, ee);
                            logger.debug(ee);
                        }
                    } else {
                        subNodeNetworkError = true;
                    }
                }
            }
            if (mainNodeNetworkError && subNodeNetworkError) {
                throw new BatchException("Key Node IO Error: detail info for log file");
            }
            if (!mainNodeSave) {
                if (!mainNodeNetworkError) {
                    retParams = mainRetParams;
                }
            } else {
                retParams = mainRetParams;
            }
            if (subKeyNodeName != null && retParams == null) {
                if (!subNodeSave) {
                    if (!subNodeNetworkError) {
                        retParams = subRetParams;
                    }
                } else {
                    retParams = subRetParams;
                }
            }
        }
        catch (BatchException be) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw be;
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] matchTargetKeyPairValueCharacter(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String keys, String characters, String type, KeyNodeConnector keyNodeConnector) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.matchTargetKeyPairValueCharacter(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, keys, characters, type, keyNodeConnector);
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block19: {
                try {
                    if (exceptionFlg) {
                        thirdRet = this.matchTargetKeyPairValueCharacter(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, keys, characters, type, keyNodeConnector);
                        ret = thirdRet;
                    } else if (thirdKeyNodeFullName != null) {
                        super.execNodeUseEnd(thirdKeyNodeFullName);
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block19;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] matchTargetKeyPairValueCharacter(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String keys, String characters, String type, KeyNodeConnector keyNodeConnector) throws BatchException {
        String[] retParams = null;
        Object cnvConsistencyRet = null;
        boolean slaveUse = false;
        boolean mainRetry = false;
        Object nowUseNodeInfo = null;
        String sendStr = null;
        StringBuilder buf = new StringBuilder(512);
        buf.append("50");
        buf.append(",");
        buf.append(this.stringCnv(keys));
        buf.append(",");
        buf.append(characters);
        buf.append(",");
        buf.append(type);
        sendStr = buf.toString();
        SocketException se = null;
        IOException ie = null;
        try {
            while (true) {
                block22: {
                    if (keyNodeConnector == null) {
                        if (subKeyNodeName != null) {
                            keyNodeConnector = this.createKeyNodeConnection(subKeyNodeName, subKeyNodePort, subKeyNodeFullName, false);
                            if (keyNodeConnector == null) {
                                throw new BatchException("Key Node IO Error: detail info for log file");
                            }
                            keyNodeConnector.println(sendStr);
                            keyNodeConnector.flush();
                        }
                        slaveUse = true;
                    }
                    try {
                        String retParam = keyNodeConnector.readLine(sendStr);
                        retParams = retParam.split(",");
                        super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                        if (retParams == null || retParams.length <= 1 || retParams[1].equals("error")) break block22;
                        break;
                    }
                    catch (SocketException tSe) {
                        se = tSe;
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                    }
                    catch (IOException tIe) {
                        ie = tIe;
                        if (keyNodeConnector == null) break block22;
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                }
                if (slaveUse) {
                    if (mainRetry) {
                        if (se != null) {
                            throw se;
                        }
                        if (ie != null) {
                            throw ie;
                        }
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    keyNodeConnector = this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, true);
                    if (keyNodeConnector == null) {
                        throw new BatchException("Key Node IO Error: detail info for log file");
                    }
                    keyNodeConnector.println(sendStr);
                    keyNodeConnector.flush();
                    mainRetry = true;
                    continue;
                }
                if (subKeyNodeName == null) {
                    if (se != null) {
                        throw se;
                    }
                    if (ie == null) continue;
                    throw ie;
                }
                keyNodeConnector = null;
            }
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] removeKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String key, String transactionCode) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.removeKeyNodeValue(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, key, transactionCode);
            if (ret == null) {
                throw new BatchException("removeKeyNodeValue - RetParam = null");
            }
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block18: {
                try {
                    thirdRet = this.removeKeyNodeValue(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, key, transactionCode);
                    if (exceptionFlg) {
                        ret = thirdRet;
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block18;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] removeKeyNodeValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String key, String transactionCode) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String nodeName = keyNodeName;
        String nodePort = keyNodePort;
        String nodeFullName = keyNodeFullName;
        String[] retParams = null;
        String[] cnvConsistencyRet = null;
        int counter = 0;
        Object tmpSaveHost = null;
        Object tmpSaveData = null;
        String retParam = null;
        boolean mainNodeSave = false;
        boolean subNodeSave = false;
        try {
            if (this.transactionMode) {
                String[] keyNodeLockRet;
                while ((keyNodeLockRet = this.hasLockKeyNode(this.transactionManagerInfo[0], this.transactionManagerInfo[1], key))[1].equals("true") && !keyNodeLockRet[2].equals(transactionCode)) {
                }
            }
            do {
                if ((keyNodeConnector = this.createKeyNodeConnection(nodeName, nodePort, nodeFullName, false)) != null) {
                    try {
                        StringBuilder buf = new StringBuilder(128);
                        String sendStr = null;
                        buf.append("5");
                        buf.append(",");
                        buf.append(this.stringCnv(key));
                        buf.append(",");
                        buf.append(transactionCode);
                        sendStr = buf.toString();
                        keyNodeConnector.println(sendStr);
                        keyNodeConnector.flush();
                        retParam = keyNodeConnector.readLine(sendStr);
                        super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                        if (retParam != null && retParam.indexOf("5,true") == 0) {
                            if (counter == 0) {
                                mainNodeSave = true;
                            }
                            if (counter == 1) {
                                subNodeSave = true;
                            }
                        } else if (retParam == null || retParam.indexOf("5,false") != 0) {
                            super.setDeadNode(nodeName + ":" + nodePort, 14, null);
                            logger.error("removeKeyNodeValue Logical Error Node =[" + nodeName + ":" + nodePort + "] retParam=[" + retParam + "]" + " Connectoer=[" + keyNodeConnector.connectorDump() + "]");
                        }
                    }
                    catch (SocketException se) {
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                        super.setDeadNode(nodeName + ":" + nodePort, 15, se);
                        logger.debug(se);
                    }
                    catch (IOException ie) {
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                        super.setDeadNode(nodeName + ":" + nodePort, 16, ie);
                        logger.debug(ie);
                    }
                    catch (Exception ee) {
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                        super.setDeadNode(nodeName + ":" + nodePort, 17, ee);
                        logger.debug(ee);
                    }
                }
                nodeName = subKeyNodeName;
                nodePort = subKeyNodePort;
                nodeFullName = subKeyNodeFullName;
            } while (nodeName != null && ++counter < 2);
        }
        catch (BatchException be) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw be;
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
            if (retParam != null && (retParams = retParam.split(","))[1].equals("true")) {
                cnvConsistencyRet = this.dataConvert4Consistency(retParams[2]);
                retParams[2] = cnvConsistencyRet[0];
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] removeTargetTagInKey(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String thirdKeyNodeName, String thirdKeyNodePort, String thirdKeyNodeFullName, String tag, String key, String transactionCode) throws BatchException {
        boolean exceptionFlg = false;
        String[] ret = null;
        String[] thirdRet = null;
        BatchException retBe = null;
        try {
            ret = this.removeTargetTagInKey(keyNodeName, keyNodePort, keyNodeFullName, subKeyNodeName, subKeyNodePort, subKeyNodeFullName, tag, key, transactionCode);
            if (ret == null) {
                throw new BatchException("removeTargetTagInKey - RetParam = null");
            }
        }
        catch (BatchException be) {
            retBe = be;
            exceptionFlg = true;
        }
        catch (Exception e) {
            retBe = new BatchException(e);
            exceptionFlg = true;
        }
        finally {
            block18: {
                try {
                    thirdRet = this.removeTargetTagInKey(thirdKeyNodeName, thirdKeyNodePort, thirdKeyNodeFullName, null, null, null, tag, key, transactionCode);
                    if (exceptionFlg) {
                        ret = thirdRet;
                    }
                }
                catch (Exception e) {
                    if (!exceptionFlg) break block18;
                    throw retBe;
                }
            }
        }
        return ret;
    }

    private String[] removeTargetTagInKey(String keyNodeName, String keyNodePort, String keyNodeFullName, String subKeyNodeName, String subKeyNodePort, String subKeyNodeFullName, String tag, String key, String transactionCode) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String nodeName = keyNodeName;
        String nodePort = keyNodePort;
        String nodeFullName = keyNodeFullName;
        String[] retParams = null;
        Object cnvConsistencyRet = null;
        int counter = 0;
        Object tmpSaveHost = null;
        Object tmpSaveData = null;
        String retParam = null;
        boolean mainNodeSave = false;
        boolean subNodeSave = false;
        try {
            if (this.transactionMode) {
                String[] keyNodeLockRet;
                while ((keyNodeLockRet = this.hasLockKeyNode(this.transactionManagerInfo[0], this.transactionManagerInfo[1], tag))[1].equals("true") && !keyNodeLockRet[2].equals(transactionCode)) {
                }
            }
            do {
                if ((keyNodeConnector = this.createKeyNodeConnection(nodeName, nodePort, nodeFullName, false)) != null) {
                    try {
                        StringBuilder buf = new StringBuilder(128);
                        String sendStr = null;
                        buf.append("40");
                        buf.append(",");
                        buf.append(this.stringCnv(tag));
                        buf.append(",");
                        buf.append(this.stringCnv(key));
                        buf.append(",");
                        buf.append(transactionCode);
                        sendStr = buf.toString();
                        keyNodeConnector.println(sendStr);
                        keyNodeConnector.flush();
                        retParam = keyNodeConnector.readLine(sendStr);
                        super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                        if (retParam != null && retParam.indexOf("40,true") == 0) {
                            if (counter == 0) {
                                mainNodeSave = true;
                            }
                            if (counter == 1) {
                                subNodeSave = true;
                            }
                        } else if (retParam == null || retParam.indexOf("40,false") != 0) {
                            super.setDeadNode(nodeName + ":" + nodePort, 14, null);
                            logger.error("removeTargetTagInKey Logical Error Node =[" + nodeName + ":" + nodePort + "] retParam=[" + retParam + "]" + " Connectoer=[" + keyNodeConnector.connectorDump() + "]");
                        }
                    }
                    catch (SocketException se) {
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                        super.setDeadNode(nodeName + ":" + nodePort, 15, se);
                        logger.debug(se);
                    }
                    catch (IOException ie) {
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                        super.setDeadNode(nodeName + ":" + nodePort, 16, ie);
                        logger.debug(ie);
                    }
                    catch (Exception ee) {
                        if (keyNodeConnector != null) {
                            keyNodeConnector.close();
                            keyNodeConnector = null;
                        }
                        super.setDeadNode(nodeName + ":" + nodePort, 17, ee);
                        logger.debug(ee);
                    }
                }
                nodeName = subKeyNodeName;
                nodePort = subKeyNodePort;
                nodeFullName = subKeyNodeFullName;
            } while (nodeName != null && ++counter < 2);
        }
        catch (BatchException be) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw be;
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            throw new BatchException(e);
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (subKeyNodeName != null) {
                super.execNodeUseEnd(subKeyNodeFullName);
            }
            if (retParam != null) {
                retParams = retParam.split(",");
            }
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] calcKeyValue(String keyNodeName, String keyNodePort, String keyNodeFullName, String key, String calcValue, String transactionCode) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        Object slaveKeyNodeConnector = null;
        String nodeName = keyNodeName;
        String nodePort = keyNodePort;
        String nodeFullName = keyNodeFullName;
        String[] retParams = null;
        boolean counter = false;
        Object tmpSaveHost = null;
        Object tmpSaveData = null;
        String retParam = null;
        boolean mainNodeSave = false;
        StringBuilder buf = new StringBuilder(128);
        String sendStr = null;
        try {
            if (this.transactionMode) {
                String[] keyNodeLockRet;
                while ((keyNodeLockRet = this.hasLockKeyNode(this.transactionManagerInfo[0], this.transactionManagerInfo[1], key))[1].equals("true") && !keyNodeLockRet[2].equals(transactionCode)) {
                }
            }
            buf.append("13");
            buf.append(",");
            buf.append(this.stringCnv(key));
            buf.append(",");
            buf.append(transactionCode);
            buf.append(",");
            buf.append(calcValue);
            sendStr = buf.toString();
            keyNodeConnector = this.createKeyNodeConnection(nodeName, nodePort, nodeFullName, false);
            if (keyNodeConnector != null) {
                try {
                    keyNodeConnector.setSoTimeout(300000);
                    keyNodeConnector.println(sendStr);
                    keyNodeConnector.flush();
                    retParam = keyNodeConnector.readLine(sendStr);
                    keyNodeConnector.setSoTimeout(ImdstDefine.nodeConnectionTimeout);
                    if (retParam != null && retParam.indexOf("13,true") == 0) {
                        mainNodeSave = true;
                    } else {
                        super.setDeadNode(nodeName + ":" + nodePort, 3, null);
                        logger.error("calcValue Logical Error Node =[" + nodeName + ":" + nodePort + "] retParam=[" + retParam + "]" + " Connectoer=[" + keyNodeConnector.connectorDump() + "]");
                    }
                    super.addKeyNodeCacheConnectionPool(keyNodeConnector);
                }
                catch (SocketException se) {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    super.setDeadNode(nodeName + ":" + nodePort, 5, se);
                    logger.debug(se);
                }
                catch (IOException ie) {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    super.setDeadNode(nodeName + ":" + nodePort, 6, ie);
                    logger.debug(ie);
                }
                catch (Exception ee) {
                    if (keyNodeConnector != null) {
                        keyNodeConnector.close();
                        keyNodeConnector = null;
                    }
                    super.setDeadNode(nodeName + ":" + nodePort, 7, ee);
                    logger.debug(ee);
                }
            }
            if (!mainNodeSave) {
                retParam = null;
            }
        }
        catch (Exception e) {
            if (keyNodeConnector != null) {
                keyNodeConnector.close();
                keyNodeConnector = null;
            }
            retParam = null;
        }
        finally {
            super.execNodeUseEnd(keyNodeFullName);
            if (retParam != null) {
                retParams = retParam.split(",");
            }
        }
        return retParams;
    }

    private String[] lockKeyNodeValue(String transactionManagerName, String transactionManagerPort, String key, String transactionCode, String lockingTime, String lockingWaitTime) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String retParam = null;
        String[] retParams = null;
        try {
            if (!this.transactionMode) {
                retParams = new String[]{"30", "false"};
            }
            if ((keyNodeConnector = this.createTransactionManagerConnection(transactionManagerName, transactionManagerPort, transactionManagerName + ":" + transactionManagerPort)) != null) {
                try {
                    StringBuilder buf = new StringBuilder(128);
                    buf.append("30");
                    buf.append(",");
                    buf.append(this.stringCnv(key));
                    buf.append(",");
                    buf.append(transactionCode);
                    buf.append(",");
                    buf.append(lockingTime);
                    buf.append(",");
                    buf.append(lockingWaitTime);
                    keyNodeConnector.println(buf.toString());
                    keyNodeConnector.flush();
                    retParam = keyNodeConnector.readLine();
                }
                catch (SocketException se) {
                    logger.error("TransactionManager - Error " + se);
                }
                catch (IOException ie) {
                    logger.error("TransactionManager - Error " + ie);
                }
            }
            retParams = retParam != null ? (retParam.indexOf("30,true") == 0 ? new String[]{"30", "true", transactionCode} : new String[]{"30", "false"}) : new String[]{"30", "false"};
        }
        catch (BatchException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return retParams;
    }

    private String[] releaseLockKeyNodeValue(String transactionManagerName, String transactionManagerPort, String key, String transactionCode) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String retParam = null;
        String[] retParams = null;
        try {
            if (!this.transactionMode) {
                retParams = new String[]{"31", "false"};
            }
            if ((keyNodeConnector = this.createTransactionManagerConnection(transactionManagerName, transactionManagerPort, transactionManagerName + ":" + transactionManagerPort)) != null) {
                try {
                    StringBuilder buf = new StringBuilder(128);
                    buf.append("31");
                    buf.append(",");
                    buf.append(this.stringCnv(key));
                    buf.append(",");
                    buf.append(transactionCode);
                    keyNodeConnector.println(buf.toString());
                    keyNodeConnector.flush();
                    retParam = keyNodeConnector.readLine();
                }
                catch (SocketException se) {
                    logger.error("TransactionManager - Error " + se);
                }
                catch (IOException ie) {
                    logger.error("TransactionManager - Error " + ie);
                }
            }
            retParams = retParam != null ? (retParam.indexOf("31,true") == 0 ? new String[]{"31", "true", transactionCode} : new String[]{"31", "false"}) : new String[]{"31", "false"};
        }
        catch (BatchException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return retParams;
    }

    private String[] hasLockKeyNode(String transactionManagerName, String transactionManagerPort, String key) throws BatchException {
        KeyNodeConnector keyNodeConnector = null;
        String retParam = null;
        String[] retParams = null;
        try {
            if (!this.transactionMode) {
                retParams = new String[]{"32", "false"};
            }
            if ((keyNodeConnector = this.createTransactionManagerConnection(transactionManagerName, transactionManagerPort, transactionManagerName + ":" + transactionManagerPort)) != null) {
                try {
                    StringBuilder buf = new StringBuilder(128);
                    buf.append("32");
                    buf.append(",");
                    buf.append(this.stringCnv(key));
                    keyNodeConnector.println(buf.toString());
                    keyNodeConnector.flush();
                    retParam = keyNodeConnector.readLine();
                }
                catch (SocketException se) {
                    logger.error("TransactionManager - Error " + se);
                }
                catch (IOException ie) {
                    logger.error("TransactionManager - Error " + ie);
                }
            }
            retParams = retParam != null ? (retParam.indexOf("32,true") == 0 ? retParam.split(",") : new String[]{"32", "false"}) : new String[]{"32", "false"};
        }
        catch (BatchException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return retParams;
    }

    private String[] pauseKeyNodeUse(String keyNodeFullName) throws BatchException {
        String[] retParams = new String[3];
        try {
            super.setNodeWaitStatus(keyNodeFullName);
            while (super.getNodeUseStatus(keyNodeFullName) != 0) {
                Thread.sleep(50L);
            }
            retParams[0] = "90";
            retParams[1] = "true";
            retParams[2] = "";
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return retParams;
    }

    private String[] restartKeyNodeUse(String keyNodeFullName) throws BatchException {
        String[] retParams = new String[3];
        try {
            super.removeNodeWaitStatus(keyNodeFullName);
            retParams[0] = "91";
            retParams[1] = "true";
            retParams[2] = "";
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return retParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] deadKeyNode(String keyNodeFullName) throws BatchException {
        String[] retParams = null;
        try {
            StatusUtil.setDeadNode(keyNodeFullName);
            super.setDeadNode(keyNodeFullName, 9, null);
        }
        catch (Exception e) {
            logger.error("", e);
        }
        finally {
            retParams = new String[]{"95", "true", ""};
        }
        return retParams;
    }

    private String[] arriveKeyNode(String keyNodeFullName) throws BatchException {
        String[] retParams = new String[3];
        try {
            super.setArriveNode(keyNodeFullName);
            retParams[0] = "92";
            retParams[1] = "true";
            retParams[2] = "";
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return retParams;
    }

    private KeyNodeConnector createKeyNodeConnection(String keyNodeName, String keyNodePort, String keyNodeFullName, boolean retryFlg) throws BatchException {
        KeyNodeConnector keyNodeConnector;
        block9: {
            keyNodeConnector = null;
            String connectionFullName = keyNodeFullName;
            Long connectTime = new Long(0L);
            String connTimeKey = "time";
            boolean sockCheck = false;
            try {
                if (!super.isNodeArrival(connectionFullName)) {
                    return null;
                }
                if (!retryFlg && AbstractMasterManagerHelper.keyNodeConnectPool.containsKey(connectionFullName) && (keyNodeConnector = (KeyNodeConnector)((ArrayBlockingQueue)AbstractMasterManagerHelper.keyNodeConnectPool.get(connectionFullName)).poll()) != null && !super.checkConnectionEffective(connectionFullName, keyNodeConnector.getConnetTime())) {
                    keyNodeConnector = null;
                }
                if (keyNodeConnector == null) {
                    keyNodeConnector = new KeyNodeConnector(keyNodeName, Integer.parseInt(keyNodePort), keyNodeFullName);
                    keyNodeConnector.connect();
                }
                if (keyNodeConnector == null) break block9;
                keyNodeConnector.initRetryFlg();
                try {
                    if (this.longReadTimeout) {
                        keyNodeConnector.setSoTimeout(ImdstDefine.nodeConnectionTimeout * 2);
                        break block9;
                    }
                    keyNodeConnector.setSoTimeout(ImdstDefine.nodeConnectionTimeout);
                }
                catch (Exception ee) {}
            }
            catch (Exception e) {
                logger.error(connectionFullName + " " + e);
                if (keyNodeConnector != null) {
                    keyNodeConnector.close();
                    keyNodeConnector = null;
                }
                super.setDeadNode(connectionFullName, 20, e);
            }
        }
        return keyNodeConnector;
    }

    private KeyNodeConnector createTransactionManagerConnection(String keyNodeName, String keyNodePort, String keyNodeFullName) throws BatchException {
        return this.createKeyNodeConnection(keyNodeName, keyNodePort, keyNodeFullName, false);
    }

    private void closeClientConnect(PrintWriter pw, CustomReader br, BufferedOutputStream bos, Socket socket) {
        try {
            if (pw != null) {
                pw.close();
                pw = null;
            }
            if (br != null) {
                br.close();
                br = null;
            }
            if (bos != null) {
                bos.close();
                bos = null;
            }
            if (socket != null) {
                socket.close();
                socket = null;
            }
        }
        catch (Exception e) {
            logger.error("", e);
        }
    }

    private void initConsistencyMode() {
        if (this.dataConsistencyMode == 1) {
            this.reverseAccess = true;
        } else if (this.dataConsistencyMode == 2) {
            this.reverseAccess = false;
        }
    }

    private String[] dataConvert4Consistency(String targetStr) {
        boolean multiResult = false;
        String[] ret = new String[]{null, "-1"};
        if (targetStr != null) {
            if (targetStr.indexOf("!") < targetStr.indexOf(";")) {
                multiResult = true;
            }
            if (!multiResult) {
                String[] setTimeSplitRet = targetStr.split("!");
                if (setTimeSplitRet.length > 1) {
                    ret[0] = setTimeSplitRet[0];
                    if (setTimeSplitRet[1].trim().length() > 0) {
                        ret[1] = setTimeSplitRet[1];
                    }
                } else {
                    ret[0] = setTimeSplitRet[0];
                }
            } else {
                String[] multiResultList = targetStr.split(";");
                StringBuilder valueBuf = new StringBuilder(1024);
                StringBuilder timeBuf = new StringBuilder(1024);
                String valSep = "";
                String timeSep = "";
                for (int idx = 0; idx < multiResultList.length; ++idx) {
                    String[] setTimeSplitRet = multiResultList[idx].split("!");
                    if (setTimeSplitRet.length > 1) {
                        valueBuf.append(valSep);
                        valueBuf.append(setTimeSplitRet[0]);
                        if (setTimeSplitRet[1].trim().length() > 0) {
                            timeBuf.append(timeSep);
                            timeBuf.append(setTimeSplitRet[1]);
                            timeSep = ";";
                        }
                    } else {
                        valueBuf.append(valSep);
                        valueBuf.append(setTimeSplitRet[0]);
                    }
                    valSep = ";";
                }
                ret[0] = valueBuf.toString();
                ret[1] = timeBuf.toString();
            }
        }
        return ret;
    }

    private String[] strongConsistencyDataConvert(String[] execRetParams, String[] mainNodeRetParam, String[] subNodeRetParam, String type, boolean returnVersion) {
        String[] checkConsistencyRetMain = null;
        String[] checkConsistencyRetSub = null;
        String[] retParams = execRetParams;
        if (mainNodeRetParam != null && mainNodeRetParam.length > 1 && mainNodeRetParam[1].equals("true")) {
            checkConsistencyRetMain = this.dataConvert4Consistency(mainNodeRetParam[2]);
        } else if (mainNodeRetParam != null && mainNodeRetParam.length > 1 && mainNodeRetParam[1].equals("false")) {
            checkConsistencyRetMain = new String[]{null, "-1"};
        }
        if (subNodeRetParam != null && subNodeRetParam.length > 1 && subNodeRetParam[1].equals("true")) {
            checkConsistencyRetSub = this.dataConvert4Consistency(subNodeRetParam[2]);
        } else if (subNodeRetParam != null && subNodeRetParam.length > 1 && subNodeRetParam[1].equals("false")) {
            checkConsistencyRetSub = new String[]{null, "-1"};
        }
        if (checkConsistencyRetMain != null && checkConsistencyRetSub != null) {
            if (checkConsistencyRetMain[0] == null && checkConsistencyRetSub[0] == null) {
                retParams = new String[]{type, "false"};
            } else if (Long.parseLong(checkConsistencyRetMain[1]) >= Long.parseLong(checkConsistencyRetSub[1])) {
                retParams = !returnVersion ? new String[3] : new String[4];
                retParams[0] = type;
                retParams[1] = "true";
                retParams[2] = checkConsistencyRetMain[0];
                if (returnVersion) {
                    retParams[3] = checkConsistencyRetMain[1];
                }
            } else {
                retParams = !returnVersion ? new String[3] : new String[4];
                retParams[0] = type;
                retParams[1] = "true";
                retParams[2] = checkConsistencyRetSub[0];
                if (returnVersion) {
                    retParams[3] = checkConsistencyRetSub[1];
                }
            }
        } else if (checkConsistencyRetMain != null) {
            if (checkConsistencyRetMain[0] == null) {
                retParams[1] = "false";
            } else {
                if (returnVersion) {
                    String[] workRet = new String[]{retParams[0], retParams[1], retParams[2], checkConsistencyRetMain[1]};
                    retParams = workRet;
                }
                retParams[2] = checkConsistencyRetMain[0];
            }
        } else if (checkConsistencyRetSub[0] == null) {
            retParams[1] = "false";
        } else {
            if (returnVersion) {
                String[] workRet = new String[]{retParams[0], retParams[1], retParams[2], checkConsistencyRetSub[1]};
                retParams = workRet;
            }
            retParams[2] = checkConsistencyRetSub[0];
        }
        return retParams;
    }

    private String encodeIsolationConvert(String str) {
        StringBuilder isolationBuffer = new StringBuilder(128);
        if (this.isolationMode) {
            isolationBuffer.delete(0, Integer.MAX_VALUE);
            if (str != null && StatusUtil.isIsolationEncodeTarget(str)) {
                isolationBuffer.append(StatusUtil.getIsolationPrefix());
                isolationBuffer.append(str);
                return isolationBuffer.toString();
            }
            return str;
        }
        return str;
    }

    private String decodeIsolationConvert(String str) {
        if (this.isolationMode) {
            if (str != null) {
                return str.substring(this.isolationPrefixLength);
            }
            return str;
        }
        return str;
    }

    private String stringCnv(String str) {
        return str;
    }

    private boolean checkKeyLength(String key) {
        if (key == null) {
            return false;
        }
        return key.length() < ImdstDefine.saveKeyMaxSize;
    }

    private boolean checkValueLength(String value) {
        if (value == null) {
            return false;
        }
        return value.length() < this.encodeMaxDataSize;
    }
}

