/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import okuyama.imdst.util.CoreFileBaseKeyMap;
import okuyama.imdst.util.FileBaseDataMap;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.SoftRefCacheMap;
import okuyama.imdst.util.SystemUtil;

class DelayWriteCoreFileBaseKeyMap
extends Thread
implements CoreFileBaseKeyMap {
    private String[] baseFileDirs = null;
    private String[] fileDirs = null;
    private int keyDataLength = new Double((double)ImdstDefine.saveKeyMaxSize * 1.33).intValue() + 1;
    private int oneDataLength = 11;
    private int lineDataSize = this.keyDataLength + this.oneDataLength;
    private int getDataSize = 32768 / this.lineDataSize * this.lineDataSize;
    private int numberOfDataFiles = 1024;
    private int dataDirsFactor = 20;
    private File[] dataFileList = null;
    private SoftRefCacheMap innerCache = null;
    private AtomicInteger totalSize = null;
    private int innerCacheSize = 128;
    private int numberOfOneFileKey = ImdstDefine.fileBaseMapNumberOfOneFileKey;
    private int nowIterationFileIndex = 0;
    private long nowIterationFpPosition = 0L;
    private volatile int delayWriteQueueSize = ImdstDefine.delayWriteMaxQueueingSize;
    private ArrayBlockingQueue delayWriteQueue = new ArrayBlockingQueue(this.delayWriteQueueSize);
    private ConcurrentHashMap delayWriteDifferenceMap = new ConcurrentHashMap(this.delayWriteQueueSize, this.delayWriteQueueSize - 100, 32);
    private long delayWriteRequestCount = 0L;
    private long delayWriteExecCount = 0L;

    public DelayWriteCoreFileBaseKeyMap(String[] dirs, int innerCacheSize, int numberOfKeyData) {
        try {
            this.baseFileDirs = dirs;
            this.innerCacheSize = innerCacheSize;
            if (numberOfKeyData <= this.numberOfOneFileKey) {
                numberOfKeyData = this.numberOfOneFileKey * 2;
            }
            this.innerCacheSize = this.numberOfDataFiles = numberOfKeyData / this.numberOfOneFileKey;
            this.init();
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DelayWriteCoreFileBaseKeyMap(String[] dirs, int innerCacheSize, int numberOfKeyData, int numberOfValueSize) {
        try {
            this.oneDataLength = numberOfValueSize;
            this.lineDataSize = this.keyDataLength + this.oneDataLength;
            this.getDataSize = 8192 > this.lineDataSize ? this.lineDataSize * (8192 / this.lineDataSize) * 10 : this.lineDataSize * 1 * 2;
            this.baseFileDirs = dirs;
            if (numberOfKeyData <= this.numberOfOneFileKey) {
                numberOfKeyData = this.numberOfOneFileKey * 2;
            }
            this.innerCacheSize = this.numberOfDataFiles = numberOfKeyData / this.numberOfOneFileKey;
            this.init();
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
        this.innerCache = new SoftRefCacheMap(this.innerCacheSize);
        this.totalSize = new AtomicInteger(0);
        this.dataFileList = new File[this.numberOfDataFiles];
        try {
            this.fileDirs = new String[this.baseFileDirs.length * this.dataDirsFactor];
            int counter = 0;
            for (int idx = 0; idx < this.baseFileDirs.length; ++idx) {
                for (int idx2 = 0; idx2 < this.dataDirsFactor; ++idx2) {
                    this.fileDirs[counter] = this.baseFileDirs[idx] + idx2 + "/";
                    File dir = new File(this.fileDirs[counter]);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    ++counter;
                }
            }
            for (int i = 0; i < this.numberOfDataFiles; ++i) {
                File file = new File(this.fileDirs[i % this.fileDirs.length] + i + ".data");
                file.delete();
                this.dataFileList[i] = file;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    byte[] decompressData;
                    byte[] compressData;
                    File compressFile;
                    String value;
                    String key;
                    block21: {
                        Object[] instructionObj = (Object[])this.delayWriteQueue.take();
                        key = (String)instructionObj[0];
                        value = (String)instructionObj[1];
                        int hashCode = (Integer)instructionObj[2];
                        StringBuilder buf = new StringBuilder(this.lineDataSize);
                        Object wr = null;
                        buf.append(this.fillCharacter(key, this.keyDataLength));
                        buf.append(this.fillCharacter(value, this.oneDataLength));
                        compressFile = null;
                        compressData = null;
                        Object decompressDataStr = null;
                        decompressData = null;
                        File file = this.dataFileList[hashCode % this.numberOfDataFiles];
                        // MONITORENTER : file
                        compressFile = this.dataFileList[hashCode % this.numberOfDataFiles];
                        compressData = null;
                        decompressDataStr = null;
                        decompressData = null;
                        if (compressFile.exists()) {
                            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(compressFile));
                            compressData = new byte[new Long(compressFile.length()).intValue()];
                            bis.read(compressData);
                            bis.close();
                            decompressData = SystemUtil.dataDecompress(compressData);
                        }
                        try {
                            long[] dataLineNoRet = this.getLinePoint(key, decompressData);
                            if (dataLineNoRet[0] == -1L) {
                                byte[] fixNewData = null;
                                byte[] bufBytes = buf.toString().getBytes();
                                if (decompressData == null || decompressData.length < 1) {
                                    fixNewData = bufBytes;
                                } else {
                                    fixNewData = new byte[bufBytes.length + decompressData.length];
                                    for (int cpIdx = 0; cpIdx < decompressData.length; ++cpIdx) {
                                        fixNewData[cpIdx] = decompressData[cpIdx];
                                    }
                                    int newCpIdx = decompressData.length;
                                    for (int cpBufIdx = 0; cpBufIdx < bufBytes.length; ++newCpIdx, ++cpBufIdx) {
                                        fixNewData[newCpIdx] = bufBytes[cpBufIdx];
                                    }
                                }
                                decompressData = fixNewData;
                                this.totalSize.getAndIncrement();
                                break block21;
                            }
                            boolean increMentFlg = false;
                            if (dataLineNoRet[1] == -1L) {
                                increMentFlg = true;
                            }
                            int insIdx = new Long(dataLineNoRet[0] * (long)this.lineDataSize).intValue();
                            byte[] insBytes = buf.toString().getBytes();
                            for (int i = 0; i < this.lineDataSize; ++insIdx, ++i) {
                                decompressData[insIdx] = insBytes[i];
                            }
                            if (increMentFlg) {
                                this.totalSize.getAndIncrement();
                            }
                        }
                        catch (IOException ie) {
                            // empty catch block
                        }
                    }
                    compressData = SystemUtil.dataCompress(decompressData);
                    BufferedOutputStream compressBos = new BufferedOutputStream(new FileOutputStream(compressFile, false));
                    compressBos.write(compressData);
                    compressBos.flush();
                    compressBos.close();
                    // MONITOREXIT : file
                    if (value.indexOf("&&&&&&&&&&&") == 0) {
                        this.totalSize.getAndDecrement();
                    }
                    ConcurrentHashMap concurrentHashMap = this.delayWriteDifferenceMap;
                    // MONITORENTER : concurrentHashMap
                    String removeChcek = (String)this.delayWriteDifferenceMap.get(key);
                    if (removeChcek != null && removeChcek.equals(value)) {
                        this.delayWriteDifferenceMap.remove(key);
                        ++this.delayWriteExecCount;
                    }
                    // MONITOREXIT : concurrentHashMap
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void clear() {
        if (this.innerCache != null) {
            this.innerCache.end();
            this.innerCache = new SoftRefCacheMap(this.innerCacheSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String value, int hashCode) {
        Object[] instructionObj = new Object[]{key, value, new Integer(hashCode)};
        try {
            ConcurrentHashMap concurrentHashMap = this.delayWriteDifferenceMap;
            synchronized (concurrentHashMap) {
                this.delayWriteDifferenceMap.put(key, value);
            }
            this.delayWriteQueue.put(instructionObj);
            ++this.delayWriteRequestCount;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long[] getLinePoint(String key, byte[] targetData) throws Exception {
        long[] ret = new long[]{-1L, 0L};
        if (targetData == null) {
            return ret;
        }
        long line = -1L;
        long lineCount = 0L;
        byte[] keyBytes = key.getBytes();
        byte[] equalKeyBytes = new byte[keyBytes.length + 1];
        byte[] lineBufs = null;
        boolean matchFlg = true;
        for (int idx = 0; idx < keyBytes.length; ++idx) {
            equalKeyBytes[idx] = keyBytes[idx];
        }
        equalKeyBytes[equalKeyBytes.length - 1] = new Integer(FileBaseDataMap.paddingSymbol).byteValue();
        int readLen = targetData.length;
        lineBufs = targetData;
        int loop = readLen / this.lineDataSize;
        for (int loopIdx = 0; loopIdx < loop; ++loopIdx) {
            int assist = this.lineDataSize * loopIdx;
            matchFlg = true;
            if (equalKeyBytes[equalKeyBytes.length - 1] == lineBufs[assist + (equalKeyBytes.length - 1)]) {
                for (int i = 0; i < equalKeyBytes.length; ++i) {
                    if (equalKeyBytes[i] == lineBufs[assist + i]) continue;
                    matchFlg = false;
                    break;
                }
            } else {
                matchFlg = false;
            }
            if (matchFlg) {
                line = lineCount;
                if (lineBufs[assist + this.keyDataLength] == FileBaseDataMap.paddingSymbol) {
                    ret[1] = -1L;
                }
                break;
            }
            ++lineCount;
        }
        ret[0] = line;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key, int hashCode) {
        if (this.delayWriteDifferenceMap.containsKey(key)) {
            String retStr = (String)this.delayWriteDifferenceMap.get(key);
            if (retStr != null && retStr.equals("&&&&&&&&&&&")) {
                return null;
            }
            if (retStr != null) {
                return retStr;
            }
        }
        byte[] tmpBytes = null;
        String ret = null;
        byte[] keyBytes = key.getBytes();
        byte[] equalKeyBytes = new byte[keyBytes.length + 1];
        byte[] lineBufs = null;
        boolean matchFlg = true;
        for (int idx = 0; idx < keyBytes.length; ++idx) {
            equalKeyBytes[idx] = keyBytes[idx];
        }
        equalKeyBytes[equalKeyBytes.length - 1] = new Integer(FileBaseDataMap.paddingSymbol).byteValue();
        try {
            Object accessor = null;
            File file = this.dataFileList[hashCode % this.numberOfDataFiles];
            synchronized (file) {
                File compressFile = this.dataFileList[hashCode % this.numberOfDataFiles];
                byte[] compressData = null;
                byte[] decompressData = null;
                if (compressFile.exists()) {
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(compressFile));
                    compressData = new byte[new Long(compressFile.length()).intValue()];
                    bis.read(compressData);
                    bis.close();
                    lineBufs = decompressData = SystemUtil.dataDecompress(compressData);
                }
                int readLen = 0;
                if (decompressData != null && decompressData.length > 0) {
                    readLen = decompressData.length;
                }
                matchFlg = true;
                int loop = readLen / this.lineDataSize;
                for (int loopIdx = 0; loopIdx < loop; ++loopIdx) {
                    int i;
                    int assist = this.lineDataSize * loopIdx;
                    matchFlg = true;
                    if (equalKeyBytes[equalKeyBytes.length - 1] == lineBufs[assist + (equalKeyBytes.length - 1)]) {
                        for (i = 0; i < equalKeyBytes.length; ++i) {
                            if (equalKeyBytes[i] == lineBufs[assist + i]) continue;
                            matchFlg = false;
                            break;
                        }
                    } else {
                        matchFlg = false;
                    }
                    if (!matchFlg) continue;
                    tmpBytes = new byte[this.lineDataSize];
                    for (i = 0; i < this.lineDataSize; ++i) {
                        tmpBytes[i] = lineBufs[assist + i];
                    }
                    break;
                }
            }
            if (tmpBytes != null && tmpBytes[this.keyDataLength] != FileBaseDataMap.paddingSymbol) {
                int counter = 0;
                for (int i = this.keyDataLength; i < tmpBytes.length && tmpBytes[i] != FileBaseDataMap.paddingSymbol; ++i) {
                    ++counter;
                }
                ret = new String(tmpBytes, this.keyDataLength, counter, "UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public String remove(String key, int hashCode) {
        String ret = null;
        ret = this.get(key, hashCode);
        if (ret != null) {
            this.put(key, "&&&&&&&&&&&", hashCode);
        }
        return ret;
    }

    @Override
    public AtomicInteger getTotalSize() {
        return this.totalSize;
    }

    private String fillCharacter(String data, int fixSize) {
        return SystemUtil.fillCharacter(data, fixSize, FileBaseDataMap.paddingSymbol);
    }

    public int getCacheSize() {
        return -1;
    }

    @Override
    public void startKeyIteration() {
        this.nowIterationFileIndex = 0;
        this.nowIterationFpPosition = 0L;
        long nowDelayRequestCount = this.delayWriteRequestCount;
        while (nowDelayRequestCount > this.delayWriteExecCount) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getAllOneFileInKeys() {
        ArrayList<String> keys = null;
        byte[] datas = null;
        StringBuilder keysBuf = null;
        try {
            if (this.nowIterationFileIndex < this.dataFileList.length) {
                keys = new ArrayList<String>();
                File compressFile = this.dataFileList[this.nowIterationFileIndex];
                byte[] compressData = null;
                byte[] decompressData = null;
                if (compressFile.exists()) {
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(compressFile));
                    compressData = new byte[new Long(compressFile.length()).intValue()];
                    bis.read(compressData);
                    bis.close();
                    decompressData = SystemUtil.dataDecompress(compressData);
                }
                datas = decompressData;
                int readLen = -1;
                if (decompressData != null && decompressData.length > 0) {
                    readLen = decompressData.length;
                }
                if (readLen > 0) {
                    int loop = readLen / this.lineDataSize;
                    for (int loopIdx = 0; loopIdx < loop; ++loopIdx) {
                        int assist = this.lineDataSize * loopIdx;
                        keysBuf = new StringBuilder(8192);
                        int idx = 0;
                        while (datas[assist + idx] != FileBaseDataMap.paddingSymbol) {
                            keysBuf.append(new String(datas, assist + idx, 1));
                            ++idx;
                        }
                        keys.add(keysBuf.toString());
                        keysBuf = null;
                    }
                }
            }
            ++this.nowIterationFileIndex;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                datas = null;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return keys;
    }
}

