/*
 * Decompiled with CFR 0.152.
 */
package okuyama.base.parameter.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import okuyama.base.lang.BatchException;
import okuyama.base.parameter.config.HelperConfigMap;
import okuyama.base.parameter.config.JobConfigMap;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;

public class JobConfig {
    private ILogger logger = LoggerFactory.createLogger(JobConfig.class);
    private LinkedHashMap configMap = new LinkedHashMap();
    private LinkedHashMap helperMap = new LinkedHashMap();
    private Hashtable userPrivateValuesMap = new Hashtable();
    private String configFileName = null;
    private File configFile = null;
    private long fileModifiedTime = 0L;

    public JobConfig(String fileName) throws BatchException {
        this.configFileName = fileName;
        this.configFile = new File(fileName);
        try {
            if (this.configFile.exists()) {
                this.initConfig(new FileInputStream(this.configFile));
            } else {
                this.configFile = new File(JobConfig.class.getResource(this.configFileName).toURI());
                this.initConfig(new FileInputStream(this.configFile));
            }
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
    }

    private void initConfig(InputStream is) throws BatchException {
        Properties prop = null;
        String jobs = null;
        String[] jobList = null;
        String helpers = null;
        String[] helperList = null;
        String jobClass = null;
        String optionValue = null;
        String initValue = null;
        String dependValue = null;
        String helperLimitSizeStr = null;
        int helperLimitSize = 0;
        String helperMaxUseStr = null;
        int helperMaxUse = 0;
        String[] dependList = null;
        String dbgroupValue = null;
        String[] dbgroupList = null;
        String commitValue = null;
        String helperDbgroupValue = null;
        String[] helperDbgroupList = null;
        String helperCommitValue = null;
        String helperClass = null;
        Set<Object> keys = null;
        Object var24_24 = null;
        JobConfigMap jobConfigMap = null;
        HelperConfigMap helperConfigMap = null;
        try {
            int index;
            this.logger.debug("initConfig - Start");
            prop = new Properties();
            prop.load(is);
            jobs = prop.getProperty("joblist");
            this.logger.debug("JOBLIST:[" + jobs + "]");
            jobList = jobs.split(",");
            for (index = 0; index < jobList.length; ++index) {
                jobClass = null;
                initValue = null;
                optionValue = null;
                dependValue = null;
                dependList = null;
                dbgroupValue = null;
                dbgroupList = null;
                commitValue = null;
                this.logger.debug("Job Parse Job:[" + jobList[index] + "]");
                jobClass = (String)prop.remove(jobList[index] + "." + "JobClass");
                if (jobClass == null) {
                    this.logger.error("Job Class Configure Not Found");
                    this.logger.error("Error Job Name:[" + jobList[index] + "]");
                    throw new BatchException("Job Class Configure Error");
                }
                this.logger.debug("Job Class Configure Exists");
                this.logger.debug("Job Class Name:[" + jobClass + "]");
                optionValue = (String)prop.remove(jobList[index] + "." + "Option");
                initValue = (String)prop.remove(jobList[index] + "." + "Init");
                dependValue = (String)prop.remove(jobList[index] + "." + "Depend");
                if (dependValue != null && !dependValue.equals("")) {
                    dependList = dependValue.indexOf(",") == -1 ? new String[]{dependValue} : dependValue.split(",");
                }
                if ((dbgroupValue = (String)prop.remove(jobList[index] + "." + "Dbgroup")) != null && !dbgroupValue.equals("")) {
                    dbgroupList = dbgroupValue.indexOf(",") == -1 ? new String[]{dbgroupValue} : dbgroupValue.split(",");
                }
                commitValue = (String)prop.remove(jobList[index] + "." + "Commit");
                jobConfigMap = new JobConfigMap(jobList[index], jobClass, initValue, optionValue, dependList, dbgroupList, commitValue);
                this.logger.info("Job Name" + jobList[index] + ", Class Name[" + jobClass + "]" + ", Init  Name[" + initValue + "]" + ", Option  Name[" + optionValue + "]" + ", Depend  Name[" + dependValue + "]" + ", Dbgroup  Name[" + dbgroupValue + "]" + ", Commit  Name[" + commitValue + "]");
                this.configMap.put(jobList[index], jobConfigMap);
            }
            helpers = prop.getProperty("helperlist");
            this.logger.debug("HelperList:[" + helpers + "]");
            if (helpers != null && !helpers.equals("")) {
                helperList = helpers.split(",");
                for (index = 0; index < helperList.length; ++index) {
                    helperClass = null;
                    initValue = null;
                    optionValue = null;
                    helperDbgroupValue = null;
                    helperDbgroupList = null;
                    helperCommitValue = null;
                    this.logger.debug("Helper Parse List:[" + helperList[index] + "]");
                    helperClass = (String)prop.remove(helperList[index] + "." + "HelperClass");
                    if (helperClass == null) {
                        this.logger.error("Helper Class Not Found");
                        this.logger.error("Target Helper :[" + helperList[index] + "]");
                        throw new BatchException("ConfigureError");
                    }
                    optionValue = (String)prop.remove(helperList[index] + "." + "Option");
                    initValue = (String)prop.remove(helperList[index] + "." + "Init");
                    helperLimitSize = 0;
                    helperLimitSizeStr = (String)prop.remove(helperList[index] + "." + "Limit");
                    if (helperLimitSizeStr != null) {
                        try {
                            helperLimitSize = Integer.parseInt(helperLimitSizeStr);
                        }
                        catch (NumberFormatException nfe) {
                            this.logger.error("[" + helperList[index] + "]");
                            throw new BatchException("Cofigure File[ Helper Limit ] Error[" + helperLimitSizeStr + "]");
                        }
                    }
                    helperMaxUse = 0;
                    helperMaxUseStr = (String)prop.remove(helperList[index] + "." + "MaxUse");
                    if (helperMaxUseStr != null) {
                        try {
                            helperMaxUse = Integer.parseInt(helperMaxUseStr);
                        }
                        catch (NumberFormatException nfe) {
                            this.logger.error("Helper Name:[" + helperList[index] + "]");
                            throw new BatchException("Helper[ Helper Max Use ]Configure Error[" + helperMaxUseStr + "]");
                        }
                    }
                    if ((helperDbgroupValue = (String)prop.remove(helperList[index] + "." + "Dbgroup")) != null && !helperDbgroupValue.equals("")) {
                        helperDbgroupList = helperDbgroupValue.indexOf(",") == -1 ? new String[]{helperDbgroupValue} : helperDbgroupValue.split(",");
                    }
                    helperCommitValue = (String)prop.remove(helperList[index] + "." + "Commit");
                    helperConfigMap = new HelperConfigMap(helperList[index], helperClass, initValue, optionValue, helperLimitSize, helperMaxUse, helperDbgroupList, helperCommitValue);
                    this.logger.info("Helper Name" + helperList[index] + ", Class Name[" + helperClass + "]" + ", Init Parameter[" + initValue + "]" + ", Option Parameter[" + optionValue + "]" + ", Limit Parameter[" + helperLimitSizeStr + "]" + ", MaxUse Parameter[" + helperMaxUseStr + "]" + ", Dbgroup Parameter[" + helperDbgroupValue + "]" + ", Commit Parameter[" + helperCommitValue + "]");
                    this.helperMap.put(helperList[index], helperConfigMap);
                }
            }
            keys = prop.keySet();
            Object var24_25 = null;
            if (keys != null) {
                for (String string : keys) {
                    this.userPrivateValuesMap.put(string, prop.get(string));
                }
            }
            this.fileModifiedTime = this.configFile.lastModified();
        }
        catch (Exception e) {
            this.logger.error("initConfig - Error");
            throw new BatchException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ie) {
                this.logger.error("initConfig - File Stream Close Error");
            }
        }
        this.logger.debug("initConfig - End");
    }

    public String[] getJobNameList() {
        int index = 0;
        Set keys = this.configMap.keySet();
        String[] returnKyes = new String[keys.size()];
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key;
            returnKyes[index] = key = (String)iterator.next();
            ++index;
        }
        return returnKyes;
    }

    public String[] getHelperNameList() {
        int index = 0;
        Set keys = this.helperMap.keySet();
        String[] returnKyes = new String[keys.size()];
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key;
            returnKyes[index] = key = (String)iterator.next();
            ++index;
        }
        return returnKyes;
    }

    public JobConfigMap getJobConfig(String jobName) {
        JobConfigMap jobConfigMap = (JobConfigMap)this.configMap.get(jobName);
        return jobConfigMap;
    }

    public HelperConfigMap getHelperConfig(String helperName) throws BatchException {
        HelperConfigMap helperConfigMap = null;
        if (!this.helperMap.containsKey(helperName)) {
            throw new BatchException(helperName + ":Helper Not Found");
        }
        helperConfigMap = (HelperConfigMap)this.helperMap.get(helperName);
        return helperConfigMap;
    }

    public String getUserParam(String key) {
        String ret = null;
        if (this.userPrivateValuesMap.containsKey(key)) {
            ret = (String)this.userPrivateValuesMap.get(key);
        }
        return ret;
    }

    public boolean isChangePropertiesFile() throws BatchException {
        boolean ret = false;
        try {
            if (this.fileModifiedTime != this.configFile.lastModified()) {
                ret = true;
            }
        }
        catch (Exception e) {
            this.logger.error("isChangePropertiesFile - Error" + e);
        }
        return ret;
    }

    public void reloadUserParam(String[] keys) throws BatchException {
        InputStream is = null;
        try {
            this.fileModifiedTime = this.configFile.lastModified();
            is = new FileInputStream(this.configFile);
            Properties prop = new Properties();
            prop.load(is);
            for (int i = 0; i < keys.length; ++i) {
                String value = (String)prop.get(keys[i]);
                if (value == null) continue;
                this.userPrivateValuesMap.put(keys[i], value);
            }
        }
        catch (Exception e) {
            this.logger.error("reloadUserParam - Error");
            throw new BatchException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ie) {
                this.logger.error("reloadUserParam - File Stream Close Error");
            }
        }
    }
}

