/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.server.jobtracker;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobTrackerJspHelper {
    private DecimalFormat percentFormat = new DecimalFormat("##0.00");

    public void generateJobTable(JspWriter out, String label, List<JobInProgress> jobs) throws IOException {
        if (jobs.size() > 0) {
            for (JobInProgress job : jobs) {
                JobProfile profile = job.getProfile();
                JobStatus status = job.getStatus();
                JobID jobid = profile.getJobID();
                int desiredMaps = job.desiredMaps();
                int desiredReduces = job.desiredReduces();
                int completedMaps = job.finishedMaps();
                int completedReduces = job.finishedReduces();
                String name = profile.getJobName();
                out.print("<" + label + "_job jobid=\"" + jobid + "\">\n");
                out.print("  <jobid>" + jobid + "</jobid>\n");
                out.print("  <user>" + profile.getUser() + "</user>\n");
                out.print("  <name>" + ("".equals(name) ? "&nbsp;" : name) + "</name>\n");
                out.print("  <map_complete>" + StringUtils.formatPercent((double)status.mapProgress(), (int)2) + "</map_complete>\n");
                out.print("  <map_total>" + desiredMaps + "</map_total>\n");
                out.print("  <maps_completed>" + completedMaps + "</maps_completed>\n");
                out.print("  <reduce_complete>" + StringUtils.formatPercent((double)status.reduceProgress(), (int)2) + "</reduce_complete>\n");
                out.print("  <reduce_total>" + desiredReduces + "</reduce_total>\n");
                out.print("  <reduces_completed>" + completedReduces + "</reduces_completed>\n");
                out.print("</" + label + "_job>\n");
            }
        }
    }

    public void generateSummaryTable(JspWriter out, JobTracker tracker) throws IOException {
        String tasksPerNodeStr;
        ClusterStatus status = tracker.getClusterStatus();
        int maxMapTasks = status.getMaxMapTasks();
        int maxReduceTasks = status.getMaxReduceTasks();
        int numTaskTrackers = status.getTaskTrackers();
        if (numTaskTrackers > 0) {
            double tasksPerNodePct = (double)(maxMapTasks + maxReduceTasks) / (double)numTaskTrackers;
            tasksPerNodeStr = this.percentFormat.format(tasksPerNodePct);
        } else {
            tasksPerNodeStr = "-";
        }
        out.print("<maps>" + status.getMapTasks() + "</maps>\n" + "<reduces>" + status.getReduceTasks() + "</reduces>\n" + "<total_submissions>" + tracker.getTotalSubmissions() + "</total_submissions>\n" + "<nodes>" + status.getTaskTrackers() + "</nodes>\n" + "<map_task_capacity>" + status.getMaxMapTasks() + "</map_task_capacity>\n" + "<reduce_task_capacity>" + status.getMaxReduceTasks() + "</reduce_task_capacity>\n" + "<avg_tasks_per_node>" + tasksPerNodeStr + "</avg_tasks_per_node>\n");
    }
}

