/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class GenerationStamp
implements Comparable<GenerationStamp> {
    public static final long FIRST_VALID_STAMP = 1000L;
    public static final long GRANDFATHER_GENERATION_STAMP = 0L;
    private volatile long genstamp;

    public GenerationStamp() {
        this(1000L);
    }

    GenerationStamp(long stamp) {
        this.genstamp = stamp;
    }

    public long getStamp() {
        return this.genstamp;
    }

    public void setStamp(long stamp) {
        this.genstamp = stamp;
    }

    public synchronized long nextStamp() {
        ++this.genstamp;
        return this.genstamp;
    }

    @Override
    public int compareTo(GenerationStamp that) {
        return this.genstamp < that.genstamp ? -1 : (this.genstamp > that.genstamp ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GenerationStamp)) {
            return false;
        }
        return this.compareTo((GenerationStamp)o) == 0;
    }

    public int hashCode() {
        return (int)(this.genstamp ^ this.genstamp >>> 32);
    }
}

