/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import okuyama.imdst.client.OkuyamaClient;

public class UtilClient {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("args[0]=Command");
            System.out.println("Command1. DataExport args1=bkup args2=DataNode-IPAdress args3=DataNode-Port args4=ClientArrivalCheckTime(Option) args5=DataReadWaitTime(Option - milli)");
            System.out.println("Command2. TruncateData args1=truncatedata args2=MainMasterNode-IPAdress args3=MainMasterNode-Port args4=IsolationName or 'all'");
            System.out.println("Command3. MasterNodeConfigCheck args1=masterconfig args2=MainMasterNode-IPAdress args3=MainMasterNode-Port");
            System.out.println("Command4. DataNode is added args1=adddatanode args2=MasterNode-IPAdress:PortNo args3=DataNodeIPAddress:PortNo args4=Slave1-DataNodeIpAddress:PortNo args5=Slave2-DataNodeIpAddress:PortNo");
            System.exit(1);
        }
        if (args[0].trim().equals("dataexport") || args[0].trim().equals("bkup")) {
            if (args.length < 3) {
                System.out.println("Argument Error! args[0]=dataexport or bkup, args[1]=serverip, args[2]=port");
                System.exit(1);
            }
            if (args.length > 4) {
                UtilClient.dataExport(args[1], Integer.parseInt(args[2]), args[3], args[4]);
            } else if (args.length > 3) {
                UtilClient.dataExport(args[1], Integer.parseInt(args[2]), args[3], "0");
            } else {
                UtilClient.dataExport(args[1], Integer.parseInt(args[2]), "1", "0");
            }
        }
        if (args[0].trim().equals("truncatedata")) {
            if (args.length != 4) {
                System.out.println("Argument Error! args[0]=truncatedata, args[1]=MainMasterNodeServerIp, args[2]=port, args[3]=IsolationPrefix or 'all'");
                System.exit(1);
            }
            UtilClient.truncateData(args[1], Integer.parseInt(args[2]), args[3]);
        }
        if (args[0].trim().equals("masterconfig")) {
            if (args.length != 3) {
                System.out.println("Argument Error! args[0]=masterconfig, args[1]=MainMasterNodeServerIp, args[2]=port");
                System.exit(1);
            }
            UtilClient.masterNodeConfigCheck(args[1], Integer.parseInt(args[2]));
        }
        if (args[0].equals("fulldataexport")) {
            if (args.length != 3) {
                System.out.println("Argument Error! args[0]=Command, args[1]=serverip, args[2]=port");
                System.exit(1);
            }
            if (args.length > 4) {
                UtilClient.dataExport(args[1], Integer.parseInt(args[2]), args[3], args[4]);
            } else if (args.length > 3) {
                UtilClient.dataExport(args[1], Integer.parseInt(args[2]), args[3], "0");
            } else {
                UtilClient.dataExport(args[1], Integer.parseInt(args[2]), "1", "0");
            }
        }
        if (args[0].equals("adddatanode")) {
            if (args.length < 3) {
                System.out.println("Argument Error! args[0]=Command, args[1]=MasterNodeIp:Port, args[2]=DataNodeIP:Port");
                System.exit(1);
            }
            ArrayList<String> addNodeList = new ArrayList<String>(3);
            addNodeList.add(args[2]);
            if (args.length > 3) {
                addNodeList.add(args[3]);
            }
            if (args.length > 4) {
                addNodeList.add(args[4]);
            }
            UtilClient.addDataNode(args[1], addNodeList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dataExport(String serverip, int port, String checkWaitTime, String readWaitTime) {
        Socket socket = null;
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            socket = new Socket();
            InetSocketAddress inetAddr = new InetSocketAddress(serverip, port);
            socket.connect(inetAddr, 10000);
            socket.setSoTimeout(60000);
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8")));
            br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
            pw.println("101");
            pw.flush();
            pw.println(checkWaitTime + "," + readWaitTime);
            pw.flush();
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.equals("-1")) {
                    break;
                }
                System.out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateData(String serverip, int port, String isolationPrefix) {
        Socket socket = null;
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            socket = new Socket();
            InetSocketAddress inetAddr = new InetSocketAddress(serverip, port);
            socket.connect(inetAddr, 10000);
            socket.setSoTimeout(13600000);
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8")));
            br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
            pw.println("61," + isolationPrefix);
            pw.flush();
            System.out.println("Truncate Execute");
            String line = null;
            line = br.readLine();
            if (line != null) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void masterNodeConfigCheck(String serverip, int port) {
        Socket socket = null;
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            socket = new Socket();
            InetSocketAddress inetAddr = new InetSocketAddress(serverip, port);
            socket.connect(inetAddr, 10000);
            socket.setSoTimeout(10000);
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8")));
            br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
            pw.println("998");
            pw.flush();
            String line = null;
            line = br.readLine();
            if (line != null) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addDataNode(String masterNodeIpPort, List addNodeList) {
        OkuyamaClient client = null;
        try {
            client = new OkuyamaClient();
            client.setConnectionInfos(masterNodeIpPort.split(","));
            client.autoConnect();
            String[] algorithmRet = client.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ DistributionAlgorithm");
            if (!algorithmRet[0].equals("true")) return;
            if (algorithmRet[1].equals("consistenthash")) {
                int replicaType = 0;
                String[] dataNodeRet = client.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ KeyMapNodesInfo");
                String[] slaveDataNodeRet = client.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ SubKeyMapNodesInfo");
                String[] thirdDataNodeRet = client.getValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ ThirdKeyMapNodesInfo");
                if (dataNodeRet[0].equals("true")) {
                    ++replicaType;
                }
                if (slaveDataNodeRet[0].equals("true")) {
                    ++replicaType;
                }
                if (thirdDataNodeRet[0].equals("true")) {
                    ++replicaType;
                }
                if (replicaType != addNodeList.size()) {
                    System.out.println("[Error] - The number of the replicas of DataNode to add differs from the number of replicas of DataNode set up now");
                    return;
                }
                StringBuilder addAllNodeInfos = new StringBuilder();
                boolean setUpRet = false;
                if (replicaType > 0) {
                    setUpRet = client.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ KeyMapNodesInfo", dataNodeRet[1] + "," + (String)addNodeList.get(0));
                    if (!setUpRet) {
                        client.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ KeyMapNodesInfo", dataNodeRet[1]);
                    }
                    addAllNodeInfos.append((String)addNodeList.get(0));
                }
                if (!setUpRet) {
                    System.out.println("[Error] - When registering the information on DataNode, the error occurred. AddDataNodeName[" + (String)addNodeList.get(0) + "]");
                    return;
                }
                if (replicaType > 1) {
                    setUpRet = client.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ SubKeyMapNodesInfo", slaveDataNodeRet[1] + "," + (String)addNodeList.get(1));
                    if (!setUpRet) {
                        client.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ SubKeyMapNodesInfo", slaveDataNodeRet[1]);
                    }
                    addAllNodeInfos.append(",");
                    addAllNodeInfos.append((String)addNodeList.get(1));
                }
                if (!setUpRet) {
                    System.out.println("[Error] - When registering the information on DataNode, the error occurred. AddDataNodeName[" + (String)addNodeList.get(1) + "]");
                    return;
                }
                if (replicaType > 2) {
                    client.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ ThirdKeyMapNodesInfo", thirdDataNodeRet[1] + "," + (String)addNodeList.get(2));
                    if (!setUpRet) {
                        client.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ ThirdKeyMapNodesInfo", thirdDataNodeRet[1]);
                    }
                    addAllNodeInfos.append(",");
                    addAllNodeInfos.append((String)addNodeList.get(2));
                }
                if (!setUpRet) {
                    System.out.println("[Error] - When registering the information on DataNode, the error occurred. AddDataNodeName[" + (String)addNodeList.get(2) + "]");
                    return;
                }
                setUpRet = client.setValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ addNode4ConsistentHashMode", addAllNodeInfos.toString());
                if (!setUpRet) {
                    client.removeValue("MasterNode-MasterConfigSettingDataNodeSaveKeyPrefixString#112344%&987$#3# _ addNode4ConsistentHashMode");
                }
                if (setUpRet) {
                    System.out.println("[Success] - The additional application of DataNode was completed");
                    return;
                }
                System.out.println("[Error] - The additional application of DataNode went wrong");
                return;
            }
            System.out.println("[Error] - DataNode can be added only when 'DistributionAlgorithm' is 'consistenthash'");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

